/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.functions;

import cdm.base.math.ArithmeticOperationEnum;
import cdm.base.math.FinancialUnitEnum;
import cdm.base.math.UnitType;
import cdm.observable.asset.CashPrice;
import cdm.observable.asset.Price;
import cdm.observable.asset.PriceComposite;
import cdm.observable.asset.PriceExpressionEnum;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ResolveEquityInitialPriceDefault.class)
public abstract class ResolveEquityInitialPrice
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public PriceSchedule evaluate(List<? extends PriceSchedule> price) {
        PriceSchedule initialPrice;
        PriceSchedule.PriceScheduleBuilder initialPriceBuilder = this.doEvaluate(price);
        if (initialPriceBuilder == null) {
            initialPrice = null;
        } else {
            initialPrice = initialPriceBuilder.build();
            this.objectValidator.validate(PriceSchedule.class, (RosettaModelObject)initialPrice);
        }
        return initialPrice;
    }

    protected abstract PriceSchedule.PriceScheduleBuilder doEvaluate(List<? extends PriceSchedule> var1);

    public static class ResolveEquityInitialPriceDefault
    extends ResolveEquityInitialPrice {
        @Override
        protected PriceSchedule.PriceScheduleBuilder doEvaluate(List<? extends PriceSchedule> price) {
            if (price == null) {
                price = Collections.emptyList();
            }
            PriceSchedule.PriceScheduleBuilder initialPrice = PriceSchedule.builder();
            return this.assignOutput(initialPrice, price);
        }

        protected PriceSchedule.PriceScheduleBuilder assignOutput(PriceSchedule.PriceScheduleBuilder initialPrice, List<? extends PriceSchedule> price) {
            MapperC thenArg0 = MapperC.of(price).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).map("getFinancialUnit", unitType -> unitType.getFinancialUnit()), (Mapper)MapperS.of((Object)((Object)FinancialUnitEnum.SHARE)), (CardinalityOperator)CardinalityOperator.All).get());
            MapperC thenArg1 = thenArg0.mapItem(item -> MapperS.of((Object)Price.builder().setValue((BigDecimal)item.map("getValue", priceSchedule -> priceSchedule.getValue()).get()).setUnit((UnitType)item.map("getUnit", priceSchedule -> priceSchedule.getUnit()).get()).setPerUnitOf((UnitType)item.map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).get()).setPriceType((PriceTypeEnum)((Object)((Object)item.map("getPriceType", priceSchedule -> priceSchedule.getPriceType()).get()))).setPriceExpression((PriceExpressionEnum)((Object)((Object)item.map("getPriceExpression", priceSchedule -> priceSchedule.getPriceExpression()).get()))).setComposite((PriceComposite)item.map("getComposite", priceSchedule -> priceSchedule.getComposite()).get()).setArithmeticOperator((ArithmeticOperationEnum)((Object)((Object)item.map("getArithmeticOperator", priceSchedule -> priceSchedule.getArithmeticOperator()).get()))).setCashPrice((CashPrice)item.map("getCashPrice", priceSchedule -> priceSchedule.getCashPrice()).get()).setDatedValue(Collections.emptyList()).build()));
            initialPrice = (PriceSchedule.PriceScheduleBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)((Price)thenArg1.get())).get());
            return Optional.ofNullable(initialPrice).map(o -> o.prune()).orElse(null);
        }
    }
}

