/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.model.lib.mapper;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperItem;
import com.rosetta.model.lib.mapper.MapperPath;
import com.rosetta.model.lib.mapper.NamedFunction;
import com.rosetta.model.lib.mapper.NamedFunctionImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class MapperS<T>
implements MapperBuilder<T> {
    private final MapperItem<? extends T, ?> item;
    private final boolean identity;

    public MapperS(MapperItem<? extends T, ?> item) {
        this(item, false);
    }

    public MapperS(MapperItem<? extends T, ?> item, boolean identity) {
        this.item = item;
        this.identity = identity;
    }

    public static <T> MapperS<T> identity() {
        return new MapperS<Object>(new MapperItem(null, MapperPath.builder().addNull(), true, Optional.empty()), true);
    }

    public static <T> MapperS<T> ofNull() {
        return new MapperS<Object>(new MapperItem(null, MapperPath.builder().addNull(), true, Optional.empty()));
    }

    public static <T> MapperS<T> of(T t) {
        if (t == null) {
            return new MapperS<T>(new MapperItem(t, MapperPath.builder().addNull(), true, Optional.empty()));
        }
        if (t instanceof RosettaModelObject) {
            return new MapperS<T>(new MapperItem(t, MapperPath.builder().addRoot(((RosettaModelObject)t).getType()), false, Optional.empty()));
        }
        return new MapperS<T>(new MapperItem(t, MapperPath.builder().addRoot(t.getClass()), false, Optional.empty()));
    }

    public static <T, P> MapperS<T> of(T t, MapperPath path, MapperItem<P, ?> parent) {
        if (t == null) {
            return new MapperS<T>(new MapperItem(t, path, true, Optional.ofNullable(parent)));
        }
        return new MapperS<T>(new MapperItem(t, path, false, Optional.ofNullable(parent)));
    }

    public MapperS<T> filterSingle(Predicate<MapperS<T>> predicate) {
        if (!this.item.isError()) {
            boolean condition = predicate.test(this);
            if (condition) {
                return this;
            }
            return MapperS.ofNull();
        }
        return this;
    }

    public MapperS<T> filterSingleNullSafe(Function<MapperS<T>, Boolean> predicate) {
        if (!this.item.isError()) {
            Boolean condition = predicate.apply(this);
            if (condition != null && condition.booleanValue()) {
                return this;
            }
            return MapperS.ofNull();
        }
        return this;
    }

    @Override
    public <F> MapperS<F> map(String name, Function<T, F> mappingFunc) {
        return this.map(new NamedFunctionImpl<T, F>(name, mappingFunc));
    }

    @Override
    public <F> MapperS<F> map(NamedFunction<T, F> mappingFunc) {
        return new MapperS<F>(MapperItem.getMapperItem(this.item, mappingFunc));
    }

    public <F> MapperS<F> checkedMap(String name, Function<T, F> mappingFunc, Class<? extends Exception> errorClass) {
        return this.checkedMap(new NamedFunctionImpl<T, F>(name, mappingFunc), errorClass);
    }

    public <F> MapperS<F> checkedMap(NamedFunction<T, F> mappingFunc, Class<? extends Exception> errorClass) {
        return new MapperS<F>(MapperItem.getCheckedMapperItem(this.item, mappingFunc, errorClass));
    }

    @Override
    public <F> MapperC<F> mapC(String name, Function<T, List<? extends F>> mappingFunc) {
        return this.mapC(new NamedFunctionImpl<T, List<? extends F>>(name, mappingFunc));
    }

    @Override
    public <F> MapperC<F> mapC(NamedFunction<T, List<? extends F>> mappingFunc) {
        return new MapperC(MapperItem.getMapperItems(this.item, mappingFunc));
    }

    @Override
    public T get() {
        return this.item.getMappedObject();
    }

    @Override
    public T getOrDefault(T defaultValue) {
        return Optional.ofNullable(this.item.getMappedObject()).orElse(defaultValue);
    }

    @Override
    public List<T> getMulti() {
        return Optional.ofNullable(this.get()).map((? super T xva$0) -> Arrays.asList(xva$0)).orElseGet(ArrayList::new);
    }

    @Override
    public Optional<?> getParent() {
        return this.findParent(this.item).map(MapperItem::getMappedObject);
    }

    @Override
    public List<?> getParentMulti() {
        return this.findParent(this.item).map(MapperItem::getMappedObject).map((? super T xva$0) -> Arrays.asList(xva$0)).orElseGet(ArrayList::new);
    }

    @Override
    public int resultCount() {
        return this.item.getMappedObject() != null ? 1 : 0;
    }

    public boolean isIdentity() {
        return this.identity;
    }

    public <F> MapperS<F> mapSingleToItem(Function<MapperS<T>, MapperS<F>> mappingFunc) {
        if (this.item.getMappedObject() == null) {
            return MapperS.ofNull();
        }
        return mappingFunc.apply(this);
    }

    public <F> MapperC<F> mapSingleToList(Function<MapperS<T>, MapperC<F>> mappingFunc) {
        if (this.item.getMappedObject() == null) {
            return MapperC.ofNull();
        }
        return mappingFunc.apply(this);
    }

    public <F> F apply(Function<MapperS<T>, F> f) {
        return f.apply(this);
    }

    @Override
    public List<Mapper.Path> getPaths() {
        return !this.item.isError() ? Collections.singletonList(this.item.getPath()) : Collections.emptyList();
    }

    @Override
    public List<Mapper.Path> getErrorPaths() {
        return this.item.isError() ? Collections.singletonList(this.item.getPath()) : Collections.emptyList();
    }

    @Override
    public List<String> getErrors() {
        return this.item.isError() ? Collections.singletonList(this.item.getPath().toString() + " was null") : Collections.emptyList();
    }

    public String toString() {
        return this.item.getPath().toString();
    }

    @Override
    public MapperC<T> unionSame(MapperBuilder<T> other) {
        if (other instanceof MapperS) {
            MapperS otherMapperS = (MapperS)other;
            return new MapperC(Arrays.asList(this.item, otherMapperS.item));
        }
        if (other instanceof MapperC) {
            return new MapperC<T>(Collections.singletonList(this.item)).unionSame((MapperBuilder)other);
        }
        throw new IllegalArgumentException("Unsupported Mapper type: " + other.getClass().getName());
    }

    public MapperC<Object> unionDifferent(MapperBuilder<?> other) {
        if (other instanceof MapperS) {
            MapperS otherMapperS = (MapperS)other;
            return new MapperC(Arrays.asList(this.item.upcast(), otherMapperS.item.upcast()));
        }
        if (other instanceof MapperC) {
            return new MapperC(Collections.singletonList(this.item.upcast())).unionDifferent((MapperBuilder)other);
        }
        throw new IllegalArgumentException("Unsupported Mapper type: " + other.getClass().getName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.item == null ? 0 : this.item.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MapperS other = (MapperS)obj;
        return !(this.item == null ? other.item != null : !this.item.equals(other.item));
    }

    @Override
    public Stream<MapperItem<? extends T, ?>> getItems() {
        return Stream.of(this.item);
    }
}

