/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta;

import com.google.common.collect.Iterables;
import com.regnosys.rosetta.rosetta.ExternalAnnotationSource;
import com.regnosys.rosetta.rosetta.RosettaEnumValue;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaExternalClass;
import com.regnosys.rosetta.rosetta.RosettaExternalRuleSource;
import com.regnosys.rosetta.rosetta.RosettaExternalSynonymSource;
import com.regnosys.rosetta.rosetta.RosettaFeature;
import com.regnosys.rosetta.rosetta.RosettaRecordType;
import com.regnosys.rosetta.rosetta.RosettaSynonym;
import com.regnosys.rosetta.rosetta.expression.ChoiceOperation;
import com.regnosys.rosetta.rosetta.expression.OneOfOperation;
import com.regnosys.rosetta.rosetta.simple.Annotated;
import com.regnosys.rosetta.rosetta.simple.Annotation;
import com.regnosys.rosetta.rosetta.simple.AnnotationRef;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Condition;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RChoiceType;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.REnumType;
import com.regnosys.rosetta.types.RMetaAnnotatedType;
import com.regnosys.rosetta.types.RMetaAttribute;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import com.regnosys.rosetta.types.builtin.RRecordType;
import com.regnosys.rosetta.utils.RosettaConfigExtension;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.IEObjectDescription;

public class RosettaEcoreUtil {
    @Inject
    private RBuiltinTypeService builtins;
    @Inject
    private RosettaConfigExtension configs;

    public boolean isResolved(EObject obj) {
        return obj != null && !obj.eIsProxy();
    }

    public Iterable<? extends RosettaFeature> allFeaturesExcludingEnumValues(RMetaAnnotatedType t, EObject context) {
        Iterable<? extends RosettaFeature> features = this.allFeaturesExcludingEnumValues(t.getRType(), this.getResourceSet(context));
        if (t.equals(this.builtins.NOTHING_WITH_ANY_META)) {
            return features;
        }
        return Iterables.concat(features, this.getMetaDescriptions(t, context));
    }

    public Iterable<? extends RosettaFeature> allFeaturesExcludingEnumValues(RType t, EObject context) {
        return this.allFeaturesExcludingEnumValues(t, this.getResourceSet(context));
    }

    public ResourceSet getResourceSet(EObject context) {
        if (context == null) {
            return null;
        }
        Resource resource = context.eResource();
        if (resource == null) {
            return null;
        }
        return resource.getResourceSet();
    }

    public Iterable<? extends RosettaFeature> allFeaturesExcludingEnumValues(RType t, ResourceSet resourceSet) {
        if (t instanceof RDataType) {
            return Iterables.transform(((RDataType)t).getAllAttributes(), RAttribute::getEObject);
        }
        if (t instanceof RChoiceType) {
            return this.allFeaturesExcludingEnumValues((RType)((RChoiceType)t).asRDataType(), resourceSet);
        }
        if (t instanceof RRecordType) {
            if (resourceSet != null) {
                return this.builtins.toRosettaType(t, RosettaRecordType.class, resourceSet).getFeatures();
            }
        } else if (t instanceof REnumType) {
            REnumType enumType = (REnumType)t;
            return this.getAllEnumValues(enumType.getEObject());
        }
        return Collections::emptyIterator;
    }

    public List<RosettaFeature> getMetaDescriptions(List<RMetaAttribute> metaAttributes, EObject context) {
        Set metaNames = metaAttributes.stream().map(a -> a.getName()).collect(Collectors.toSet());
        if (!metaNames.isEmpty()) {
            ArrayList<RosettaFeature> result = new ArrayList<RosettaFeature>();
            for (IEObjectDescription mt : this.configs.findMetaTypes(context)) {
                EObject resolved;
                if (!metaNames.contains(mt.getName().getLastSegment().toString()) || !((resolved = EcoreUtil.resolve((EObject)mt.getEObjectOrProxy(), (EObject)context)) instanceof RosettaFeature)) continue;
                result.add((RosettaFeature)resolved);
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Deprecated
    public List<Data> getAllSuperTypes(Data data) {
        LinkedHashSet<Data> reversedResult = new LinkedHashSet<Data>();
        this.doGetAllSuperTypes(data, reversedResult);
        ArrayList<Data> result = new ArrayList<Data>(reversedResult);
        Collections.reverse(result);
        return result;
    }

    private void doGetAllSuperTypes(Data current, Set<Data> superTypes) {
        Data s;
        if (superTypes.add(current) && (s = current.getSuperType()) != null) {
            this.doGetAllSuperTypes(s, superTypes);
        }
    }

    @Deprecated
    public Iterable<Attribute> getAllAttributes(Data data) {
        return Iterables.concat((Iterable)Iterables.transform(this.getAllSuperTypes(data), Data::getAttributes));
    }

    @Deprecated
    public Collection<Attribute> getAllNonOverridenAttributes(Data data) {
        LinkedHashMap result = new LinkedHashMap();
        this.getAllAttributes(data).forEach(it -> result.put(it.getName(), it));
        return result.values();
    }

    @Deprecated
    public Set<RosettaEnumeration> getAllSuperEnumerations(RosettaEnumeration e) {
        return this.doGetSuperEnumerations(e, new LinkedHashSet<RosettaEnumeration>());
    }

    private Set<RosettaEnumeration> doGetSuperEnumerations(RosettaEnumeration e, Set<RosettaEnumeration> seenEnums) {
        if (e != null && seenEnums.add(e)) {
            this.doGetSuperEnumerations(e.getParent(), seenEnums);
        }
        return seenEnums;
    }

    @Deprecated
    public Iterable<RosettaEnumValue> getAllEnumValues(RosettaEnumeration e) {
        return Iterables.concat((Iterable)Iterables.transform(this.getAllSuperEnumerations(e), RosettaEnumeration::getEnumValues));
    }

    public Attribute getParentAttribute(Attribute attr) {
        EObject container = attr.eContainer();
        if (container instanceof Data) {
            Data t = (Data)container;
            HashSet<Data> visited = new HashSet<Data>();
            visited.add(t);
            Data st = t.getSuperType();
            while (st != null) {
                Attribute p = st.getAttributes().stream().filter(it -> it.getName().equals(attr.getName())).findAny().orElse(null);
                if (p != null) {
                    return p;
                }
                if (visited.add(st = st.getSuperType())) continue;
                return null;
            }
        }
        return null;
    }

    public List<EObject> getParentsOfExternalType(RosettaExternalClass externalType) {
        List<ExternalAnnotationSource> superSources;
        ExternalAnnotationSource source = (ExternalAnnotationSource)EcoreUtil2.getContainerOfType((EObject)externalType, ExternalAnnotationSource.class);
        if (source == null) {
            return Collections.emptyList();
        }
        Data type = externalType.getData();
        LinkedHashSet<Object> parents = new LinkedHashSet<Object>();
        RosettaExternalClass superTypeInSource = null;
        if (type.getSuperType() != null && (superTypeInSource = this.findSuperTypeInSource(type.getSuperType(), null, source)) != null) {
            parents.add(superTypeInSource);
        }
        if ((superSources = this.getSuperSources(source)).isEmpty()) {
            parents.add(type);
        } else {
            HashSet<ExternalAnnotationSource> visitedSources = new HashSet<ExternalAnnotationSource>();
            visitedSources.add(source);
            Data stop = superTypeInSource == null ? null : superTypeInSource.getData();
            superSources.forEach(it -> this.collectParentsOfTypeInSource((Set<EObject>)parents, type, stop, (ExternalAnnotationSource)it, (Set<ExternalAnnotationSource>)visitedSources));
        }
        return new ArrayList<EObject>(parents);
    }

    private void collectParentsOfTypeInSource(Set<EObject> parents, Data type, Data stop, ExternalAnnotationSource currentSource, Set<ExternalAnnotationSource> visitedSources) {
        List<ExternalAnnotationSource> superSources;
        if (!visitedSources.add(currentSource)) {
            return;
        }
        RosettaExternalClass superTypeInSource = this.findSuperTypeInSource(type, stop, currentSource);
        if (superTypeInSource != null) {
            parents.add(superTypeInSource);
        }
        if ((superSources = this.getSuperSources(currentSource)).isEmpty()) {
            parents.add(type);
        } else {
            Data newStop = superTypeInSource != null && superTypeInSource.getData() != null ? superTypeInSource.getData() : stop;
            superSources.forEach(it -> this.collectParentsOfTypeInSource(parents, type, newStop, (ExternalAnnotationSource)it, visitedSources));
        }
    }

    private RosettaExternalClass findSuperTypeInSource(Data type, Data stop, ExternalAnnotationSource source) {
        HashSet<Data> visitedTypes = new HashSet<Data>();
        for (Data current = type; current != null && !current.equals(stop) && !visitedTypes.add(current); current = current.getSuperType()) {
            Data d = current;
            RosettaExternalClass externalType = source.getExternalClasses().stream().filter(ext -> ext.getData().equals(d)).findAny().orElse(null);
            if (externalType == null) continue;
            return externalType;
        }
        return null;
    }

    private List<ExternalAnnotationSource> getSuperSources(ExternalAnnotationSource source) {
        if (source instanceof RosettaExternalSynonymSource) {
            return ((RosettaExternalSynonymSource)source).getSuperSources().stream().filter(s -> s instanceof ExternalAnnotationSource).map(s -> (ExternalAnnotationSource)((Object)s)).toList();
        }
        if (source instanceof RosettaExternalRuleSource) {
            return ((RosettaExternalRuleSource)source).getSuperSources();
        }
        return Collections.emptyList();
    }

    public Set<RosettaSynonym> getAllSynonyms(RosettaSynonym s) {
        return this.doGetSynonyms(s, new LinkedHashSet<RosettaSynonym>());
    }

    private Set<RosettaSynonym> doGetSynonyms(RosettaSynonym s, Set<RosettaSynonym> seenSynonyms) {
        if (s != null && seenSynonyms.add(s)) {
            this.doGetSynonyms(s, seenSynonyms);
        }
        return seenSynonyms;
    }

    @Deprecated
    public Iterable<AnnotationRef> metaAnnotations(Annotated it) {
        return this.allAnnotations(it, ann -> "metadata".equals(ann.getName()));
    }

    private boolean metaAttributeExists(Annotated it, Predicate<Attribute> test) {
        return Iterables.any(this.metaAnnotations(it), ref -> this.isResolved(ref.getAttribute()) && test.test(ref.getAttribute()));
    }

    public boolean isAttributeMeta(String name) {
        return !this.isTypeMeta(name);
    }

    public boolean isTypeMeta(String name) {
        return "key".equals(name) || "template".equals(name);
    }

    @Deprecated
    public boolean hasKeyedAnnotation(Annotated it) {
        return this.metaAttributeExists(it, attr -> "key".equals(attr.getName()));
    }

    @Deprecated
    public boolean hasTemplateAnnotation(Annotated it) {
        return this.metaAttributeExists(it, attr -> "template".equals(attr.getName()));
    }

    @Deprecated
    public boolean hasMetaDataAnnotations(Annotated it) {
        return this.metaAttributeExists(it, attr -> List.of("reference", "location", "scheme", "id").contains(attr.getName()));
    }

    @Deprecated
    public boolean hasMetaFieldAnnotations(Annotated it) {
        return this.metaAttributeExists(it, attr -> !List.of("reference", "address").contains(attr.getName()));
    }

    @Deprecated
    public boolean hasMetaDataAddress(Annotated it) {
        return this.metaAttributeExists(it, attr -> "address".equals(attr.getName()));
    }

    @Deprecated
    public boolean hasIdAnnotation(Annotated it) {
        return this.metaAttributeExists(it, attr -> "id".equals(attr.getName()));
    }

    @Deprecated
    public boolean hasReferenceAnnotation(Annotated it) {
        return this.metaAttributeExists(it, attr -> "reference".equals(attr.getName()));
    }

    @Deprecated
    public boolean hasCalculationAnnotation(Annotated it) {
        return this.allAnnotations(it, ann -> "calculation".equals(ann.getName())).iterator().hasNext();
    }

    @Deprecated
    private Iterable<AnnotationRef> allAnnotations(Annotated withAnnotations, Predicate<Annotation> filter) {
        return Iterables.filter(withAnnotations.getAnnotations(), ref -> this.isResolved(ref.getAnnotation()) && filter.test(ref.getAnnotation()));
    }

    @Deprecated
    public boolean isConstraintCondition(Condition cond) {
        return this.isOneOf(cond) || this.isChoice(cond);
    }

    private boolean isOneOf(Condition cond) {
        return cond.getExpression() instanceof OneOfOperation;
    }

    private boolean isChoice(Condition cond) {
        return cond.getExpression() instanceof ChoiceOperation;
    }

    private List<RosettaFeature> getMetaDescriptions(RMetaAnnotatedType type, EObject context) {
        return this.getMetaDescriptions(type.getMetaAttributes(), context);
    }
}

