/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.statement.builder;

import com.regnosys.rosetta.generator.DebuggingTargetLanguageStringConcatenation;
import com.regnosys.rosetta.generator.GeneratedIdentifier;
import com.regnosys.rosetta.generator.java.scoping.JavaStatementScope;
import com.regnosys.rosetta.generator.java.statement.JavaAssignment;
import com.regnosys.rosetta.generator.java.statement.JavaExpressionStatement;
import com.regnosys.rosetta.generator.java.statement.JavaLambdaBody;
import com.regnosys.rosetta.generator.java.statement.JavaLocalVariableDeclarationStatement;
import com.regnosys.rosetta.generator.java.statement.JavaReturnStatement;
import com.regnosys.rosetta.generator.java.statement.JavaStatement;
import com.regnosys.rosetta.generator.java.statement.JavaStatementList;
import com.regnosys.rosetta.generator.java.statement.builder.JavaBlockBuilder;
import com.regnosys.rosetta.generator.java.statement.builder.JavaStatementBuilder;
import com.regnosys.rosetta.generator.java.statement.builder.JavaVariable;
import com.rosetta.util.types.JavaType;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.eclipse.xtend2.lib.StringConcatenationClient;

public abstract class JavaExpression
extends JavaStatementBuilder
implements JavaLambdaBody {
    private final JavaType type;

    public JavaExpression(JavaType type) {
        this.type = type;
    }

    public static JavaExpression from(final StringConcatenationClient value, JavaType type) {
        return new JavaExpression(type){

            @Override
            public void appendTo(StringConcatenationClient.TargetStringConcatenation target) {
                target.append((Object)value);
            }
        };
    }

    @Override
    public JavaType getExpressionType() {
        return this.type;
    }

    @Override
    public JavaStatementBuilder mapExpression(Function<JavaExpression, ? extends JavaStatementBuilder> mapper) {
        return mapper.apply(this);
    }

    @Override
    public JavaStatementBuilder then(JavaStatementBuilder after, BiFunction<JavaExpression, JavaExpression, JavaStatementBuilder> combineExpressions, JavaStatementScope scope) {
        if (after instanceof JavaExpression) {
            return this.then((JavaExpression)after, combineExpressions, scope);
        }
        return after.then(this, (JavaExpression otherExpr, JavaExpression thisExpr) -> (JavaStatementBuilder)combineExpressions.apply((JavaExpression)thisExpr, (JavaExpression)otherExpr), scope);
    }

    public JavaStatementBuilder then(JavaExpression after, BiFunction<JavaExpression, JavaExpression, JavaStatementBuilder> combineExpressions, JavaStatementScope scope) {
        return combineExpressions.apply(this, after);
    }

    @Override
    public JavaStatement complete(Function<JavaExpression, JavaStatement> completer) {
        return completer.apply(this);
    }

    @Override
    public JavaReturnStatement completeAsReturn() {
        return new JavaReturnStatement(this);
    }

    @Override
    public JavaExpressionStatement completeAsExpressionStatement() {
        return new JavaExpressionStatement(this);
    }

    @Override
    public JavaAssignment completeAsAssignment(GeneratedIdentifier variableId) {
        return new JavaAssignment(variableId, this);
    }

    @Override
    public JavaStatementBuilder declareAsVariable(boolean isFinal, String variableId, JavaStatementScope scope) {
        GeneratedIdentifier id = scope.createIdentifier(this, variableId);
        return new JavaBlockBuilder(JavaStatementList.of(new JavaStatement[]{new JavaLocalVariableDeclarationStatement(isFinal, this.type, id, this)}), new JavaVariable(id, this.type));
    }

    @Override
    public JavaStatementBuilder collapseToSingleExpression(JavaStatementScope scope) {
        return this;
    }

    @Override
    public JavaLambdaBody toLambdaBody() {
        return this;
    }

    public String toString() {
        return DebuggingTargetLanguageStringConcatenation.convertToDebugString(this);
    }
}

