/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.validation;

import com.google.common.collect.Iterables;
import com.regnosys.rosetta.rosetta.RosettaPackage;
import com.regnosys.rosetta.rosetta.simple.Choice;
import com.regnosys.rosetta.types.RChoiceOption;
import com.regnosys.rosetta.types.RChoiceType;
import com.regnosys.rosetta.types.RMetaAnnotatedType;
import com.regnosys.rosetta.types.RObjectFactory;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import com.regnosys.rosetta.validation.AbstractDeclarativeRosettaValidator;
import com.regnosys.rosetta.validation.CycleValidationHelper;
import jakarta.inject.Inject;
import java.util.HashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;

public class ChoiceValidator
extends AbstractDeclarativeRosettaValidator {
    @Inject
    private RObjectFactory rObjectFactory;
    @Inject
    private RBuiltinTypeService builtins;
    @Inject
    private CycleValidationHelper cycleValidationHelper;

    @Check
    public void checkCyclicOptions(Choice choice) {
        this.cycleValidationHelper.detectMultipleCycles(choice, c -> Iterables.filter(c.getOptions(), opt -> opt.getTypeCall().getType() instanceof Choice), opt -> (Choice)opt.getTypeCall().getType(), "includes", (opt, pathMsg) -> this.error("Cyclic option: " + pathMsg, (EObject)opt, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME));
    }

    @Check
    public void checkChoiceOptionsDoNotOverlap(Choice choice) {
        RChoiceType t = this.rObjectFactory.buildRChoiceType(choice);
        HashMap<RMetaAnnotatedType, RChoiceOption> includedOptions = new HashMap<RMetaAnnotatedType, RChoiceOption>();
        for (RChoiceOption opt : t.getOwnOptions()) {
            if (!(opt.getType().getRType() instanceof RChoiceType)) continue;
            ((RChoiceType)opt.getType().getRType()).getAllOptions().forEach(o -> includedOptions.put(o.getType(), opt));
        }
        for (RChoiceOption opt : t.getOwnOptions()) {
            RChoiceOption alreadyIncluded;
            if (this.builtins.NOTHING.equals(opt.getType().getRType()) || (alreadyIncluded = includedOptions.put(opt.getType(), opt)) == null) continue;
            String msg = alreadyIncluded.getType().equals(opt.getType()) ? "Duplicate option '" + String.valueOf(opt.getType()) + "'" : "Option '" + String.valueOf(opt.getType()) + "' is already included by option '" + String.valueOf(alreadyIncluded.getType()) + "'";
            this.error(msg, opt.getEObject(), null);
        }
    }
}

