/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.validation;

import com.regnosys.rosetta.rosetta.RosettaExternalClass;
import com.regnosys.rosetta.rosetta.RosettaExternalRegularAttribute;
import com.regnosys.rosetta.rosetta.RosettaExternalRuleSource;
import com.regnosys.rosetta.rosetta.RosettaPackage;
import com.regnosys.rosetta.rosetta.RosettaReport;
import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.simple.AnnotationDeepPath;
import com.regnosys.rosetta.rosetta.simple.AnnotationPath;
import com.regnosys.rosetta.rosetta.simple.AnnotationPathExpression;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.RuleReferenceAnnotation;
import com.regnosys.rosetta.rosetta.simple.SimplePackage;
import com.regnosys.rosetta.rules.RulePathMap;
import com.regnosys.rosetta.rules.RuleReferenceService;
import com.regnosys.rosetta.rules.RuleResult;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.RFunction;
import com.regnosys.rosetta.types.RMetaAnnotatedType;
import com.regnosys.rosetta.types.RObjectFactory;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.TypeSystem;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import com.regnosys.rosetta.utils.AnnotationPathExpressionUtil;
import com.regnosys.rosetta.validation.AbstractDeclarativeRosettaValidator;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;

public class ReportValidator
extends AbstractDeclarativeRosettaValidator {
    @Inject
    private TypeSystem ts;
    @Inject
    private RBuiltinTypeService builtins;
    @Inject
    private RuleReferenceService ruleService;
    @Inject
    private RObjectFactory objectFactory;
    @Inject
    private AnnotationPathExpressionUtil annotationPathUtil;

    @Check
    public void checkRuleReferenceAnnotation(RuleReferenceAnnotation ann) {
        AnnotationPathExpression path = ann.getPath();
        if (path != null) {
            RosettaRule rule;
            EcoreUtil2.eAllOfType((EObject)path, AnnotationDeepPath.class).forEach(deepPath -> this.error("Deep paths are not allowed for `ruleReference` annotations", (EObject)deepPath, (EStructuralFeature)SimplePackage.Literals.ANNOTATION_DEEP_PATH__OPERATOR));
            EObject container = ann.eContainer();
            if (container instanceof Attribute) {
                Attribute containingAttribute = (Attribute)container;
                if (containingAttribute.getCard().isPlural()) {
                    this.error("Paths on multi-cardinality attributes are not allowed", ann, (EStructuralFeature)SimplePackage.Literals.BUILTIN_ANNOTATION_WITH_PATH__PATH);
                } else {
                    EcoreUtil2.eAllOfType((EObject)path, AnnotationPath.class).forEach(p -> {
                        Attribute target = this.annotationPathUtil.getTargetAttribute(p.getReceiver());
                        if (target.getCard().isPlural()) {
                            this.error("Paths on multi-cardinality attributes are not allowed", (EObject)p, (EStructuralFeature)SimplePackage.Literals.ANNOTATION_PATH__OPERATOR);
                        }
                    });
                }
            }
            if ((rule = ann.getReportingRule()) != null && rule.getIdentifier() != null) {
                this.warning("Specifying a label in a reporting rule is deprecated. Add a `label` annotation instead", ann, (EStructuralFeature)SimplePackage.Literals.RULE_REFERENCE_ANNOTATION__REPORTING_RULE);
            }
        }
    }

    @Check
    public void checkReport(RosettaReport report) {
        RType inputType = this.ts.typeCallToRType(report.getInputType());
        EList<RosettaRule> eligibilityRules = report.getEligibilityRules();
        for (int i = 0; i < eligibilityRules.size(); ++i) {
            RType ruleInputType;
            RosettaRule eligibilityRule = (RosettaRule)eligibilityRules.get(i);
            if (!eligibilityRule.isEligibility()) {
                this.error("Rule " + eligibilityRule.getName() + " is not an eligibility rule.", report, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_REPORT__ELIGIBILITY_RULES, i);
            }
            if (this.ts.isSubtypeOf(ruleInputType = this.ts.getRuleInputType(eligibilityRule), inputType)) continue;
            this.error("Eligibility rule " + eligibilityRule.getName() + " expects a `" + String.valueOf(ruleInputType) + "` as input, but this report is generated from a `" + String.valueOf(inputType) + "`.", report, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_REPORT__ELIGIBILITY_RULES, i);
        }
        RType reportTypeInputType = this.ts.getRulesInputType(this.objectFactory.buildRDataType(report.getReportType()), report.getRuleSource());
        if (reportTypeInputType != this.builtins.ANY && !this.ts.isSubtypeOf(reportTypeInputType, inputType)) {
            if (report.getRuleSource() != null) {
                this.error("Rule source " + report.getRuleSource().getName() + " expects a `" + String.valueOf(reportTypeInputType) + "` as input, but this report is generated from a `" + String.valueOf(inputType) + "`.", report, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_REPORT__RULE_SOURCE);
            } else {
                this.error("Report type " + report.getReportType().getName() + " expects a `" + String.valueOf(reportTypeInputType) + "` as input, but this report is generated from a `" + String.valueOf(inputType) + "`.", report, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_REPORT__REPORT_TYPE);
            }
        }
    }

    @Check
    public void checkReportType(Data data) {
        RDataType rData = this.objectFactory.buildRDataType(data);
        this.checkReportInputType(data, null, rData);
    }

    @Check
    public void checkExternalRuleSource(RosettaExternalRuleSource source) {
        for (RosettaExternalClass externalClass : source.getExternalClasses()) {
            RDataType data = this.objectFactory.buildRDataType(externalClass.getData());
            this.checkReportInputType(externalClass, source, data);
            externalClass.getRegularAttributes().forEach(annotatedAttr -> {
                RAttribute attribute = data.getAttributeByName(annotatedAttr.getAttributeRef().getName());
                if (attribute != null) {
                    this.checkOwnRuleReferenceAnnotations(source, data, attribute);
                }
            });
        }
    }

    @Check
    public void checkAttribute(Attribute attr) {
        RAttribute attribute = this.objectFactory.buildRAttribute(attr);
        if (!attribute.getOwnRuleReferences().isEmpty()) {
            EObject container = attr.eContainer();
            if (!(container instanceof Data)) {
                for (int i = 0; i < attribute.getOwnRuleReferences().size(); ++i) {
                    this.error("You can only add rule references on the attribute of a type", attr, (EStructuralFeature)SimplePackage.Literals.ATTRIBUTE__RULE_REFERENCES, i);
                }
            } else {
                this.checkOwnRuleReferenceAnnotations(null, attribute.getEnclosingType(), attribute);
            }
        }
    }

    private void checkOwnRuleReferenceAnnotations(RosettaExternalRuleSource source, RDataType type, RAttribute attribute) {
        RulePathMap ruleMap = this.ruleService.computeRulePathMapInContext(source, type, attribute);
        Map<List<String>, RuleResult> parentRules = ruleMap.getParentRules();
        Map<List<String>, RuleResult> ownRules = ruleMap.getOwnRules();
        ownRules.forEach((path, ruleResult) -> {
            if (ruleResult.isExplicitlyEmpty()) {
                RAttribute targetAttribute = this.ruleService.getTargetAttribute(attribute, (List<String>)path);
                RulePathMap targetRuleMap = this.ruleService.computeRulePathMapInContext(source, targetAttribute.getEnclosingType(), targetAttribute);
                RuleResult ruleDefinedOnTarget = targetRuleMap.get(List.of());
                if (!parentRules.containsKey(path) && ruleDefinedOnTarget.isExplicitlyEmpty()) {
                    EObject errorOrigin = ruleResult.getOrigin();
                    String msg = "There is no rule reference" + this.toPathMessage((List<String>)path) + " to remove";
                    if (errorOrigin instanceof RuleReferenceAnnotation) {
                        this.error(msg, errorOrigin, (EStructuralFeature)SimplePackage.Literals.RULE_REFERENCE_ANNOTATION__EMPTY);
                    } else {
                        this.error(msg, errorOrigin, null);
                    }
                }
            } else {
                RosettaRule rule = ruleResult.getRule();
                RAttribute target = this.ruleService.getTargetAttribute(attribute, (List<String>)path);
                if (target != null) {
                    RFunction ruleFunc = this.objectFactory.buildRFunction(rule);
                    RMetaAnnotatedType ruleType = ruleFunc.getOutput().getRMetaAnnotatedType();
                    if (!this.ts.isSubtypeOf(ruleType, target.getRMetaAnnotatedType())) {
                        this.error("Expected type " + String.valueOf(target.getRMetaAnnotatedType()) + this.toPathMessage((List<String>)path) + ", but rule has type " + String.valueOf(ruleType), ruleResult.getOrigin(), (EStructuralFeature)SimplePackage.Literals.RULE_REFERENCE_ANNOTATION__EMPTY);
                    }
                    if (!target.isMulti() && ruleFunc.getOutput().isMulti()) {
                        this.warning("Expected single cardinality" + this.toPathMessage((List<String>)path) + ", but rule has multi cardinality", ruleResult.getOrigin(), (EStructuralFeature)SimplePackage.Literals.RULE_REFERENCE_ANNOTATION__EMPTY);
                    }
                }
            }
        });
    }

    private void checkReportInputType(EObject objectBeingChecked, RosettaExternalRuleSource source, RDataType type) {
        this.ruleService.traverse(source, type, this.builtins.ANY, (current, context) -> {
            if (context.isExplicitlyEmpty()) {
                return current;
            }
            RType ruleInputType = this.ts.getRuleInputType(context.getRule());
            if (ruleInputType.equals(this.builtins.NOTHING)) {
                return current;
            }
            RType newCurrent = this.ts.meet((RType)current, ruleInputType);
            if (newCurrent.equals(this.builtins.NOTHING)) {
                this.inputTypeErrorForRule(objectBeingChecked, (RuleReferenceService.RuleReferenceContext)context, (RType)current, ruleInputType);
                return current;
            }
            return newCurrent;
        });
    }

    private void inputTypeErrorForRule(EObject objectBeingChecked, RuleReferenceService.RuleReferenceContext context, RType previousInputType, RType inputType) {
        EObject origin = context.getRuleOrigin();
        EObject container = EcoreUtil2.getContainerOfType((EObject)origin, (Class)objectBeingChecked.getClass());
        RosettaRule rule = context.getRule();
        if (objectBeingChecked.equals((Object)container)) {
            if (origin instanceof RuleReferenceAnnotation) {
                RuleReferenceAnnotation ann = (RuleReferenceAnnotation)origin;
                this.error("Rule `" + rule.getName() + "` expects an input of type `" + String.valueOf(inputType) + "`, while previous rules expect an input of type `" + String.valueOf(previousInputType) + "`", ann, (EStructuralFeature)SimplePackage.Literals.RULE_REFERENCE_ANNOTATION__REPORTING_RULE);
            } else if (origin instanceof RosettaExternalRegularAttribute) {
                // empty if block
            }
        } else {
            RAttribute containingAttribute = context.getPath().get(0);
            String pathMsg = this.getPathMessage(context.getPath());
            this.error("Rule `" + rule.getName() + "`" + pathMsg + " expects an input of type `" + String.valueOf(inputType) + "`, while previous rules expect an input of type `" + String.valueOf(previousInputType) + "`", containingAttribute.getEObject(), (EStructuralFeature)RosettaPackage.Literals.ROSETTA_TYPED__TYPE_CALL);
        }
    }

    private String getPathMessage(List<RAttribute> path) {
        if (path.isEmpty()) {
            return "";
        }
        return " for " + path.stream().map(a -> a.getName()).collect(Collectors.joining(" -> "));
    }

    private String toPathMessage(List<String> path) {
        if (path.isEmpty()) {
            return "";
        }
        return " for " + String.join((CharSequence)" -> ", path);
    }
}

