/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.validation;

import com.regnosys.rosetta.RosettaEcoreUtil;
import com.regnosys.rosetta.rosetta.RosettaPackage;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Choice;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.SimplePackage;
import com.regnosys.rosetta.validation.AbstractDeclarativeRosettaValidator;
import com.regnosys.rosetta.validation.CycleValidationHelper;
import jakarta.inject.Inject;
import java.util.HashSet;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;

public class TypeValidator
extends AbstractDeclarativeRosettaValidator {
    @Inject
    private RosettaEcoreUtil ecoreUtil;
    @Inject
    private CycleValidationHelper cycleValidationHelper;

    @Check
    public void checkTypeNameIsCapitalized(Data data) {
        String name = data.getName();
        if (name != null && Character.isLowerCase(name.charAt(0))) {
            this.warning("Type name should start with a capital", (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME, "RosettaIssueCodes.invalidCase", new String[0]);
        }
    }

    @Check
    public void checkDoNotExtendChoice(Data data) {
        if (data.getSuperType() instanceof Choice) {
            this.warning("Extending a choice type is deprecated", data, (EStructuralFeature)SimplePackage.Literals.DATA__SUPER_TYPE);
        }
    }

    @Check
    public void checkCyclicExtensions(Data data) {
        this.cycleValidationHelper.detectCycle(data, Data::getSuperType, "extends", pathMsg -> this.error("Cyclic extension: " + pathMsg, data, (EStructuralFeature)SimplePackage.Literals.DATA__SUPER_TYPE));
    }

    @Check
    public void checkAttributeNamesAreUnique(Data data) {
        HashSet usedNamesInSuperType = new HashSet();
        if (data.getSuperType() != null) {
            this.ecoreUtil.getAllAttributes(data.getSuperType()).forEach(attr -> usedNamesInSuperType.add(attr.getName()));
        }
        for (Attribute attr2 : data.getAttributes()) {
            if (attr2.isOverride() || !usedNamesInSuperType.contains(attr2.getName())) continue;
            this.warning("Attribute '" + attr2.getName() + "' already defined in super type. To override the type, cardinality or annotations of this attribute, use the keyword `override`", attr2, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME);
        }
    }

    @Check
    public void checkAttributeOverridesShouldComeFirst(Data data) {
        boolean newAttrEncountered = false;
        for (Attribute attr : data.getAttributes()) {
            if (!attr.isOverride()) {
                newAttrEncountered = true;
                continue;
            }
            if (!newAttrEncountered) continue;
            this.error("Attribute overrides should come before any new attributes", attr, null);
        }
    }
}

