/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.validation.names;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.regnosys.rosetta.rosetta.RosettaPackage;
import com.regnosys.rosetta.rosetta.simple.SimplePackage;
import com.regnosys.rosetta.validation.names.DuplicationCluster;
import com.regnosys.rosetta.validation.names.RosettaUniqueNamesConfig;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.validation.INamesAreUniqueValidationHelper;
import org.eclipse.xtext.validation.NamesAreUniqueValidationHelper;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;

@Singleton
public class RosettaNamesAreUniqueValidationHelper
extends NamesAreUniqueValidationHelper {
    private static final Set<EClass> IGNORED_TYPES = Set.of(RosettaPackage.eINSTANCE.getRosettaModel(), RosettaPackage.eINSTANCE.getRosettaMetaType(), SimplePackage.eINSTANCE.getFunctionDispatch());
    private static final Map<EClass, String> TYPE_LABELS = ImmutableMap.builder().put((Object)RosettaPackage.eINSTANCE.getRosettaModel(), (Object)"namespace").put((Object)RosettaPackage.eINSTANCE.getRosettaRootElement(), (Object)"element").put((Object)RosettaPackage.eINSTANCE.getRosettaSynonymSource(), (Object)"synonym source").put((Object)RosettaPackage.eINSTANCE.getRosettaExternalRuleSource(), (Object)"rule source").put((Object)RosettaPackage.eINSTANCE.getRosettaCallableWithArgs(), (Object)"function").put((Object)RosettaPackage.eINSTANCE.getRosettaType(), (Object)"type").put((Object)SimplePackage.eINSTANCE.getData(), (Object)"type").put((Object)SimplePackage.eINSTANCE.getAnnotation(), (Object)"annotation").put((Object)RosettaPackage.eINSTANCE.getRosettaBody(), (Object)"body").put((Object)RosettaPackage.eINSTANCE.getRosettaCorpus(), (Object)"corpus").put((Object)RosettaPackage.eINSTANCE.getRosettaSegment(), (Object)"segment").put((Object)RosettaPackage.eINSTANCE.getRosettaScope(), (Object)"scope").put((Object)SimplePackage.eINSTANCE.getAttribute(), (Object)"attribute").build();
    private final RosettaUniqueNamesConfig config;
    private final Set<EClass> clusterTypes;

    @Inject
    public RosettaNamesAreUniqueValidationHelper(RosettaUniqueNamesConfig config) {
        this.config = config;
        this.clusterTypes = config.getDuplicationClusters().keySet();
    }

    protected EClass getClusterType(IEObjectDescription description) {
        EClass associatedType = this.getAssociatedClusterType(description);
        if (associatedType == null) {
            return null;
        }
        DuplicationCluster cluster = this.config.getDuplicationCluster(associatedType);
        if (cluster != null && cluster.clusterScope().acceptCluster(description, associatedType)) {
            return associatedType;
        }
        return null;
    }

    protected EClass getAssociatedClusterType(IEObjectDescription description) {
        if (IGNORED_TYPES.contains(description.getEClass()) || this.isInOverriddenNamespace(description)) {
            return null;
        }
        return this.clusterTypes.stream().filter(clusterType -> this.isPartOfCluster(description, (EClass)clusterType)).findFirst().orElse(null);
    }

    protected boolean isPartOfCluster(IEObjectDescription description, EClass clusterType) {
        return clusterType.isSuperTypeOf(description.getEClass()) && this.config.getDuplicationCluster(clusterType).clusterScope().acceptCluster(description, clusterType);
    }

    protected void doCheckUniqueIn(IEObjectDescription description, INamesAreUniqueValidationHelper.Context context, ValidationMessageAcceptor acceptor) {
        EObject object = description.getEObjectOrProxy();
        Preconditions.checkArgument((!object.eIsProxy() ? 1 : 0) != 0);
        EClass clusterType = this.getClusterType(description);
        if (clusterType == null) {
            return;
        }
        ISelectable validationScope = context.getValidationScope(description, clusterType);
        if (validationScope.isEmpty()) {
            return;
        }
        boolean caseSensitive = context.isCaseSensitive(object, clusterType);
        Iterable sameNames = validationScope.getExportedObjects(clusterType, description.getName(), !caseSensitive);
        if (sameNames instanceof Collection && ((Collection)sameNames).size() <= 1) {
            return;
        }
        for (IEObjectDescription candidate : sameNames) {
            EObject otherObject = candidate.getEObjectOrProxy();
            if ((object == otherObject || !this.isPartOfCluster(candidate, clusterType) || otherObject.eIsProxy()) && candidate.getEObjectURI().equals(description.getEObjectURI()) || !this.isDuplicate(description, candidate)) continue;
            this.createDuplicateNameError(description, clusterType, acceptor);
            return;
        }
    }

    protected boolean isDuplicate(IEObjectDescription description, IEObjectDescription candidate) {
        return !this.isInOverriddenNamespace(candidate);
    }

    private boolean isInOverriddenNamespace(IEObjectDescription description) {
        return "true".equals(description.getUserData("IN_OVERRIDDEN_NAMESPACE"));
    }

    protected String getTypeLabel(EClass clusterType) {
        String label = TYPE_LABELS.get(clusterType);
        return label != null ? label : super.getTypeLabel(clusterType);
    }
}

