/*
 * Decompiled with CFR 0.152.
 */
package drr.base.trade.payment;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.base.trade.payment.meta.PeriodicPaymentMeta;
import drr.standards.iso.FrequencyPeriodEnum;
import drr.standards.iso.InterestComputationMethod4Code;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="PeriodicPayment", builder=PeriodicPaymentBuilderImpl.class, version="7.0.0-dev.66")
@RuneDataType(value="PeriodicPayment", model="drr", builder=PeriodicPaymentBuilderImpl.class, version="7.0.0-dev.66")
public interface PeriodicPayment
extends RosettaModelObject {
    public static final PeriodicPaymentMeta metaData = new PeriodicPaymentMeta();

    public InterestComputationMethod4Code getFixedRateDayCountConvention();

    public InterestComputationMethod4Code getFloatingRateDayCountConvention();

    public FrequencyPeriodEnum getFixedRatePaymentFrequencyPeriod();

    public FrequencyPeriodEnum getFloatingRatePaymentFrequencyPeriod();

    public Integer getFixedRatePaymentFrequencyPeriodMultiplier();

    public Integer getFloatingRatePaymentFrequencyPeriodMultiplier();

    public PeriodicPayment build();

    public PeriodicPaymentBuilder toBuilder();

    public static PeriodicPaymentBuilder builder() {
        return new PeriodicPaymentBuilderImpl();
    }

    default public RosettaMetaData<? extends PeriodicPayment> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PeriodicPayment> getType() {
        return PeriodicPayment.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fixedRateDayCountConvention"), InterestComputationMethod4Code.class, (Object)this.getFixedRateDayCountConvention(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingRateDayCountConvention"), InterestComputationMethod4Code.class, (Object)this.getFloatingRateDayCountConvention(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriod"), FrequencyPeriodEnum.class, (Object)this.getFixedRatePaymentFrequencyPeriod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriod"), FrequencyPeriodEnum.class, (Object)this.getFloatingRatePaymentFrequencyPeriod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodMultiplier"), Integer.class, (Object)this.getFixedRatePaymentFrequencyPeriodMultiplier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodMultiplier"), Integer.class, (Object)this.getFloatingRatePaymentFrequencyPeriodMultiplier(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class PeriodicPaymentBuilderImpl
    implements PeriodicPaymentBuilder {
        protected InterestComputationMethod4Code fixedRateDayCountConvention;
        protected InterestComputationMethod4Code floatingRateDayCountConvention;
        protected FrequencyPeriodEnum fixedRatePaymentFrequencyPeriod;
        protected FrequencyPeriodEnum floatingRatePaymentFrequencyPeriod;
        protected Integer fixedRatePaymentFrequencyPeriodMultiplier;
        protected Integer floatingRatePaymentFrequencyPeriodMultiplier;

        @Override
        @RosettaAttribute(value="fixedRateDayCountConvention")
        @RuneAttribute(value="fixedRateDayCountConvention")
        public InterestComputationMethod4Code getFixedRateDayCountConvention() {
            return this.fixedRateDayCountConvention;
        }

        @Override
        @RosettaAttribute(value="floatingRateDayCountConvention")
        @RuneAttribute(value="floatingRateDayCountConvention")
        public InterestComputationMethod4Code getFloatingRateDayCountConvention() {
            return this.floatingRateDayCountConvention;
        }

        @Override
        @RosettaAttribute(value="fixedRatePaymentFrequencyPeriod")
        @RuneAttribute(value="fixedRatePaymentFrequencyPeriod")
        public FrequencyPeriodEnum getFixedRatePaymentFrequencyPeriod() {
            return this.fixedRatePaymentFrequencyPeriod;
        }

        @Override
        @RosettaAttribute(value="floatingRatePaymentFrequencyPeriod")
        @RuneAttribute(value="floatingRatePaymentFrequencyPeriod")
        public FrequencyPeriodEnum getFloatingRatePaymentFrequencyPeriod() {
            return this.floatingRatePaymentFrequencyPeriod;
        }

        @Override
        @RosettaAttribute(value="fixedRatePaymentFrequencyPeriodMultiplier")
        @RuneAttribute(value="fixedRatePaymentFrequencyPeriodMultiplier")
        public Integer getFixedRatePaymentFrequencyPeriodMultiplier() {
            return this.fixedRatePaymentFrequencyPeriodMultiplier;
        }

        @Override
        @RosettaAttribute(value="floatingRatePaymentFrequencyPeriodMultiplier")
        @RuneAttribute(value="floatingRatePaymentFrequencyPeriodMultiplier")
        public Integer getFloatingRatePaymentFrequencyPeriodMultiplier() {
            return this.floatingRatePaymentFrequencyPeriodMultiplier;
        }

        @Override
        @RosettaAttribute(value="fixedRateDayCountConvention")
        @RuneAttribute(value="fixedRateDayCountConvention")
        public PeriodicPaymentBuilder setFixedRateDayCountConvention(InterestComputationMethod4Code _fixedRateDayCountConvention) {
            this.fixedRateDayCountConvention = _fixedRateDayCountConvention == null ? null : _fixedRateDayCountConvention;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRateDayCountConvention")
        @RuneAttribute(value="floatingRateDayCountConvention")
        public PeriodicPaymentBuilder setFloatingRateDayCountConvention(InterestComputationMethod4Code _floatingRateDayCountConvention) {
            this.floatingRateDayCountConvention = _floatingRateDayCountConvention == null ? null : _floatingRateDayCountConvention;
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedRatePaymentFrequencyPeriod")
        @RuneAttribute(value="fixedRatePaymentFrequencyPeriod")
        public PeriodicPaymentBuilder setFixedRatePaymentFrequencyPeriod(FrequencyPeriodEnum _fixedRatePaymentFrequencyPeriod) {
            this.fixedRatePaymentFrequencyPeriod = _fixedRatePaymentFrequencyPeriod == null ? null : _fixedRatePaymentFrequencyPeriod;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRatePaymentFrequencyPeriod")
        @RuneAttribute(value="floatingRatePaymentFrequencyPeriod")
        public PeriodicPaymentBuilder setFloatingRatePaymentFrequencyPeriod(FrequencyPeriodEnum _floatingRatePaymentFrequencyPeriod) {
            this.floatingRatePaymentFrequencyPeriod = _floatingRatePaymentFrequencyPeriod == null ? null : _floatingRatePaymentFrequencyPeriod;
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedRatePaymentFrequencyPeriodMultiplier")
        @RuneAttribute(value="fixedRatePaymentFrequencyPeriodMultiplier")
        public PeriodicPaymentBuilder setFixedRatePaymentFrequencyPeriodMultiplier(Integer _fixedRatePaymentFrequencyPeriodMultiplier) {
            this.fixedRatePaymentFrequencyPeriodMultiplier = _fixedRatePaymentFrequencyPeriodMultiplier == null ? null : _fixedRatePaymentFrequencyPeriodMultiplier;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRatePaymentFrequencyPeriodMultiplier")
        @RuneAttribute(value="floatingRatePaymentFrequencyPeriodMultiplier")
        public PeriodicPaymentBuilder setFloatingRatePaymentFrequencyPeriodMultiplier(Integer _floatingRatePaymentFrequencyPeriodMultiplier) {
            this.floatingRatePaymentFrequencyPeriodMultiplier = _floatingRatePaymentFrequencyPeriodMultiplier == null ? null : _floatingRatePaymentFrequencyPeriodMultiplier;
            return this;
        }

        @Override
        public PeriodicPayment build() {
            return new PeriodicPaymentImpl(this);
        }

        @Override
        public PeriodicPaymentBuilder toBuilder() {
            return this;
        }

        @Override
        public PeriodicPaymentBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getFixedRateDayCountConvention() != null) {
                return true;
            }
            if (this.getFloatingRateDayCountConvention() != null) {
                return true;
            }
            if (this.getFixedRatePaymentFrequencyPeriod() != null) {
                return true;
            }
            if (this.getFloatingRatePaymentFrequencyPeriod() != null) {
                return true;
            }
            if (this.getFixedRatePaymentFrequencyPeriodMultiplier() != null) {
                return true;
            }
            return this.getFloatingRatePaymentFrequencyPeriodMultiplier() != null;
        }

        public PeriodicPaymentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PeriodicPaymentBuilder o = (PeriodicPaymentBuilder)other;
            merger.mergeBasic((Object)this.getFixedRateDayCountConvention(), (Object)o.getFixedRateDayCountConvention(), this::setFixedRateDayCountConvention, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFloatingRateDayCountConvention(), (Object)o.getFloatingRateDayCountConvention(), this::setFloatingRateDayCountConvention, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFixedRatePaymentFrequencyPeriod(), (Object)o.getFixedRatePaymentFrequencyPeriod(), this::setFixedRatePaymentFrequencyPeriod, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFloatingRatePaymentFrequencyPeriod(), (Object)o.getFloatingRatePaymentFrequencyPeriod(), this::setFloatingRatePaymentFrequencyPeriod, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFixedRatePaymentFrequencyPeriodMultiplier(), (Object)o.getFixedRatePaymentFrequencyPeriodMultiplier(), this::setFixedRatePaymentFrequencyPeriodMultiplier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFloatingRatePaymentFrequencyPeriodMultiplier(), (Object)o.getFloatingRatePaymentFrequencyPeriodMultiplier(), this::setFloatingRatePaymentFrequencyPeriodMultiplier, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PeriodicPayment _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.fixedRateDayCountConvention, (Object)_that.getFixedRateDayCountConvention())) {
                return false;
            }
            if (!Objects.equals((Object)this.floatingRateDayCountConvention, (Object)_that.getFloatingRateDayCountConvention())) {
                return false;
            }
            if (!Objects.equals((Object)this.fixedRatePaymentFrequencyPeriod, (Object)_that.getFixedRatePaymentFrequencyPeriod())) {
                return false;
            }
            if (!Objects.equals((Object)this.floatingRatePaymentFrequencyPeriod, (Object)_that.getFloatingRatePaymentFrequencyPeriod())) {
                return false;
            }
            if (!Objects.equals(this.fixedRatePaymentFrequencyPeriodMultiplier, _that.getFixedRatePaymentFrequencyPeriodMultiplier())) {
                return false;
            }
            return Objects.equals(this.floatingRatePaymentFrequencyPeriodMultiplier, _that.getFloatingRatePaymentFrequencyPeriodMultiplier());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.fixedRateDayCountConvention != null ? ((Object)((Object)this.fixedRateDayCountConvention)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.floatingRateDayCountConvention != null ? ((Object)((Object)this.floatingRateDayCountConvention)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.fixedRatePaymentFrequencyPeriod != null ? ((Object)((Object)this.fixedRatePaymentFrequencyPeriod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.floatingRatePaymentFrequencyPeriod != null ? ((Object)((Object)this.floatingRatePaymentFrequencyPeriod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.fixedRatePaymentFrequencyPeriodMultiplier != null ? this.fixedRatePaymentFrequencyPeriodMultiplier.hashCode() : 0);
            _result = 31 * _result + (this.floatingRatePaymentFrequencyPeriodMultiplier != null ? this.floatingRatePaymentFrequencyPeriodMultiplier.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PeriodicPaymentBuilder {fixedRateDayCountConvention=" + String.valueOf((Object)this.fixedRateDayCountConvention) + ", floatingRateDayCountConvention=" + String.valueOf((Object)this.floatingRateDayCountConvention) + ", fixedRatePaymentFrequencyPeriod=" + String.valueOf((Object)this.fixedRatePaymentFrequencyPeriod) + ", floatingRatePaymentFrequencyPeriod=" + String.valueOf((Object)this.floatingRatePaymentFrequencyPeriod) + ", fixedRatePaymentFrequencyPeriodMultiplier=" + this.fixedRatePaymentFrequencyPeriodMultiplier + ", floatingRatePaymentFrequencyPeriodMultiplier=" + this.floatingRatePaymentFrequencyPeriodMultiplier + "}";
        }
    }

    public static interface PeriodicPaymentBuilder
    extends PeriodicPayment,
    RosettaModelObjectBuilder {
        public PeriodicPaymentBuilder setFixedRateDayCountConvention(InterestComputationMethod4Code var1);

        public PeriodicPaymentBuilder setFloatingRateDayCountConvention(InterestComputationMethod4Code var1);

        public PeriodicPaymentBuilder setFixedRatePaymentFrequencyPeriod(FrequencyPeriodEnum var1);

        public PeriodicPaymentBuilder setFloatingRatePaymentFrequencyPeriod(FrequencyPeriodEnum var1);

        public PeriodicPaymentBuilder setFixedRatePaymentFrequencyPeriodMultiplier(Integer var1);

        public PeriodicPaymentBuilder setFloatingRatePaymentFrequencyPeriodMultiplier(Integer var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fixedRateDayCountConvention"), InterestComputationMethod4Code.class, (Object)this.getFixedRateDayCountConvention(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingRateDayCountConvention"), InterestComputationMethod4Code.class, (Object)this.getFloatingRateDayCountConvention(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriod"), FrequencyPeriodEnum.class, (Object)this.getFixedRatePaymentFrequencyPeriod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriod"), FrequencyPeriodEnum.class, (Object)this.getFloatingRatePaymentFrequencyPeriod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodMultiplier"), Integer.class, (Object)this.getFixedRatePaymentFrequencyPeriodMultiplier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodMultiplier"), Integer.class, (Object)this.getFloatingRatePaymentFrequencyPeriodMultiplier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public PeriodicPaymentBuilder prune();
    }

    public static class PeriodicPaymentImpl
    implements PeriodicPayment {
        private final InterestComputationMethod4Code fixedRateDayCountConvention;
        private final InterestComputationMethod4Code floatingRateDayCountConvention;
        private final FrequencyPeriodEnum fixedRatePaymentFrequencyPeriod;
        private final FrequencyPeriodEnum floatingRatePaymentFrequencyPeriod;
        private final Integer fixedRatePaymentFrequencyPeriodMultiplier;
        private final Integer floatingRatePaymentFrequencyPeriodMultiplier;

        protected PeriodicPaymentImpl(PeriodicPaymentBuilder builder) {
            this.fixedRateDayCountConvention = builder.getFixedRateDayCountConvention();
            this.floatingRateDayCountConvention = builder.getFloatingRateDayCountConvention();
            this.fixedRatePaymentFrequencyPeriod = builder.getFixedRatePaymentFrequencyPeriod();
            this.floatingRatePaymentFrequencyPeriod = builder.getFloatingRatePaymentFrequencyPeriod();
            this.fixedRatePaymentFrequencyPeriodMultiplier = builder.getFixedRatePaymentFrequencyPeriodMultiplier();
            this.floatingRatePaymentFrequencyPeriodMultiplier = builder.getFloatingRatePaymentFrequencyPeriodMultiplier();
        }

        @Override
        @RosettaAttribute(value="fixedRateDayCountConvention")
        @RuneAttribute(value="fixedRateDayCountConvention")
        public InterestComputationMethod4Code getFixedRateDayCountConvention() {
            return this.fixedRateDayCountConvention;
        }

        @Override
        @RosettaAttribute(value="floatingRateDayCountConvention")
        @RuneAttribute(value="floatingRateDayCountConvention")
        public InterestComputationMethod4Code getFloatingRateDayCountConvention() {
            return this.floatingRateDayCountConvention;
        }

        @Override
        @RosettaAttribute(value="fixedRatePaymentFrequencyPeriod")
        @RuneAttribute(value="fixedRatePaymentFrequencyPeriod")
        public FrequencyPeriodEnum getFixedRatePaymentFrequencyPeriod() {
            return this.fixedRatePaymentFrequencyPeriod;
        }

        @Override
        @RosettaAttribute(value="floatingRatePaymentFrequencyPeriod")
        @RuneAttribute(value="floatingRatePaymentFrequencyPeriod")
        public FrequencyPeriodEnum getFloatingRatePaymentFrequencyPeriod() {
            return this.floatingRatePaymentFrequencyPeriod;
        }

        @Override
        @RosettaAttribute(value="fixedRatePaymentFrequencyPeriodMultiplier")
        @RuneAttribute(value="fixedRatePaymentFrequencyPeriodMultiplier")
        public Integer getFixedRatePaymentFrequencyPeriodMultiplier() {
            return this.fixedRatePaymentFrequencyPeriodMultiplier;
        }

        @Override
        @RosettaAttribute(value="floatingRatePaymentFrequencyPeriodMultiplier")
        @RuneAttribute(value="floatingRatePaymentFrequencyPeriodMultiplier")
        public Integer getFloatingRatePaymentFrequencyPeriodMultiplier() {
            return this.floatingRatePaymentFrequencyPeriodMultiplier;
        }

        @Override
        public PeriodicPayment build() {
            return this;
        }

        @Override
        public PeriodicPaymentBuilder toBuilder() {
            PeriodicPaymentBuilder builder = PeriodicPayment.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PeriodicPaymentBuilder builder) {
            Optional.ofNullable(this.getFixedRateDayCountConvention()).ifPresent(builder::setFixedRateDayCountConvention);
            Optional.ofNullable(this.getFloatingRateDayCountConvention()).ifPresent(builder::setFloatingRateDayCountConvention);
            Optional.ofNullable(this.getFixedRatePaymentFrequencyPeriod()).ifPresent(builder::setFixedRatePaymentFrequencyPeriod);
            Optional.ofNullable(this.getFloatingRatePaymentFrequencyPeriod()).ifPresent(builder::setFloatingRatePaymentFrequencyPeriod);
            Optional.ofNullable(this.getFixedRatePaymentFrequencyPeriodMultiplier()).ifPresent(builder::setFixedRatePaymentFrequencyPeriodMultiplier);
            Optional.ofNullable(this.getFloatingRatePaymentFrequencyPeriodMultiplier()).ifPresent(builder::setFloatingRatePaymentFrequencyPeriodMultiplier);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PeriodicPayment _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.fixedRateDayCountConvention, (Object)_that.getFixedRateDayCountConvention())) {
                return false;
            }
            if (!Objects.equals((Object)this.floatingRateDayCountConvention, (Object)_that.getFloatingRateDayCountConvention())) {
                return false;
            }
            if (!Objects.equals((Object)this.fixedRatePaymentFrequencyPeriod, (Object)_that.getFixedRatePaymentFrequencyPeriod())) {
                return false;
            }
            if (!Objects.equals((Object)this.floatingRatePaymentFrequencyPeriod, (Object)_that.getFloatingRatePaymentFrequencyPeriod())) {
                return false;
            }
            if (!Objects.equals(this.fixedRatePaymentFrequencyPeriodMultiplier, _that.getFixedRatePaymentFrequencyPeriodMultiplier())) {
                return false;
            }
            return Objects.equals(this.floatingRatePaymentFrequencyPeriodMultiplier, _that.getFloatingRatePaymentFrequencyPeriodMultiplier());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.fixedRateDayCountConvention != null ? ((Object)((Object)this.fixedRateDayCountConvention)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.floatingRateDayCountConvention != null ? ((Object)((Object)this.floatingRateDayCountConvention)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.fixedRatePaymentFrequencyPeriod != null ? ((Object)((Object)this.fixedRatePaymentFrequencyPeriod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.floatingRatePaymentFrequencyPeriod != null ? ((Object)((Object)this.floatingRatePaymentFrequencyPeriod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.fixedRatePaymentFrequencyPeriodMultiplier != null ? this.fixedRatePaymentFrequencyPeriodMultiplier.hashCode() : 0);
            _result = 31 * _result + (this.floatingRatePaymentFrequencyPeriodMultiplier != null ? this.floatingRatePaymentFrequencyPeriodMultiplier.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PeriodicPayment {fixedRateDayCountConvention=" + String.valueOf((Object)this.fixedRateDayCountConvention) + ", floatingRateDayCountConvention=" + String.valueOf((Object)this.floatingRateDayCountConvention) + ", fixedRatePaymentFrequencyPeriod=" + String.valueOf((Object)this.fixedRatePaymentFrequencyPeriod) + ", floatingRatePaymentFrequencyPeriod=" + String.valueOf((Object)this.floatingRatePaymentFrequencyPeriod) + ", fixedRatePaymentFrequencyPeriodMultiplier=" + this.fixedRatePaymentFrequencyPeriodMultiplier + ", floatingRatePaymentFrequencyPeriodMultiplier=" + this.floatingRatePaymentFrequencyPeriodMultiplier + "}";
        }
    }
}

