/*
 * Decompiled with CFR 0.152.
 */
package drr.base.trade.underlier.functions;

import cdm.product.asset.CommodityPayout;
import cdm.product.template.ForwardPayout;
import cdm.product.template.OptionPayout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.functions.EconomicTermsForProduct;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=UnderlierForProductDefault.class)
public abstract class UnderlierForProduct
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;

    public Product evaluate(Product product) {
        Product underlierProduct;
        Product.ProductBuilder underlierProductBuilder = this.doEvaluate(product);
        if (underlierProductBuilder == null) {
            underlierProduct = null;
        } else {
            underlierProduct = underlierProductBuilder.build();
            this.objectValidator.validate(Product.class, (RosettaModelObject)underlierProduct);
        }
        return underlierProduct;
    }

    protected abstract Product.ProductBuilder doEvaluate(Product var1);

    public static class UnderlierForProductDefault
    extends UnderlierForProduct {
        @Override
        protected Product.ProductBuilder doEvaluate(Product product) {
            Product.ProductBuilder underlierProduct = Product.builder();
            return this.assignOutput(underlierProduct, product);
        }

        protected Product.ProductBuilder assignOutput(Product.ProductBuilder underlierProduct, Product product) {
            underlierProduct = ExpressionOperators.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout())).getOrDefault(Boolean.valueOf(false)) != false ? (Product.ProductBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)((OptionPayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).get())).map("getUnderlier", optionPayout -> optionPayout.getUnderlier()).get()) : (ExpressionOperators.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout())).getOrDefault(Boolean.valueOf(false)) != false ? (Product.ProductBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)((ForwardPayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).get())).map("getUnderlier", forwardPayout -> forwardPayout.getUnderlier()).get()) : (ExpressionOperators.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout())).getOrDefault(Boolean.valueOf(false)) != false ? (Product.ProductBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)((PerformancePayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get())).map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).get()) : (ExpressionOperators.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout())).getOrDefault(Boolean.valueOf(false)) != false ? (Product.ProductBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)((CommodityPayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).get())).map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).get()) : null)));
            return Optional.ofNullable(underlierProduct).map(o -> o.prune()).orElse(null);
        }
    }
}

