/*
 * Decompiled with CFR 0.152.
 */
package drr.projection.dtcc.rds.harmonized.csa.rewrite.trade.functions;

import cdm.base.staticdata.asset.common.AssetClassEnum;
import cdm.base.staticdata.asset.common.ISOCountryCodeEnum;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.base.staticdata.party.PartyIdentifierTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.base.trade.price.PriceNotationEnum;
import drr.base.trade.price.functions.NotationStringFromEnum;
import drr.base.util.string.functions.SubString;
import drr.regulation.common.ClearingAccountOriginEnum;
import drr.regulation.common.ClearingExceptionsAndExemptionsEnum;
import drr.regulation.common.trade.contract.MasterAgreementEnum;
import drr.regulation.csa.rewrite.trade.CSATransactionReport;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.ClearedEnum;
import drr.standards.iso.EmbeddedOptionTypeEnum;
import drr.standards.iso.EventTypeEnum;
import drr.standards.iso.FrequencyPeriodEnum;
import drr.standards.iso.InterestComputationMethod4Code;
import drr.standards.iso.OptionStyleEnum;
import drr.standards.iso.ReportLevelEnum;
import iso20022.dtcc.rds.harmonized.HarmonizedData;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=Create_SubmissionHarmonizedDataDefault.class)
public abstract class Create_SubmissionHarmonizedData
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected NotationStringFromEnum notationStringFromEnum;
    @Inject
    protected SubString subString;

    public HarmonizedData evaluate(CSATransactionReport drrReport) {
        HarmonizedData harmonized;
        HarmonizedData.HarmonizedDataBuilder harmonizedBuilder = this.doEvaluate(drrReport);
        if (harmonizedBuilder == null) {
            harmonized = null;
        } else {
            harmonized = harmonizedBuilder.build();
            this.objectValidator.validate(HarmonizedData.class, (RosettaModelObject)harmonized);
        }
        return harmonized;
    }

    protected abstract HarmonizedData.HarmonizedDataBuilder doEvaluate(CSATransactionReport var1);

    public static class Create_SubmissionHarmonizedDataDefault
    extends Create_SubmissionHarmonizedData {
        @Override
        protected HarmonizedData.HarmonizedDataBuilder doEvaluate(CSATransactionReport drrReport) {
            HarmonizedData.HarmonizedDataBuilder harmonized = HarmonizedData.builder();
            return this.assignOutput(harmonized, drrReport);
        }

        protected HarmonizedData.HarmonizedDataBuilder assignOutput(HarmonizedData.HarmonizedDataBuilder harmonized, CSATransactionReport drrReport) {
            Integer integer0 = (Integer)MapperS.of((Object)drrReport).map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).map("getPeriodicPayment", cSALeg -> cSALeg.getPeriodicPayment()).map("getFixedRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriodMultiplier()).get();
            Integer integer1 = (Integer)MapperS.of((Object)drrReport).map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).map("getPeriodicPayment", cSALeg -> cSALeg.getPeriodicPayment()).map("getFixedRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriodMultiplier()).get();
            Integer integer2 = (Integer)MapperS.of((Object)drrReport).map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).map("getPeriodicPayment", cSALeg -> cSALeg.getPeriodicPayment()).map("getFloatingRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRatePaymentFrequencyPeriodMultiplier()).get();
            Integer integer3 = (Integer)MapperS.of((Object)drrReport).map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).map("getPeriodicPayment", cSALeg -> cSALeg.getPeriodicPayment()).map("getFloatingRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRatePaymentFrequencyPeriodMultiplier()).get();
            String ifThenElseResult0 = ExpressionOperators.exists((Mapper)MapperS.of((Object)drrReport).map("getPlatformIdentifier", cSATransactionReport -> cSATransactionReport.getPlatformIdentifier())).getOrDefault(Boolean.valueOf(false)) != false ? (String)MapperS.of((Object)drrReport).map("getPlatformIdentifier", cSATransactionReport -> cSATransactionReport.getPlatformIdentifier()).get() : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getCleared", cSATransactionReport -> cSATransactionReport.getCleared()), (Mapper)MapperS.of((Object)((Object)ClearedEnum.N)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getCleared", cSATransactionReport -> cSATransactionReport.getCleared()), (Mapper)MapperS.of((Object)((Object)ClearedEnum.I)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)) != false ? "BILT" : null);
            MapperS thenArg0 = MapperS.of((Object)drrReport).map("getPriceNotation", cSATransactionReport -> cSATransactionReport.getPriceNotation());
            MapperS thenArg1 = MapperS.of((Object)drrReport).map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).map("getSpreadNotation", cSALeg -> cSALeg.getSpreadNotation());
            MapperS thenArg2 = MapperS.of((Object)drrReport).map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).map("getSpreadNotation", cSALeg -> cSALeg.getSpreadNotation());
            MapperS thenArg3 = MapperS.of((Object)drrReport).map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).map("getPeriodicPayment", cSALeg -> cSALeg.getPeriodicPayment()).map("getFloatingRateResetFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRateResetFrequencyPeriod());
            MapperS ifThenElseResult1 = ExpressionOperators.areEqual((Mapper)thenArg3, (Mapper)MapperS.of((Object)((Object)FrequencyPeriodEnum.DAIL)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)"D") : (ExpressionOperators.areEqual((Mapper)thenArg3, (Mapper)MapperS.of((Object)((Object)FrequencyPeriodEnum.WEEK)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)"W") : (ExpressionOperators.areEqual((Mapper)thenArg3, (Mapper)MapperS.of((Object)((Object)FrequencyPeriodEnum.MNTH)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)"M") : (ExpressionOperators.areEqual((Mapper)thenArg3, (Mapper)MapperS.of((Object)((Object)FrequencyPeriodEnum.YEAR)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)"Y") : (ExpressionOperators.areEqual((Mapper)thenArg3, (Mapper)MapperS.of((Object)((Object)FrequencyPeriodEnum.EXPI)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)"T") : thenArg3.map("to-string", FrequencyPeriodEnum::toDisplayString)))));
            Integer integer4 = (Integer)MapperS.of((Object)drrReport).map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).map("getPeriodicPayment", cSALeg -> cSALeg.getPeriodicPayment()).map("getFloatingRateResetFrequencyMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRateResetFrequencyMultiplier()).get();
            String ifThenElseResult2 = ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).map("getOptionStyle", dTCCAdditionalFields -> dTCCAdditionalFields.getOptionStyle()), (Mapper)MapperS.of((Object)((Object)OptionStyleEnum.EURO)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? "European" : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).map("getOptionStyle", dTCCAdditionalFields -> dTCCAdditionalFields.getOptionStyle()), (Mapper)MapperS.of((Object)((Object)OptionStyleEnum.AMER)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? "American" : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).map("getOptionStyle", dTCCAdditionalFields -> dTCCAdditionalFields.getOptionStyle()), (Mapper)MapperS.of((Object)((Object)OptionStyleEnum.BERM)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? "Bermudan" : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).map("getOptionStyle", dTCCAdditionalFields -> dTCCAdditionalFields.getOptionStyle()), (Mapper)MapperS.of((Object)((Object)OptionStyleEnum.ASIA)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? "Asian" : null)));
            Integer integer5 = (Integer)MapperS.of((Object)drrReport).map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).map("getQuantityFrequencyMultiplier", cSALeg -> cSALeg.getQuantityFrequencyMultiplier()).get();
            Integer integer6 = (Integer)MapperS.of((Object)drrReport).map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).map("getQuantityFrequencyMultiplier", cSALeg -> cSALeg.getQuantityFrequencyMultiplier()).get();
            MapperS thenArg4 = MapperS.of((Object)drrReport).map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).map("getPeriodicPayment", cSALeg -> cSALeg.getPeriodicPayment()).map("getFloatingRateResetFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRateResetFrequencyPeriod());
            MapperS ifThenElseResult3 = ExpressionOperators.areEqual((Mapper)thenArg4, (Mapper)MapperS.of((Object)((Object)FrequencyPeriodEnum.DAIL)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)"D") : (ExpressionOperators.areEqual((Mapper)thenArg4, (Mapper)MapperS.of((Object)((Object)FrequencyPeriodEnum.WEEK)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)"W") : (ExpressionOperators.areEqual((Mapper)thenArg4, (Mapper)MapperS.of((Object)((Object)FrequencyPeriodEnum.MNTH)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)"M") : (ExpressionOperators.areEqual((Mapper)thenArg4, (Mapper)MapperS.of((Object)((Object)FrequencyPeriodEnum.YEAR)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)"Y") : (ExpressionOperators.areEqual((Mapper)thenArg4, (Mapper)MapperS.of((Object)((Object)FrequencyPeriodEnum.EXPI)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)"T") : thenArg4.map("to-string", FrequencyPeriodEnum::toDisplayString)))));
            Integer integer7 = (Integer)MapperS.of((Object)drrReport).map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).map("getPeriodicPayment", cSALeg -> cSALeg.getPeriodicPayment()).map("getFloatingRateResetFrequencyMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRateResetFrequencyMultiplier()).get();
            BigDecimal ifThenElseResult4 = ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getStrikePriceNotation", cSATransactionReport -> cSATransactionReport.getStrikePriceNotation()), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.MONETARY)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? (BigDecimal)MapperS.of((Object)drrReport).map("getStrikePrice", cSATransactionReport -> cSATransactionReport.getStrikePrice()).map("getMonetary", priceFormat -> priceFormat.getMonetary()).get() : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getStrikePriceNotation", cSATransactionReport -> cSATransactionReport.getStrikePriceNotation()), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.DECIMAL)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? (BigDecimal)MapperS.of((Object)drrReport).map("getStrikePrice", cSATransactionReport -> cSATransactionReport.getStrikePrice()).map("getDecimal", priceFormat -> priceFormat.getDecimal()).get() : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getStrikePriceNotation", cSATransactionReport -> cSATransactionReport.getStrikePriceNotation()), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.BASIS)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? (BigDecimal)MapperS.of((Object)drrReport).map("getStrikePrice", cSATransactionReport -> cSATransactionReport.getStrikePrice()).map("getBasis", priceFormat -> priceFormat.getBasis()).get() : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getStrikePriceNotation", cSATransactionReport -> cSATransactionReport.getStrikePriceNotation()), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.PERCENTAGE)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? (BigDecimal)MapperS.of((Object)drrReport).map("getStrikePrice", cSATransactionReport -> cSATransactionReport.getStrikePrice()).map("getPercentage", priceFormat -> priceFormat.getPercentage()).get() : null)));
            String ifThenElseResult5 = null;
            if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getStrikePriceNotation", cSATransactionReport -> cSATransactionReport.getStrikePriceNotation()), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.MONETARY)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult5 = this.subString.evaluate((String)MapperS.of((Object)drrReport).map("getStrikePriceCurrency", cSATransactionReport -> cSATransactionReport.getStrikePriceCurrency()).get(), 1, 3);
            }
            String ifThenElseResult6 = null;
            if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).map("getPrimaryAssetClass", dTCCAdditionalFields -> dTCCAdditionalFields.getPrimaryAssetClass()), (Mapper)MapperS.of((Object)AssetClassEnum.FOREIGN_EXCHANGE), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult6 = this.subString.evaluate((String)MapperS.of((Object)drrReport).map("getStrikePriceCurrency", cSATransactionReport -> cSATransactionReport.getStrikePriceCurrency()).get(), 5, 3);
            }
            MapperS thenArg5 = MapperS.of((Object)drrReport).map("getStrikePriceNotation", cSATransactionReport -> cSATransactionReport.getStrikePriceNotation());
            String ifThenElseResult7 = ExpressionOperators.exists((Mapper)MapperS.of((Object)drrReport).map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).map("getVersionTransaction", dTCCAdditionalFields -> dTCCAdditionalFields.getVersionTransaction())).getOrDefault(Boolean.valueOf(false)) != false ? (String)MapperS.of((Object)drrReport).map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).map("getVersionTransaction", dTCCAdditionalFields -> dTCCAdditionalFields.getVersionTransaction()).get() : (ExpressionOperators.exists((Mapper)MapperS.of((Object)drrReport).map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).map("getVersionPPD", dTCCAdditionalFields -> dTCCAdditionalFields.getVersionPPD())).getOrDefault(Boolean.valueOf(false)) != false ? (String)MapperS.of((Object)drrReport).map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).map("getVersionPPD", dTCCAdditionalFields -> dTCCAdditionalFields.getVersionPPD()).get() : null);
            Integer integer8 = (Integer)MapperS.of((Object)drrReport).map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).map("getPeriodicPayment", cSALeg -> cSALeg.getPeriodicPayment()).map("getFloatingRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRatePaymentFrequencyPeriodMultiplier()).get();
            Integer integer9 = (Integer)MapperS.of((Object)drrReport).map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).map("getPeriodicPayment", cSALeg -> cSALeg.getPeriodicPayment()).map("getFloatingRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRatePaymentFrequencyPeriodMultiplier()).get();
            Integer integer10 = (Integer)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)drrReport).map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).map("getPeriodicPayment", cSALeg -> cSALeg.getPeriodicPayment()).map("getFixedRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriodMultiplier()), MapperS.of((Object)drrReport).map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).map("getPeriodicPayment", cSALeg -> cSALeg.getPeriodicPayment()).map("getFloatingRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRatePaymentFrequencyPeriodMultiplier())}).get();
            Integer integer11 = (Integer)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)drrReport).map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).map("getPeriodicPayment", cSALeg -> cSALeg.getPeriodicPayment()).map("getFixedRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriodMultiplier()), MapperS.of((Object)drrReport).map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).map("getPeriodicPayment", cSALeg -> cSALeg.getPeriodicPayment()).map("getFloatingRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRatePaymentFrequencyPeriodMultiplier())}).get();
            MapperS thenArg6 = MapperS.of((Object)drrReport).map("getPackageTransactionPriceNotation", cSATransactionReport -> cSATransactionReport.getPackageTransactionPriceNotation());
            MapperS thenArg7 = MapperS.of((Object)drrReport).map("getPackageTransactionSpreadNotation", cSATransactionReport -> cSATransactionReport.getPackageTransactionSpreadNotation());
            MapperC thenArg8 = MapperS.of((Object)drrReport).mapC("getClearingExceptionsAndExemptionsCounterparty1", cSATransactionReport -> cSATransactionReport.getClearingExceptionsAndExemptionsCounterparty1());
            MapperC thenArg9 = thenArg8.mapItem(item -> item.map("to-string", ClearingExceptionsAndExemptionsEnum::toDisplayString));
            harmonized = (HarmonizedData.HarmonizedDataBuilder)this.toBuilder((RosettaModelObject)HarmonizedData.builder().setAmendmentIndicator((Boolean)MapperS.of((Object)drrReport).map("getAmendmentIndicator", cSATransactionReport -> cSATransactionReport.getAmendmentIndicator()).get()).setCdePackageTransactionSpreadCurrency((String)MapperS.of((Object)drrReport).map("getPackageTransactionSpreadCurrency", cSATransactionReport -> cSATransactionReport.getPackageTransactionSpreadCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).setClearingVenueIdType((String)MapperS.of((Object)drrReport).map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).map("getClearingVenueIDType", dTCCAdditionalFields -> dTCCAdditionalFields.getClearingVenueIDType()).map("to-string", PartyIdentifierTypeEnum::toDisplayString).get()).setClearingVenueId((String)MapperS.of((Object)drrReport).map("getCentralCounterparty", cSATransactionReport -> cSATransactionReport.getCentralCounterparty()).get()).setTradeParty1ClearingBrokerId((String)MapperS.of((Object)drrReport).map("getClearingMember", cSATransactionReport -> cSATransactionReport.getClearingMember()).get()).setTradeParty1ClearingBrokerIdType((String)MapperS.of((Object)drrReport).map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).map("getTradeParty1ClearingBrokerIDType", dTCCAdditionalFields -> dTCCAdditionalFields.getTradeParty1ClearingBrokerIDType()).map("to-string", PartyIdentifierTypeEnum::toDisplayString).get()).setBuyerPayer1((String)MapperS.of((Object)drrReport).map("getBuyerIdentifier", cSATransactionReport -> cSATransactionReport.getBuyerIdentifier()).get()).setCdeCallAmountLeg1((BigDecimal)MapperS.of((Object)drrReport).map("getCallAmount", cSATransactionReport -> cSATransactionReport.getCallAmount()).get()).setCdeCallCurrencyLeg1((String)MapperS.of((Object)drrReport).map("getCallCurrency", cSATransactionReport -> cSATransactionReport.getCallCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).setCdeEffectiveDate((Date)MapperS.of((Object)drrReport).map("getEffectiveDate", cSATransactionReport -> cSATransactionReport.getEffectiveDate()).get()).setCustomBasketIndicator((Boolean)MapperS.of((Object)drrReport).map("getCustomBasketIndicator", cSATransactionReport -> cSATransactionReport.getCustomBasketIndicator()).get()).setCdeExpirationDate((Date)MapperS.of((Object)drrReport).map("getExpirationDate", cSATransactionReport -> cSATransactionReport.getExpirationDate()).get()).setCdeFinalContractualSettlementDate((Date)MapperS.of((Object)drrReport).map("getFinalContractualSettlementDate", cSATransactionReport -> cSATransactionReport.getFinalContractualSettlementDate()).get()).setCdeFirstExerciseDate((Date)MapperS.of((Object)drrReport).map("getFirstExerciseDate", cSATransactionReport -> cSATransactionReport.getFirstExerciseDate()).get()).setCdeFixedRateDayCountConventionLeg1((String)MapperS.of((Object)drrReport).map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).map("getPeriodicPayment", cSALeg -> cSALeg.getPeriodicPayment()).map("getFixedRateDayCountConvention", commonPeriodicPayment -> commonPeriodicPayment.getFixedRateDayCountConvention()).map("to-string", InterestComputationMethod4Code::toDisplayString).get()).setCdeFixedRateDayCountConventionLeg2((String)MapperS.of((Object)drrReport).map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).map("getPeriodicPayment", cSALeg -> cSALeg.getPeriodicPayment()).map("getFixedRateDayCountConvention", commonPeriodicPayment -> commonPeriodicPayment.getFixedRateDayCountConvention()).map("to-string", InterestComputationMethod4Code::toDisplayString).get()).setCdeFixedRatePaymentFrequencyPeriodMultiplierLeg1(integer0 == null ? null : BigDecimal.valueOf(integer0.intValue())).setCdeFixedRatePaymentFrequencyPeriodMultiplierLeg2(integer1 == null ? null : BigDecimal.valueOf(integer1.intValue())).setCdeFixedRatePaymentFrequencyPeriodLeg1((String)MapperS.of((Object)drrReport).map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).map("getPeriodicPayment", cSALeg -> cSALeg.getPeriodicPayment()).map("getFixedRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriod()).map("to-string", FrequencyPeriodEnum::toDisplayString).get()).setCdeFixedRatePaymentFrequencyPeriodLeg2((String)MapperS.of((Object)drrReport).map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).map("getPeriodicPayment", cSALeg -> cSALeg.getPeriodicPayment()).map("getFixedRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriod()).map("to-string", FrequencyPeriodEnum::toDisplayString).get()).setCdeFloatingRateDayCountConventionLeg1((String)MapperS.of((Object)drrReport).map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).map("getPeriodicPayment", cSALeg -> cSALeg.getPeriodicPayment()).map("getFloatingRateDayCountConvention", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRateDayCountConvention()).map("to-string", InterestComputationMethod4Code::toDisplayString).get()).setCdeFloatingRateDayCountConventionLeg2((String)MapperS.of((Object)drrReport).map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).map("getPeriodicPayment", cSALeg -> cSALeg.getPeriodicPayment()).map("getFloatingRateDayCountConvention", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRateDayCountConvention()).map("to-string", InterestComputationMethod4Code::toDisplayString).get()).setCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1(integer2 == null ? null : BigDecimal.valueOf(integer2.intValue())).setCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2(integer3 == null ? null : BigDecimal.valueOf(integer3.intValue())).setCdeFloatingRatePaymentFrequencyPeriodLeg1((String)MapperS.of((Object)drrReport).map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).map("getPeriodicPayment", cSALeg -> cSALeg.getPeriodicPayment()).map("getFloatingRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRatePaymentFrequencyPeriod()).map("to-string", FrequencyPeriodEnum::toDisplayString).get()).setCdeFloatingRatePaymentFrequencyPeriodLeg2((String)MapperS.of((Object)drrReport).map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).map("getPeriodicPayment", cSALeg -> cSALeg.getPeriodicPayment()).map("getFloatingRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRatePaymentFrequencyPeriod()).map("to-string", FrequencyPeriodEnum::toDisplayString).get()).setCdePlatformIdentifier(ifThenElseResult0).setCdePriceCurrency((String)MapperS.of((Object)drrReport).map("getPriceCurrency", cSATransactionReport -> cSATransactionReport.getPriceCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).setCdePriceNotation((String)MapperS.of((Object)this.notationStringFromEnum.evaluate((PriceNotationEnum)((Object)thenArg0.get()))).get()).setCdePutAmountLeg1((BigDecimal)MapperS.of((Object)drrReport).map("getPutAmount", cSATransactionReport -> cSATransactionReport.getPutAmount()).get()).setCdePutCurrencyLeg1((String)MapperS.of((Object)drrReport).map("getPutCurrency", cSATransactionReport -> cSATransactionReport.getPutCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).setCdeQuantityUnitOfMeasureLeg1((String)MapperS.of((Object)drrReport).map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).map("getQuantityUnitOfMeasure", cSALeg -> cSALeg.getQuantityUnitOfMeasure()).get()).setCdeQuantityUnitOfMeasureLeg2((String)MapperS.of((Object)drrReport).map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).map("getQuantityUnitOfMeasure", cSALeg -> cSALeg.getQuantityUnitOfMeasure()).get()).setCdeReceiverIdentifierLeg2((String)MapperS.of((Object)drrReport).map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).map("getReceiverIdentifier", cSALeg -> cSALeg.getReceiverIdentifier()).get()).setCdeSettlementLocationLeg1((String)MapperS.of((Object)drrReport).map("getSettlementLocation", cSATransactionReport -> cSATransactionReport.getSettlementLocation()).map("to-string", ISOCountryCodeEnum::toDisplayString).get()).setCdeSpreadNotationLeg1((String)MapperS.of((Object)this.notationStringFromEnum.evaluate((PriceNotationEnum)((Object)thenArg1.get()))).get()).setCdeSpreadNotationLeg2((String)MapperS.of((Object)this.notationStringFromEnum.evaluate((PriceNotationEnum)((Object)thenArg2.get()))).get()).setClearingStatus((String)MapperS.of((Object)drrReport).map("getCleared", cSATransactionReport -> cSATransactionReport.getCleared()).map("to-string", ClearedEnum::toDisplayString).get()).setEventType((String)MapperS.of((Object)drrReport).map("getEventType", cSATransactionReport -> cSATransactionReport.getEventType()).map("to-string", EventTypeEnum::toDisplayString).get()).setFixingDateLeg1((Date)MapperS.of((Object)drrReport).map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).map("getFixingDate", cSALeg -> cSALeg.getFixingDate()).map("Date", zdt -> Date.of((LocalDate)zdt.toLocalDate())).get()).setFixingDateLeg2((Date)MapperS.of((Object)drrReport).map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).map("getFixingDate", cSALeg -> cSALeg.getFixingDate()).map("Date", zdt -> Date.of((LocalDate)zdt.toLocalDate())).get()).setIndexFactor((BigDecimal)MapperS.of((Object)drrReport).map("getIndexFactor", cSATransactionReport -> cSATransactionReport.getIndexFactor()).get()).setExchangeRate((BigDecimal)MapperS.of((Object)drrReport).map("getExchangeRate", cSATransactionReport -> cSATransactionReport.getExchangeRate()).get()).setLeg1FixedRateInitial((BigDecimal)MapperS.of((Object)drrReport).map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).map("getFixedRate", cSALeg -> cSALeg.getFixedRate()).get()).setLeg1NotionalQuantity((BigDecimal)MapperS.of((Object)drrReport).map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).map("getNotionalQuantity", cSALeg -> cSALeg.getNotionalQuantity()).get()).setLeg1SpreadCurrency((String)MapperS.of((Object)drrReport).map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).map("getSpreadCurrency", cSALeg -> cSALeg.getSpreadCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).setLeg1TotalNotionalQuantity((BigDecimal)MapperS.of((Object)drrReport).map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).map("getTotalNotionalQuantity", cSALeg -> cSALeg.getTotalNotionalQuantity()).get()).setLeg2FixedRateInitial((BigDecimal)MapperS.of((Object)drrReport).map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).map("getFixedRate", cSALeg -> cSALeg.getFixedRate()).get()).setLeg2NotionalQuantity((BigDecimal)MapperS.of((Object)drrReport).map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).map("getNotionalQuantity", cSALeg -> cSALeg.getNotionalQuantity()).get()).setLeg2QuantityFrequency((String)MapperS.of((Object)drrReport).map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).map("getQuantityFrequency", cSALeg -> cSALeg.getQuantityFrequency()).map("to-string", FrequencyPeriodEnum::toDisplayString).get()).setLeg2ResetFrequencyPeriod((String)ifThenElseResult1.get()).setLeg2ResetFrequencyPeriodMultiplier(integer4 == null ? null : BigDecimal.valueOf(integer4.intValue())).setLeg2SettlementCurrency((String)MapperS.of((Object)drrReport).map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).map("getSettlementCurrency", cSALeg -> cSALeg.getSettlementCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).setLeg2SpreadCurrency((String)MapperS.of((Object)drrReport).map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).map("getSpreadCurrency", cSALeg -> cSALeg.getSpreadCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).setLeg2TotalNotionalQuantity((BigDecimal)MapperS.of((Object)drrReport).map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).map("getTotalNotionalQuantity", cSALeg -> cSALeg.getTotalNotionalQuantity()).get()).setNewSdrIdentifier((String)MapperS.of((Object)drrReport).map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).map("getNewSDRIdentifier", dTCCAdditionalFields -> dTCCAdditionalFields.getNewSDRIdentifier()).get()).setNoaActionType((String)MapperS.of((Object)drrReport).map("getActionType", cSATransactionReport -> cSATransactionReport.getActionType()).map("to-string", ActionTypeEnum::toDisplayString).get()).setNonStandardTradeIndicator((Boolean)MapperS.of((Object)drrReport).map("getNonStandardizedTermIndicator", cSATransactionReport -> cSATransactionReport.getNonStandardizedTermIndicator()).get()).setNotionalAmount1((BigDecimal)MapperS.of((Object)drrReport).map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).map("getNotionalAmount", cSALeg -> cSALeg.getNotionalAmount()).get()).setNotionalAmount2((BigDecimal)MapperS.of((Object)drrReport).map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).map("getNotionalAmount", cSALeg -> cSALeg.getNotionalAmount()).get()).setNotionalCurrency1((String)MapperS.of((Object)drrReport).map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).map("getNotionalCurrency", cSALeg -> cSALeg.getNotionalCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).setNotionalCurrency2((String)MapperS.of((Object)drrReport).map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).map("getNotionalCurrency", cSALeg -> cSALeg.getNotionalCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).setOptionStyle(ifThenElseResult2).setOptionType((String)MapperS.of((Object)drrReport).map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).map("getOptionType", dTCCAdditionalFields -> dTCCAdditionalFields.getOptionType()).get()).setOriginalExecutionTimestamp((ZonedDateTime)MapperS.of((Object)drrReport).map("getExecutionTimestamp", cSATransactionReport -> cSATransactionReport.getExecutionTimestamp()).get()).setPayment1Payer((String)MapperS.of((Object)drrReport).map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).map("getPayerIdentifier", cSALeg -> cSALeg.getPayerIdentifier()).get()).setPayment1Receiver((String)MapperS.of((Object)drrReport).map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).map("getReceiverIdentifier", cSALeg -> cSALeg.getReceiverIdentifier()).get()).setPayment2Payer((String)MapperS.of((Object)drrReport).map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).map("getPayerIdentifier", cSALeg -> cSALeg.getPayerIdentifier()).get()).setPremiumAmount((BigDecimal)MapperS.of((Object)drrReport).map("getOptionPremiumAmount", cSATransactionReport -> cSATransactionReport.getOptionPremiumAmount()).get()).setPremiumCurrency((String)MapperS.of((Object)drrReport).map("getOptionPremiumCurrency", cSATransactionReport -> cSATransactionReport.getOptionPremiumCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).setPremiumPaymentDateUnadjusted((Date)MapperS.of((Object)drrReport).map("getOptionPremiumPaymentDate", cSATransactionReport -> cSATransactionReport.getOptionPremiumPaymentDate()).get()).setPrice1Price((BigDecimal)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)drrReport).map("getPrice", cSATransactionReport -> cSATransactionReport.getPrice()).map("getMonetary", priceFormat -> priceFormat.getMonetary()), MapperS.of((Object)drrReport).map("getPrice", cSATransactionReport -> cSATransactionReport.getPrice()).map("getDecimal", priceFormat -> priceFormat.getDecimal())}).get()).setPrice1Units((String)MapperS.of((Object)drrReport).map("getPriceUnitOfMeasure", cSATransactionReport -> cSATransactionReport.getPriceUnitOfMeasure()).get()).setPriorUtiId((String)MapperS.of((Object)drrReport).map("getPriorUTI", cSATransactionReport -> cSATransactionReport.getPriorUTI()).get()).setQuantityFrequencyMultiplierLeg1(integer5 == null ? null : BigDecimal.valueOf(integer5.intValue())).setQuantityFrequencyMultiplierLeg2(integer6 == null ? null : BigDecimal.valueOf(integer6.intValue())).setResetFrequencyPeriod1((String)ifThenElseResult3.get()).setResetFrequencyPeriodMultiplier1(integer7 == null ? null : BigDecimal.valueOf(integer7.intValue())).setSellerPayer2((String)MapperS.of((Object)drrReport).map("getSellerIdentifier", cSATransactionReport -> cSATransactionReport.getSellerIdentifier()).get()).setSettlementCurrency1((String)MapperS.of((Object)drrReport).map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).map("getSettlementCurrency", cSALeg -> cSALeg.getSettlementCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).setStrikePrice(ifThenElseResult4).setStrikePriceCurrency(ifThenElseResult5).setCdeStrikePriceCurrency2(ifThenElseResult6).setCdeStrikePriceNotation((String)MapperS.of((Object)this.notationStringFromEnum.evaluate((PriceNotationEnum)((Object)thenArg5.get()))).get()).setSettlementType((String)MapperS.of((Object)drrReport).map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).map("getSettlementType", dTCCAdditionalFields -> dTCCAdditionalFields.getSettlementType()).get()).setLeg1CommodityInstrumentId((String)MapperS.of((Object)drrReport).map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).map("getLeg1CommodityInstrumentID", dTCCAdditionalFields -> dTCCAdditionalFields.getLeg1CommodityInstrumentID()).get()).setLeg2CommodityInstrumentId((String)MapperS.of((Object)drrReport).map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).map("getLeg2CommodityInstrumentID", dTCCAdditionalFields -> dTCCAdditionalFields.getLeg2CommodityInstrumentID()).get()).setLeg1FloatingRateIndex((String)MapperS.of((Object)drrReport).map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).map("getLeg1FloatingRateIndex", dTCCAdditionalFields -> dTCCAdditionalFields.getLeg1FloatingRateIndex()).get()).setLeg2FloatingRateIndex((String)MapperS.of((Object)drrReport).map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).map("getLeg2FloatingRateIndex", dTCCAdditionalFields -> dTCCAdditionalFields.getLeg2FloatingRateIndex()).get()).setLeg1CommodityUnderlyerId((String)MapperS.of((Object)drrReport).map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).map("getLeg1CommodityUnderlyerID", dTCCAdditionalFields -> dTCCAdditionalFields.getLeg1CommodityUnderlyerID()).get()).setLeg2CommodityUnderlyerId((String)MapperS.of((Object)drrReport).map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).map("getLeg2CommodityUnderlyerID", dTCCAdditionalFields -> dTCCAdditionalFields.getLeg2CommodityUnderlyerID()).get()).setResponsibleDataSubmitterId((String)MapperS.of((Object)drrReport).map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).map("getResponsibleDataSubmitterID", dTCCAdditionalFields -> dTCCAdditionalFields.getResponsibleDataSubmitterID()).get()).setResponsibleDataSubmitterIdType((String)MapperS.of((Object)drrReport).map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).map("getResponsibleDataSubmitterIDType", dTCCAdditionalFields -> dTCCAdditionalFields.getResponsibleDataSubmitterIDType()).map("to-string", PartyIdentifierTypeEnum::toDisplayString).get()).setSecondaryAssetClass((String)MapperS.of((Object)drrReport).map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).map("getSecondaryAssetClass", dTCCAdditionalFields -> dTCCAdditionalFields.getSecondaryAssetClass()).map("to-string", AssetClassEnum::toDisplayString).get()).setTradeParty1BrokerIdType((String)MapperS.of((Object)drrReport).map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).map("getTradeParty1BrokerIDType", dTCCAdditionalFields -> dTCCAdditionalFields.getTradeParty1BrokerIDType()).map("to-string", PartyIdentifierTypeEnum::toDisplayString).get()).setTradeParty1BrokerId((String)MapperS.of((Object)drrReport).map("getBrokerID", cSATransactionReport -> cSATransactionReport.getBrokerID()).get()).setLeg2SpreadAmount((BigDecimal)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)drrReport).map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).map("getSpread", cSALeg -> cSALeg.getSpread()).map("getMonetary", priceFormat -> priceFormat.getMonetary()), MapperS.of((Object)drrReport).map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).map("getSpread", cSALeg -> cSALeg.getSpread()).map("getDecimal", priceFormat -> priceFormat.getDecimal()), MapperS.of((Object)drrReport).map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).map("getSpread", cSALeg -> cSALeg.getSpread()).map("getPercentage", priceFormat -> priceFormat.getPercentage()), MapperS.of((Object)drrReport).map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).map("getSpread", cSALeg -> cSALeg.getSpread()).map("getBasis", priceFormat -> priceFormat.getBasis())}).get()).setCdeCryptoAssetUnderlyingIndicatorLeg1((Boolean)MapperS.of((Object)drrReport).map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).map("getCryptoAssetUnderlyingIndicator", cSALeg -> cSALeg.getCryptoAssetUnderlyingIndicator()).get()).setCdeCryptoAssetUnderlyingIndicatorLeg2((Boolean)MapperS.of((Object)drrReport).map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).map("getCryptoAssetUnderlyingIndicator", cSALeg -> cSALeg.getCryptoAssetUnderlyingIndicator()).get()).setCdeCustomBasketCode((String)MapperS.of((Object)drrReport).map("getCustomBasketCode", cSATransactionReport -> cSATransactionReport.getCustomBasketCode()).get()).setUnderlierIdOtherLeg1((String)MapperS.of((Object)drrReport).map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).map("getUnderlierIDOther", cSALeg -> cSALeg.getUnderlierIDOther()).get()).setUnderlierIdOtherLeg2((String)MapperS.of((Object)drrReport).map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).map("getUnderlierIDOther", cSALeg -> cSALeg.getUnderlierIDOther()).get()).setUnderlierIdOtherSourceLeg1((String)MapperS.of((Object)drrReport).map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).map("getUnderlierIDOtherSource", cSALeg -> cSALeg.getUnderlierIDOtherSource()).map("to-string", Object::toString).get()).setUnderlierIdOtherSourceLeg2((String)MapperS.of((Object)drrReport).map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).map("getUnderlierIDOtherSource", cSALeg -> cSALeg.getUnderlierIDOtherSource()).map("to-string", Object::toString).get()).setCdeUnderlyingAssetTradingPlatformIdLeg1((String)MapperS.of((Object)drrReport).map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).map("getUnderlyingAssetTradingPlatformIdentifier", cSALeg -> cSALeg.getUnderlyingAssetTradingPlatformIdentifier()).get()).setCdeUnderlyingAssetTradingPlatformIdLeg2((String)MapperS.of((Object)drrReport).map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).map("getUnderlyingAssetTradingPlatformIdentifier", cSALeg -> cSALeg.getUnderlyingAssetTradingPlatformIdentifier()).get()).setCdeUnderlyingAssetPriceSourceLeg1((String)MapperS.of((Object)drrReport).map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).map("getUnderlyingAssetPriceSource", cSALeg -> cSALeg.getUnderlyingAssetPriceSource()).get()).setCdeUnderlyingAssetPriceSourceLeg2((String)MapperS.of((Object)drrReport).map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).map("getUnderlyingAssetPriceSource", cSALeg -> cSALeg.getUnderlyingAssetPriceSource()).get()).setLeg1SpreadAmount((BigDecimal)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)drrReport).map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).map("getSpread", cSALeg -> cSALeg.getSpread()).map("getMonetary", priceFormat -> priceFormat.getMonetary()), MapperS.of((Object)drrReport).map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).map("getSpread", cSALeg -> cSALeg.getSpread()).map("getDecimal", priceFormat -> priceFormat.getDecimal()), MapperS.of((Object)drrReport).map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).map("getSpread", cSALeg -> cSALeg.getSpread()).map("getPercentage", priceFormat -> priceFormat.getPercentage()), MapperS.of((Object)drrReport).map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).map("getSpread", cSALeg -> cSALeg.getSpread()).map("getBasis", priceFormat -> priceFormat.getBasis())}).get()).setLeg1PartyReceiver((String)MapperS.of((Object)drrReport).map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).map("getReceiverIdentifier", cSALeg -> cSALeg.getReceiverIdentifier()).get()).setLeg2PartyReceiver((String)MapperS.of((Object)drrReport).map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).map("getReceiverIdentifier", cSALeg -> cSALeg.getReceiverIdentifier()).get()).setLoadType((String)MapperS.of((Object)drrReport).map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).map("getLoadType", dTCCAdditionalFields -> dTCCAdditionalFields.getLoadType()).get()).setDeliveryLocation((String)MapperS.of((Object)drrReport).map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).map("getDeliveryLocation", dTCCAdditionalFields -> dTCCAdditionalFields.getDeliveryLocation()).get()).setExchangeRateBasisCurrency1(this.subString.evaluate((String)MapperS.of((Object)drrReport).map("getExchangeRateBasis", cSATransactionReport -> cSATransactionReport.getExchangeRateBasis()).get(), 1, 3)).setExchangeRateBasisCurrency2(this.subString.evaluate((String)MapperS.of((Object)drrReport).map("getExchangeRateBasis", cSATransactionReport -> cSATransactionReport.getExchangeRateBasis()).get(), 5, 3)).setExpirationDate((Date)MapperS.of((Object)drrReport).map("getExpirationDate", cSATransactionReport -> cSATransactionReport.getExpirationDate()).get()).setVersion(ifThenElseResult7).setComment1((String)MapperS.of((Object)drrReport).map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).map("getComment1", dTCCAdditionalFields -> dTCCAdditionalFields.getComment1()).get()).setExecutionVenueId((String)MapperS.of((Object)drrReport).map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).map("getExecutionVenueID", dTCCAdditionalFields -> dTCCAdditionalFields.getExecutionVenueID()).get()).setExecutionVenueIdType((String)MapperS.of((Object)drrReport).map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).map("getExecutionVenueIDType", dTCCAdditionalFields -> dTCCAdditionalFields.getExecutionVenueIDType()).map("to-string", PartyIdentifierTypeEnum::toDisplayString).get()).setMasterAgreementType((String)MapperS.of((Object)drrReport).map("getMasterAgreementType", cSATransactionReport -> cSATransactionReport.getMasterAgreementType()).map("to-string", MasterAgreementEnum::toDisplayString).get()).setMasterAgreementVersion((String)MapperS.of((Object)drrReport).map("getMasterAgreementVersion", cSATransactionReport -> cSATransactionReport.getMasterAgreementVersion()).map("to-string", Object::toString).get()).setMaturityDateOfTheUnderlying((Date)MapperS.of((Object)drrReport).map("getMaturityDateOfTheUnderlying", cSATransactionReport -> cSATransactionReport.getMaturityDateOfTheUnderlying()).get()).setProductIdentification((String)MapperS.of((Object)drrReport).map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).map("getProductID", dTCCAdditionalFields -> dTCCAdditionalFields.getProductID()).get()).setLevel((String)MapperS.of((Object)drrReport).map("getLevel", cSATransactionReport -> cSATransactionReport.getLevel()).map("to-string", ReportLevelEnum::toDisplayString).get()).setAllocationType((String)MapperS.of((Object)drrReport).map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).map("getAllocationType", dTCCAdditionalFields -> dTCCAdditionalFields.getAllocationType()).get()).setInteraffiliate((Boolean)MapperS.of((Object)drrReport).map("getInterAffiliateIndicator", cSATransactionReport -> cSATransactionReport.getInterAffiliateIndicator()).get()).setFloatingRatePaymentFrequencyLeg1Multiplier(integer8 == null ? null : BigDecimal.valueOf(integer8.intValue())).setFloatingRatePaymentFrequencyLeg2Multiplier(integer9 == null ? null : BigDecimal.valueOf(integer9.intValue())).setPaymentFrequencyPeriodLeg1((String)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)drrReport).map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).map("getPeriodicPayment", cSALeg -> cSALeg.getPeriodicPayment()).map("getFixedRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriod()).map("to-string", FrequencyPeriodEnum::toDisplayString), MapperS.of((Object)drrReport).map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).map("getPeriodicPayment", cSALeg -> cSALeg.getPeriodicPayment()).map("getFloatingRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRatePaymentFrequencyPeriod()).map("to-string", FrequencyPeriodEnum::toDisplayString)}).get()).setPaymentFrequencyPeriodLeg2((String)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)drrReport).map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).map("getPeriodicPayment", cSALeg -> cSALeg.getPeriodicPayment()).map("getFixedRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriod()).map("to-string", FrequencyPeriodEnum::toDisplayString), MapperS.of((Object)drrReport).map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).map("getPeriodicPayment", cSALeg -> cSALeg.getPeriodicPayment()).map("getFloatingRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRatePaymentFrequencyPeriod()).map("to-string", FrequencyPeriodEnum::toDisplayString)}).get()).setPaymentFrequencyPeriodMultiplierLeg1(integer10 == null ? null : BigDecimal.valueOf(integer10.intValue())).setPaymentFrequencyPeriodMultiplierLeg2(integer11 == null ? null : BigDecimal.valueOf(integer11.intValue())).setEventIdentifier((String)MapperS.of((Object)drrReport).map("getEventIdentifier", cSATransactionReport -> cSATransactionReport.getEventIdentifier()).get()).setPackageIndicator((Boolean)MapperS.of((Object)drrReport).map("getPackageIndicator", cSATransactionReport -> cSATransactionReport.getPackageIndicator()).get()).setCdePackageIdentifier((String)MapperS.of((Object)drrReport).map("getPackageIdentifier", cSATransactionReport -> cSATransactionReport.getPackageIdentifier()).get()).setCdePackageTransactionPrice((BigDecimal)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)drrReport).map("getPackageTransactionPrice", cSATransactionReport -> cSATransactionReport.getPackageTransactionPrice()).map("getMonetary", priceFormat -> priceFormat.getMonetary()), MapperS.of((Object)drrReport).map("getPackageTransactionPrice", cSATransactionReport -> cSATransactionReport.getPackageTransactionPrice()).map("getDecimal", priceFormat -> priceFormat.getDecimal()), MapperS.of((Object)drrReport).map("getPackageTransactionPrice", cSATransactionReport -> cSATransactionReport.getPackageTransactionPrice()).map("getPercentage", priceFormat -> priceFormat.getPercentage()), MapperS.of((Object)drrReport).map("getPackageTransactionPrice", cSATransactionReport -> cSATransactionReport.getPackageTransactionPrice()).map("getBasis", priceFormat -> priceFormat.getBasis())}).get()).setCdePackageTransactionPriceCurrency((String)MapperS.of((Object)drrReport).map("getPackageTransactionPriceCurrency", cSATransactionReport -> cSATransactionReport.getPackageTransactionPriceCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).setCdePackageTransactionPriceNotation((String)MapperS.of((Object)this.notationStringFromEnum.evaluate((PriceNotationEnum)((Object)thenArg6.get()))).get()).setCdePackageTransactionSpread((BigDecimal)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)drrReport).map("getPackageTransactionSpread", cSATransactionReport -> cSATransactionReport.getPackageTransactionSpread()).map("getMonetary", priceFormat -> priceFormat.getMonetary()), MapperS.of((Object)drrReport).map("getPackageTransactionSpread", cSATransactionReport -> cSATransactionReport.getPackageTransactionSpread()).map("getDecimal", priceFormat -> priceFormat.getDecimal()), MapperS.of((Object)drrReport).map("getPackageTransactionSpread", cSATransactionReport -> cSATransactionReport.getPackageTransactionSpread()).map("getPercentage", priceFormat -> priceFormat.getPercentage()), MapperS.of((Object)drrReport).map("getPackageTransactionSpread", cSATransactionReport -> cSATransactionReport.getPackageTransactionSpread()).map("getBasis", priceFormat -> priceFormat.getBasis())}).get()).setCdePackageTransactionSpreadNotation((String)MapperS.of((Object)this.notationStringFromEnum.evaluate((PriceNotationEnum)((Object)thenArg7.get()))).get()).setInitialMarginCollateralPortfolioCode((String)MapperS.of((Object)drrReport).map("getInitialMarginCollateralPortfolioCode", cSATransactionReport -> cSATransactionReport.getInitialMarginCollateralPortfolioCode()).get()).setVariationMarginCollateralPortfolioCode((String)MapperS.of((Object)drrReport).map("getVariationMarginCollateralPortfolioCode", cSATransactionReport -> cSATransactionReport.getVariationMarginCollateralPortfolioCode()).get()).setSefOrDcmAnonymousExecutionIndicator((Boolean)MapperS.of((Object)drrReport).map("getPlatformAnonymousExecutionIndicator", cSATransactionReport -> cSATransactionReport.getPlatformAnonymousExecutionIndicator()).get()).setPriorUsiId((String)MapperS.of((Object)drrReport).map("getPriorUSI", cSATransactionReport -> cSATransactionReport.getPriorUSI()).get()).setPrice1Currency((String)MapperS.of((Object)drrReport).map("getPriceCurrency", cSATransactionReport -> cSATransactionReport.getPriceCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).setAttachmentPoint((BigDecimal)MapperS.of((Object)drrReport).map("getCdSIndexAttachmentPoint", cSATransactionReport -> cSATransactionReport.getCdSIndexAttachmentPoint()).get()).setExhaustionPoint((BigDecimal)MapperS.of((Object)drrReport).map("getCdSIndexDetachmentPoint", cSATransactionReport -> cSATransactionReport.getCdSIndexDetachmentPoint()).get()).setClearingExceptionType((String)thenArg9.join(MapperS.of((Object)";")).get()).setEmbeddedOptionOnSwap((String)MapperS.of((Object)drrReport).map("getEmbeddedOptionType", cSATransactionReport -> cSATransactionReport.getEmbeddedOptionType()).map("to-string", EmbeddedOptionTypeEnum::toDisplayString).get()).setPriorUsiIdPrefix(null).setPriorUtiIdPrefix(null).setTradeParty2CountryOfTheOtherCounterparty((String)MapperS.of((Object)drrReport).map("getCountryAndProvinceOrTerritoryOfIndividual", cSATransactionReport -> cSATransactionReport.getCountryAndProvinceOrTerritoryOfIndividual()).get()).setClearingReceiptDatetime((ZonedDateTime)MapperS.of((Object)drrReport).map("getClearingReceiptTimestamp", cSATransactionReport -> cSATransactionReport.getClearingReceiptTimestamp()).get()).setLeg1SettlementPeriod((String)MapperS.of((Object)drrReport).map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).map("getLeg1SettlementPeriod", dTCCAdditionalFields -> dTCCAdditionalFields.getLeg1SettlementPeriod()).get()).setOrigin((String)MapperS.of((Object)drrReport).map("getClearingAccountOrigin", cSATransactionReport -> cSATransactionReport.getClearingAccountOrigin()).map("to-string", ClearingAccountOriginEnum::toDisplayString).get()).build());
            return Optional.ofNullable(harmonized).map(o -> o.prune()).orElse(null);
        }
    }
}

