/*
 * Decompiled with CFR 0.152.
 */
package drr.projection.iso20022.fca.ukemir.refit.trade.functions;

import cdm.base.math.functions.Abs;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.fca.ukemir.refit.trade.FCAUKEMIRTransactionReport;
import iso20022.auth030.fca.ActiveOrHistoricCurrencyAnd13DecimalAmount__1;
import iso20022.auth030.fca.AmountAndDirection106__1;
import iso20022.auth030.fca.PriceData2__1;
import iso20022.auth030.fca.Schedule1__1;
import iso20022.auth030.fca.SecuritiesTransactionPrice17Choice__1;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetTxPricDefault.class)
public abstract class GetTxPric
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Abs abs;

    public PriceData2__1 evaluate(FCAUKEMIRTransactionReport drrReport) {
        PriceData2__1 txPric;
        PriceData2__1.PriceData2__1Builder txPricBuilder = this.doEvaluate(drrReport);
        if (txPricBuilder == null) {
            txPric = null;
        } else {
            txPric = txPricBuilder.build();
            this.objectValidator.validate(PriceData2__1.class, (RosettaModelObject)txPric);
        }
        return txPric;
    }

    protected abstract PriceData2__1.PriceData2__1Builder doEvaluate(FCAUKEMIRTransactionReport var1);

    public static class GetTxPricDefault
    extends GetTxPric {
        @Override
        protected PriceData2__1.PriceData2__1Builder doEvaluate(FCAUKEMIRTransactionReport drrReport) {
            PriceData2__1.PriceData2__1Builder txPric = PriceData2__1.builder();
            return this.assignOutput(txPric, drrReport);
        }

        protected PriceData2__1.PriceData2__1Builder assignOutput(PriceData2__1.PriceData2__1Builder txPric, FCAUKEMIRTransactionReport drrReport) {
            txPric.setPric((SecuritiesTransactionPrice17Choice__1)MapperS.of((Object)drrReport).mapSingleToItem(item -> {
                Boolean ifThenElseResult = null;
                if (ExpressionOperators.lessThan((Mapper)item.map("getPrice", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getPrice()).map("getMonetary", priceFormat -> priceFormat.getMonetary()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult = false;
                }
                return MapperS.of((Object)SecuritiesTransactionPrice17Choice__1.builder().setMntryVal(AmountAndDirection106__1.builder().setAmt(ActiveOrHistoricCurrencyAnd13DecimalAmount__1.builder().setValue(this.abs.evaluate((BigDecimal)item.map("getPrice", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getPrice()).map("getMonetary", priceFormat -> priceFormat.getMonetary()).get())).setCcy((String)MapperS.of((Object)drrReport).map("getPriceCurrency", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getPriceCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).build()).setSgn(ifThenElseResult).build()).setPctg((BigDecimal)item.map("getPrice", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getPrice()).map("getPercentage", priceFormat -> priceFormat.getPercentage()).get()).build());
            }).get());
            txPric.addSchdlPrd(MapperS.of((Object)drrReport).mapC("getPriceSchedule", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getPriceSchedule()).mapItem(item -> {
                Boolean ifThenElseResult = null;
                if (ExpressionOperators.lessThan((Mapper)item.map("getPrice", pricePeriod -> pricePeriod.getPrice()).map("getMonetary", priceFormat -> priceFormat.getMonetary()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult = false;
                }
                return MapperS.of((Object)Schedule1__1.builder().setUadjstdFctvDt((Date)item.map("getEffectiveDate", pricePeriod -> pricePeriod.getEffectiveDate()).get()).setUadjstdEndDt((Date)item.map("getEndDate", pricePeriod -> pricePeriod.getEndDate()).get()).setPric(SecuritiesTransactionPrice17Choice__1.builder().setMntryVal(AmountAndDirection106__1.builder().setAmt(ActiveOrHistoricCurrencyAnd13DecimalAmount__1.builder().setValue(this.abs.evaluate((BigDecimal)item.map("getPrice", pricePeriod -> pricePeriod.getPrice()).map("getMonetary", priceFormat -> priceFormat.getMonetary()).get())).setCcy((String)MapperS.of((Object)drrReport).map("getPriceCurrency", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getPriceCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).build()).setSgn(ifThenElseResult).build()).setPctg((BigDecimal)item.map("getPrice", pricePeriod -> pricePeriod.getPrice()).map("getPercentage", priceFormat -> priceFormat.getPercentage()).get()).build()).build());
            }).getMulti());
            return Optional.ofNullable(txPric).map(o -> o.prune()).orElse(null);
        }
    }
}

