/*
 * Decompiled with CFR 0.152.
 */
package drr.projection.iso20022.jfsa.rewrite.trade.functions;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.jfsa.rewrite.trade.JFSATransactionReport;
import iso20022.auth030.jfsa.ActiveOrHistoricCurrencyAnd5DecimalAmount;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetPrmAmtDefault.class)
public abstract class GetPrmAmt
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public ActiveOrHistoricCurrencyAnd5DecimalAmount evaluate(JFSATransactionReport drrReport) {
        ActiveOrHistoricCurrencyAnd5DecimalAmount prmAmt;
        ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder prmAmtBuilder = this.doEvaluate(drrReport);
        if (prmAmtBuilder == null) {
            prmAmt = null;
        } else {
            prmAmt = prmAmtBuilder.build();
            this.objectValidator.validate(ActiveOrHistoricCurrencyAnd5DecimalAmount.class, (RosettaModelObject)prmAmt);
        }
        return prmAmt;
    }

    protected abstract ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder doEvaluate(JFSATransactionReport var1);

    public static class GetPrmAmtDefault
    extends GetPrmAmt {
        @Override
        protected ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder doEvaluate(JFSATransactionReport drrReport) {
            ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder prmAmt = ActiveOrHistoricCurrencyAnd5DecimalAmount.builder();
            return this.assignOutput(prmAmt, drrReport);
        }

        protected ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder assignOutput(ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder prmAmt, JFSATransactionReport drrReport) {
            String ifThenElseResult = ExpressionOperators.exists((Mapper)MapperS.of((Object)drrReport).map("getOptionPremiumCurrency", jFSATransactionReport -> jFSATransactionReport.getOptionPremiumCurrency())).getOrDefault(Boolean.valueOf(false)) != false ? (String)MapperS.of((Object)drrReport).map("getOptionPremiumCurrency", jFSATransactionReport -> jFSATransactionReport.getOptionPremiumCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get() : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getOptionPremiumAmount", jFSATransactionReport -> jFSATransactionReport.getOptionPremiumAmount()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? (String)MapperS.of((Object)drrReport).map("getLeg1", jFSATransactionReport -> jFSATransactionReport.getLeg1()).map("getSettlementCurrency", commonLeg -> commonLeg.getSettlementCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get() : null);
            prmAmt = (ActiveOrHistoricCurrencyAnd5DecimalAmount.ActiveOrHistoricCurrencyAnd5DecimalAmountBuilder)this.toBuilder((RosettaModelObject)ActiveOrHistoricCurrencyAnd5DecimalAmount.builder().setValue((BigDecimal)MapperS.of((Object)drrReport).map("getOptionPremiumAmount", jFSATransactionReport -> jFSATransactionReport.getOptionPremiumAmount()).get()).setCcy(ifThenElseResult).build());
            return Optional.ofNullable(prmAmt).map(o -> o.prune()).orElse(null);
        }
    }
}

