/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.asic.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.TransactionReportInstructionBase;
import drr.base.trade.price.PriceNotationEnum;
import drr.regulation.asic.rewrite.trade.functions.IsAllowableActionForASIC;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.price.functions.DefaultPercentageToDecimal;
import drr.standards.iosco.cde.version3.link.reports.PackageIdentifierRule;
import drr.standards.iosco.cde.version3.price.reports.PackageTransactionPriceNotationEnumRule;
import javax.inject.Inject;

@ImplementedBy(value=PackageTransactionPriceNotationRuleDefault.class)
public abstract class PackageTransactionPriceNotationRule
implements ReportFunction<TransactionReportInstruction, PriceNotationEnum> {
    @Inject
    protected DefaultPercentageToDecimal defaultPercentageToDecimal;
    @Inject
    protected IsAllowableActionForASIC isAllowableActionForASIC;
    @Inject
    protected PackageIdentifierRule packageIdentifierRule;
    @Inject
    protected PackageTransactionPriceNotationEnumRule packageTransactionPriceNotationEnumRule;

    public PriceNotationEnum evaluate(TransactionReportInstruction input) {
        PriceNotationEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract PriceNotationEnum doEvaluate(TransactionReportInstruction var1);

    public static class PackageTransactionPriceNotationRuleDefault
    extends PackageTransactionPriceNotationRule {
        @Override
        protected PriceNotationEnum doEvaluate(TransactionReportInstruction input) {
            PriceNotationEnum output = null;
            return this.assignOutput(output, input);
        }

        protected PriceNotationEnum assignOutput(PriceNotationEnum output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForASIC.evaluate((ReportableEventBase)item.get()));
            String string = this.packageIdentifierRule.evaluate((TransactionReportInstructionBase)thenArg.get());
            output = (PriceNotationEnum)((Object)MapperS.of((Object)((Object)this.defaultPercentageToDecimal.evaluate(this.packageTransactionPriceNotationEnumRule.evaluate((TransactionReportInstructionBase)thenArg.get()), (string == null ? ExpressionOperators.exists((Mapper)MapperS.ofNull()) : ExpressionOperators.exists((Mapper)MapperS.of((Object)FieldWithMetaString.builder().setValue(string).build()))).and(ExpressionOperators.notExists((Mapper)MapperS.of((Object)((Object)this.packageTransactionPriceNotationEnumRule.evaluate((TransactionReportInstructionBase)thenArg.get()))))).get()))).get());
            return output;
        }
    }
}

