/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.asic.rewrite.trade.reports;

import cdm.observable.asset.PriceExpressionEnum;
import cdm.observable.asset.PriceTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.TransactionReportInstructionBase;
import drr.regulation.asic.rewrite.trade.functions.IsAllowableActionForASIC;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iosco.cde.version3.price.reports.PriceRule;
import javax.inject.Inject;

@ImplementedBy(value=PriceUnitOfMeasureRuleDefault.class)
public abstract class PriceUnitOfMeasureRule
implements ReportFunction<TransactionReportInstruction, String> {
    @Inject
    protected IsAllowableActionForASIC isAllowableActionForASIC;
    @Inject
    protected PriceRule priceRule;
    @Inject
    protected drr.standards.iosco.cde.version3.price.reports.PriceUnitOfMeasureRule priceUnitOfMeasureRule;

    public String evaluate(TransactionReportInstruction input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1);

    public static class PriceUnitOfMeasureRuleDefault
    extends PriceUnitOfMeasureRule {
        @Override
        protected String doEvaluate(TransactionReportInstruction input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForASIC.evaluate((ReportableEventBase)item.get()));
            output = (String)thenArg.mapSingleToItem(item -> {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.priceRule.evaluate((TransactionReportInstructionBase)item.get())).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.CASH_PRICE), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.priceRule.evaluate((TransactionReportInstructionBase)item.get())).map("getPriceExpression", priceSchedule -> priceSchedule.getPriceExpression()), (Mapper)MapperS.of((Object)PriceExpressionEnum.PERCENTAGE_OF_NOTIONAL), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.priceRule.evaluate((TransactionReportInstructionBase)item.get())).map("getPriceExpression", priceSchedule -> priceSchedule.getPriceExpression()), (Mapper)MapperS.of((Object)PriceExpressionEnum.ABSOLUTE_TERMS), (CardinalityOperator)CardinalityOperator.All))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)"ACCY");
                }
                return MapperS.of((Object)this.priceUnitOfMeasureRule.evaluate((TransactionReportInstructionBase)item.get()));
            }).get();
            return output;
        }
    }
}

