/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.asic.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.ReportableEventBase;
import drr.regulation.asic.rewrite.trade.functions.IsAllowableActionForASIC;
import drr.regulation.common.RegimeNameEnum;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.link.functions.GetPriorTransactionIdentifier;
import drr.standards.iso.functions.IsMax52UpperCaseAlphanumericText;
import javax.inject.Inject;

@ImplementedBy(value=PriorUTIRuleDefault.class)
public abstract class PriorUTIRule
implements ReportFunction<TransactionReportInstruction, String> {
    @Inject
    protected GetPriorTransactionIdentifier getPriorTransactionIdentifier;
    @Inject
    protected IsAllowableActionForASIC isAllowableActionForASIC;
    @Inject
    protected IsMax52UpperCaseAlphanumericText isMax52UpperCaseAlphanumericText;

    public String evaluate(TransactionReportInstruction input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1);

    public static class PriorUTIRuleDefault
    extends PriorUTIRule {
        @Override
        protected String doEvaluate(TransactionReportInstruction input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForASIC.evaluate((ReportableEventBase)item.get()));
            MapperS thenArg1 = MapperS.of((Object)this.getPriorTransactionIdentifier.evaluate((TransactionReportInstruction)thenArg0.get(), RegimeNameEnum.ASIC));
            output = (String)thenArg1.filterSingleNullSafe(item -> ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.isMax52UpperCaseAlphanumericText.evaluate((String)item.get())), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).get()).get();
            return output;
        }
    }
}

