/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.cftc.rewrite.valuation.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.annotations.RosettaReport;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.cftc.rewrite.valuation.CFTCValuationReport;
import drr.regulation.cftc.rewrite.valuation.labels.CFTCValuationLabelProvider;
import drr.regulation.cftc.rewrite.valuation.reports.ActionTypeRule;
import drr.regulation.cftc.rewrite.valuation.reports.Counterparty1Rule;
import drr.regulation.cftc.rewrite.valuation.reports.Counterparty2IdentifierSourceRule;
import drr.regulation.cftc.rewrite.valuation.reports.Counterparty2Rule;
import drr.regulation.cftc.rewrite.valuation.reports.DTCC_Comment1Rule;
import drr.regulation.cftc.rewrite.valuation.reports.DTCC_MessageIDRule;
import drr.regulation.cftc.rewrite.valuation.reports.DTCC_MessageTypeRule;
import drr.regulation.cftc.rewrite.valuation.reports.DTCC_PrimaryAssetClassRule;
import drr.regulation.cftc.rewrite.valuation.reports.DTCC_SubmittedForPartyRule;
import drr.regulation.cftc.rewrite.valuation.reports.DTCC_SubmittingPartyIDTypeRule;
import drr.regulation.cftc.rewrite.valuation.reports.DTCC_TradeParty1ExecutionAgentIDRule;
import drr.regulation.cftc.rewrite.valuation.reports.DTCC_TradeParty1ExecutionAgentIDTypeRule;
import drr.regulation.cftc.rewrite.valuation.reports.DTCC_TradeParty1IDTypeRule;
import drr.regulation.cftc.rewrite.valuation.reports.DTCC_TradeParty1ReportingDestinationRule;
import drr.regulation.cftc.rewrite.valuation.reports.DTCC_TradeParty1TransactionIDRule;
import drr.regulation.cftc.rewrite.valuation.reports.DTCC_TradeParty2ExecutionAgentIDRule;
import drr.regulation.cftc.rewrite.valuation.reports.DTCC_TradeParty2ExecutionAgentIDTypeRule;
import drr.regulation.cftc.rewrite.valuation.reports.DTCC_TradeParty2ReportingDestinationRule;
import drr.regulation.cftc.rewrite.valuation.reports.DTCC_VersionRule;
import drr.regulation.cftc.rewrite.valuation.reports.DeltaRule;
import drr.regulation.cftc.rewrite.valuation.reports.InitialMarginCollateralPortfolioCodeRule;
import drr.regulation.cftc.rewrite.valuation.reports.LastFloatingReferenceResetDateLeg1Rule;
import drr.regulation.cftc.rewrite.valuation.reports.LastFloatingReferenceResetDateLeg2Rule;
import drr.regulation.cftc.rewrite.valuation.reports.LastFloatingReferenceValueLeg1Rule;
import drr.regulation.cftc.rewrite.valuation.reports.LastFloatingReferenceValueLeg2Rule;
import drr.regulation.cftc.rewrite.valuation.reports.NextFloatingReferenceResetDateLeg1Rule;
import drr.regulation.cftc.rewrite.valuation.reports.NextFloatingReferenceResetDateLeg2Rule;
import drr.regulation.cftc.rewrite.valuation.reports.ReportingTimestampRule;
import drr.regulation.cftc.rewrite.valuation.reports.SubmitterIdentifierRule;
import drr.regulation.cftc.rewrite.valuation.reports.UniqueProductIdentifierRule;
import drr.regulation.cftc.rewrite.valuation.reports.UniqueSwapIdentifierRule;
import drr.regulation.cftc.rewrite.valuation.reports.UniqueTransactionIdentifierRule;
import drr.regulation.cftc.rewrite.valuation.reports.ValuationAmountRule;
import drr.regulation.cftc.rewrite.valuation.reports.ValuationCurrencyRule;
import drr.regulation.cftc.rewrite.valuation.reports.ValuationMethodRule;
import drr.regulation.cftc.rewrite.valuation.reports.ValuationTimestampRule;
import drr.regulation.cftc.rewrite.valuation.reports.VariationMarginCollateralPortfolioCodeRule;
import drr.regulation.common.ValuationReportInstruction;
import java.util.Optional;
import javax.inject.Inject;

@RosettaReport(namespace="drr.regulation.cftc.rewrite.valuation", body="CFTC", corpusList={"Valuation"})
@RuneLabelProvider(labelProvider=CFTCValuationLabelProvider.class)
@ImplementedBy(value=CFTCValuationReportFunctionDefault.class)
public abstract class CFTCValuationReportFunction
implements ReportFunction<ValuationReportInstruction, CFTCValuationReport> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ActionTypeRule actionTypeRule;
    @Inject
    protected Counterparty1Rule counterparty1Rule;
    @Inject
    protected Counterparty2IdentifierSourceRule counterparty2IdentifierSourceRule;
    @Inject
    protected Counterparty2Rule counterparty2Rule;
    @Inject
    protected DTCC_Comment1Rule dTCC_Comment1Rule;
    @Inject
    protected DTCC_MessageIDRule dTCC_MessageIDRule;
    @Inject
    protected DTCC_MessageTypeRule dTCC_MessageTypeRule;
    @Inject
    protected DTCC_PrimaryAssetClassRule dTCC_PrimaryAssetClassRule;
    @Inject
    protected DTCC_SubmittedForPartyRule dTCC_SubmittedForPartyRule;
    @Inject
    protected DTCC_SubmittingPartyIDTypeRule dTCC_SubmittingPartyIDTypeRule;
    @Inject
    protected DTCC_TradeParty1ExecutionAgentIDRule dTCC_TradeParty1ExecutionAgentIDRule;
    @Inject
    protected DTCC_TradeParty1ExecutionAgentIDTypeRule dTCC_TradeParty1ExecutionAgentIDTypeRule;
    @Inject
    protected DTCC_TradeParty1IDTypeRule dTCC_TradeParty1IDTypeRule;
    @Inject
    protected DTCC_TradeParty1ReportingDestinationRule dTCC_TradeParty1ReportingDestinationRule;
    @Inject
    protected DTCC_TradeParty1TransactionIDRule dTCC_TradeParty1TransactionIDRule;
    @Inject
    protected DTCC_TradeParty2ExecutionAgentIDRule dTCC_TradeParty2ExecutionAgentIDRule;
    @Inject
    protected DTCC_TradeParty2ExecutionAgentIDTypeRule dTCC_TradeParty2ExecutionAgentIDTypeRule;
    @Inject
    protected DTCC_TradeParty2ReportingDestinationRule dTCC_TradeParty2ReportingDestinationRule;
    @Inject
    protected DTCC_VersionRule dTCC_VersionRule;
    @Inject
    protected DeltaRule deltaRule;
    @Inject
    protected InitialMarginCollateralPortfolioCodeRule initialMarginCollateralPortfolioCodeRule;
    @Inject
    protected LastFloatingReferenceResetDateLeg1Rule lastFloatingReferenceResetDateLeg1Rule;
    @Inject
    protected LastFloatingReferenceResetDateLeg2Rule lastFloatingReferenceResetDateLeg2Rule;
    @Inject
    protected LastFloatingReferenceValueLeg1Rule lastFloatingReferenceValueLeg1Rule;
    @Inject
    protected LastFloatingReferenceValueLeg2Rule lastFloatingReferenceValueLeg2Rule;
    @Inject
    protected NextFloatingReferenceResetDateLeg1Rule nextFloatingReferenceResetDateLeg1Rule;
    @Inject
    protected NextFloatingReferenceResetDateLeg2Rule nextFloatingReferenceResetDateLeg2Rule;
    @Inject
    protected ReportingTimestampRule reportingTimestampRule;
    @Inject
    protected SubmitterIdentifierRule submitterIdentifierRule;
    @Inject
    protected UniqueProductIdentifierRule uniqueProductIdentifierRule;
    @Inject
    protected UniqueSwapIdentifierRule uniqueSwapIdentifierRule;
    @Inject
    protected UniqueTransactionIdentifierRule uniqueTransactionIdentifierRule;
    @Inject
    protected ValuationAmountRule valuationAmountRule;
    @Inject
    protected ValuationCurrencyRule valuationCurrencyRule;
    @Inject
    protected ValuationMethodRule valuationMethodRule;
    @Inject
    protected ValuationTimestampRule valuationTimestampRule;
    @Inject
    protected VariationMarginCollateralPortfolioCodeRule variationMarginCollateralPortfolioCodeRule;

    public CFTCValuationReport evaluate(ValuationReportInstruction input) {
        CFTCValuationReport output;
        CFTCValuationReport.CFTCValuationReportBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(CFTCValuationReport.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract CFTCValuationReport.CFTCValuationReportBuilder doEvaluate(ValuationReportInstruction var1);

    public static class CFTCValuationReportFunctionDefault
    extends CFTCValuationReportFunction {
        @Override
        protected CFTCValuationReport.CFTCValuationReportBuilder doEvaluate(ValuationReportInstruction input) {
            CFTCValuationReport.CFTCValuationReportBuilder output = CFTCValuationReport.builder();
            return this.assignOutput(output, input);
        }

        protected CFTCValuationReport.CFTCValuationReportBuilder assignOutput(CFTCValuationReport.CFTCValuationReportBuilder output, ValuationReportInstruction input) {
            output.setCounterparty1(this.counterparty1Rule.evaluate(input));
            output.setCounterparty2(this.counterparty2Rule.evaluate(input));
            output.setCounterparty2IdentifierSource(this.counterparty2IdentifierSourceRule.evaluate(input));
            output.setSubmitterIdentifier(this.submitterIdentifierRule.evaluate(input));
            output.setActionType(this.actionTypeRule.evaluate(input));
            output.setUniqueProductIdentifier(this.uniqueProductIdentifierRule.evaluate(input));
            output.setReportingTimestamp(this.reportingTimestampRule.evaluate(input));
            output.setUniqueSwapIdentifier(this.uniqueSwapIdentifierRule.evaluate(input));
            output.setUniqueTransactionIdentifier(this.uniqueTransactionIdentifierRule.evaluate(input));
            output.setNextFloatingReferenceResetDateLeg1(this.nextFloatingReferenceResetDateLeg1Rule.evaluate(input));
            output.setNextFloatingReferenceResetDateLeg2(this.nextFloatingReferenceResetDateLeg2Rule.evaluate(input));
            output.setLastFloatingReferenceValueLeg1(this.lastFloatingReferenceValueLeg1Rule.evaluate(input));
            output.setLastFloatingReferenceValueLeg2(this.lastFloatingReferenceValueLeg2Rule.evaluate(input));
            output.setLastFloatingReferenceResetDateLeg1(this.lastFloatingReferenceResetDateLeg1Rule.evaluate(input));
            output.setLastFloatingReferenceResetDateLeg2(this.lastFloatingReferenceResetDateLeg2Rule.evaluate(input));
            output.setDelta(this.deltaRule.evaluate(input));
            output.setValuationAmount(this.valuationAmountRule.evaluate(input));
            output.setValuationCurrency(this.valuationCurrencyRule.evaluate(input));
            output.setValuationMethod(this.valuationMethodRule.evaluate(input));
            output.setValuationTimestamp(this.valuationTimestampRule.evaluate(input));
            output.setInitialMarginCollateralPortfolioCode(this.initialMarginCollateralPortfolioCodeRule.evaluate(input));
            output.setVariationMarginCollateralPortfolioCode(this.variationMarginCollateralPortfolioCodeRule.evaluate(input));
            output.setTradeParty1IDType(this.dTCC_TradeParty1IDTypeRule.evaluate(input));
            output.setSubmittingPartyIDType(this.dTCC_SubmittingPartyIDTypeRule.evaluate(input));
            output.setSubmittedForParty(this.dTCC_SubmittedForPartyRule.evaluate(input));
            output.setTradeParty1ReportingDestination(this.dTCC_TradeParty1ReportingDestinationRule.evaluate(input));
            output.setTradeParty2ReportingDestination(this.dTCC_TradeParty2ReportingDestinationRule.evaluate(input));
            output.setPrimaryAssetClass(this.dTCC_PrimaryAssetClassRule.evaluate(input));
            output.setComment1(null);
            output.setMessageID(this.dTCC_MessageIDRule.evaluate(input));
            output.setMessageType(this.dTCC_MessageTypeRule.evaluate(input));
            output.setTradeParty2ExecutionAgentID(this.dTCC_TradeParty2ExecutionAgentIDRule.evaluate(input));
            output.setTradeParty2ExecutionAgentIDType(this.dTCC_TradeParty2ExecutionAgentIDTypeRule.evaluate(input));
            output.setTradeParty1ExecutionAgentID(this.dTCC_TradeParty1ExecutionAgentIDRule.evaluate(input));
            output.setTradeParty1ExecutionAgentIDType(this.dTCC_TradeParty1ExecutionAgentIDTypeRule.evaluate(input));
            output.setTradeParty1TransactionID(this.dTCC_TradeParty1TransactionIDRule.evaluate(input));
            output.setVersion(this.dTCC_VersionRule.evaluate(input));
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

