/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RosettaIgnore;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.base.margin.CollateralDetails;
import drr.base.margin.CollateralReportInstructionBase;
import drr.base.trade.ReportableInformationBase;
import drr.base.trade.ReportingSide;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.meta.CollateralReportInstructionMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CollateralReportInstruction", builder=CollateralReportInstructionBuilderImpl.class, version="7.0.0-dev.66")
@RuneDataType(value="CollateralReportInstruction", model="drr", builder=CollateralReportInstructionBuilderImpl.class, version="7.0.0-dev.66")
public interface CollateralReportInstruction
extends CollateralReportInstructionBase {
    public static final CollateralReportInstructionMeta metaData = new CollateralReportInstructionMeta();

    @Override
    public ReportableInformation getReportableInformation();

    @Override
    public CollateralReportInstruction build();

    @Override
    public CollateralReportInstructionBuilder toBuilder();

    public static CollateralReportInstructionBuilder builder() {
        return new CollateralReportInstructionBuilderImpl();
    }

    default public RosettaMetaData<? extends CollateralReportInstruction> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CollateralReportInstruction> getType() {
        return CollateralReportInstruction.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("collateralDetails"), processor, CollateralDetails.class, this.getCollateralDetails(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reportableInformation"), processor, ReportableInformation.class, this.getReportableInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reportingSide"), processor, ReportingSide.class, this.getReportingSide(), new AttributeMeta[0]);
    }

    public static class CollateralReportInstructionBuilderImpl
    implements CollateralReportInstructionBuilder {
        protected CollateralDetails.CollateralDetailsBuilder collateralDetails;
        protected ReportableInformation.ReportableInformationBuilder reportableInformation;
        protected ReportingSide.ReportingSideBuilder reportingSide;

        @Override
        @RosettaAttribute(value="collateralDetails")
        @RuneAttribute(value="collateralDetails")
        public CollateralDetails.CollateralDetailsBuilder getCollateralDetails() {
            return this.collateralDetails;
        }

        @Override
        public CollateralDetails.CollateralDetailsBuilder getOrCreateCollateralDetails() {
            CollateralDetails.CollateralDetailsBuilder result = this.collateralDetails != null ? this.collateralDetails : (this.collateralDetails = CollateralDetails.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="reportableInformation", isRequired=true)
        @RuneAttribute(value="reportableInformation", isRequired=true)
        public ReportableInformation.ReportableInformationBuilder getReportableInformation() {
            return this.reportableInformation;
        }

        @Override
        public ReportableInformation.ReportableInformationBuilder getOrCreateReportableInformation() {
            ReportableInformation.ReportableInformationBuilder result = this.reportableInformation != null ? this.reportableInformation : (this.reportableInformation = ReportableInformation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="reportingSide", isRequired=true)
        @RuneAttribute(value="reportingSide", isRequired=true)
        public ReportingSide.ReportingSideBuilder getReportingSide() {
            return this.reportingSide;
        }

        @Override
        public ReportingSide.ReportingSideBuilder getOrCreateReportingSide() {
            ReportingSide.ReportingSideBuilder result = this.reportingSide != null ? this.reportingSide : (this.reportingSide = ReportingSide.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="collateralDetails")
        @RuneAttribute(value="collateralDetails")
        public CollateralReportInstructionBuilder setCollateralDetails(CollateralDetails _collateralDetails) {
            this.collateralDetails = _collateralDetails == null ? null : _collateralDetails.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="reportableInformation", isRequired=true)
        @RuneAttribute(value="reportableInformation", isRequired=true)
        public CollateralReportInstructionBuilder setReportableInformation(ReportableInformation _reportableInformation) {
            this.reportableInformation = _reportableInformation == null ? null : _reportableInformation.toBuilder();
            return this;
        }

        @Override
        @RosettaIgnore
        public CollateralReportInstructionBuilder setReportableInformation(ReportableInformationBase _reportableInformation) {
            ReportableInformation ifThenElseResult = _reportableInformation == null ? null : (_reportableInformation instanceof ReportableInformation ? (ReportableInformation)ReportableInformation.class.cast(_reportableInformation) : null);
            return this.setReportableInformation(ifThenElseResult);
        }

        @Override
        @RosettaAttribute(value="reportingSide", isRequired=true)
        @RuneAttribute(value="reportingSide", isRequired=true)
        public CollateralReportInstructionBuilder setReportingSide(ReportingSide _reportingSide) {
            this.reportingSide = _reportingSide == null ? null : _reportingSide.toBuilder();
            return this;
        }

        @Override
        public CollateralReportInstruction build() {
            return new CollateralReportInstructionImpl(this);
        }

        @Override
        public CollateralReportInstructionBuilder toBuilder() {
            return this;
        }

        @Override
        public CollateralReportInstructionBuilder prune() {
            if (this.collateralDetails != null && !this.collateralDetails.prune().hasData()) {
                this.collateralDetails = null;
            }
            if (this.reportableInformation != null && !this.reportableInformation.prune().hasData()) {
                this.reportableInformation = null;
            }
            if (this.reportingSide != null && !this.reportingSide.prune().hasData()) {
                this.reportingSide = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCollateralDetails() != null && this.getCollateralDetails().hasData()) {
                return true;
            }
            if (this.getReportableInformation() != null && this.getReportableInformation().hasData()) {
                return true;
            }
            return this.getReportingSide() != null && this.getReportingSide().hasData();
        }

        public CollateralReportInstructionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CollateralReportInstructionBuilder o = (CollateralReportInstructionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCollateralDetails(), (RosettaModelObjectBuilder)o.getCollateralDetails(), this::setCollateralDetails);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReportableInformation(), (RosettaModelObjectBuilder)o.getReportableInformation(), this::setReportableInformation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReportingSide(), (RosettaModelObjectBuilder)o.getReportingSide(), this::setReportingSide);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CollateralReportInstruction _that = this.getType().cast(o);
            if (!Objects.equals(this.collateralDetails, _that.getCollateralDetails())) {
                return false;
            }
            if (!Objects.equals(this.reportableInformation, _that.getReportableInformation())) {
                return false;
            }
            return Objects.equals(this.reportingSide, _that.getReportingSide());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.collateralDetails != null ? this.collateralDetails.hashCode() : 0);
            _result = 31 * _result + (this.reportableInformation != null ? this.reportableInformation.hashCode() : 0);
            _result = 31 * _result + (this.reportingSide != null ? this.reportingSide.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralReportInstructionBuilder {collateralDetails=" + String.valueOf(this.collateralDetails) + ", reportableInformation=" + String.valueOf(this.reportableInformation) + ", reportingSide=" + String.valueOf(this.reportingSide) + "}";
        }
    }

    public static interface CollateralReportInstructionBuilder
    extends CollateralReportInstruction,
    CollateralReportInstructionBase.CollateralReportInstructionBaseBuilder {
        @Override
        public ReportableInformation.ReportableInformationBuilder getOrCreateReportableInformation();

        @Override
        public ReportableInformation.ReportableInformationBuilder getReportableInformation();

        @Override
        public CollateralReportInstructionBuilder setCollateralDetails(CollateralDetails var1);

        @Override
        public CollateralReportInstructionBuilder setReportableInformation(ReportableInformationBase var1);

        @Override
        public CollateralReportInstructionBuilder setReportingSide(ReportingSide var1);

        public CollateralReportInstructionBuilder setReportableInformation(ReportableInformation var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("collateralDetails"), processor, CollateralDetails.CollateralDetailsBuilder.class, (RosettaModelObjectBuilder)this.getCollateralDetails(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reportableInformation"), processor, ReportableInformation.ReportableInformationBuilder.class, this.getReportableInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reportingSide"), processor, ReportingSide.ReportingSideBuilder.class, (RosettaModelObjectBuilder)this.getReportingSide(), new AttributeMeta[0]);
        }

        @Override
        public CollateralReportInstructionBuilder prune();
    }

    public static class CollateralReportInstructionImpl
    extends CollateralReportInstructionBase.CollateralReportInstructionBaseImpl
    implements CollateralReportInstruction {
        private final ReportableInformation reportableInformation;

        protected CollateralReportInstructionImpl(CollateralReportInstructionBuilder builder) {
            super(builder);
            this.reportableInformation = Optional.ofNullable(builder.getReportableInformation()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="reportableInformation", isRequired=true)
        @RuneAttribute(value="reportableInformation", isRequired=true)
        public ReportableInformation getReportableInformation() {
            return this.reportableInformation;
        }

        @Override
        public CollateralReportInstruction build() {
            return this;
        }

        @Override
        public CollateralReportInstructionBuilder toBuilder() {
            CollateralReportInstructionBuilder builder = CollateralReportInstruction.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CollateralReportInstructionBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getReportableInformation()).ifPresent(builder::setReportableInformation);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CollateralReportInstruction _that = (CollateralReportInstruction)this.getType().cast(o);
            return Objects.equals(this.reportableInformation, _that.getReportableInformation());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.reportableInformation != null ? this.reportableInformation.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CollateralReportInstruction {reportableInformation=" + String.valueOf(this.reportableInformation) + "} " + super.toString();
        }
    }
}

