/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.product.common.settlement.PriceQuantity;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.template.ForwardPayout;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.functions.GetQuantityKeys;
import drr.base.trade.functions.GetQuantityReference;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=CommodityForwardObservablePriceQuantityDefault.class)
public abstract class CommodityForwardObservablePriceQuantity
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected GetQuantityKeys getQuantityKeys;
    @Inject
    protected GetQuantityReference getQuantityReference;

    public PriceQuantity evaluate(TradeLot tradeLot, ForwardPayout forwardPayout) {
        PriceQuantity priceQuantity;
        PriceQuantity.PriceQuantityBuilder priceQuantityBuilder = this.doEvaluate(tradeLot, forwardPayout);
        if (priceQuantityBuilder == null) {
            priceQuantity = null;
        } else {
            priceQuantity = priceQuantityBuilder.build();
            this.objectValidator.validate(PriceQuantity.class, (RosettaModelObject)priceQuantity);
        }
        return priceQuantity;
    }

    protected abstract PriceQuantity.PriceQuantityBuilder doEvaluate(TradeLot var1, ForwardPayout var2);

    protected abstract MapperS<? extends PriceQuantity> priceQuantityWithMatchingObservable(TradeLot var1, ForwardPayout var2);

    protected abstract MapperS<? extends PriceQuantity> priceQuantityWithMatchingKey(TradeLot var1, ForwardPayout var2);

    public static class CommodityForwardObservablePriceQuantityDefault
    extends CommodityForwardObservablePriceQuantity {
        @Override
        protected PriceQuantity.PriceQuantityBuilder doEvaluate(TradeLot tradeLot, ForwardPayout forwardPayout) {
            PriceQuantity.PriceQuantityBuilder priceQuantity = PriceQuantity.builder();
            return this.assignOutput(priceQuantity, tradeLot, forwardPayout);
        }

        protected PriceQuantity.PriceQuantityBuilder assignOutput(PriceQuantity.PriceQuantityBuilder priceQuantity, TradeLot tradeLot, ForwardPayout forwardPayout) {
            priceQuantity = ExpressionOperators.exists(this.priceQuantityWithMatchingObservable(tradeLot, forwardPayout)).getOrDefault(Boolean.valueOf(false)) != false ? (PriceQuantity.PriceQuantityBuilder)this.toBuilder((RosettaModelObject)this.priceQuantityWithMatchingObservable(tradeLot, forwardPayout).get()) : (PriceQuantity.PriceQuantityBuilder)this.toBuilder((RosettaModelObject)this.priceQuantityWithMatchingKey(tradeLot, forwardPayout).get());
            return Optional.ofNullable(priceQuantity).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends PriceQuantity> priceQuantityWithMatchingObservable(TradeLot tradeLot, ForwardPayout forwardPayout) {
            MapperC thenArg0 = MapperS.of((Object)tradeLot).mapC("getPriceQuantity", _tradeLot -> _tradeLot.getPriceQuantity());
            MapperC thenArg1 = thenArg0.filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("getObservable", priceQuantity -> priceQuantity.getObservable()).map("getCommodity", observable -> observable.getCommodity()).map("Type coercion", fieldWithMetaCommodity -> fieldWithMetaCommodity == null ? null : fieldWithMetaCommodity.getValue()), (Mapper)MapperS.of((Object)forwardPayout).map("getUnderlier", _forwardPayout -> _forwardPayout.getUnderlier()).map("getCommodity", product -> product.getCommodity()).map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity == null ? null : referenceWithMetaCommodity.getValue()), (CardinalityOperator)CardinalityOperator.All).get());
            return MapperS.of((Object)((PriceQuantity)thenArg1.get()));
        }

        @Override
        protected MapperS<? extends PriceQuantity> priceQuantityWithMatchingKey(TradeLot tradeLot, ForwardPayout forwardPayout) {
            MapperC thenArg = MapperS.of((Object)tradeLot).mapC("getPriceQuantity", _tradeLot -> _tradeLot.getPriceQuantity()).filterItemNullSafe(item -> ExpressionOperators.contains((Mapper)MapperC.of(this.getQuantityKeys.evaluate((PriceQuantity)item.get())), (Mapper)MapperS.of((Object)this.getQuantityReference.evaluate((ResolvablePriceQuantity)MapperS.of((Object)forwardPayout).map("getPriceQuantity", _forwardPayout -> _forwardPayout.getPriceQuantity()).get()))).get());
            return MapperS.of((Object)((PriceQuantity)thenArg.get()));
        }
    }
}

