/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.product.common.settlement.Cashflow;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.qualification.product.functions.IsFXForward;
import drr.base.qualification.product.functions.IsFXOption;
import drr.base.trade.underlier.functions.UnderlierForProduct;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=FXLeg2Default.class)
public abstract class FXLeg2
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected IsFXForward isFXForward;
    @Inject
    protected IsFXOption isFXOption;
    @Inject
    protected UnderlierForProduct underlierForProduct;

    public Cashflow evaluate(Product product) {
        Cashflow fxLeg2;
        Cashflow.CashflowBuilder fxLeg2Builder = this.doEvaluate(product);
        if (fxLeg2Builder == null) {
            fxLeg2 = null;
        } else {
            fxLeg2 = fxLeg2Builder.build();
            this.objectValidator.validate(Cashflow.class, (RosettaModelObject)fxLeg2);
        }
        return fxLeg2;
    }

    protected abstract Cashflow.CashflowBuilder doEvaluate(Product var1);

    public static class FXLeg2Default
    extends FXLeg2 {
        @Override
        protected Cashflow.CashflowBuilder doEvaluate(Product product) {
            Cashflow.CashflowBuilder fxLeg2 = Cashflow.builder();
            return this.assignOutput(fxLeg2, product);
        }

        protected Cashflow.CashflowBuilder assignOutput(Cashflow.CashflowBuilder fxLeg2, Product product) {
            fxLeg2 = ComparisonResult.of((Mapper)MapperS.of((Object)this.isFXForward.evaluate(product))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.isFXOption.evaluate(product)))).getOrDefault(Boolean.valueOf(false)) != false ? (Cashflow.CashflowBuilder)this.toBuilder((RosettaModelObject)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)this.underlierForProduct.evaluate(product)).map("getForeignExchange", _product -> _product.getForeignExchange()).map("getExchangedCurrency1", foreignExchange -> foreignExchange.getExchangedCurrency1()), MapperS.of((Object)this.underlierForProduct.evaluate(product)).map("getForeignExchange", _product -> _product.getForeignExchange()).map("getExchangedCurrency2", foreignExchange -> foreignExchange.getExchangedCurrency2())}).max(item -> item.map("getPriceQuantity", cashflow -> cashflow.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule == null ? null : referenceWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("Type coercion", fieldWithMetaString -> fieldWithMetaString == null ? null : fieldWithMetaString.getValue())).get()) : null;
            return Optional.ofNullable(fxLeg2).map(o -> o.prune()).orElse(null);
        }
    }
}

