/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.RegimeNameEnum;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.TransactionInformation;
import drr.regulation.common.TransactionReportInstruction;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetTransactionInformationForRegimeDefault.class)
public abstract class GetTransactionInformationForRegime
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public TransactionInformation evaluate(TransactionReportInstruction transaction, RegimeNameEnum regime, SupervisoryBodyEnum supervisoryBodyIn) {
        TransactionInformation transactionInformation;
        TransactionInformation.TransactionInformationBuilder transactionInformationBuilder = this.doEvaluate(transaction, regime, supervisoryBodyIn);
        if (transactionInformationBuilder == null) {
            transactionInformation = null;
        } else {
            transactionInformation = transactionInformationBuilder.build();
            this.objectValidator.validate(TransactionInformation.class, (RosettaModelObject)transactionInformation);
        }
        return transactionInformation;
    }

    protected abstract TransactionInformation.TransactionInformationBuilder doEvaluate(TransactionReportInstruction var1, RegimeNameEnum var2, SupervisoryBodyEnum var3);

    public static class GetTransactionInformationForRegimeDefault
    extends GetTransactionInformationForRegime {
        @Override
        protected TransactionInformation.TransactionInformationBuilder doEvaluate(TransactionReportInstruction transaction, RegimeNameEnum regime, SupervisoryBodyEnum supervisoryBodyIn) {
            TransactionInformation.TransactionInformationBuilder transactionInformation = TransactionInformation.builder();
            return this.assignOutput(transactionInformation, transaction, regime, supervisoryBodyIn);
        }

        protected TransactionInformation.TransactionInformationBuilder assignOutput(TransactionInformation.TransactionInformationBuilder transactionInformation, TransactionReportInstruction transaction, RegimeNameEnum regime, SupervisoryBodyEnum supervisoryBodyIn) {
            MapperC thenArg0 = MapperS.of((Object)transaction).map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).mapC("getTransactionInformation", reportableInformation -> reportableInformation.getTransactionInformation());
            MapperC thenArg1 = thenArg0.filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("getRegimeName", _transactionInformation -> _transactionInformation.getRegimeName()).map("Type coercion", fieldWithMetaRegimeNameEnum -> fieldWithMetaRegimeNameEnum == null ? null : fieldWithMetaRegimeNameEnum.getValue()), (Mapper)MapperS.of((Object)((Object)regime)), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)item.map("getSupervisoryBody", _transactionInformation -> _transactionInformation.getSupervisoryBody()).map("Type coercion", fieldWithMetaSupervisoryBodyEnum -> fieldWithMetaSupervisoryBodyEnum == null ? null : fieldWithMetaSupervisoryBodyEnum.getValue()), (Mapper)MapperS.of((Object)((Object)supervisoryBodyIn)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.notExists((Mapper)MapperS.of((Object)((Object)supervisoryBodyIn))))).get());
            transactionInformation = (TransactionInformation.TransactionInformationBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)((TransactionInformation)thenArg1.get())).get());
            return Optional.ofNullable(transactionInformation).map(o -> o.prune()).orElse(null);
        }
    }
}

