/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.contract.reports;

import cdm.product.common.settlement.SettlementTerms;
import cdm.product.common.settlement.SettlementTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.standards.iso.DeliveryTypeEnum;

@ImplementedBy(value=DeliveryTypeFromSettlementRuleDefault.class)
public abstract class DeliveryTypeFromSettlementRule
implements ReportFunction<SettlementTerms, DeliveryTypeEnum> {
    public DeliveryTypeEnum evaluate(SettlementTerms input) {
        DeliveryTypeEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract DeliveryTypeEnum doEvaluate(SettlementTerms var1);

    public static class DeliveryTypeFromSettlementRuleDefault
    extends DeliveryTypeFromSettlementRule {
        @Override
        protected DeliveryTypeEnum doEvaluate(SettlementTerms input) {
            DeliveryTypeEnum output = null;
            return this.assignOutput(output, input);
        }

        protected DeliveryTypeEnum assignOutput(DeliveryTypeEnum output, SettlementTerms input) {
            output = ExpressionOperators.areEqual((Mapper)MapperS.of((Object)input).map("getSettlementType", settlementTerms -> settlementTerms.getSettlementType()), (Mapper)MapperS.of((Object)SettlementTypeEnum.CASH), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.exists((Mapper)MapperS.of((Object)input).mapC("getCashSettlementTerms", settlementTerms -> settlementTerms.getCashSettlementTerms()))).getOrDefault(Boolean.valueOf(false)) != false ? DeliveryTypeEnum.CASH : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)input).map("getSettlementType", settlementTerms -> settlementTerms.getSettlementType()), (Mapper)MapperS.of((Object)SettlementTypeEnum.PHYSICAL), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.exists((Mapper)MapperS.of((Object)input).map("getPhysicalSettlementTerms", settlementTerms -> settlementTerms.getPhysicalSettlementTerms()))).getOrDefault(Boolean.valueOf(false)) != false ? DeliveryTypeEnum.PHYS : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)input).map("getSettlementType", settlementTerms -> settlementTerms.getSettlementType()), (Mapper)MapperS.of((Object)SettlementTypeEnum.CASH_OR_PHYSICAL), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)input).map("getSettlementType", settlementTerms -> settlementTerms.getSettlementType()), (Mapper)MapperS.of((Object)SettlementTypeEnum.ELECTION), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)) != false ? DeliveryTypeEnum.OPTL : null));
            return output;
        }
    }
}

