/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.payment;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.base.trade.payment.PeriodicPayment;
import drr.regulation.common.trade.payment.meta.CommonPeriodicPaymentMeta;
import drr.standards.iso.FrequencyPeriodEnum;
import drr.standards.iso.IndexEnum;
import drr.standards.iso.InterestComputationMethod4Code;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CommonPeriodicPayment", builder=CommonPeriodicPaymentBuilderImpl.class, version="7.0.0-dev.66")
@RuneDataType(value="CommonPeriodicPayment", model="drr", builder=CommonPeriodicPaymentBuilderImpl.class, version="7.0.0-dev.66")
public interface CommonPeriodicPayment
extends PeriodicPayment {
    public static final CommonPeriodicPaymentMeta metaData = new CommonPeriodicPaymentMeta();

    public FrequencyPeriodEnum getFloatingRateResetFrequencyPeriod();

    public Integer getFloatingRateResetFrequencyMultiplier();

    public IndexEnum getFloatingRateIndicator();

    public String getFloatingRateIdentifier();

    public FrequencyPeriodEnum getFloatingRateReferencePeriod();

    public Integer getFloatingRateReferencePeriodMultiplier();

    public String getNameOfTheFloatingRate();

    @Override
    public CommonPeriodicPayment build();

    @Override
    public CommonPeriodicPaymentBuilder toBuilder();

    public static CommonPeriodicPaymentBuilder builder() {
        return new CommonPeriodicPaymentBuilderImpl();
    }

    default public RosettaMetaData<? extends CommonPeriodicPayment> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CommonPeriodicPayment> getType() {
        return CommonPeriodicPayment.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fixedRateDayCountConvention"), InterestComputationMethod4Code.class, (Object)this.getFixedRateDayCountConvention(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingRateDayCountConvention"), InterestComputationMethod4Code.class, (Object)this.getFloatingRateDayCountConvention(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriod"), FrequencyPeriodEnum.class, (Object)this.getFixedRatePaymentFrequencyPeriod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriod"), FrequencyPeriodEnum.class, (Object)this.getFloatingRatePaymentFrequencyPeriod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodMultiplier"), Integer.class, (Object)this.getFixedRatePaymentFrequencyPeriodMultiplier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodMultiplier"), Integer.class, (Object)this.getFloatingRatePaymentFrequencyPeriodMultiplier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriod"), FrequencyPeriodEnum.class, (Object)this.getFloatingRateResetFrequencyPeriod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingRateResetFrequencyMultiplier"), Integer.class, (Object)this.getFloatingRateResetFrequencyMultiplier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingRateIndicator"), IndexEnum.class, (Object)this.getFloatingRateIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingRateIdentifier"), String.class, (Object)this.getFloatingRateIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingRateReferencePeriod"), FrequencyPeriodEnum.class, (Object)this.getFloatingRateReferencePeriod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingRateReferencePeriodMultiplier"), Integer.class, (Object)this.getFloatingRateReferencePeriodMultiplier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nameOfTheFloatingRate"), String.class, (Object)this.getNameOfTheFloatingRate(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CommonPeriodicPaymentBuilderImpl
    extends PeriodicPayment.PeriodicPaymentBuilderImpl
    implements CommonPeriodicPaymentBuilder {
        protected FrequencyPeriodEnum floatingRateResetFrequencyPeriod;
        protected Integer floatingRateResetFrequencyMultiplier;
        protected IndexEnum floatingRateIndicator;
        protected String floatingRateIdentifier;
        protected FrequencyPeriodEnum floatingRateReferencePeriod;
        protected Integer floatingRateReferencePeriodMultiplier;
        protected String nameOfTheFloatingRate;

        @Override
        @RosettaAttribute(value="floatingRateResetFrequencyPeriod")
        @RuneAttribute(value="floatingRateResetFrequencyPeriod")
        public FrequencyPeriodEnum getFloatingRateResetFrequencyPeriod() {
            return this.floatingRateResetFrequencyPeriod;
        }

        @Override
        @RosettaAttribute(value="floatingRateResetFrequencyMultiplier")
        @RuneAttribute(value="floatingRateResetFrequencyMultiplier")
        public Integer getFloatingRateResetFrequencyMultiplier() {
            return this.floatingRateResetFrequencyMultiplier;
        }

        @Override
        @RosettaAttribute(value="floatingRateIndicator")
        @RuneAttribute(value="floatingRateIndicator")
        public IndexEnum getFloatingRateIndicator() {
            return this.floatingRateIndicator;
        }

        @Override
        @RosettaAttribute(value="floatingRateIdentifier")
        @RuneAttribute(value="floatingRateIdentifier")
        public String getFloatingRateIdentifier() {
            return this.floatingRateIdentifier;
        }

        @Override
        @RosettaAttribute(value="floatingRateReferencePeriod")
        @RuneAttribute(value="floatingRateReferencePeriod")
        public FrequencyPeriodEnum getFloatingRateReferencePeriod() {
            return this.floatingRateReferencePeriod;
        }

        @Override
        @RosettaAttribute(value="floatingRateReferencePeriodMultiplier")
        @RuneAttribute(value="floatingRateReferencePeriodMultiplier")
        public Integer getFloatingRateReferencePeriodMultiplier() {
            return this.floatingRateReferencePeriodMultiplier;
        }

        @Override
        @RosettaAttribute(value="nameOfTheFloatingRate")
        @RuneAttribute(value="nameOfTheFloatingRate")
        public String getNameOfTheFloatingRate() {
            return this.nameOfTheFloatingRate;
        }

        @Override
        @RosettaAttribute(value="fixedRateDayCountConvention")
        @RuneAttribute(value="fixedRateDayCountConvention")
        public CommonPeriodicPaymentBuilder setFixedRateDayCountConvention(InterestComputationMethod4Code _fixedRateDayCountConvention) {
            this.fixedRateDayCountConvention = _fixedRateDayCountConvention == null ? null : _fixedRateDayCountConvention;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRateDayCountConvention")
        @RuneAttribute(value="floatingRateDayCountConvention")
        public CommonPeriodicPaymentBuilder setFloatingRateDayCountConvention(InterestComputationMethod4Code _floatingRateDayCountConvention) {
            this.floatingRateDayCountConvention = _floatingRateDayCountConvention == null ? null : _floatingRateDayCountConvention;
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedRatePaymentFrequencyPeriod")
        @RuneAttribute(value="fixedRatePaymentFrequencyPeriod")
        public CommonPeriodicPaymentBuilder setFixedRatePaymentFrequencyPeriod(FrequencyPeriodEnum _fixedRatePaymentFrequencyPeriod) {
            this.fixedRatePaymentFrequencyPeriod = _fixedRatePaymentFrequencyPeriod == null ? null : _fixedRatePaymentFrequencyPeriod;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRatePaymentFrequencyPeriod")
        @RuneAttribute(value="floatingRatePaymentFrequencyPeriod")
        public CommonPeriodicPaymentBuilder setFloatingRatePaymentFrequencyPeriod(FrequencyPeriodEnum _floatingRatePaymentFrequencyPeriod) {
            this.floatingRatePaymentFrequencyPeriod = _floatingRatePaymentFrequencyPeriod == null ? null : _floatingRatePaymentFrequencyPeriod;
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedRatePaymentFrequencyPeriodMultiplier")
        @RuneAttribute(value="fixedRatePaymentFrequencyPeriodMultiplier")
        public CommonPeriodicPaymentBuilder setFixedRatePaymentFrequencyPeriodMultiplier(Integer _fixedRatePaymentFrequencyPeriodMultiplier) {
            this.fixedRatePaymentFrequencyPeriodMultiplier = _fixedRatePaymentFrequencyPeriodMultiplier == null ? null : _fixedRatePaymentFrequencyPeriodMultiplier;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRatePaymentFrequencyPeriodMultiplier")
        @RuneAttribute(value="floatingRatePaymentFrequencyPeriodMultiplier")
        public CommonPeriodicPaymentBuilder setFloatingRatePaymentFrequencyPeriodMultiplier(Integer _floatingRatePaymentFrequencyPeriodMultiplier) {
            this.floatingRatePaymentFrequencyPeriodMultiplier = _floatingRatePaymentFrequencyPeriodMultiplier == null ? null : _floatingRatePaymentFrequencyPeriodMultiplier;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRateResetFrequencyPeriod")
        @RuneAttribute(value="floatingRateResetFrequencyPeriod")
        public CommonPeriodicPaymentBuilder setFloatingRateResetFrequencyPeriod(FrequencyPeriodEnum _floatingRateResetFrequencyPeriod) {
            this.floatingRateResetFrequencyPeriod = _floatingRateResetFrequencyPeriod == null ? null : _floatingRateResetFrequencyPeriod;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRateResetFrequencyMultiplier")
        @RuneAttribute(value="floatingRateResetFrequencyMultiplier")
        public CommonPeriodicPaymentBuilder setFloatingRateResetFrequencyMultiplier(Integer _floatingRateResetFrequencyMultiplier) {
            this.floatingRateResetFrequencyMultiplier = _floatingRateResetFrequencyMultiplier == null ? null : _floatingRateResetFrequencyMultiplier;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRateIndicator")
        @RuneAttribute(value="floatingRateIndicator")
        public CommonPeriodicPaymentBuilder setFloatingRateIndicator(IndexEnum _floatingRateIndicator) {
            this.floatingRateIndicator = _floatingRateIndicator == null ? null : _floatingRateIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRateIdentifier")
        @RuneAttribute(value="floatingRateIdentifier")
        public CommonPeriodicPaymentBuilder setFloatingRateIdentifier(String _floatingRateIdentifier) {
            this.floatingRateIdentifier = _floatingRateIdentifier == null ? null : _floatingRateIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRateReferencePeriod")
        @RuneAttribute(value="floatingRateReferencePeriod")
        public CommonPeriodicPaymentBuilder setFloatingRateReferencePeriod(FrequencyPeriodEnum _floatingRateReferencePeriod) {
            this.floatingRateReferencePeriod = _floatingRateReferencePeriod == null ? null : _floatingRateReferencePeriod;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRateReferencePeriodMultiplier")
        @RuneAttribute(value="floatingRateReferencePeriodMultiplier")
        public CommonPeriodicPaymentBuilder setFloatingRateReferencePeriodMultiplier(Integer _floatingRateReferencePeriodMultiplier) {
            this.floatingRateReferencePeriodMultiplier = _floatingRateReferencePeriodMultiplier == null ? null : _floatingRateReferencePeriodMultiplier;
            return this;
        }

        @Override
        @RosettaAttribute(value="nameOfTheFloatingRate")
        @RuneAttribute(value="nameOfTheFloatingRate")
        public CommonPeriodicPaymentBuilder setNameOfTheFloatingRate(String _nameOfTheFloatingRate) {
            this.nameOfTheFloatingRate = _nameOfTheFloatingRate == null ? null : _nameOfTheFloatingRate;
            return this;
        }

        @Override
        public CommonPeriodicPayment build() {
            return new CommonPeriodicPaymentImpl(this);
        }

        @Override
        public CommonPeriodicPaymentBuilder toBuilder() {
            return this;
        }

        @Override
        public CommonPeriodicPaymentBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getFloatingRateResetFrequencyPeriod() != null) {
                return true;
            }
            if (this.getFloatingRateResetFrequencyMultiplier() != null) {
                return true;
            }
            if (this.getFloatingRateIndicator() != null) {
                return true;
            }
            if (this.getFloatingRateIdentifier() != null) {
                return true;
            }
            if (this.getFloatingRateReferencePeriod() != null) {
                return true;
            }
            if (this.getFloatingRateReferencePeriodMultiplier() != null) {
                return true;
            }
            return this.getNameOfTheFloatingRate() != null;
        }

        @Override
        public CommonPeriodicPaymentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CommonPeriodicPaymentBuilder o = (CommonPeriodicPaymentBuilder)other;
            merger.mergeBasic((Object)this.getFloatingRateResetFrequencyPeriod(), (Object)o.getFloatingRateResetFrequencyPeriod(), this::setFloatingRateResetFrequencyPeriod, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFloatingRateResetFrequencyMultiplier(), (Object)o.getFloatingRateResetFrequencyMultiplier(), this::setFloatingRateResetFrequencyMultiplier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFloatingRateIndicator(), (Object)o.getFloatingRateIndicator(), this::setFloatingRateIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFloatingRateIdentifier(), (Object)o.getFloatingRateIdentifier(), this::setFloatingRateIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFloatingRateReferencePeriod(), (Object)o.getFloatingRateReferencePeriod(), this::setFloatingRateReferencePeriod, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFloatingRateReferencePeriodMultiplier(), (Object)o.getFloatingRateReferencePeriodMultiplier(), this::setFloatingRateReferencePeriodMultiplier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNameOfTheFloatingRate(), (Object)o.getNameOfTheFloatingRate(), this::setNameOfTheFloatingRate, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CommonPeriodicPayment _that = (CommonPeriodicPayment)this.getType().cast(o);
            if (!Objects.equals((Object)this.floatingRateResetFrequencyPeriod, (Object)_that.getFloatingRateResetFrequencyPeriod())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateResetFrequencyMultiplier, _that.getFloatingRateResetFrequencyMultiplier())) {
                return false;
            }
            if (!Objects.equals((Object)this.floatingRateIndicator, (Object)_that.getFloatingRateIndicator())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateIdentifier, _that.getFloatingRateIdentifier())) {
                return false;
            }
            if (!Objects.equals((Object)this.floatingRateReferencePeriod, (Object)_that.getFloatingRateReferencePeriod())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateReferencePeriodMultiplier, _that.getFloatingRateReferencePeriodMultiplier())) {
                return false;
            }
            return Objects.equals(this.nameOfTheFloatingRate, _that.getNameOfTheFloatingRate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.floatingRateResetFrequencyPeriod != null ? ((Object)((Object)this.floatingRateResetFrequencyPeriod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.floatingRateResetFrequencyMultiplier != null ? this.floatingRateResetFrequencyMultiplier.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateIndicator != null ? ((Object)((Object)this.floatingRateIndicator)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.floatingRateIdentifier != null ? this.floatingRateIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateReferencePeriod != null ? ((Object)((Object)this.floatingRateReferencePeriod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.floatingRateReferencePeriodMultiplier != null ? this.floatingRateReferencePeriodMultiplier.hashCode() : 0);
            _result = 31 * _result + (this.nameOfTheFloatingRate != null ? this.nameOfTheFloatingRate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CommonPeriodicPaymentBuilder {floatingRateResetFrequencyPeriod=" + String.valueOf((Object)this.floatingRateResetFrequencyPeriod) + ", floatingRateResetFrequencyMultiplier=" + this.floatingRateResetFrequencyMultiplier + ", floatingRateIndicator=" + String.valueOf((Object)this.floatingRateIndicator) + ", floatingRateIdentifier=" + this.floatingRateIdentifier + ", floatingRateReferencePeriod=" + String.valueOf((Object)this.floatingRateReferencePeriod) + ", floatingRateReferencePeriodMultiplier=" + this.floatingRateReferencePeriodMultiplier + ", nameOfTheFloatingRate=" + this.nameOfTheFloatingRate + "} " + super.toString();
        }
    }

    public static interface CommonPeriodicPaymentBuilder
    extends CommonPeriodicPayment,
    PeriodicPayment.PeriodicPaymentBuilder {
        @Override
        public CommonPeriodicPaymentBuilder setFixedRateDayCountConvention(InterestComputationMethod4Code var1);

        @Override
        public CommonPeriodicPaymentBuilder setFloatingRateDayCountConvention(InterestComputationMethod4Code var1);

        @Override
        public CommonPeriodicPaymentBuilder setFixedRatePaymentFrequencyPeriod(FrequencyPeriodEnum var1);

        @Override
        public CommonPeriodicPaymentBuilder setFloatingRatePaymentFrequencyPeriod(FrequencyPeriodEnum var1);

        @Override
        public CommonPeriodicPaymentBuilder setFixedRatePaymentFrequencyPeriodMultiplier(Integer var1);

        @Override
        public CommonPeriodicPaymentBuilder setFloatingRatePaymentFrequencyPeriodMultiplier(Integer var1);

        public CommonPeriodicPaymentBuilder setFloatingRateResetFrequencyPeriod(FrequencyPeriodEnum var1);

        public CommonPeriodicPaymentBuilder setFloatingRateResetFrequencyMultiplier(Integer var1);

        public CommonPeriodicPaymentBuilder setFloatingRateIndicator(IndexEnum var1);

        public CommonPeriodicPaymentBuilder setFloatingRateIdentifier(String var1);

        public CommonPeriodicPaymentBuilder setFloatingRateReferencePeriod(FrequencyPeriodEnum var1);

        public CommonPeriodicPaymentBuilder setFloatingRateReferencePeriodMultiplier(Integer var1);

        public CommonPeriodicPaymentBuilder setNameOfTheFloatingRate(String var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fixedRateDayCountConvention"), InterestComputationMethod4Code.class, (Object)this.getFixedRateDayCountConvention(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingRateDayCountConvention"), InterestComputationMethod4Code.class, (Object)this.getFloatingRateDayCountConvention(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriod"), FrequencyPeriodEnum.class, (Object)this.getFixedRatePaymentFrequencyPeriod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriod"), FrequencyPeriodEnum.class, (Object)this.getFloatingRatePaymentFrequencyPeriod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodMultiplier"), Integer.class, (Object)this.getFixedRatePaymentFrequencyPeriodMultiplier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodMultiplier"), Integer.class, (Object)this.getFloatingRatePaymentFrequencyPeriodMultiplier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriod"), FrequencyPeriodEnum.class, (Object)this.getFloatingRateResetFrequencyPeriod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingRateResetFrequencyMultiplier"), Integer.class, (Object)this.getFloatingRateResetFrequencyMultiplier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingRateIndicator"), IndexEnum.class, (Object)this.getFloatingRateIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingRateIdentifier"), String.class, (Object)this.getFloatingRateIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingRateReferencePeriod"), FrequencyPeriodEnum.class, (Object)this.getFloatingRateReferencePeriod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingRateReferencePeriodMultiplier"), Integer.class, (Object)this.getFloatingRateReferencePeriodMultiplier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nameOfTheFloatingRate"), String.class, (Object)this.getNameOfTheFloatingRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public CommonPeriodicPaymentBuilder prune();
    }

    public static class CommonPeriodicPaymentImpl
    extends PeriodicPayment.PeriodicPaymentImpl
    implements CommonPeriodicPayment {
        private final FrequencyPeriodEnum floatingRateResetFrequencyPeriod;
        private final Integer floatingRateResetFrequencyMultiplier;
        private final IndexEnum floatingRateIndicator;
        private final String floatingRateIdentifier;
        private final FrequencyPeriodEnum floatingRateReferencePeriod;
        private final Integer floatingRateReferencePeriodMultiplier;
        private final String nameOfTheFloatingRate;

        protected CommonPeriodicPaymentImpl(CommonPeriodicPaymentBuilder builder) {
            super(builder);
            this.floatingRateResetFrequencyPeriod = builder.getFloatingRateResetFrequencyPeriod();
            this.floatingRateResetFrequencyMultiplier = builder.getFloatingRateResetFrequencyMultiplier();
            this.floatingRateIndicator = builder.getFloatingRateIndicator();
            this.floatingRateIdentifier = builder.getFloatingRateIdentifier();
            this.floatingRateReferencePeriod = builder.getFloatingRateReferencePeriod();
            this.floatingRateReferencePeriodMultiplier = builder.getFloatingRateReferencePeriodMultiplier();
            this.nameOfTheFloatingRate = builder.getNameOfTheFloatingRate();
        }

        @Override
        @RosettaAttribute(value="floatingRateResetFrequencyPeriod")
        @RuneAttribute(value="floatingRateResetFrequencyPeriod")
        public FrequencyPeriodEnum getFloatingRateResetFrequencyPeriod() {
            return this.floatingRateResetFrequencyPeriod;
        }

        @Override
        @RosettaAttribute(value="floatingRateResetFrequencyMultiplier")
        @RuneAttribute(value="floatingRateResetFrequencyMultiplier")
        public Integer getFloatingRateResetFrequencyMultiplier() {
            return this.floatingRateResetFrequencyMultiplier;
        }

        @Override
        @RosettaAttribute(value="floatingRateIndicator")
        @RuneAttribute(value="floatingRateIndicator")
        public IndexEnum getFloatingRateIndicator() {
            return this.floatingRateIndicator;
        }

        @Override
        @RosettaAttribute(value="floatingRateIdentifier")
        @RuneAttribute(value="floatingRateIdentifier")
        public String getFloatingRateIdentifier() {
            return this.floatingRateIdentifier;
        }

        @Override
        @RosettaAttribute(value="floatingRateReferencePeriod")
        @RuneAttribute(value="floatingRateReferencePeriod")
        public FrequencyPeriodEnum getFloatingRateReferencePeriod() {
            return this.floatingRateReferencePeriod;
        }

        @Override
        @RosettaAttribute(value="floatingRateReferencePeriodMultiplier")
        @RuneAttribute(value="floatingRateReferencePeriodMultiplier")
        public Integer getFloatingRateReferencePeriodMultiplier() {
            return this.floatingRateReferencePeriodMultiplier;
        }

        @Override
        @RosettaAttribute(value="nameOfTheFloatingRate")
        @RuneAttribute(value="nameOfTheFloatingRate")
        public String getNameOfTheFloatingRate() {
            return this.nameOfTheFloatingRate;
        }

        @Override
        public CommonPeriodicPayment build() {
            return this;
        }

        @Override
        public CommonPeriodicPaymentBuilder toBuilder() {
            CommonPeriodicPaymentBuilder builder = CommonPeriodicPayment.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CommonPeriodicPaymentBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getFloatingRateResetFrequencyPeriod()).ifPresent(builder::setFloatingRateResetFrequencyPeriod);
            Optional.ofNullable(this.getFloatingRateResetFrequencyMultiplier()).ifPresent(builder::setFloatingRateResetFrequencyMultiplier);
            Optional.ofNullable(this.getFloatingRateIndicator()).ifPresent(builder::setFloatingRateIndicator);
            Optional.ofNullable(this.getFloatingRateIdentifier()).ifPresent(builder::setFloatingRateIdentifier);
            Optional.ofNullable(this.getFloatingRateReferencePeriod()).ifPresent(builder::setFloatingRateReferencePeriod);
            Optional.ofNullable(this.getFloatingRateReferencePeriodMultiplier()).ifPresent(builder::setFloatingRateReferencePeriodMultiplier);
            Optional.ofNullable(this.getNameOfTheFloatingRate()).ifPresent(builder::setNameOfTheFloatingRate);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CommonPeriodicPayment _that = (CommonPeriodicPayment)this.getType().cast(o);
            if (!Objects.equals((Object)this.floatingRateResetFrequencyPeriod, (Object)_that.getFloatingRateResetFrequencyPeriod())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateResetFrequencyMultiplier, _that.getFloatingRateResetFrequencyMultiplier())) {
                return false;
            }
            if (!Objects.equals((Object)this.floatingRateIndicator, (Object)_that.getFloatingRateIndicator())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateIdentifier, _that.getFloatingRateIdentifier())) {
                return false;
            }
            if (!Objects.equals((Object)this.floatingRateReferencePeriod, (Object)_that.getFloatingRateReferencePeriod())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateReferencePeriodMultiplier, _that.getFloatingRateReferencePeriodMultiplier())) {
                return false;
            }
            return Objects.equals(this.nameOfTheFloatingRate, _that.getNameOfTheFloatingRate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.floatingRateResetFrequencyPeriod != null ? ((Object)((Object)this.floatingRateResetFrequencyPeriod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.floatingRateResetFrequencyMultiplier != null ? this.floatingRateResetFrequencyMultiplier.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateIndicator != null ? ((Object)((Object)this.floatingRateIndicator)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.floatingRateIdentifier != null ? this.floatingRateIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateReferencePeriod != null ? ((Object)((Object)this.floatingRateReferencePeriod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.floatingRateReferencePeriodMultiplier != null ? this.floatingRateReferencePeriodMultiplier.hashCode() : 0);
            _result = 31 * _result + (this.nameOfTheFloatingRate != null ? this.nameOfTheFloatingRate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CommonPeriodicPayment {floatingRateResetFrequencyPeriod=" + String.valueOf((Object)this.floatingRateResetFrequencyPeriod) + ", floatingRateResetFrequencyMultiplier=" + this.floatingRateResetFrequencyMultiplier + ", floatingRateIndicator=" + String.valueOf((Object)this.floatingRateIndicator) + ", floatingRateIdentifier=" + this.floatingRateIdentifier + ", floatingRateReferencePeriod=" + String.valueOf((Object)this.floatingRateReferencePeriod) + ", floatingRateReferencePeriodMultiplier=" + this.floatingRateReferencePeriodMultiplier + ", nameOfTheFloatingRate=" + this.nameOfTheFloatingRate + "} " + super.toString();
        }
    }
}

