/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.functions;

import cdm.product.asset.CommodityPayout;
import cdm.product.asset.InterestRatePayout;
import cdm.product.common.settlement.PayoutBase;
import cdm.product.qualification.functions.Qualify_AssetClass_Commodity;
import cdm.product.qualification.functions.Qualify_AssetClass_InterestRate;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.functions.ProductForTrade;
import drr.base.trade.functions.TradeForEvent;
import drr.regulation.csa.rewrite.trade.functions.CommodityLeg2;
import drr.regulation.csa.rewrite.trade.functions.InterestRateLeg2;
import drr.regulation.csa.rewrite.trade.functions.PayoutMatches;
import javax.inject.Inject;

@ImplementedBy(value=IsCSALeg2AlignedDefault.class)
public abstract class IsCSALeg2Aligned
implements RosettaFunction {
    @Inject
    protected drr.regulation.common.functions.CommodityLeg2 commodityLeg20;
    @Inject
    protected CommodityLeg2 commodityLeg21;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected drr.regulation.common.functions.InterestRateLeg2 interestRateLeg20;
    @Inject
    protected InterestRateLeg2 interestRateLeg21;
    @Inject
    protected PayoutMatches payoutMatches;
    @Inject
    protected ProductForTrade productForTrade;
    @Inject
    protected Qualify_AssetClass_Commodity qualify_AssetClass_Commodity;
    @Inject
    protected Qualify_AssetClass_InterestRate qualify_AssetClass_InterestRate;
    @Inject
    protected TradeForEvent tradeForEvent;

    public Boolean evaluate(ReportableEventBase reportableEvent) {
        Boolean result = this.doEvaluate(reportableEvent);
        return result;
    }

    protected abstract Boolean doEvaluate(ReportableEventBase var1);

    protected abstract MapperS<? extends Product> product(ReportableEventBase var1);

    protected abstract MapperS<? extends EconomicTerms> economicTerms(ReportableEventBase var1);

    protected abstract MapperS<? extends InterestRatePayout> csaInterestRateLeg2(ReportableEventBase var1);

    protected abstract MapperS<? extends InterestRatePayout> drrInterestRateLeg2(ReportableEventBase var1);

    protected abstract MapperS<? extends CommodityPayout> csaCommodityLeg2(ReportableEventBase var1);

    protected abstract MapperS<? extends CommodityPayout> drrCommodityLeg2(ReportableEventBase var1);

    public static class IsCSALeg2AlignedDefault
    extends IsCSALeg2Aligned {
        @Override
        protected Boolean doEvaluate(ReportableEventBase reportableEvent) {
            Boolean result = null;
            return this.assignOutput(result, reportableEvent);
        }

        protected Boolean assignOutput(Boolean result, ReportableEventBase reportableEvent) {
            Boolean boolean1;
            Boolean boolean0 = this.qualify_AssetClass_InterestRate.evaluate((EconomicTerms)this.economicTerms(reportableEvent).get());
            result = boolean0 != null && boolean0 != false ? this.payoutMatches.evaluate((PayoutBase)this.csaInterestRateLeg2(reportableEvent).get(), (PayoutBase)this.drrInterestRateLeg2(reportableEvent).get()) : ((boolean1 = this.qualify_AssetClass_Commodity.evaluate((EconomicTerms)this.economicTerms(reportableEvent).get())) != null && boolean1 != false ? this.payoutMatches.evaluate((PayoutBase)this.csaCommodityLeg2(reportableEvent).get(), (PayoutBase)this.drrCommodityLeg2(reportableEvent).get()) : Boolean.valueOf(true));
            return result;
        }

        @Override
        protected MapperS<? extends Product> product(ReportableEventBase reportableEvent) {
            return MapperS.of((Object)this.productForTrade.evaluate(this.tradeForEvent.evaluate(reportableEvent)));
        }

        @Override
        protected MapperS<? extends EconomicTerms> economicTerms(ReportableEventBase reportableEvent) {
            return MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)this.product(reportableEvent).get()));
        }

        @Override
        protected MapperS<? extends InterestRatePayout> csaInterestRateLeg2(ReportableEventBase reportableEvent) {
            return MapperS.of((Object)this.interestRateLeg21.evaluate((Product)this.product(reportableEvent).get()));
        }

        @Override
        protected MapperS<? extends InterestRatePayout> drrInterestRateLeg2(ReportableEventBase reportableEvent) {
            return MapperS.of((Object)this.interestRateLeg20.evaluate((Product)this.product(reportableEvent).get()));
        }

        @Override
        protected MapperS<? extends CommodityPayout> csaCommodityLeg2(ReportableEventBase reportableEvent) {
            return MapperS.of((Object)this.commodityLeg21.evaluate((Product)this.product(reportableEvent).get()));
        }

        @Override
        protected MapperS<? extends CommodityPayout> drrCommodityLeg2(ReportableEventBase reportableEvent) {
            return MapperS.of((Object)this.commodityLeg20.evaluate((Product)this.product(reportableEvent).get()));
        }
    }
}

