/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.ReportableEventBase;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.csa.rewrite.trade.functions.IsAllowableActionForCSA;
import drr.regulation.csa.rewrite.trade.functions.PayoutForQuantityLeg1;
import drr.standards.iosco.cde.version3.quantity.functions.NotionalAmountFormat;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=NotionalAmountLeg1RuleDefault.class)
public abstract class NotionalAmountLeg1Rule
implements ReportFunction<TransactionReportInstruction, BigDecimal> {
    @Inject
    protected IsAllowableActionForCSA isAllowableActionForCSA;
    @Inject
    protected NotionalAmountFormat notionalAmountFormat;
    @Inject
    protected PayoutForQuantityLeg1 payoutForQuantityLeg1;

    public BigDecimal evaluate(TransactionReportInstruction input) {
        BigDecimal output = this.doEvaluate(input);
        return output;
    }

    protected abstract BigDecimal doEvaluate(TransactionReportInstruction var1);

    public static class NotionalAmountLeg1RuleDefault
    extends NotionalAmountLeg1Rule {
        @Override
        protected BigDecimal doEvaluate(TransactionReportInstruction input) {
            BigDecimal output = null;
            return this.assignOutput(output, input);
        }

        protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForCSA.evaluate((ReportableEventBase)item.get()));
            output = (BigDecimal)MapperS.of((Object)this.notionalAmountFormat.evaluate(this.payoutForQuantityLeg1.evaluate((TransactionReportInstruction)thenArg.get()), new BigDecimal("99999999999999999999.99999"))).get();
            return output;
        }
    }
}

