/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.reports;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.ReportableEventBase;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.csa.rewrite.trade.functions.IsAllowableActionForCSA;
import drr.regulation.csa.rewrite.trade.functions.PayoutLeg1;
import drr.standards.iosco.cde.version3.execution.reports.SettlementCurrencyRule;
import javax.inject.Inject;

@ImplementedBy(value=SettlementCurrencyLeg1RuleDefault.class)
public abstract class SettlementCurrencyLeg1Rule
implements ReportFunction<TransactionReportInstruction, ISOCurrencyCodeEnum> {
    @Inject
    protected IsAllowableActionForCSA isAllowableActionForCSA;
    @Inject
    protected PayoutLeg1 payoutLeg1;
    @Inject
    protected SettlementCurrencyRule settlementCurrencyRule;

    public ISOCurrencyCodeEnum evaluate(TransactionReportInstruction input) {
        ISOCurrencyCodeEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction var1);

    public static class SettlementCurrencyLeg1RuleDefault
    extends SettlementCurrencyLeg1Rule {
        @Override
        protected ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction input) {
            ISOCurrencyCodeEnum output = null;
            return this.assignOutput(output, input);
        }

        protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForCSA.evaluate((ReportableEventBase)item.get()));
            output = (ISOCurrencyCodeEnum)MapperS.of((Object)this.settlementCurrencyRule.evaluate(this.payoutLeg1.evaluate((ReportableEventBase)thenArg.get()))).get();
            return output;
        }
    }
}

