/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.esma.emir.refit.valuation.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.annotations.RosettaReport;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.enrichment.common.reports.ValuationEnrichmentDataRule;
import drr.regulation.common.ValuationReportInstruction;
import drr.regulation.common.valuation.datetime.reports.EventDateRule;
import drr.regulation.common.valuation.datetime.reports.ReportingTimestampRule;
import drr.regulation.common.valuation.datetime.reports.ValuationTimestampRule;
import drr.regulation.common.valuation.event.reports.ActionTypeRule;
import drr.regulation.common.valuation.event.reports.LevelRule;
import drr.regulation.common.valuation.party.reports.Counterparty1Rule;
import drr.regulation.common.valuation.party.reports.Counterparty2IdentifierTypeRule;
import drr.regulation.common.valuation.party.reports.Counterparty2Rule;
import drr.regulation.common.valuation.party.reports.ReportSubmittingEntityIDRule;
import drr.regulation.common.valuation.quantity.reports.DeltaRule;
import drr.regulation.common.valuation.valuation.reports.ValuationAmountRule;
import drr.regulation.common.valuation.valuation.reports.ValuationCurrencyRule;
import drr.regulation.common.valuation.valuation.reports.ValuationMethodRule;
import drr.regulation.esma.emir.refit.valuation.ESMAValuationReport;
import drr.regulation.esma.emir.refit.valuation.labels.ESMAEMIRValuationLabelProvider;
import drr.regulation.esma.emir.refit.valuation.reports.EntityResponsibleForReportingRule;
import drr.regulation.esma.emir.refit.valuation.reports.UniqueTransactionIdentifierRule;
import drr.regulation.esma.emir.refit.valuation.reports.UtiProprietaryRule;
import java.util.Optional;
import javax.inject.Inject;

@RosettaReport(namespace="drr.regulation.esma.emir.refit.valuation", body="ESMA", corpusList={"EMIR", "Valuation"})
@RuneLabelProvider(labelProvider=ESMAEMIRValuationLabelProvider.class)
@ImplementedBy(value=ESMAEMIRValuationReportFunctionDefault.class)
public abstract class ESMAEMIRValuationReportFunction
implements ReportFunction<ValuationReportInstruction, ESMAValuationReport> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ActionTypeRule actionTypeRule;
    @Inject
    protected Counterparty1Rule counterparty1Rule;
    @Inject
    protected Counterparty2IdentifierTypeRule counterparty2IdentifierTypeRule;
    @Inject
    protected Counterparty2Rule counterparty2Rule;
    @Inject
    protected DeltaRule deltaRule;
    @Inject
    protected EntityResponsibleForReportingRule entityResponsibleForReportingRule;
    @Inject
    protected EventDateRule eventDateRule;
    @Inject
    protected LevelRule levelRule;
    @Inject
    protected ReportSubmittingEntityIDRule reportSubmittingEntityIDRule;
    @Inject
    protected ReportingTimestampRule reportingTimestampRule;
    @Inject
    protected UniqueTransactionIdentifierRule uniqueTransactionIdentifierRule;
    @Inject
    protected UtiProprietaryRule utiProprietaryRule;
    @Inject
    protected ValuationAmountRule valuationAmountRule;
    @Inject
    protected ValuationCurrencyRule valuationCurrencyRule;
    @Inject
    protected ValuationEnrichmentDataRule valuationEnrichmentDataRule;
    @Inject
    protected ValuationMethodRule valuationMethodRule;
    @Inject
    protected ValuationTimestampRule valuationTimestampRule;

    public ESMAValuationReport evaluate(ValuationReportInstruction input) {
        ESMAValuationReport output;
        ESMAValuationReport.ESMAValuationReportBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(ESMAValuationReport.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract ESMAValuationReport.ESMAValuationReportBuilder doEvaluate(ValuationReportInstruction var1);

    public static class ESMAEMIRValuationReportFunctionDefault
    extends ESMAEMIRValuationReportFunction {
        @Override
        protected ESMAValuationReport.ESMAValuationReportBuilder doEvaluate(ValuationReportInstruction input) {
            ESMAValuationReport.ESMAValuationReportBuilder output = ESMAValuationReport.builder();
            return this.assignOutput(output, input);
        }

        protected ESMAValuationReport.ESMAValuationReportBuilder assignOutput(ESMAValuationReport.ESMAValuationReportBuilder output, ValuationReportInstruction input) {
            output.setReportingTimestamp(this.reportingTimestampRule.evaluate(input));
            output.setCounterparty1(this.counterparty1Rule.evaluate(input));
            output.setCounterparty2IdentifierType(this.counterparty2IdentifierTypeRule.evaluate(input));
            output.setCounterparty2(this.counterparty2Rule.evaluate(input));
            output.setValuationAmount(this.valuationAmountRule.evaluate(input));
            output.setValuationCurrency(this.valuationCurrencyRule.evaluate(input));
            output.setValuationTimestamp(this.valuationTimestampRule.evaluate(input));
            output.setValuationMethod(this.valuationMethodRule.evaluate(input));
            output.setDelta(this.deltaRule.evaluate(input));
            output.setActionType(this.actionTypeRule.evaluate(input));
            output.setLevelOverriddenAsReportLevelEnum(this.levelRule.evaluate(input));
            output.setReportSubmittingEntityID(this.reportSubmittingEntityIDRule.evaluate(input));
            output.setEntityResponsibleForReporting(this.entityResponsibleForReportingRule.evaluate(input));
            output.setUniqueTransactionIdentifier(this.uniqueTransactionIdentifierRule.evaluate(input));
            output.setUniqueTransactionIdentifierProprietary(this.utiProprietaryRule.evaluate(input));
            output.setEventDateOverriddenAsDate(this.eventDateRule.evaluate(input));
            output.getOrCreateNonReportable().setEnrichment(this.valuationEnrichmentDataRule.evaluate(input));
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

