/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.esma.emir.refit.valuation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.emir.functions.Level_01_Validation;
import drr.regulation.esma.emir.refit.valuation.ESMAValuationReport;
import drr.standards.iso.ReportLevelEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@RosettaDataRule(value="ESMAValuationReportEMIR_VR_2154_01")
@ImplementedBy(value=Default.class)
public interface ESMAValuationReportEMIR_VR_2154_01
extends Validator<ESMAValuationReport> {
    public static final String NAME = "ESMAValuationReportEMIR_VR_2154_01";
    public static final String DEFINITION = "Level_01_Validation(level)";

    public static class NoOp
    implements ESMAValuationReportEMIR_VR_2154_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAValuationReport eSMAValuationReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ESMAValuationReportEMIR_VR_2154_01 {
        @Inject
        protected Level_01_Validation level_01_Validation;

        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAValuationReport eSMAValuationReport) {
            ComparisonResult result = this.executeDataRule(eSMAValuationReport);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ESMAValuationReportEMIR_VR_2154_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ESMAValuationReport", (RosettaPath)path, (String)ESMAValuationReportEMIR_VR_2154_01.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ESMAValuationReportEMIR_VR_2154_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ESMAValuationReport", (RosettaPath)path, (String)ESMAValuationReportEMIR_VR_2154_01.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ESMAValuationReport eSMAValuationReport) {
            try {
                return ComparisonResult.of((Mapper)MapperS.of((Object)this.level_01_Validation.evaluate((ReportLevelEnum)((Object)MapperS.of((Object)eSMAValuationReport).map("getLevel", _eSMAValuationReport -> _eSMAValuationReport.getLevel()).get()))));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

