/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.mas.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.mas.rewrite.trade.MASTransactionReport;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.EventTypeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="MASTransactionReportDTCC_MAS_BR_0012_01")
@ImplementedBy(value=Default.class)
public interface MASTransactionReportDTCC_MAS_BR_0012_01
extends Validator<MASTransactionReport> {
    public static final String NAME = "MASTransactionReportDTCC_MAS_BR_0012_01";
    public static final String DEFINITION = "(if actionType = ActionTypeEnum -> NEWT and eventType = EventTypeEnum -> ALOC then required choice priorUTI, priorUTIProprietary else True) and priorUTI <> uniqueTransactionIdentifier and priorUTIProprietary <> uniqueTransactionIdentifierProprietary";

    public static class NoOp
    implements MASTransactionReportDTCC_MAS_BR_0012_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements MASTransactionReportDTCC_MAS_BR_0012_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
            ComparisonResult result = this.executeDataRule(mASTransactionReport);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)MASTransactionReportDTCC_MAS_BR_0012_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"MASTransactionReport", (RosettaPath)path, (String)MASTransactionReportDTCC_MAS_BR_0012_01.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)MASTransactionReportDTCC_MAS_BR_0012_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"MASTransactionReport", (RosettaPath)path, (String)MASTransactionReportDTCC_MAS_BR_0012_01.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(MASTransactionReport mASTransactionReport) {
            try {
                ComparisonResult ifThenElseResult = ExpressionOperators.areEqual((Mapper)MapperS.of((Object)mASTransactionReport).map("getActionType", _mASTransactionReport -> _mASTransactionReport.getActionType()), (Mapper)MapperS.of((Object)((Object)ActionTypeEnum.NEWT)), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)mASTransactionReport).map("getEventType", _mASTransactionReport -> _mASTransactionReport.getEventType()), (Mapper)MapperS.of((Object)((Object)EventTypeEnum.ALOC)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)) != false ? ExpressionOperators.choice((Mapper)MapperS.of((Object)mASTransactionReport), Arrays.asList("priorUTI", "priorUTIProprietary"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED) : ComparisonResult.of((Mapper)MapperS.of((Object)true));
                return ifThenElseResult.and(ExpressionOperators.notEqual((Mapper)MapperS.of((Object)mASTransactionReport).map("getPriorUTI", _mASTransactionReport -> _mASTransactionReport.getPriorUTI()), (Mapper)MapperS.of((Object)mASTransactionReport).map("getUniqueTransactionIdentifier", _mASTransactionReport -> _mASTransactionReport.getUniqueTransactionIdentifier()), (CardinalityOperator)CardinalityOperator.Any)).and(ExpressionOperators.notEqual((Mapper)MapperS.of((Object)mASTransactionReport).map("getPriorUTIProprietary", _mASTransactionReport -> _mASTransactionReport.getPriorUTIProprietary()), (Mapper)MapperS.of((Object)mASTransactionReport).map("getUniqueTransactionIdentifierProprietary", _mASTransactionReport -> _mASTransactionReport.getUniqueTransactionIdentifierProprietary()), (CardinalityOperator)CardinalityOperator.Any));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

