/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.sec.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.price.PriceFormat;
import drr.base.trade.price.functions.PriceFormatFromNotation;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.reports.PayoutLeg2Rule;
import drr.regulation.sec.rewrite.trade.functions.IsAllowableActionForSEC;
import drr.regulation.sec.rewrite.trade.reports.SpreadNotationLeg2Rule;
import drr.standards.iosco.cde.version2.price.reports.SpreadValueRule;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=SpreadAmountLeg2RuleDefault.class)
public abstract class SpreadAmountLeg2Rule
implements ReportFunction<TransactionReportInstruction, PriceFormat> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected IsAllowableActionForSEC isAllowableActionForSEC;
    @Inject
    protected PayoutLeg2Rule payoutLeg2Rule;
    @Inject
    protected PriceFormatFromNotation priceFormatFromNotation;
    @Inject
    protected SpreadNotationLeg2Rule spreadNotationLeg2Rule;
    @Inject
    protected SpreadValueRule spreadValueRule;

    public PriceFormat evaluate(TransactionReportInstruction input) {
        PriceFormat output;
        PriceFormat.PriceFormatBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(PriceFormat.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract PriceFormat.PriceFormatBuilder doEvaluate(TransactionReportInstruction var1);

    public static class SpreadAmountLeg2RuleDefault
    extends SpreadAmountLeg2Rule {
        @Override
        protected PriceFormat.PriceFormatBuilder doEvaluate(TransactionReportInstruction input) {
            PriceFormat.PriceFormatBuilder output = PriceFormat.builder();
            return this.assignOutput(output, input);
        }

        protected PriceFormat.PriceFormatBuilder assignOutput(PriceFormat.PriceFormatBuilder output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForSEC.evaluate((ReportableEventBase)item.get()));
            output = (PriceFormat.PriceFormatBuilder)this.toBuilder((RosettaModelObject)thenArg.mapSingleToItem(item -> MapperS.of((Object)this.priceFormatFromNotation.evaluate(this.spreadValueRule.evaluate(this.payoutLeg2Rule.evaluate((ReportableEventBase)item.get())), this.spreadNotationLeg2Rule.evaluate((TransactionReportInstruction)item.get())))).get());
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

