/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1;

import cdm.base.staticdata.asset.common.ISOCountryCodeEnum;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import drr.base.trade.basket.BasketConstituentsReport;
import drr.base.trade.payment.OtherPayment;
import drr.base.trade.price.PriceFormat;
import drr.base.trade.price.PriceNotationEnum;
import drr.base.trade.price.PricePeriod;
import drr.standards.iosco.cde.version1.LegV1;
import drr.standards.iosco.cde.version1.meta.CriticalDataElementV1Meta;
import drr.standards.iso.ClearedEnum;
import drr.standards.iso.ConfirmationEnum;
import drr.standards.iso.Direction1Enum;
import drr.standards.iso.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CriticalDataElementV1", builder=CriticalDataElementV1BuilderImpl.class, version="7.0.0-dev.66")
@RuneDataType(value="CriticalDataElementV1", model="drr", builder=CriticalDataElementV1BuilderImpl.class, version="7.0.0-dev.66")
public interface CriticalDataElementV1
extends RosettaModelObject {
    public static final CriticalDataElementV1Meta metaData = new CriticalDataElementV1Meta();

    public Date getEffectiveDate();

    public Date getEarlyTerminationDate();

    public ZonedDateTime getReportingTimestamp();

    public ZonedDateTime getExecutionTimestamp();

    public Date getExpirationDate();

    public String getCounterparty1();

    public String getCounterparty2();

    public Boolean getCounterparty2IdentifierType();

    public String getBeneficiary1();

    public Boolean getBeneficiary1IdentifierTypeIndicator();

    public String getBuyerIdentifier();

    public String getSellerIdentifier();

    public ClearedEnum getCleared();

    public String getCentralCounterparty();

    public String getClearingMember();

    public ConfirmationEnum getConfirmed();

    public BigDecimal getCallAmount();

    public BigDecimal getPutAmount();

    public ISOCurrencyCodeEnum getCallCurrency();

    public ISOCurrencyCodeEnum getPutCurrency();

    public BigDecimal getDelta();

    public List<? extends PricePeriod> getPriceSchedule();

    public List<? extends PricePeriod> getStrikePriceSchedule();

    public PriceFormat getPrice();

    public PriceNotationEnum getPriceNotation();

    public ISOCurrencyCodeEnum getPriceCurrency();

    public PriceFormat getPackageTransactionPrice();

    public PriceNotationEnum getPackageTransactionPriceNotation();

    public ISOCurrencyCodeEnum getPackageTransactionPriceCurrency();

    public PriceFormat getPackageTransactionSpread();

    public PriceNotationEnum getPackageTransactionSpreadNotation();

    public ISOCurrencyCodeEnum getPackageTransactionSpreadCurrency();

    public String getPackageIdentifier();

    public PriceFormat getStrikePrice();

    public PriceNotationEnum getStrikePriceNotation();

    public String getStrikePriceCurrency();

    public String getPriceUnitOfMeasure();

    public BigDecimal getOptionPremiumAmount();

    public ISOCurrencyCodeEnum getOptionPremiumCurrency();

    public Date getOptionPremiumPaymentDate();

    public BigDecimal getExchangeRate();

    public String getExchangeRateBasis();

    public BigDecimal getCdSIndexAttachmentPoint();

    public BigDecimal getCdSIndexDetachmentPoint();

    public Boolean getCollateralPortfolioIndicator();

    public Date getFirstExerciseDate();

    public Date getFinalContractualSettlementDate();

    public ISOCountryCodeEnum getSettlementLocation();

    public String getPriorUTI();

    public Direction1Enum getDirection1();

    public BigDecimal getValuationAmount();

    public ISOCurrencyCodeEnum getValuationCurrency();

    public ValuationType1Code getValuationMethod();

    public ZonedDateTime getValuationTimestamp();

    public String getCustomBasketCode();

    public List<? extends BasketConstituentsReport> getBasketConstituents();

    public List<? extends OtherPayment> getOtherPayment();

    public LegV1 getLeg1();

    public LegV1 getLeg2();

    public CriticalDataElementV1 build();

    public CriticalDataElementV1Builder toBuilder();

    public static CriticalDataElementV1Builder builder() {
        return new CriticalDataElementV1BuilderImpl();
    }

    default public RosettaMetaData<? extends CriticalDataElementV1> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CriticalDataElementV1> getType() {
        return CriticalDataElementV1.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("earlyTerminationDate"), Date.class, (Object)this.getEarlyTerminationDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, (Object)this.getExecutionTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expirationDate"), Date.class, (Object)this.getExpirationDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("beneficiary1"), String.class, (Object)this.getBeneficiary1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("beneficiary1IdentifierTypeIndicator"), Boolean.class, (Object)this.getBeneficiary1IdentifierTypeIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("buyerIdentifier"), String.class, (Object)this.getBuyerIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("sellerIdentifier"), String.class, (Object)this.getSellerIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cleared"), ClearedEnum.class, (Object)this.getCleared(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("centralCounterparty"), String.class, (Object)this.getCentralCounterparty(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingMember"), String.class, (Object)this.getClearingMember(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("confirmed"), ConfirmationEnum.class, (Object)this.getConfirmed(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, (Object)this.getCallAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, (Object)this.getPutAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getCallCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPutCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("priceSchedule"), processor, PricePeriod.class, this.getPriceSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strikePriceSchedule"), processor, PricePeriod.class, this.getStrikePriceSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("price"), processor, PriceFormat.class, this.getPrice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priceNotation"), PriceNotationEnum.class, (Object)this.getPriceNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priceCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPriceCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("packageTransactionPrice"), processor, PriceFormat.class, this.getPackageTransactionPrice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), PriceNotationEnum.class, (Object)this.getPackageTransactionPriceNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageTransactionPriceCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPackageTransactionPriceCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("packageTransactionSpread"), processor, PriceFormat.class, this.getPackageTransactionSpread(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageTransactionSpreadNotation"), PriceNotationEnum.class, (Object)this.getPackageTransactionSpreadNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageTransactionSpreadCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPackageTransactionSpreadCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageIdentifier"), String.class, (Object)this.getPackageIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strikePrice"), processor, PriceFormat.class, this.getStrikePrice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("strikePriceNotation"), PriceNotationEnum.class, (Object)this.getStrikePriceNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("strikePriceCurrency"), String.class, (Object)this.getStrikePriceCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, (Object)this.getPriceUnitOfMeasure(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, (Object)this.getOptionPremiumAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getOptionPremiumCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, (Object)this.getOptionPremiumPaymentDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, (Object)this.getExchangeRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, (Object)this.getExchangeRateBasis(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, (Object)this.getCdSIndexAttachmentPoint(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, (Object)this.getCdSIndexDetachmentPoint(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, (Object)this.getCollateralPortfolioIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, (Object)this.getFirstExerciseDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, (Object)this.getFinalContractualSettlementDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementLocation"), ISOCountryCodeEnum.class, (Object)this.getSettlementLocation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priorUTI"), String.class, (Object)this.getPriorUTI(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("direction1"), Direction1Enum.class, (Object)this.getDirection1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("customBasketCode"), String.class, (Object)this.getCustomBasketCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.class, this.getBasketConstituents(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("otherPayment"), processor, OtherPayment.class, this.getOtherPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("leg1"), processor, LegV1.class, this.getLeg1(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("leg2"), processor, LegV1.class, this.getLeg2(), new AttributeMeta[0]);
    }

    public static class CriticalDataElementV1BuilderImpl
    implements CriticalDataElementV1Builder {
        protected Date effectiveDate;
        protected Date earlyTerminationDate;
        protected ZonedDateTime reportingTimestamp;
        protected ZonedDateTime executionTimestamp;
        protected Date expirationDate;
        protected String counterparty1;
        protected String counterparty2;
        protected Boolean counterparty2IdentifierType;
        protected String beneficiary1;
        protected Boolean beneficiary1IdentifierTypeIndicator;
        protected String buyerIdentifier;
        protected String sellerIdentifier;
        protected ClearedEnum cleared;
        protected String centralCounterparty;
        protected String clearingMember;
        protected ConfirmationEnum confirmed;
        protected BigDecimal callAmount;
        protected BigDecimal putAmount;
        protected ISOCurrencyCodeEnum callCurrency;
        protected ISOCurrencyCodeEnum putCurrency;
        protected BigDecimal delta;
        protected List<PricePeriod.PricePeriodBuilder> priceSchedule = new ArrayList<PricePeriod.PricePeriodBuilder>();
        protected List<PricePeriod.PricePeriodBuilder> strikePriceSchedule = new ArrayList<PricePeriod.PricePeriodBuilder>();
        protected PriceFormat.PriceFormatBuilder price;
        protected PriceNotationEnum priceNotation;
        protected ISOCurrencyCodeEnum priceCurrency;
        protected PriceFormat.PriceFormatBuilder packageTransactionPrice;
        protected PriceNotationEnum packageTransactionPriceNotation;
        protected ISOCurrencyCodeEnum packageTransactionPriceCurrency;
        protected PriceFormat.PriceFormatBuilder packageTransactionSpread;
        protected PriceNotationEnum packageTransactionSpreadNotation;
        protected ISOCurrencyCodeEnum packageTransactionSpreadCurrency;
        protected String packageIdentifier;
        protected PriceFormat.PriceFormatBuilder strikePrice;
        protected PriceNotationEnum strikePriceNotation;
        protected String strikePriceCurrency;
        protected String priceUnitOfMeasure;
        protected BigDecimal optionPremiumAmount;
        protected ISOCurrencyCodeEnum optionPremiumCurrency;
        protected Date optionPremiumPaymentDate;
        protected BigDecimal exchangeRate;
        protected String exchangeRateBasis;
        protected BigDecimal cdSIndexAttachmentPoint;
        protected BigDecimal cdSIndexDetachmentPoint;
        protected Boolean collateralPortfolioIndicator;
        protected Date firstExerciseDate;
        protected Date finalContractualSettlementDate;
        protected ISOCountryCodeEnum settlementLocation;
        protected String priorUTI;
        protected Direction1Enum direction1;
        protected BigDecimal valuationAmount;
        protected ISOCurrencyCodeEnum valuationCurrency;
        protected ValuationType1Code valuationMethod;
        protected ZonedDateTime valuationTimestamp;
        protected String customBasketCode;
        protected List<BasketConstituentsReport.BasketConstituentsReportBuilder> basketConstituents = new ArrayList<BasketConstituentsReport.BasketConstituentsReportBuilder>();
        protected List<OtherPayment.OtherPaymentBuilder> otherPayment = new ArrayList<OtherPayment.OtherPaymentBuilder>();
        protected LegV1.LegV1Builder leg1;
        protected LegV1.LegV1Builder leg2;

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public Date getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="earlyTerminationDate")
        @RuneAttribute(value="earlyTerminationDate")
        public Date getEarlyTerminationDate() {
            return this.earlyTerminationDate;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public ZonedDateTime getReportingTimestamp() {
            return this.reportingTimestamp;
        }

        @Override
        @RosettaAttribute(value="executionTimestamp")
        @RuneAttribute(value="executionTimestamp")
        public ZonedDateTime getExecutionTimestamp() {
            return this.executionTimestamp;
        }

        @Override
        @RosettaAttribute(value="expirationDate")
        @RuneAttribute(value="expirationDate")
        public Date getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public String getCounterparty1() {
            return this.counterparty1;
        }

        @Override
        @RosettaAttribute(value="counterparty2")
        @RuneAttribute(value="counterparty2")
        public String getCounterparty2() {
            return this.counterparty2;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType")
        @RuneAttribute(value="counterparty2IdentifierType")
        public Boolean getCounterparty2IdentifierType() {
            return this.counterparty2IdentifierType;
        }

        @Override
        @RosettaAttribute(value="beneficiary1")
        @RuneAttribute(value="beneficiary1")
        public String getBeneficiary1() {
            return this.beneficiary1;
        }

        @Override
        @RosettaAttribute(value="beneficiary1IdentifierTypeIndicator")
        @RuneAttribute(value="beneficiary1IdentifierTypeIndicator")
        public Boolean getBeneficiary1IdentifierTypeIndicator() {
            return this.beneficiary1IdentifierTypeIndicator;
        }

        @Override
        @RosettaAttribute(value="buyerIdentifier")
        @RuneAttribute(value="buyerIdentifier")
        public String getBuyerIdentifier() {
            return this.buyerIdentifier;
        }

        @Override
        @RosettaAttribute(value="sellerIdentifier")
        @RuneAttribute(value="sellerIdentifier")
        public String getSellerIdentifier() {
            return this.sellerIdentifier;
        }

        @Override
        @RosettaAttribute(value="cleared")
        @RuneAttribute(value="cleared")
        public ClearedEnum getCleared() {
            return this.cleared;
        }

        @Override
        @RosettaAttribute(value="centralCounterparty")
        @RuneAttribute(value="centralCounterparty")
        public String getCentralCounterparty() {
            return this.centralCounterparty;
        }

        @Override
        @RosettaAttribute(value="clearingMember")
        @RuneAttribute(value="clearingMember")
        public String getClearingMember() {
            return this.clearingMember;
        }

        @Override
        @RosettaAttribute(value="confirmed")
        @RuneAttribute(value="confirmed")
        public ConfirmationEnum getConfirmed() {
            return this.confirmed;
        }

        @Override
        @RosettaAttribute(value="callAmount")
        @RuneAttribute(value="callAmount")
        public BigDecimal getCallAmount() {
            return this.callAmount;
        }

        @Override
        @RosettaAttribute(value="putAmount")
        @RuneAttribute(value="putAmount")
        public BigDecimal getPutAmount() {
            return this.putAmount;
        }

        @Override
        @RosettaAttribute(value="callCurrency")
        @RuneAttribute(value="callCurrency")
        public ISOCurrencyCodeEnum getCallCurrency() {
            return this.callCurrency;
        }

        @Override
        @RosettaAttribute(value="putCurrency")
        @RuneAttribute(value="putCurrency")
        public ISOCurrencyCodeEnum getPutCurrency() {
            return this.putCurrency;
        }

        @Override
        @RosettaAttribute(value="delta")
        @RuneAttribute(value="delta")
        public BigDecimal getDelta() {
            return this.delta;
        }

        @Override
        @RosettaAttribute(value="priceSchedule")
        @RuneAttribute(value="priceSchedule")
        public List<? extends PricePeriod.PricePeriodBuilder> getPriceSchedule() {
            return this.priceSchedule;
        }

        @Override
        public PricePeriod.PricePeriodBuilder getOrCreatePriceSchedule(int index) {
            if (this.priceSchedule == null) {
                this.priceSchedule = new ArrayList<PricePeriod.PricePeriodBuilder>();
            }
            return (PricePeriod.PricePeriodBuilder)this.getIndex(this.priceSchedule, index, () -> {
                PricePeriod.PricePeriodBuilder newPriceSchedule = PricePeriod.builder();
                return newPriceSchedule;
            });
        }

        @Override
        @RosettaAttribute(value="strikePriceSchedule")
        @RuneAttribute(value="strikePriceSchedule")
        public List<? extends PricePeriod.PricePeriodBuilder> getStrikePriceSchedule() {
            return this.strikePriceSchedule;
        }

        @Override
        public PricePeriod.PricePeriodBuilder getOrCreateStrikePriceSchedule(int index) {
            if (this.strikePriceSchedule == null) {
                this.strikePriceSchedule = new ArrayList<PricePeriod.PricePeriodBuilder>();
            }
            return (PricePeriod.PricePeriodBuilder)this.getIndex(this.strikePriceSchedule, index, () -> {
                PricePeriod.PricePeriodBuilder newStrikePriceSchedule = PricePeriod.builder();
                return newStrikePriceSchedule;
            });
        }

        @Override
        @RosettaAttribute(value="price")
        @RuneAttribute(value="price")
        public PriceFormat.PriceFormatBuilder getPrice() {
            return this.price;
        }

        @Override
        public PriceFormat.PriceFormatBuilder getOrCreatePrice() {
            PriceFormat.PriceFormatBuilder result = this.price != null ? this.price : (this.price = PriceFormat.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="priceNotation")
        @RuneAttribute(value="priceNotation")
        public PriceNotationEnum getPriceNotation() {
            return this.priceNotation;
        }

        @Override
        @RosettaAttribute(value="priceCurrency")
        @RuneAttribute(value="priceCurrency")
        public ISOCurrencyCodeEnum getPriceCurrency() {
            return this.priceCurrency;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPrice")
        @RuneAttribute(value="packageTransactionPrice")
        public PriceFormat.PriceFormatBuilder getPackageTransactionPrice() {
            return this.packageTransactionPrice;
        }

        @Override
        public PriceFormat.PriceFormatBuilder getOrCreatePackageTransactionPrice() {
            PriceFormat.PriceFormatBuilder result = this.packageTransactionPrice != null ? this.packageTransactionPrice : (this.packageTransactionPrice = PriceFormat.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPriceNotation")
        @RuneAttribute(value="packageTransactionPriceNotation")
        public PriceNotationEnum getPackageTransactionPriceNotation() {
            return this.packageTransactionPriceNotation;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPriceCurrency")
        @RuneAttribute(value="packageTransactionPriceCurrency")
        public ISOCurrencyCodeEnum getPackageTransactionPriceCurrency() {
            return this.packageTransactionPriceCurrency;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpread")
        @RuneAttribute(value="packageTransactionSpread")
        public PriceFormat.PriceFormatBuilder getPackageTransactionSpread() {
            return this.packageTransactionSpread;
        }

        @Override
        public PriceFormat.PriceFormatBuilder getOrCreatePackageTransactionSpread() {
            PriceFormat.PriceFormatBuilder result = this.packageTransactionSpread != null ? this.packageTransactionSpread : (this.packageTransactionSpread = PriceFormat.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpreadNotation")
        @RuneAttribute(value="packageTransactionSpreadNotation")
        public PriceNotationEnum getPackageTransactionSpreadNotation() {
            return this.packageTransactionSpreadNotation;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpreadCurrency")
        @RuneAttribute(value="packageTransactionSpreadCurrency")
        public ISOCurrencyCodeEnum getPackageTransactionSpreadCurrency() {
            return this.packageTransactionSpreadCurrency;
        }

        @Override
        @RosettaAttribute(value="packageIdentifier")
        @RuneAttribute(value="packageIdentifier")
        public String getPackageIdentifier() {
            return this.packageIdentifier;
        }

        @Override
        @RosettaAttribute(value="strikePrice")
        @RuneAttribute(value="strikePrice")
        public PriceFormat.PriceFormatBuilder getStrikePrice() {
            return this.strikePrice;
        }

        @Override
        public PriceFormat.PriceFormatBuilder getOrCreateStrikePrice() {
            PriceFormat.PriceFormatBuilder result = this.strikePrice != null ? this.strikePrice : (this.strikePrice = PriceFormat.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="strikePriceNotation")
        @RuneAttribute(value="strikePriceNotation")
        public PriceNotationEnum getStrikePriceNotation() {
            return this.strikePriceNotation;
        }

        @Override
        @RosettaAttribute(value="strikePriceCurrency")
        @RuneAttribute(value="strikePriceCurrency")
        public String getStrikePriceCurrency() {
            return this.strikePriceCurrency;
        }

        @Override
        @RosettaAttribute(value="priceUnitOfMeasure")
        @RuneAttribute(value="priceUnitOfMeasure")
        public String getPriceUnitOfMeasure() {
            return this.priceUnitOfMeasure;
        }

        @Override
        @RosettaAttribute(value="optionPremiumAmount")
        @RuneAttribute(value="optionPremiumAmount")
        public BigDecimal getOptionPremiumAmount() {
            return this.optionPremiumAmount;
        }

        @Override
        @RosettaAttribute(value="optionPremiumCurrency")
        @RuneAttribute(value="optionPremiumCurrency")
        public ISOCurrencyCodeEnum getOptionPremiumCurrency() {
            return this.optionPremiumCurrency;
        }

        @Override
        @RosettaAttribute(value="optionPremiumPaymentDate")
        @RuneAttribute(value="optionPremiumPaymentDate")
        public Date getOptionPremiumPaymentDate() {
            return this.optionPremiumPaymentDate;
        }

        @Override
        @RosettaAttribute(value="exchangeRate")
        @RuneAttribute(value="exchangeRate")
        public BigDecimal getExchangeRate() {
            return this.exchangeRate;
        }

        @Override
        @RosettaAttribute(value="exchangeRateBasis")
        @RuneAttribute(value="exchangeRateBasis")
        public String getExchangeRateBasis() {
            return this.exchangeRateBasis;
        }

        @Override
        @RosettaAttribute(value="cdSIndexAttachmentPoint")
        @RuneAttribute(value="cdSIndexAttachmentPoint")
        public BigDecimal getCdSIndexAttachmentPoint() {
            return this.cdSIndexAttachmentPoint;
        }

        @Override
        @RosettaAttribute(value="cdSIndexDetachmentPoint")
        @RuneAttribute(value="cdSIndexDetachmentPoint")
        public BigDecimal getCdSIndexDetachmentPoint() {
            return this.cdSIndexDetachmentPoint;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioIndicator")
        @RuneAttribute(value="collateralPortfolioIndicator")
        public Boolean getCollateralPortfolioIndicator() {
            return this.collateralPortfolioIndicator;
        }

        @Override
        @RosettaAttribute(value="firstExerciseDate")
        @RuneAttribute(value="firstExerciseDate")
        public Date getFirstExerciseDate() {
            return this.firstExerciseDate;
        }

        @Override
        @RosettaAttribute(value="finalContractualSettlementDate")
        @RuneAttribute(value="finalContractualSettlementDate")
        public Date getFinalContractualSettlementDate() {
            return this.finalContractualSettlementDate;
        }

        @Override
        @RosettaAttribute(value="settlementLocation")
        @RuneAttribute(value="settlementLocation")
        public ISOCountryCodeEnum getSettlementLocation() {
            return this.settlementLocation;
        }

        @Override
        @RosettaAttribute(value="priorUTI")
        @RuneAttribute(value="priorUTI")
        public String getPriorUTI() {
            return this.priorUTI;
        }

        @Override
        @RosettaAttribute(value="direction1")
        @RuneAttribute(value="direction1")
        public Direction1Enum getDirection1() {
            return this.direction1;
        }

        @Override
        @RosettaAttribute(value="valuationAmount")
        @RuneAttribute(value="valuationAmount")
        public BigDecimal getValuationAmount() {
            return this.valuationAmount;
        }

        @Override
        @RosettaAttribute(value="valuationCurrency")
        @RuneAttribute(value="valuationCurrency")
        public ISOCurrencyCodeEnum getValuationCurrency() {
            return this.valuationCurrency;
        }

        @Override
        @RosettaAttribute(value="valuationMethod")
        @RuneAttribute(value="valuationMethod")
        public ValuationType1Code getValuationMethod() {
            return this.valuationMethod;
        }

        @Override
        @RosettaAttribute(value="valuationTimestamp")
        @RuneAttribute(value="valuationTimestamp")
        public ZonedDateTime getValuationTimestamp() {
            return this.valuationTimestamp;
        }

        @Override
        @RosettaAttribute(value="customBasketCode")
        @RuneAttribute(value="customBasketCode")
        public String getCustomBasketCode() {
            return this.customBasketCode;
        }

        @Override
        @RosettaAttribute(value="basketConstituents")
        @RuneAttribute(value="basketConstituents")
        public List<? extends BasketConstituentsReport.BasketConstituentsReportBuilder> getBasketConstituents() {
            return this.basketConstituents;
        }

        @Override
        public BasketConstituentsReport.BasketConstituentsReportBuilder getOrCreateBasketConstituents(int index) {
            if (this.basketConstituents == null) {
                this.basketConstituents = new ArrayList<BasketConstituentsReport.BasketConstituentsReportBuilder>();
            }
            return (BasketConstituentsReport.BasketConstituentsReportBuilder)this.getIndex(this.basketConstituents, index, () -> {
                BasketConstituentsReport.BasketConstituentsReportBuilder newBasketConstituents = BasketConstituentsReport.builder();
                return newBasketConstituents;
            });
        }

        @Override
        @RosettaAttribute(value="otherPayment")
        @RuneAttribute(value="otherPayment")
        public List<? extends OtherPayment.OtherPaymentBuilder> getOtherPayment() {
            return this.otherPayment;
        }

        @Override
        public OtherPayment.OtherPaymentBuilder getOrCreateOtherPayment(int index) {
            if (this.otherPayment == null) {
                this.otherPayment = new ArrayList<OtherPayment.OtherPaymentBuilder>();
            }
            return (OtherPayment.OtherPaymentBuilder)this.getIndex(this.otherPayment, index, () -> {
                OtherPayment.OtherPaymentBuilder newOtherPayment = OtherPayment.builder();
                return newOtherPayment;
            });
        }

        @Override
        @RosettaAttribute(value="leg1")
        @RuneAttribute(value="leg1")
        public LegV1.LegV1Builder getLeg1() {
            return this.leg1;
        }

        @Override
        public LegV1.LegV1Builder getOrCreateLeg1() {
            LegV1.LegV1Builder result = this.leg1 != null ? this.leg1 : (this.leg1 = LegV1.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="leg2")
        @RuneAttribute(value="leg2")
        public LegV1.LegV1Builder getLeg2() {
            return this.leg2;
        }

        @Override
        public LegV1.LegV1Builder getOrCreateLeg2() {
            LegV1.LegV1Builder result = this.leg2 != null ? this.leg2 : (this.leg2 = LegV1.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public CriticalDataElementV1Builder setEffectiveDate(Date _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="earlyTerminationDate")
        @RuneAttribute(value="earlyTerminationDate")
        public CriticalDataElementV1Builder setEarlyTerminationDate(Date _earlyTerminationDate) {
            this.earlyTerminationDate = _earlyTerminationDate == null ? null : _earlyTerminationDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public CriticalDataElementV1Builder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
            this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionTimestamp")
        @RuneAttribute(value="executionTimestamp")
        public CriticalDataElementV1Builder setExecutionTimestamp(ZonedDateTime _executionTimestamp) {
            this.executionTimestamp = _executionTimestamp == null ? null : _executionTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="expirationDate")
        @RuneAttribute(value="expirationDate")
        public CriticalDataElementV1Builder setExpirationDate(Date _expirationDate) {
            this.expirationDate = _expirationDate == null ? null : _expirationDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public CriticalDataElementV1Builder setCounterparty1(String _counterparty1) {
            this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2")
        @RuneAttribute(value="counterparty2")
        public CriticalDataElementV1Builder setCounterparty2(String _counterparty2) {
            this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType")
        @RuneAttribute(value="counterparty2IdentifierType")
        public CriticalDataElementV1Builder setCounterparty2IdentifierType(Boolean _counterparty2IdentifierType) {
            this.counterparty2IdentifierType = _counterparty2IdentifierType == null ? null : _counterparty2IdentifierType;
            return this;
        }

        @Override
        @RosettaAttribute(value="beneficiary1")
        @RuneAttribute(value="beneficiary1")
        public CriticalDataElementV1Builder setBeneficiary1(String _beneficiary1) {
            this.beneficiary1 = _beneficiary1 == null ? null : _beneficiary1;
            return this;
        }

        @Override
        @RosettaAttribute(value="beneficiary1IdentifierTypeIndicator")
        @RuneAttribute(value="beneficiary1IdentifierTypeIndicator")
        public CriticalDataElementV1Builder setBeneficiary1IdentifierTypeIndicator(Boolean _beneficiary1IdentifierTypeIndicator) {
            this.beneficiary1IdentifierTypeIndicator = _beneficiary1IdentifierTypeIndicator == null ? null : _beneficiary1IdentifierTypeIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="buyerIdentifier")
        @RuneAttribute(value="buyerIdentifier")
        public CriticalDataElementV1Builder setBuyerIdentifier(String _buyerIdentifier) {
            this.buyerIdentifier = _buyerIdentifier == null ? null : _buyerIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="sellerIdentifier")
        @RuneAttribute(value="sellerIdentifier")
        public CriticalDataElementV1Builder setSellerIdentifier(String _sellerIdentifier) {
            this.sellerIdentifier = _sellerIdentifier == null ? null : _sellerIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="cleared")
        @RuneAttribute(value="cleared")
        public CriticalDataElementV1Builder setCleared(ClearedEnum _cleared) {
            this.cleared = _cleared == null ? null : _cleared;
            return this;
        }

        @Override
        @RosettaAttribute(value="centralCounterparty")
        @RuneAttribute(value="centralCounterparty")
        public CriticalDataElementV1Builder setCentralCounterparty(String _centralCounterparty) {
            this.centralCounterparty = _centralCounterparty == null ? null : _centralCounterparty;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingMember")
        @RuneAttribute(value="clearingMember")
        public CriticalDataElementV1Builder setClearingMember(String _clearingMember) {
            this.clearingMember = _clearingMember == null ? null : _clearingMember;
            return this;
        }

        @Override
        @RosettaAttribute(value="confirmed")
        @RuneAttribute(value="confirmed")
        public CriticalDataElementV1Builder setConfirmed(ConfirmationEnum _confirmed) {
            this.confirmed = _confirmed == null ? null : _confirmed;
            return this;
        }

        @Override
        @RosettaAttribute(value="callAmount")
        @RuneAttribute(value="callAmount")
        public CriticalDataElementV1Builder setCallAmount(BigDecimal _callAmount) {
            this.callAmount = _callAmount == null ? null : _callAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="putAmount")
        @RuneAttribute(value="putAmount")
        public CriticalDataElementV1Builder setPutAmount(BigDecimal _putAmount) {
            this.putAmount = _putAmount == null ? null : _putAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="callCurrency")
        @RuneAttribute(value="callCurrency")
        public CriticalDataElementV1Builder setCallCurrency(ISOCurrencyCodeEnum _callCurrency) {
            this.callCurrency = _callCurrency == null ? null : _callCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="putCurrency")
        @RuneAttribute(value="putCurrency")
        public CriticalDataElementV1Builder setPutCurrency(ISOCurrencyCodeEnum _putCurrency) {
            this.putCurrency = _putCurrency == null ? null : _putCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="delta")
        @RuneAttribute(value="delta")
        public CriticalDataElementV1Builder setDelta(BigDecimal _delta) {
            this.delta = _delta == null ? null : _delta;
            return this;
        }

        @Override
        @RosettaAttribute(value="priceSchedule")
        @RuneAttribute(value="priceSchedule")
        public CriticalDataElementV1Builder addPriceSchedule(PricePeriod _priceSchedule) {
            if (_priceSchedule != null) {
                this.priceSchedule.add(_priceSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public CriticalDataElementV1Builder addPriceSchedule(PricePeriod _priceSchedule, int idx) {
            this.getIndex(this.priceSchedule, idx, () -> _priceSchedule.toBuilder());
            return this;
        }

        @Override
        public CriticalDataElementV1Builder addPriceSchedule(List<? extends PricePeriod> priceSchedules) {
            if (priceSchedules != null) {
                for (PricePeriod pricePeriod : priceSchedules) {
                    this.priceSchedule.add(pricePeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="priceSchedule")
        public CriticalDataElementV1Builder setPriceSchedule(List<? extends PricePeriod> priceSchedules) {
            this.priceSchedule = priceSchedules == null ? new ArrayList<PricePeriod.PricePeriodBuilder>() : (List)priceSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePriceSchedule")
        @RuneAttribute(value="strikePriceSchedule")
        public CriticalDataElementV1Builder addStrikePriceSchedule(PricePeriod _strikePriceSchedule) {
            if (_strikePriceSchedule != null) {
                this.strikePriceSchedule.add(_strikePriceSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public CriticalDataElementV1Builder addStrikePriceSchedule(PricePeriod _strikePriceSchedule, int idx) {
            this.getIndex(this.strikePriceSchedule, idx, () -> _strikePriceSchedule.toBuilder());
            return this;
        }

        @Override
        public CriticalDataElementV1Builder addStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedules) {
            if (strikePriceSchedules != null) {
                for (PricePeriod pricePeriod : strikePriceSchedules) {
                    this.strikePriceSchedule.add(pricePeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="strikePriceSchedule")
        public CriticalDataElementV1Builder setStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedules) {
            this.strikePriceSchedule = strikePriceSchedules == null ? new ArrayList<PricePeriod.PricePeriodBuilder>() : (List)strikePriceSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="price")
        @RuneAttribute(value="price")
        public CriticalDataElementV1Builder setPrice(PriceFormat _price) {
            this.price = _price == null ? null : _price.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="priceNotation")
        @RuneAttribute(value="priceNotation")
        public CriticalDataElementV1Builder setPriceNotation(PriceNotationEnum _priceNotation) {
            this.priceNotation = _priceNotation == null ? null : _priceNotation;
            return this;
        }

        @Override
        @RosettaAttribute(value="priceCurrency")
        @RuneAttribute(value="priceCurrency")
        public CriticalDataElementV1Builder setPriceCurrency(ISOCurrencyCodeEnum _priceCurrency) {
            this.priceCurrency = _priceCurrency == null ? null : _priceCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPrice")
        @RuneAttribute(value="packageTransactionPrice")
        public CriticalDataElementV1Builder setPackageTransactionPrice(PriceFormat _packageTransactionPrice) {
            this.packageTransactionPrice = _packageTransactionPrice == null ? null : _packageTransactionPrice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPriceNotation")
        @RuneAttribute(value="packageTransactionPriceNotation")
        public CriticalDataElementV1Builder setPackageTransactionPriceNotation(PriceNotationEnum _packageTransactionPriceNotation) {
            this.packageTransactionPriceNotation = _packageTransactionPriceNotation == null ? null : _packageTransactionPriceNotation;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPriceCurrency")
        @RuneAttribute(value="packageTransactionPriceCurrency")
        public CriticalDataElementV1Builder setPackageTransactionPriceCurrency(ISOCurrencyCodeEnum _packageTransactionPriceCurrency) {
            this.packageTransactionPriceCurrency = _packageTransactionPriceCurrency == null ? null : _packageTransactionPriceCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpread")
        @RuneAttribute(value="packageTransactionSpread")
        public CriticalDataElementV1Builder setPackageTransactionSpread(PriceFormat _packageTransactionSpread) {
            this.packageTransactionSpread = _packageTransactionSpread == null ? null : _packageTransactionSpread.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpreadNotation")
        @RuneAttribute(value="packageTransactionSpreadNotation")
        public CriticalDataElementV1Builder setPackageTransactionSpreadNotation(PriceNotationEnum _packageTransactionSpreadNotation) {
            this.packageTransactionSpreadNotation = _packageTransactionSpreadNotation == null ? null : _packageTransactionSpreadNotation;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpreadCurrency")
        @RuneAttribute(value="packageTransactionSpreadCurrency")
        public CriticalDataElementV1Builder setPackageTransactionSpreadCurrency(ISOCurrencyCodeEnum _packageTransactionSpreadCurrency) {
            this.packageTransactionSpreadCurrency = _packageTransactionSpreadCurrency == null ? null : _packageTransactionSpreadCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageIdentifier")
        @RuneAttribute(value="packageIdentifier")
        public CriticalDataElementV1Builder setPackageIdentifier(String _packageIdentifier) {
            this.packageIdentifier = _packageIdentifier == null ? null : _packageIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePrice")
        @RuneAttribute(value="strikePrice")
        public CriticalDataElementV1Builder setStrikePrice(PriceFormat _strikePrice) {
            this.strikePrice = _strikePrice == null ? null : _strikePrice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePriceNotation")
        @RuneAttribute(value="strikePriceNotation")
        public CriticalDataElementV1Builder setStrikePriceNotation(PriceNotationEnum _strikePriceNotation) {
            this.strikePriceNotation = _strikePriceNotation == null ? null : _strikePriceNotation;
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePriceCurrency")
        @RuneAttribute(value="strikePriceCurrency")
        public CriticalDataElementV1Builder setStrikePriceCurrency(String _strikePriceCurrency) {
            this.strikePriceCurrency = _strikePriceCurrency == null ? null : _strikePriceCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="priceUnitOfMeasure")
        @RuneAttribute(value="priceUnitOfMeasure")
        public CriticalDataElementV1Builder setPriceUnitOfMeasure(String _priceUnitOfMeasure) {
            this.priceUnitOfMeasure = _priceUnitOfMeasure == null ? null : _priceUnitOfMeasure;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionPremiumAmount")
        @RuneAttribute(value="optionPremiumAmount")
        public CriticalDataElementV1Builder setOptionPremiumAmount(BigDecimal _optionPremiumAmount) {
            this.optionPremiumAmount = _optionPremiumAmount == null ? null : _optionPremiumAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionPremiumCurrency")
        @RuneAttribute(value="optionPremiumCurrency")
        public CriticalDataElementV1Builder setOptionPremiumCurrency(ISOCurrencyCodeEnum _optionPremiumCurrency) {
            this.optionPremiumCurrency = _optionPremiumCurrency == null ? null : _optionPremiumCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionPremiumPaymentDate")
        @RuneAttribute(value="optionPremiumPaymentDate")
        public CriticalDataElementV1Builder setOptionPremiumPaymentDate(Date _optionPremiumPaymentDate) {
            this.optionPremiumPaymentDate = _optionPremiumPaymentDate == null ? null : _optionPremiumPaymentDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeRate")
        @RuneAttribute(value="exchangeRate")
        public CriticalDataElementV1Builder setExchangeRate(BigDecimal _exchangeRate) {
            this.exchangeRate = _exchangeRate == null ? null : _exchangeRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeRateBasis")
        @RuneAttribute(value="exchangeRateBasis")
        public CriticalDataElementV1Builder setExchangeRateBasis(String _exchangeRateBasis) {
            this.exchangeRateBasis = _exchangeRateBasis == null ? null : _exchangeRateBasis;
            return this;
        }

        @Override
        @RosettaAttribute(value="cdSIndexAttachmentPoint")
        @RuneAttribute(value="cdSIndexAttachmentPoint")
        public CriticalDataElementV1Builder setCdSIndexAttachmentPoint(BigDecimal _cdSIndexAttachmentPoint) {
            this.cdSIndexAttachmentPoint = _cdSIndexAttachmentPoint == null ? null : _cdSIndexAttachmentPoint;
            return this;
        }

        @Override
        @RosettaAttribute(value="cdSIndexDetachmentPoint")
        @RuneAttribute(value="cdSIndexDetachmentPoint")
        public CriticalDataElementV1Builder setCdSIndexDetachmentPoint(BigDecimal _cdSIndexDetachmentPoint) {
            this.cdSIndexDetachmentPoint = _cdSIndexDetachmentPoint == null ? null : _cdSIndexDetachmentPoint;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioIndicator")
        @RuneAttribute(value="collateralPortfolioIndicator")
        public CriticalDataElementV1Builder setCollateralPortfolioIndicator(Boolean _collateralPortfolioIndicator) {
            this.collateralPortfolioIndicator = _collateralPortfolioIndicator == null ? null : _collateralPortfolioIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="firstExerciseDate")
        @RuneAttribute(value="firstExerciseDate")
        public CriticalDataElementV1Builder setFirstExerciseDate(Date _firstExerciseDate) {
            this.firstExerciseDate = _firstExerciseDate == null ? null : _firstExerciseDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="finalContractualSettlementDate")
        @RuneAttribute(value="finalContractualSettlementDate")
        public CriticalDataElementV1Builder setFinalContractualSettlementDate(Date _finalContractualSettlementDate) {
            this.finalContractualSettlementDate = _finalContractualSettlementDate == null ? null : _finalContractualSettlementDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementLocation")
        @RuneAttribute(value="settlementLocation")
        public CriticalDataElementV1Builder setSettlementLocation(ISOCountryCodeEnum _settlementLocation) {
            this.settlementLocation = _settlementLocation == null ? null : _settlementLocation;
            return this;
        }

        @Override
        @RosettaAttribute(value="priorUTI")
        @RuneAttribute(value="priorUTI")
        public CriticalDataElementV1Builder setPriorUTI(String _priorUTI) {
            this.priorUTI = _priorUTI == null ? null : _priorUTI;
            return this;
        }

        @Override
        @RosettaAttribute(value="direction1")
        @RuneAttribute(value="direction1")
        public CriticalDataElementV1Builder setDirection1(Direction1Enum _direction1) {
            this.direction1 = _direction1 == null ? null : _direction1;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationAmount")
        @RuneAttribute(value="valuationAmount")
        public CriticalDataElementV1Builder setValuationAmount(BigDecimal _valuationAmount) {
            this.valuationAmount = _valuationAmount == null ? null : _valuationAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationCurrency")
        @RuneAttribute(value="valuationCurrency")
        public CriticalDataElementV1Builder setValuationCurrency(ISOCurrencyCodeEnum _valuationCurrency) {
            this.valuationCurrency = _valuationCurrency == null ? null : _valuationCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationMethod")
        @RuneAttribute(value="valuationMethod")
        public CriticalDataElementV1Builder setValuationMethod(ValuationType1Code _valuationMethod) {
            this.valuationMethod = _valuationMethod == null ? null : _valuationMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationTimestamp")
        @RuneAttribute(value="valuationTimestamp")
        public CriticalDataElementV1Builder setValuationTimestamp(ZonedDateTime _valuationTimestamp) {
            this.valuationTimestamp = _valuationTimestamp == null ? null : _valuationTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="customBasketCode")
        @RuneAttribute(value="customBasketCode")
        public CriticalDataElementV1Builder setCustomBasketCode(String _customBasketCode) {
            this.customBasketCode = _customBasketCode == null ? null : _customBasketCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="basketConstituents")
        @RuneAttribute(value="basketConstituents")
        public CriticalDataElementV1Builder addBasketConstituents(BasketConstituentsReport _basketConstituents) {
            if (_basketConstituents != null) {
                this.basketConstituents.add(_basketConstituents.toBuilder());
            }
            return this;
        }

        @Override
        public CriticalDataElementV1Builder addBasketConstituents(BasketConstituentsReport _basketConstituents, int idx) {
            this.getIndex(this.basketConstituents, idx, () -> _basketConstituents.toBuilder());
            return this;
        }

        @Override
        public CriticalDataElementV1Builder addBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
            if (basketConstituentss != null) {
                for (BasketConstituentsReport basketConstituentsReport : basketConstituentss) {
                    this.basketConstituents.add(basketConstituentsReport.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="basketConstituents")
        public CriticalDataElementV1Builder setBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
            this.basketConstituents = basketConstituentss == null ? new ArrayList<BasketConstituentsReport.BasketConstituentsReportBuilder>() : (List)basketConstituentss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="otherPayment")
        @RuneAttribute(value="otherPayment")
        public CriticalDataElementV1Builder addOtherPayment(OtherPayment _otherPayment) {
            if (_otherPayment != null) {
                this.otherPayment.add(_otherPayment.toBuilder());
            }
            return this;
        }

        @Override
        public CriticalDataElementV1Builder addOtherPayment(OtherPayment _otherPayment, int idx) {
            this.getIndex(this.otherPayment, idx, () -> _otherPayment.toBuilder());
            return this;
        }

        @Override
        public CriticalDataElementV1Builder addOtherPayment(List<? extends OtherPayment> otherPayments) {
            if (otherPayments != null) {
                for (OtherPayment otherPayment : otherPayments) {
                    this.otherPayment.add(otherPayment.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="otherPayment")
        public CriticalDataElementV1Builder setOtherPayment(List<? extends OtherPayment> otherPayments) {
            this.otherPayment = otherPayments == null ? new ArrayList<OtherPayment.OtherPaymentBuilder>() : (List)otherPayments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="leg1")
        @RuneAttribute(value="leg1")
        public CriticalDataElementV1Builder setLeg1(LegV1 _leg1) {
            this.leg1 = _leg1 == null ? null : _leg1.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="leg2")
        @RuneAttribute(value="leg2")
        public CriticalDataElementV1Builder setLeg2(LegV1 _leg2) {
            this.leg2 = _leg2 == null ? null : _leg2.toBuilder();
            return this;
        }

        @Override
        public CriticalDataElementV1 build() {
            return new CriticalDataElementV1Impl(this);
        }

        @Override
        public CriticalDataElementV1Builder toBuilder() {
            return this;
        }

        @Override
        public CriticalDataElementV1Builder prune() {
            this.priceSchedule = this.priceSchedule.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.strikePriceSchedule = this.strikePriceSchedule.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.price != null && !this.price.prune().hasData()) {
                this.price = null;
            }
            if (this.packageTransactionPrice != null && !this.packageTransactionPrice.prune().hasData()) {
                this.packageTransactionPrice = null;
            }
            if (this.packageTransactionSpread != null && !this.packageTransactionSpread.prune().hasData()) {
                this.packageTransactionSpread = null;
            }
            if (this.strikePrice != null && !this.strikePrice.prune().hasData()) {
                this.strikePrice = null;
            }
            this.basketConstituents = this.basketConstituents.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.otherPayment = this.otherPayment.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.leg1 != null && !this.leg1.prune().hasData()) {
                this.leg1 = null;
            }
            if (this.leg2 != null && !this.leg2.prune().hasData()) {
                this.leg2 = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getEffectiveDate() != null) {
                return true;
            }
            if (this.getEarlyTerminationDate() != null) {
                return true;
            }
            if (this.getReportingTimestamp() != null) {
                return true;
            }
            if (this.getExecutionTimestamp() != null) {
                return true;
            }
            if (this.getExpirationDate() != null) {
                return true;
            }
            if (this.getCounterparty1() != null) {
                return true;
            }
            if (this.getCounterparty2() != null) {
                return true;
            }
            if (this.getCounterparty2IdentifierType() != null) {
                return true;
            }
            if (this.getBeneficiary1() != null) {
                return true;
            }
            if (this.getBeneficiary1IdentifierTypeIndicator() != null) {
                return true;
            }
            if (this.getBuyerIdentifier() != null) {
                return true;
            }
            if (this.getSellerIdentifier() != null) {
                return true;
            }
            if (this.getCleared() != null) {
                return true;
            }
            if (this.getCentralCounterparty() != null) {
                return true;
            }
            if (this.getClearingMember() != null) {
                return true;
            }
            if (this.getConfirmed() != null) {
                return true;
            }
            if (this.getCallAmount() != null) {
                return true;
            }
            if (this.getPutAmount() != null) {
                return true;
            }
            if (this.getCallCurrency() != null) {
                return true;
            }
            if (this.getPutCurrency() != null) {
                return true;
            }
            if (this.getDelta() != null) {
                return true;
            }
            if (this.getPriceSchedule() != null && this.getPriceSchedule().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getStrikePriceSchedule() != null && this.getStrikePriceSchedule().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getPrice() != null && this.getPrice().hasData()) {
                return true;
            }
            if (this.getPriceNotation() != null) {
                return true;
            }
            if (this.getPriceCurrency() != null) {
                return true;
            }
            if (this.getPackageTransactionPrice() != null && this.getPackageTransactionPrice().hasData()) {
                return true;
            }
            if (this.getPackageTransactionPriceNotation() != null) {
                return true;
            }
            if (this.getPackageTransactionPriceCurrency() != null) {
                return true;
            }
            if (this.getPackageTransactionSpread() != null && this.getPackageTransactionSpread().hasData()) {
                return true;
            }
            if (this.getPackageTransactionSpreadNotation() != null) {
                return true;
            }
            if (this.getPackageTransactionSpreadCurrency() != null) {
                return true;
            }
            if (this.getPackageIdentifier() != null) {
                return true;
            }
            if (this.getStrikePrice() != null && this.getStrikePrice().hasData()) {
                return true;
            }
            if (this.getStrikePriceNotation() != null) {
                return true;
            }
            if (this.getStrikePriceCurrency() != null) {
                return true;
            }
            if (this.getPriceUnitOfMeasure() != null) {
                return true;
            }
            if (this.getOptionPremiumAmount() != null) {
                return true;
            }
            if (this.getOptionPremiumCurrency() != null) {
                return true;
            }
            if (this.getOptionPremiumPaymentDate() != null) {
                return true;
            }
            if (this.getExchangeRate() != null) {
                return true;
            }
            if (this.getExchangeRateBasis() != null) {
                return true;
            }
            if (this.getCdSIndexAttachmentPoint() != null) {
                return true;
            }
            if (this.getCdSIndexDetachmentPoint() != null) {
                return true;
            }
            if (this.getCollateralPortfolioIndicator() != null) {
                return true;
            }
            if (this.getFirstExerciseDate() != null) {
                return true;
            }
            if (this.getFinalContractualSettlementDate() != null) {
                return true;
            }
            if (this.getSettlementLocation() != null) {
                return true;
            }
            if (this.getPriorUTI() != null) {
                return true;
            }
            if (this.getDirection1() != null) {
                return true;
            }
            if (this.getValuationAmount() != null) {
                return true;
            }
            if (this.getValuationCurrency() != null) {
                return true;
            }
            if (this.getValuationMethod() != null) {
                return true;
            }
            if (this.getValuationTimestamp() != null) {
                return true;
            }
            if (this.getCustomBasketCode() != null) {
                return true;
            }
            if (this.getBasketConstituents() != null && this.getBasketConstituents().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getOtherPayment() != null && this.getOtherPayment().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getLeg1() != null && this.getLeg1().hasData()) {
                return true;
            }
            return this.getLeg2() != null && this.getLeg2().hasData();
        }

        public CriticalDataElementV1Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CriticalDataElementV1Builder o = (CriticalDataElementV1Builder)other;
            merger.mergeRosetta(this.getPriceSchedule(), o.getPriceSchedule(), this::getOrCreatePriceSchedule);
            merger.mergeRosetta(this.getStrikePriceSchedule(), o.getStrikePriceSchedule(), this::getOrCreateStrikePriceSchedule);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPrice(), (RosettaModelObjectBuilder)o.getPrice(), this::setPrice);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPackageTransactionPrice(), (RosettaModelObjectBuilder)o.getPackageTransactionPrice(), this::setPackageTransactionPrice);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPackageTransactionSpread(), (RosettaModelObjectBuilder)o.getPackageTransactionSpread(), this::setPackageTransactionSpread);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStrikePrice(), (RosettaModelObjectBuilder)o.getStrikePrice(), this::setStrikePrice);
            merger.mergeRosetta(this.getBasketConstituents(), o.getBasketConstituents(), this::getOrCreateBasketConstituents);
            merger.mergeRosetta(this.getOtherPayment(), o.getOtherPayment(), this::getOrCreateOtherPayment);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLeg1(), (RosettaModelObjectBuilder)o.getLeg1(), this::setLeg1);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLeg2(), (RosettaModelObjectBuilder)o.getLeg2(), this::setLeg2);
            merger.mergeBasic((Object)this.getEffectiveDate(), (Object)o.getEffectiveDate(), this::setEffectiveDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEarlyTerminationDate(), (Object)o.getEarlyTerminationDate(), this::setEarlyTerminationDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReportingTimestamp(), (Object)o.getReportingTimestamp(), this::setReportingTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExecutionTimestamp(), (Object)o.getExecutionTimestamp(), this::setExecutionTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExpirationDate(), (Object)o.getExpirationDate(), this::setExpirationDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty1(), (Object)o.getCounterparty1(), this::setCounterparty1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2(), (Object)o.getCounterparty2(), this::setCounterparty2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2IdentifierType(), (Object)o.getCounterparty2IdentifierType(), this::setCounterparty2IdentifierType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getBeneficiary1(), (Object)o.getBeneficiary1(), this::setBeneficiary1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getBeneficiary1IdentifierTypeIndicator(), (Object)o.getBeneficiary1IdentifierTypeIndicator(), this::setBeneficiary1IdentifierTypeIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getBuyerIdentifier(), (Object)o.getBuyerIdentifier(), this::setBuyerIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSellerIdentifier(), (Object)o.getSellerIdentifier(), this::setSellerIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCleared(), (Object)o.getCleared(), this::setCleared, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCentralCounterparty(), (Object)o.getCentralCounterparty(), this::setCentralCounterparty, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getClearingMember(), (Object)o.getClearingMember(), this::setClearingMember, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getConfirmed(), (Object)o.getConfirmed(), this::setConfirmed, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCallAmount(), (Object)o.getCallAmount(), this::setCallAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPutAmount(), (Object)o.getPutAmount(), this::setPutAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCallCurrency(), (Object)o.getCallCurrency(), this::setCallCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPutCurrency(), (Object)o.getPutCurrency(), this::setPutCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDelta(), (Object)o.getDelta(), this::setDelta, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPriceNotation(), (Object)o.getPriceNotation(), this::setPriceNotation, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPriceCurrency(), (Object)o.getPriceCurrency(), this::setPriceCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPackageTransactionPriceNotation(), (Object)o.getPackageTransactionPriceNotation(), this::setPackageTransactionPriceNotation, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPackageTransactionPriceCurrency(), (Object)o.getPackageTransactionPriceCurrency(), this::setPackageTransactionPriceCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPackageTransactionSpreadNotation(), (Object)o.getPackageTransactionSpreadNotation(), this::setPackageTransactionSpreadNotation, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPackageTransactionSpreadCurrency(), (Object)o.getPackageTransactionSpreadCurrency(), this::setPackageTransactionSpreadCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPackageIdentifier(), (Object)o.getPackageIdentifier(), this::setPackageIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getStrikePriceNotation(), (Object)o.getStrikePriceNotation(), this::setStrikePriceNotation, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getStrikePriceCurrency(), (Object)o.getStrikePriceCurrency(), this::setStrikePriceCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPriceUnitOfMeasure(), (Object)o.getPriceUnitOfMeasure(), this::setPriceUnitOfMeasure, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOptionPremiumAmount(), (Object)o.getOptionPremiumAmount(), this::setOptionPremiumAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOptionPremiumCurrency(), (Object)o.getOptionPremiumCurrency(), this::setOptionPremiumCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOptionPremiumPaymentDate(), (Object)o.getOptionPremiumPaymentDate(), this::setOptionPremiumPaymentDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExchangeRate(), (Object)o.getExchangeRate(), this::setExchangeRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExchangeRateBasis(), (Object)o.getExchangeRateBasis(), this::setExchangeRateBasis, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCdSIndexAttachmentPoint(), (Object)o.getCdSIndexAttachmentPoint(), this::setCdSIndexAttachmentPoint, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCdSIndexDetachmentPoint(), (Object)o.getCdSIndexDetachmentPoint(), this::setCdSIndexDetachmentPoint, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCollateralPortfolioIndicator(), (Object)o.getCollateralPortfolioIndicator(), this::setCollateralPortfolioIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFirstExerciseDate(), (Object)o.getFirstExerciseDate(), this::setFirstExerciseDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFinalContractualSettlementDate(), (Object)o.getFinalContractualSettlementDate(), this::setFinalContractualSettlementDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSettlementLocation(), (Object)o.getSettlementLocation(), this::setSettlementLocation, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPriorUTI(), (Object)o.getPriorUTI(), this::setPriorUTI, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDirection1(), (Object)o.getDirection1(), this::setDirection1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationAmount(), (Object)o.getValuationAmount(), this::setValuationAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationCurrency(), (Object)o.getValuationCurrency(), this::setValuationCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationMethod(), (Object)o.getValuationMethod(), this::setValuationMethod, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationTimestamp(), (Object)o.getValuationTimestamp(), this::setValuationTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCustomBasketCode(), (Object)o.getCustomBasketCode(), this::setCustomBasketCode, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CriticalDataElementV1 _that = this.getType().cast(o);
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.earlyTerminationDate, _that.getEarlyTerminationDate())) {
                return false;
            }
            if (!Objects.equals(this.reportingTimestamp, _that.getReportingTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.executionTimestamp, _that.getExecutionTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.expirationDate, _that.getExpirationDate())) {
                return false;
            }
            if (!Objects.equals(this.counterparty1, _that.getCounterparty1())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2, _that.getCounterparty2())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) {
                return false;
            }
            if (!Objects.equals(this.beneficiary1, _that.getBeneficiary1())) {
                return false;
            }
            if (!Objects.equals(this.beneficiary1IdentifierTypeIndicator, _that.getBeneficiary1IdentifierTypeIndicator())) {
                return false;
            }
            if (!Objects.equals(this.buyerIdentifier, _that.getBuyerIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.sellerIdentifier, _that.getSellerIdentifier())) {
                return false;
            }
            if (!Objects.equals((Object)this.cleared, (Object)_that.getCleared())) {
                return false;
            }
            if (!Objects.equals(this.centralCounterparty, _that.getCentralCounterparty())) {
                return false;
            }
            if (!Objects.equals(this.clearingMember, _that.getClearingMember())) {
                return false;
            }
            if (!Objects.equals((Object)this.confirmed, (Object)_that.getConfirmed())) {
                return false;
            }
            if (!Objects.equals(this.callAmount, _that.getCallAmount())) {
                return false;
            }
            if (!Objects.equals(this.putAmount, _that.getPutAmount())) {
                return false;
            }
            if (!Objects.equals(this.callCurrency, _that.getCallCurrency())) {
                return false;
            }
            if (!Objects.equals(this.putCurrency, _that.getPutCurrency())) {
                return false;
            }
            if (!Objects.equals(this.delta, _that.getDelta())) {
                return false;
            }
            if (!ListEquals.listEquals(this.priceSchedule, _that.getPriceSchedule())) {
                return false;
            }
            if (!ListEquals.listEquals(this.strikePriceSchedule, _that.getStrikePriceSchedule())) {
                return false;
            }
            if (!Objects.equals(this.price, _that.getPrice())) {
                return false;
            }
            if (!Objects.equals((Object)this.priceNotation, (Object)_that.getPriceNotation())) {
                return false;
            }
            if (!Objects.equals(this.priceCurrency, _that.getPriceCurrency())) {
                return false;
            }
            if (!Objects.equals(this.packageTransactionPrice, _that.getPackageTransactionPrice())) {
                return false;
            }
            if (!Objects.equals((Object)this.packageTransactionPriceNotation, (Object)_that.getPackageTransactionPriceNotation())) {
                return false;
            }
            if (!Objects.equals(this.packageTransactionPriceCurrency, _that.getPackageTransactionPriceCurrency())) {
                return false;
            }
            if (!Objects.equals(this.packageTransactionSpread, _that.getPackageTransactionSpread())) {
                return false;
            }
            if (!Objects.equals((Object)this.packageTransactionSpreadNotation, (Object)_that.getPackageTransactionSpreadNotation())) {
                return false;
            }
            if (!Objects.equals(this.packageTransactionSpreadCurrency, _that.getPackageTransactionSpreadCurrency())) {
                return false;
            }
            if (!Objects.equals(this.packageIdentifier, _that.getPackageIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.strikePrice, _that.getStrikePrice())) {
                return false;
            }
            if (!Objects.equals((Object)this.strikePriceNotation, (Object)_that.getStrikePriceNotation())) {
                return false;
            }
            if (!Objects.equals(this.strikePriceCurrency, _that.getStrikePriceCurrency())) {
                return false;
            }
            if (!Objects.equals(this.priceUnitOfMeasure, _that.getPriceUnitOfMeasure())) {
                return false;
            }
            if (!Objects.equals(this.optionPremiumAmount, _that.getOptionPremiumAmount())) {
                return false;
            }
            if (!Objects.equals(this.optionPremiumCurrency, _that.getOptionPremiumCurrency())) {
                return false;
            }
            if (!Objects.equals(this.optionPremiumPaymentDate, _that.getOptionPremiumPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.exchangeRate, _that.getExchangeRate())) {
                return false;
            }
            if (!Objects.equals(this.exchangeRateBasis, _that.getExchangeRateBasis())) {
                return false;
            }
            if (!Objects.equals(this.cdSIndexAttachmentPoint, _that.getCdSIndexAttachmentPoint())) {
                return false;
            }
            if (!Objects.equals(this.cdSIndexDetachmentPoint, _that.getCdSIndexDetachmentPoint())) {
                return false;
            }
            if (!Objects.equals(this.collateralPortfolioIndicator, _that.getCollateralPortfolioIndicator())) {
                return false;
            }
            if (!Objects.equals(this.firstExerciseDate, _that.getFirstExerciseDate())) {
                return false;
            }
            if (!Objects.equals(this.finalContractualSettlementDate, _that.getFinalContractualSettlementDate())) {
                return false;
            }
            if (!Objects.equals(this.settlementLocation, _that.getSettlementLocation())) {
                return false;
            }
            if (!Objects.equals(this.priorUTI, _that.getPriorUTI())) {
                return false;
            }
            if (!Objects.equals((Object)this.direction1, (Object)_that.getDirection1())) {
                return false;
            }
            if (!Objects.equals(this.valuationAmount, _that.getValuationAmount())) {
                return false;
            }
            if (!Objects.equals(this.valuationCurrency, _that.getValuationCurrency())) {
                return false;
            }
            if (!Objects.equals((Object)this.valuationMethod, (Object)_that.getValuationMethod())) {
                return false;
            }
            if (!Objects.equals(this.valuationTimestamp, _that.getValuationTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.customBasketCode, _that.getCustomBasketCode())) {
                return false;
            }
            if (!ListEquals.listEquals(this.basketConstituents, _that.getBasketConstituents())) {
                return false;
            }
            if (!ListEquals.listEquals(this.otherPayment, _that.getOtherPayment())) {
                return false;
            }
            if (!Objects.equals(this.leg1, _that.getLeg1())) {
                return false;
            }
            return Objects.equals(this.leg2, _that.getLeg2());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.earlyTerminationDate != null ? this.earlyTerminationDate.hashCode() : 0);
            _result = 31 * _result + (this.reportingTimestamp != null ? this.reportingTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.executionTimestamp != null ? this.executionTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.expirationDate != null ? this.expirationDate.hashCode() : 0);
            _result = 31 * _result + (this.counterparty1 != null ? this.counterparty1.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2 != null ? this.counterparty2.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2IdentifierType != null ? this.counterparty2IdentifierType.hashCode() : 0);
            _result = 31 * _result + (this.beneficiary1 != null ? this.beneficiary1.hashCode() : 0);
            _result = 31 * _result + (this.beneficiary1IdentifierTypeIndicator != null ? this.beneficiary1IdentifierTypeIndicator.hashCode() : 0);
            _result = 31 * _result + (this.buyerIdentifier != null ? this.buyerIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.sellerIdentifier != null ? this.sellerIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.cleared != null ? ((Object)((Object)this.cleared)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.centralCounterparty != null ? this.centralCounterparty.hashCode() : 0);
            _result = 31 * _result + (this.clearingMember != null ? this.clearingMember.hashCode() : 0);
            _result = 31 * _result + (this.confirmed != null ? ((Object)((Object)this.confirmed)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.callAmount != null ? this.callAmount.hashCode() : 0);
            _result = 31 * _result + (this.putAmount != null ? this.putAmount.hashCode() : 0);
            _result = 31 * _result + (this.callCurrency != null ? this.callCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.putCurrency != null ? this.putCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.delta != null ? this.delta.hashCode() : 0);
            _result = 31 * _result + (this.priceSchedule != null ? this.priceSchedule.hashCode() : 0);
            _result = 31 * _result + (this.strikePriceSchedule != null ? this.strikePriceSchedule.hashCode() : 0);
            _result = 31 * _result + (this.price != null ? this.price.hashCode() : 0);
            _result = 31 * _result + (this.priceNotation != null ? ((Object)((Object)this.priceNotation)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.priceCurrency != null ? this.priceCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.packageTransactionPrice != null ? this.packageTransactionPrice.hashCode() : 0);
            _result = 31 * _result + (this.packageTransactionPriceNotation != null ? ((Object)((Object)this.packageTransactionPriceNotation)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.packageTransactionPriceCurrency != null ? this.packageTransactionPriceCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.packageTransactionSpread != null ? this.packageTransactionSpread.hashCode() : 0);
            _result = 31 * _result + (this.packageTransactionSpreadNotation != null ? ((Object)((Object)this.packageTransactionSpreadNotation)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.packageTransactionSpreadCurrency != null ? this.packageTransactionSpreadCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.packageIdentifier != null ? this.packageIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.strikePrice != null ? this.strikePrice.hashCode() : 0);
            _result = 31 * _result + (this.strikePriceNotation != null ? ((Object)((Object)this.strikePriceNotation)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.strikePriceCurrency != null ? this.strikePriceCurrency.hashCode() : 0);
            _result = 31 * _result + (this.priceUnitOfMeasure != null ? this.priceUnitOfMeasure.hashCode() : 0);
            _result = 31 * _result + (this.optionPremiumAmount != null ? this.optionPremiumAmount.hashCode() : 0);
            _result = 31 * _result + (this.optionPremiumCurrency != null ? this.optionPremiumCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.optionPremiumPaymentDate != null ? this.optionPremiumPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.exchangeRate != null ? this.exchangeRate.hashCode() : 0);
            _result = 31 * _result + (this.exchangeRateBasis != null ? this.exchangeRateBasis.hashCode() : 0);
            _result = 31 * _result + (this.cdSIndexAttachmentPoint != null ? this.cdSIndexAttachmentPoint.hashCode() : 0);
            _result = 31 * _result + (this.cdSIndexDetachmentPoint != null ? this.cdSIndexDetachmentPoint.hashCode() : 0);
            _result = 31 * _result + (this.collateralPortfolioIndicator != null ? this.collateralPortfolioIndicator.hashCode() : 0);
            _result = 31 * _result + (this.firstExerciseDate != null ? this.firstExerciseDate.hashCode() : 0);
            _result = 31 * _result + (this.finalContractualSettlementDate != null ? this.finalContractualSettlementDate.hashCode() : 0);
            _result = 31 * _result + (this.settlementLocation != null ? this.settlementLocation.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.priorUTI != null ? this.priorUTI.hashCode() : 0);
            _result = 31 * _result + (this.direction1 != null ? ((Object)((Object)this.direction1)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.valuationAmount != null ? this.valuationAmount.hashCode() : 0);
            _result = 31 * _result + (this.valuationCurrency != null ? this.valuationCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.valuationMethod != null ? ((Object)((Object)this.valuationMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.valuationTimestamp != null ? this.valuationTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.customBasketCode != null ? this.customBasketCode.hashCode() : 0);
            _result = 31 * _result + (this.basketConstituents != null ? this.basketConstituents.hashCode() : 0);
            _result = 31 * _result + (this.otherPayment != null ? this.otherPayment.hashCode() : 0);
            _result = 31 * _result + (this.leg1 != null ? this.leg1.hashCode() : 0);
            _result = 31 * _result + (this.leg2 != null ? this.leg2.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CriticalDataElementV1Builder {effectiveDate=" + String.valueOf(this.effectiveDate) + ", earlyTerminationDate=" + String.valueOf(this.earlyTerminationDate) + ", reportingTimestamp=" + String.valueOf(this.reportingTimestamp) + ", executionTimestamp=" + String.valueOf(this.executionTimestamp) + ", expirationDate=" + String.valueOf(this.expirationDate) + ", counterparty1=" + this.counterparty1 + ", counterparty2=" + this.counterparty2 + ", counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", beneficiary1=" + this.beneficiary1 + ", beneficiary1IdentifierTypeIndicator=" + this.beneficiary1IdentifierTypeIndicator + ", buyerIdentifier=" + this.buyerIdentifier + ", sellerIdentifier=" + this.sellerIdentifier + ", cleared=" + String.valueOf((Object)this.cleared) + ", centralCounterparty=" + this.centralCounterparty + ", clearingMember=" + this.clearingMember + ", confirmed=" + String.valueOf((Object)this.confirmed) + ", callAmount=" + String.valueOf(this.callAmount) + ", putAmount=" + String.valueOf(this.putAmount) + ", callCurrency=" + String.valueOf(this.callCurrency) + ", putCurrency=" + String.valueOf(this.putCurrency) + ", delta=" + String.valueOf(this.delta) + ", priceSchedule=" + String.valueOf(this.priceSchedule) + ", strikePriceSchedule=" + String.valueOf(this.strikePriceSchedule) + ", price=" + String.valueOf(this.price) + ", priceNotation=" + String.valueOf((Object)this.priceNotation) + ", priceCurrency=" + String.valueOf(this.priceCurrency) + ", packageTransactionPrice=" + String.valueOf(this.packageTransactionPrice) + ", packageTransactionPriceNotation=" + String.valueOf((Object)this.packageTransactionPriceNotation) + ", packageTransactionPriceCurrency=" + String.valueOf(this.packageTransactionPriceCurrency) + ", packageTransactionSpread=" + String.valueOf(this.packageTransactionSpread) + ", packageTransactionSpreadNotation=" + String.valueOf((Object)this.packageTransactionSpreadNotation) + ", packageTransactionSpreadCurrency=" + String.valueOf(this.packageTransactionSpreadCurrency) + ", packageIdentifier=" + this.packageIdentifier + ", strikePrice=" + String.valueOf(this.strikePrice) + ", strikePriceNotation=" + String.valueOf((Object)this.strikePriceNotation) + ", strikePriceCurrency=" + this.strikePriceCurrency + ", priceUnitOfMeasure=" + this.priceUnitOfMeasure + ", optionPremiumAmount=" + String.valueOf(this.optionPremiumAmount) + ", optionPremiumCurrency=" + String.valueOf(this.optionPremiumCurrency) + ", optionPremiumPaymentDate=" + String.valueOf(this.optionPremiumPaymentDate) + ", exchangeRate=" + String.valueOf(this.exchangeRate) + ", exchangeRateBasis=" + this.exchangeRateBasis + ", cdSIndexAttachmentPoint=" + String.valueOf(this.cdSIndexAttachmentPoint) + ", cdSIndexDetachmentPoint=" + String.valueOf(this.cdSIndexDetachmentPoint) + ", collateralPortfolioIndicator=" + this.collateralPortfolioIndicator + ", firstExerciseDate=" + String.valueOf(this.firstExerciseDate) + ", finalContractualSettlementDate=" + String.valueOf(this.finalContractualSettlementDate) + ", settlementLocation=" + String.valueOf(this.settlementLocation) + ", priorUTI=" + this.priorUTI + ", direction1=" + String.valueOf((Object)this.direction1) + ", valuationAmount=" + String.valueOf(this.valuationAmount) + ", valuationCurrency=" + String.valueOf(this.valuationCurrency) + ", valuationMethod=" + String.valueOf((Object)this.valuationMethod) + ", valuationTimestamp=" + String.valueOf(this.valuationTimestamp) + ", customBasketCode=" + this.customBasketCode + ", basketConstituents=" + String.valueOf(this.basketConstituents) + ", otherPayment=" + String.valueOf(this.otherPayment) + ", leg1=" + String.valueOf(this.leg1) + ", leg2=" + String.valueOf(this.leg2) + "}";
        }
    }

    public static interface CriticalDataElementV1Builder
    extends CriticalDataElementV1,
    RosettaModelObjectBuilder {
        public PricePeriod.PricePeriodBuilder getOrCreatePriceSchedule(int var1);

        public List<? extends PricePeriod.PricePeriodBuilder> getPriceSchedule();

        public PricePeriod.PricePeriodBuilder getOrCreateStrikePriceSchedule(int var1);

        public List<? extends PricePeriod.PricePeriodBuilder> getStrikePriceSchedule();

        public PriceFormat.PriceFormatBuilder getOrCreatePrice();

        @Override
        public PriceFormat.PriceFormatBuilder getPrice();

        public PriceFormat.PriceFormatBuilder getOrCreatePackageTransactionPrice();

        @Override
        public PriceFormat.PriceFormatBuilder getPackageTransactionPrice();

        public PriceFormat.PriceFormatBuilder getOrCreatePackageTransactionSpread();

        @Override
        public PriceFormat.PriceFormatBuilder getPackageTransactionSpread();

        public PriceFormat.PriceFormatBuilder getOrCreateStrikePrice();

        @Override
        public PriceFormat.PriceFormatBuilder getStrikePrice();

        public BasketConstituentsReport.BasketConstituentsReportBuilder getOrCreateBasketConstituents(int var1);

        public List<? extends BasketConstituentsReport.BasketConstituentsReportBuilder> getBasketConstituents();

        public OtherPayment.OtherPaymentBuilder getOrCreateOtherPayment(int var1);

        public List<? extends OtherPayment.OtherPaymentBuilder> getOtherPayment();

        public LegV1.LegV1Builder getOrCreateLeg1();

        @Override
        public LegV1.LegV1Builder getLeg1();

        public LegV1.LegV1Builder getOrCreateLeg2();

        @Override
        public LegV1.LegV1Builder getLeg2();

        public CriticalDataElementV1Builder setEffectiveDate(Date var1);

        public CriticalDataElementV1Builder setEarlyTerminationDate(Date var1);

        public CriticalDataElementV1Builder setReportingTimestamp(ZonedDateTime var1);

        public CriticalDataElementV1Builder setExecutionTimestamp(ZonedDateTime var1);

        public CriticalDataElementV1Builder setExpirationDate(Date var1);

        public CriticalDataElementV1Builder setCounterparty1(String var1);

        public CriticalDataElementV1Builder setCounterparty2(String var1);

        public CriticalDataElementV1Builder setCounterparty2IdentifierType(Boolean var1);

        public CriticalDataElementV1Builder setBeneficiary1(String var1);

        public CriticalDataElementV1Builder setBeneficiary1IdentifierTypeIndicator(Boolean var1);

        public CriticalDataElementV1Builder setBuyerIdentifier(String var1);

        public CriticalDataElementV1Builder setSellerIdentifier(String var1);

        public CriticalDataElementV1Builder setCleared(ClearedEnum var1);

        public CriticalDataElementV1Builder setCentralCounterparty(String var1);

        public CriticalDataElementV1Builder setClearingMember(String var1);

        public CriticalDataElementV1Builder setConfirmed(ConfirmationEnum var1);

        public CriticalDataElementV1Builder setCallAmount(BigDecimal var1);

        public CriticalDataElementV1Builder setPutAmount(BigDecimal var1);

        public CriticalDataElementV1Builder setCallCurrency(ISOCurrencyCodeEnum var1);

        public CriticalDataElementV1Builder setPutCurrency(ISOCurrencyCodeEnum var1);

        public CriticalDataElementV1Builder setDelta(BigDecimal var1);

        public CriticalDataElementV1Builder addPriceSchedule(PricePeriod var1);

        public CriticalDataElementV1Builder addPriceSchedule(PricePeriod var1, int var2);

        public CriticalDataElementV1Builder addPriceSchedule(List<? extends PricePeriod> var1);

        public CriticalDataElementV1Builder setPriceSchedule(List<? extends PricePeriod> var1);

        public CriticalDataElementV1Builder addStrikePriceSchedule(PricePeriod var1);

        public CriticalDataElementV1Builder addStrikePriceSchedule(PricePeriod var1, int var2);

        public CriticalDataElementV1Builder addStrikePriceSchedule(List<? extends PricePeriod> var1);

        public CriticalDataElementV1Builder setStrikePriceSchedule(List<? extends PricePeriod> var1);

        public CriticalDataElementV1Builder setPrice(PriceFormat var1);

        public CriticalDataElementV1Builder setPriceNotation(PriceNotationEnum var1);

        public CriticalDataElementV1Builder setPriceCurrency(ISOCurrencyCodeEnum var1);

        public CriticalDataElementV1Builder setPackageTransactionPrice(PriceFormat var1);

        public CriticalDataElementV1Builder setPackageTransactionPriceNotation(PriceNotationEnum var1);

        public CriticalDataElementV1Builder setPackageTransactionPriceCurrency(ISOCurrencyCodeEnum var1);

        public CriticalDataElementV1Builder setPackageTransactionSpread(PriceFormat var1);

        public CriticalDataElementV1Builder setPackageTransactionSpreadNotation(PriceNotationEnum var1);

        public CriticalDataElementV1Builder setPackageTransactionSpreadCurrency(ISOCurrencyCodeEnum var1);

        public CriticalDataElementV1Builder setPackageIdentifier(String var1);

        public CriticalDataElementV1Builder setStrikePrice(PriceFormat var1);

        public CriticalDataElementV1Builder setStrikePriceNotation(PriceNotationEnum var1);

        public CriticalDataElementV1Builder setStrikePriceCurrency(String var1);

        public CriticalDataElementV1Builder setPriceUnitOfMeasure(String var1);

        public CriticalDataElementV1Builder setOptionPremiumAmount(BigDecimal var1);

        public CriticalDataElementV1Builder setOptionPremiumCurrency(ISOCurrencyCodeEnum var1);

        public CriticalDataElementV1Builder setOptionPremiumPaymentDate(Date var1);

        public CriticalDataElementV1Builder setExchangeRate(BigDecimal var1);

        public CriticalDataElementV1Builder setExchangeRateBasis(String var1);

        public CriticalDataElementV1Builder setCdSIndexAttachmentPoint(BigDecimal var1);

        public CriticalDataElementV1Builder setCdSIndexDetachmentPoint(BigDecimal var1);

        public CriticalDataElementV1Builder setCollateralPortfolioIndicator(Boolean var1);

        public CriticalDataElementV1Builder setFirstExerciseDate(Date var1);

        public CriticalDataElementV1Builder setFinalContractualSettlementDate(Date var1);

        public CriticalDataElementV1Builder setSettlementLocation(ISOCountryCodeEnum var1);

        public CriticalDataElementV1Builder setPriorUTI(String var1);

        public CriticalDataElementV1Builder setDirection1(Direction1Enum var1);

        public CriticalDataElementV1Builder setValuationAmount(BigDecimal var1);

        public CriticalDataElementV1Builder setValuationCurrency(ISOCurrencyCodeEnum var1);

        public CriticalDataElementV1Builder setValuationMethod(ValuationType1Code var1);

        public CriticalDataElementV1Builder setValuationTimestamp(ZonedDateTime var1);

        public CriticalDataElementV1Builder setCustomBasketCode(String var1);

        public CriticalDataElementV1Builder addBasketConstituents(BasketConstituentsReport var1);

        public CriticalDataElementV1Builder addBasketConstituents(BasketConstituentsReport var1, int var2);

        public CriticalDataElementV1Builder addBasketConstituents(List<? extends BasketConstituentsReport> var1);

        public CriticalDataElementV1Builder setBasketConstituents(List<? extends BasketConstituentsReport> var1);

        public CriticalDataElementV1Builder addOtherPayment(OtherPayment var1);

        public CriticalDataElementV1Builder addOtherPayment(OtherPayment var1, int var2);

        public CriticalDataElementV1Builder addOtherPayment(List<? extends OtherPayment> var1);

        public CriticalDataElementV1Builder setOtherPayment(List<? extends OtherPayment> var1);

        public CriticalDataElementV1Builder setLeg1(LegV1 var1);

        public CriticalDataElementV1Builder setLeg2(LegV1 var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("earlyTerminationDate"), Date.class, (Object)this.getEarlyTerminationDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, (Object)this.getExecutionTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expirationDate"), Date.class, (Object)this.getExpirationDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("beneficiary1"), String.class, (Object)this.getBeneficiary1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("beneficiary1IdentifierTypeIndicator"), Boolean.class, (Object)this.getBeneficiary1IdentifierTypeIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("buyerIdentifier"), String.class, (Object)this.getBuyerIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("sellerIdentifier"), String.class, (Object)this.getSellerIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cleared"), ClearedEnum.class, (Object)this.getCleared(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("centralCounterparty"), String.class, (Object)this.getCentralCounterparty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingMember"), String.class, (Object)this.getClearingMember(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("confirmed"), ConfirmationEnum.class, (Object)this.getConfirmed(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, (Object)this.getCallAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, (Object)this.getPutAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getCallCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPutCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("priceSchedule"), processor, PricePeriod.PricePeriodBuilder.class, this.getPriceSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strikePriceSchedule"), processor, PricePeriod.PricePeriodBuilder.class, this.getStrikePriceSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("price"), processor, PriceFormat.PriceFormatBuilder.class, this.getPrice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priceNotation"), PriceNotationEnum.class, (Object)this.getPriceNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priceCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPriceCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("packageTransactionPrice"), processor, PriceFormat.PriceFormatBuilder.class, this.getPackageTransactionPrice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), PriceNotationEnum.class, (Object)this.getPackageTransactionPriceNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageTransactionPriceCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPackageTransactionPriceCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("packageTransactionSpread"), processor, PriceFormat.PriceFormatBuilder.class, this.getPackageTransactionSpread(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageTransactionSpreadNotation"), PriceNotationEnum.class, (Object)this.getPackageTransactionSpreadNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageTransactionSpreadCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPackageTransactionSpreadCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageIdentifier"), String.class, (Object)this.getPackageIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strikePrice"), processor, PriceFormat.PriceFormatBuilder.class, this.getStrikePrice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("strikePriceNotation"), PriceNotationEnum.class, (Object)this.getStrikePriceNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("strikePriceCurrency"), String.class, (Object)this.getStrikePriceCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, (Object)this.getPriceUnitOfMeasure(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, (Object)this.getOptionPremiumAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getOptionPremiumCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, (Object)this.getOptionPremiumPaymentDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, (Object)this.getExchangeRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, (Object)this.getExchangeRateBasis(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, (Object)this.getCdSIndexAttachmentPoint(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, (Object)this.getCdSIndexDetachmentPoint(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, (Object)this.getCollateralPortfolioIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, (Object)this.getFirstExerciseDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, (Object)this.getFinalContractualSettlementDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementLocation"), ISOCountryCodeEnum.class, (Object)this.getSettlementLocation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priorUTI"), String.class, (Object)this.getPriorUTI(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("direction1"), Direction1Enum.class, (Object)this.getDirection1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("customBasketCode"), String.class, (Object)this.getCustomBasketCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.BasketConstituentsReportBuilder.class, this.getBasketConstituents(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("otherPayment"), processor, OtherPayment.OtherPaymentBuilder.class, this.getOtherPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("leg1"), processor, LegV1.LegV1Builder.class, this.getLeg1(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("leg2"), processor, LegV1.LegV1Builder.class, this.getLeg2(), new AttributeMeta[0]);
        }

        public CriticalDataElementV1Builder prune();
    }

    public static class CriticalDataElementV1Impl
    implements CriticalDataElementV1 {
        private final Date effectiveDate;
        private final Date earlyTerminationDate;
        private final ZonedDateTime reportingTimestamp;
        private final ZonedDateTime executionTimestamp;
        private final Date expirationDate;
        private final String counterparty1;
        private final String counterparty2;
        private final Boolean counterparty2IdentifierType;
        private final String beneficiary1;
        private final Boolean beneficiary1IdentifierTypeIndicator;
        private final String buyerIdentifier;
        private final String sellerIdentifier;
        private final ClearedEnum cleared;
        private final String centralCounterparty;
        private final String clearingMember;
        private final ConfirmationEnum confirmed;
        private final BigDecimal callAmount;
        private final BigDecimal putAmount;
        private final ISOCurrencyCodeEnum callCurrency;
        private final ISOCurrencyCodeEnum putCurrency;
        private final BigDecimal delta;
        private final List<? extends PricePeriod> priceSchedule;
        private final List<? extends PricePeriod> strikePriceSchedule;
        private final PriceFormat price;
        private final PriceNotationEnum priceNotation;
        private final ISOCurrencyCodeEnum priceCurrency;
        private final PriceFormat packageTransactionPrice;
        private final PriceNotationEnum packageTransactionPriceNotation;
        private final ISOCurrencyCodeEnum packageTransactionPriceCurrency;
        private final PriceFormat packageTransactionSpread;
        private final PriceNotationEnum packageTransactionSpreadNotation;
        private final ISOCurrencyCodeEnum packageTransactionSpreadCurrency;
        private final String packageIdentifier;
        private final PriceFormat strikePrice;
        private final PriceNotationEnum strikePriceNotation;
        private final String strikePriceCurrency;
        private final String priceUnitOfMeasure;
        private final BigDecimal optionPremiumAmount;
        private final ISOCurrencyCodeEnum optionPremiumCurrency;
        private final Date optionPremiumPaymentDate;
        private final BigDecimal exchangeRate;
        private final String exchangeRateBasis;
        private final BigDecimal cdSIndexAttachmentPoint;
        private final BigDecimal cdSIndexDetachmentPoint;
        private final Boolean collateralPortfolioIndicator;
        private final Date firstExerciseDate;
        private final Date finalContractualSettlementDate;
        private final ISOCountryCodeEnum settlementLocation;
        private final String priorUTI;
        private final Direction1Enum direction1;
        private final BigDecimal valuationAmount;
        private final ISOCurrencyCodeEnum valuationCurrency;
        private final ValuationType1Code valuationMethod;
        private final ZonedDateTime valuationTimestamp;
        private final String customBasketCode;
        private final List<? extends BasketConstituentsReport> basketConstituents;
        private final List<? extends OtherPayment> otherPayment;
        private final LegV1 leg1;
        private final LegV1 leg2;

        protected CriticalDataElementV1Impl(CriticalDataElementV1Builder builder) {
            this.effectiveDate = builder.getEffectiveDate();
            this.earlyTerminationDate = builder.getEarlyTerminationDate();
            this.reportingTimestamp = builder.getReportingTimestamp();
            this.executionTimestamp = builder.getExecutionTimestamp();
            this.expirationDate = builder.getExpirationDate();
            this.counterparty1 = builder.getCounterparty1();
            this.counterparty2 = builder.getCounterparty2();
            this.counterparty2IdentifierType = builder.getCounterparty2IdentifierType();
            this.beneficiary1 = builder.getBeneficiary1();
            this.beneficiary1IdentifierTypeIndicator = builder.getBeneficiary1IdentifierTypeIndicator();
            this.buyerIdentifier = builder.getBuyerIdentifier();
            this.sellerIdentifier = builder.getSellerIdentifier();
            this.cleared = builder.getCleared();
            this.centralCounterparty = builder.getCentralCounterparty();
            this.clearingMember = builder.getClearingMember();
            this.confirmed = builder.getConfirmed();
            this.callAmount = builder.getCallAmount();
            this.putAmount = builder.getPutAmount();
            this.callCurrency = builder.getCallCurrency();
            this.putCurrency = builder.getPutCurrency();
            this.delta = builder.getDelta();
            this.priceSchedule = Optional.ofNullable(builder.getPriceSchedule()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.strikePriceSchedule = Optional.ofNullable(builder.getStrikePriceSchedule()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.price = Optional.ofNullable(builder.getPrice()).map(f -> f.build()).orElse(null);
            this.priceNotation = builder.getPriceNotation();
            this.priceCurrency = builder.getPriceCurrency();
            this.packageTransactionPrice = Optional.ofNullable(builder.getPackageTransactionPrice()).map(f -> f.build()).orElse(null);
            this.packageTransactionPriceNotation = builder.getPackageTransactionPriceNotation();
            this.packageTransactionPriceCurrency = builder.getPackageTransactionPriceCurrency();
            this.packageTransactionSpread = Optional.ofNullable(builder.getPackageTransactionSpread()).map(f -> f.build()).orElse(null);
            this.packageTransactionSpreadNotation = builder.getPackageTransactionSpreadNotation();
            this.packageTransactionSpreadCurrency = builder.getPackageTransactionSpreadCurrency();
            this.packageIdentifier = builder.getPackageIdentifier();
            this.strikePrice = Optional.ofNullable(builder.getStrikePrice()).map(f -> f.build()).orElse(null);
            this.strikePriceNotation = builder.getStrikePriceNotation();
            this.strikePriceCurrency = builder.getStrikePriceCurrency();
            this.priceUnitOfMeasure = builder.getPriceUnitOfMeasure();
            this.optionPremiumAmount = builder.getOptionPremiumAmount();
            this.optionPremiumCurrency = builder.getOptionPremiumCurrency();
            this.optionPremiumPaymentDate = builder.getOptionPremiumPaymentDate();
            this.exchangeRate = builder.getExchangeRate();
            this.exchangeRateBasis = builder.getExchangeRateBasis();
            this.cdSIndexAttachmentPoint = builder.getCdSIndexAttachmentPoint();
            this.cdSIndexDetachmentPoint = builder.getCdSIndexDetachmentPoint();
            this.collateralPortfolioIndicator = builder.getCollateralPortfolioIndicator();
            this.firstExerciseDate = builder.getFirstExerciseDate();
            this.finalContractualSettlementDate = builder.getFinalContractualSettlementDate();
            this.settlementLocation = builder.getSettlementLocation();
            this.priorUTI = builder.getPriorUTI();
            this.direction1 = builder.getDirection1();
            this.valuationAmount = builder.getValuationAmount();
            this.valuationCurrency = builder.getValuationCurrency();
            this.valuationMethod = builder.getValuationMethod();
            this.valuationTimestamp = builder.getValuationTimestamp();
            this.customBasketCode = builder.getCustomBasketCode();
            this.basketConstituents = Optional.ofNullable(builder.getBasketConstituents()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.otherPayment = Optional.ofNullable(builder.getOtherPayment()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.leg1 = Optional.ofNullable(builder.getLeg1()).map(f -> f.build()).orElse(null);
            this.leg2 = Optional.ofNullable(builder.getLeg2()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public Date getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="earlyTerminationDate")
        @RuneAttribute(value="earlyTerminationDate")
        public Date getEarlyTerminationDate() {
            return this.earlyTerminationDate;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public ZonedDateTime getReportingTimestamp() {
            return this.reportingTimestamp;
        }

        @Override
        @RosettaAttribute(value="executionTimestamp")
        @RuneAttribute(value="executionTimestamp")
        public ZonedDateTime getExecutionTimestamp() {
            return this.executionTimestamp;
        }

        @Override
        @RosettaAttribute(value="expirationDate")
        @RuneAttribute(value="expirationDate")
        public Date getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public String getCounterparty1() {
            return this.counterparty1;
        }

        @Override
        @RosettaAttribute(value="counterparty2")
        @RuneAttribute(value="counterparty2")
        public String getCounterparty2() {
            return this.counterparty2;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType")
        @RuneAttribute(value="counterparty2IdentifierType")
        public Boolean getCounterparty2IdentifierType() {
            return this.counterparty2IdentifierType;
        }

        @Override
        @RosettaAttribute(value="beneficiary1")
        @RuneAttribute(value="beneficiary1")
        public String getBeneficiary1() {
            return this.beneficiary1;
        }

        @Override
        @RosettaAttribute(value="beneficiary1IdentifierTypeIndicator")
        @RuneAttribute(value="beneficiary1IdentifierTypeIndicator")
        public Boolean getBeneficiary1IdentifierTypeIndicator() {
            return this.beneficiary1IdentifierTypeIndicator;
        }

        @Override
        @RosettaAttribute(value="buyerIdentifier")
        @RuneAttribute(value="buyerIdentifier")
        public String getBuyerIdentifier() {
            return this.buyerIdentifier;
        }

        @Override
        @RosettaAttribute(value="sellerIdentifier")
        @RuneAttribute(value="sellerIdentifier")
        public String getSellerIdentifier() {
            return this.sellerIdentifier;
        }

        @Override
        @RosettaAttribute(value="cleared")
        @RuneAttribute(value="cleared")
        public ClearedEnum getCleared() {
            return this.cleared;
        }

        @Override
        @RosettaAttribute(value="centralCounterparty")
        @RuneAttribute(value="centralCounterparty")
        public String getCentralCounterparty() {
            return this.centralCounterparty;
        }

        @Override
        @RosettaAttribute(value="clearingMember")
        @RuneAttribute(value="clearingMember")
        public String getClearingMember() {
            return this.clearingMember;
        }

        @Override
        @RosettaAttribute(value="confirmed")
        @RuneAttribute(value="confirmed")
        public ConfirmationEnum getConfirmed() {
            return this.confirmed;
        }

        @Override
        @RosettaAttribute(value="callAmount")
        @RuneAttribute(value="callAmount")
        public BigDecimal getCallAmount() {
            return this.callAmount;
        }

        @Override
        @RosettaAttribute(value="putAmount")
        @RuneAttribute(value="putAmount")
        public BigDecimal getPutAmount() {
            return this.putAmount;
        }

        @Override
        @RosettaAttribute(value="callCurrency")
        @RuneAttribute(value="callCurrency")
        public ISOCurrencyCodeEnum getCallCurrency() {
            return this.callCurrency;
        }

        @Override
        @RosettaAttribute(value="putCurrency")
        @RuneAttribute(value="putCurrency")
        public ISOCurrencyCodeEnum getPutCurrency() {
            return this.putCurrency;
        }

        @Override
        @RosettaAttribute(value="delta")
        @RuneAttribute(value="delta")
        public BigDecimal getDelta() {
            return this.delta;
        }

        @Override
        @RosettaAttribute(value="priceSchedule")
        @RuneAttribute(value="priceSchedule")
        public List<? extends PricePeriod> getPriceSchedule() {
            return this.priceSchedule;
        }

        @Override
        @RosettaAttribute(value="strikePriceSchedule")
        @RuneAttribute(value="strikePriceSchedule")
        public List<? extends PricePeriod> getStrikePriceSchedule() {
            return this.strikePriceSchedule;
        }

        @Override
        @RosettaAttribute(value="price")
        @RuneAttribute(value="price")
        public PriceFormat getPrice() {
            return this.price;
        }

        @Override
        @RosettaAttribute(value="priceNotation")
        @RuneAttribute(value="priceNotation")
        public PriceNotationEnum getPriceNotation() {
            return this.priceNotation;
        }

        @Override
        @RosettaAttribute(value="priceCurrency")
        @RuneAttribute(value="priceCurrency")
        public ISOCurrencyCodeEnum getPriceCurrency() {
            return this.priceCurrency;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPrice")
        @RuneAttribute(value="packageTransactionPrice")
        public PriceFormat getPackageTransactionPrice() {
            return this.packageTransactionPrice;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPriceNotation")
        @RuneAttribute(value="packageTransactionPriceNotation")
        public PriceNotationEnum getPackageTransactionPriceNotation() {
            return this.packageTransactionPriceNotation;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPriceCurrency")
        @RuneAttribute(value="packageTransactionPriceCurrency")
        public ISOCurrencyCodeEnum getPackageTransactionPriceCurrency() {
            return this.packageTransactionPriceCurrency;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpread")
        @RuneAttribute(value="packageTransactionSpread")
        public PriceFormat getPackageTransactionSpread() {
            return this.packageTransactionSpread;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpreadNotation")
        @RuneAttribute(value="packageTransactionSpreadNotation")
        public PriceNotationEnum getPackageTransactionSpreadNotation() {
            return this.packageTransactionSpreadNotation;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpreadCurrency")
        @RuneAttribute(value="packageTransactionSpreadCurrency")
        public ISOCurrencyCodeEnum getPackageTransactionSpreadCurrency() {
            return this.packageTransactionSpreadCurrency;
        }

        @Override
        @RosettaAttribute(value="packageIdentifier")
        @RuneAttribute(value="packageIdentifier")
        public String getPackageIdentifier() {
            return this.packageIdentifier;
        }

        @Override
        @RosettaAttribute(value="strikePrice")
        @RuneAttribute(value="strikePrice")
        public PriceFormat getStrikePrice() {
            return this.strikePrice;
        }

        @Override
        @RosettaAttribute(value="strikePriceNotation")
        @RuneAttribute(value="strikePriceNotation")
        public PriceNotationEnum getStrikePriceNotation() {
            return this.strikePriceNotation;
        }

        @Override
        @RosettaAttribute(value="strikePriceCurrency")
        @RuneAttribute(value="strikePriceCurrency")
        public String getStrikePriceCurrency() {
            return this.strikePriceCurrency;
        }

        @Override
        @RosettaAttribute(value="priceUnitOfMeasure")
        @RuneAttribute(value="priceUnitOfMeasure")
        public String getPriceUnitOfMeasure() {
            return this.priceUnitOfMeasure;
        }

        @Override
        @RosettaAttribute(value="optionPremiumAmount")
        @RuneAttribute(value="optionPremiumAmount")
        public BigDecimal getOptionPremiumAmount() {
            return this.optionPremiumAmount;
        }

        @Override
        @RosettaAttribute(value="optionPremiumCurrency")
        @RuneAttribute(value="optionPremiumCurrency")
        public ISOCurrencyCodeEnum getOptionPremiumCurrency() {
            return this.optionPremiumCurrency;
        }

        @Override
        @RosettaAttribute(value="optionPremiumPaymentDate")
        @RuneAttribute(value="optionPremiumPaymentDate")
        public Date getOptionPremiumPaymentDate() {
            return this.optionPremiumPaymentDate;
        }

        @Override
        @RosettaAttribute(value="exchangeRate")
        @RuneAttribute(value="exchangeRate")
        public BigDecimal getExchangeRate() {
            return this.exchangeRate;
        }

        @Override
        @RosettaAttribute(value="exchangeRateBasis")
        @RuneAttribute(value="exchangeRateBasis")
        public String getExchangeRateBasis() {
            return this.exchangeRateBasis;
        }

        @Override
        @RosettaAttribute(value="cdSIndexAttachmentPoint")
        @RuneAttribute(value="cdSIndexAttachmentPoint")
        public BigDecimal getCdSIndexAttachmentPoint() {
            return this.cdSIndexAttachmentPoint;
        }

        @Override
        @RosettaAttribute(value="cdSIndexDetachmentPoint")
        @RuneAttribute(value="cdSIndexDetachmentPoint")
        public BigDecimal getCdSIndexDetachmentPoint() {
            return this.cdSIndexDetachmentPoint;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioIndicator")
        @RuneAttribute(value="collateralPortfolioIndicator")
        public Boolean getCollateralPortfolioIndicator() {
            return this.collateralPortfolioIndicator;
        }

        @Override
        @RosettaAttribute(value="firstExerciseDate")
        @RuneAttribute(value="firstExerciseDate")
        public Date getFirstExerciseDate() {
            return this.firstExerciseDate;
        }

        @Override
        @RosettaAttribute(value="finalContractualSettlementDate")
        @RuneAttribute(value="finalContractualSettlementDate")
        public Date getFinalContractualSettlementDate() {
            return this.finalContractualSettlementDate;
        }

        @Override
        @RosettaAttribute(value="settlementLocation")
        @RuneAttribute(value="settlementLocation")
        public ISOCountryCodeEnum getSettlementLocation() {
            return this.settlementLocation;
        }

        @Override
        @RosettaAttribute(value="priorUTI")
        @RuneAttribute(value="priorUTI")
        public String getPriorUTI() {
            return this.priorUTI;
        }

        @Override
        @RosettaAttribute(value="direction1")
        @RuneAttribute(value="direction1")
        public Direction1Enum getDirection1() {
            return this.direction1;
        }

        @Override
        @RosettaAttribute(value="valuationAmount")
        @RuneAttribute(value="valuationAmount")
        public BigDecimal getValuationAmount() {
            return this.valuationAmount;
        }

        @Override
        @RosettaAttribute(value="valuationCurrency")
        @RuneAttribute(value="valuationCurrency")
        public ISOCurrencyCodeEnum getValuationCurrency() {
            return this.valuationCurrency;
        }

        @Override
        @RosettaAttribute(value="valuationMethod")
        @RuneAttribute(value="valuationMethod")
        public ValuationType1Code getValuationMethod() {
            return this.valuationMethod;
        }

        @Override
        @RosettaAttribute(value="valuationTimestamp")
        @RuneAttribute(value="valuationTimestamp")
        public ZonedDateTime getValuationTimestamp() {
            return this.valuationTimestamp;
        }

        @Override
        @RosettaAttribute(value="customBasketCode")
        @RuneAttribute(value="customBasketCode")
        public String getCustomBasketCode() {
            return this.customBasketCode;
        }

        @Override
        @RosettaAttribute(value="basketConstituents")
        @RuneAttribute(value="basketConstituents")
        public List<? extends BasketConstituentsReport> getBasketConstituents() {
            return this.basketConstituents;
        }

        @Override
        @RosettaAttribute(value="otherPayment")
        @RuneAttribute(value="otherPayment")
        public List<? extends OtherPayment> getOtherPayment() {
            return this.otherPayment;
        }

        @Override
        @RosettaAttribute(value="leg1")
        @RuneAttribute(value="leg1")
        public LegV1 getLeg1() {
            return this.leg1;
        }

        @Override
        @RosettaAttribute(value="leg2")
        @RuneAttribute(value="leg2")
        public LegV1 getLeg2() {
            return this.leg2;
        }

        @Override
        public CriticalDataElementV1 build() {
            return this;
        }

        @Override
        public CriticalDataElementV1Builder toBuilder() {
            CriticalDataElementV1Builder builder = CriticalDataElementV1.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CriticalDataElementV1Builder builder) {
            Optional.ofNullable(this.getEffectiveDate()).ifPresent(builder::setEffectiveDate);
            Optional.ofNullable(this.getEarlyTerminationDate()).ifPresent(builder::setEarlyTerminationDate);
            Optional.ofNullable(this.getReportingTimestamp()).ifPresent(builder::setReportingTimestamp);
            Optional.ofNullable(this.getExecutionTimestamp()).ifPresent(builder::setExecutionTimestamp);
            Optional.ofNullable(this.getExpirationDate()).ifPresent(builder::setExpirationDate);
            Optional.ofNullable(this.getCounterparty1()).ifPresent(builder::setCounterparty1);
            Optional.ofNullable(this.getCounterparty2()).ifPresent(builder::setCounterparty2);
            Optional.ofNullable(this.getCounterparty2IdentifierType()).ifPresent(builder::setCounterparty2IdentifierType);
            Optional.ofNullable(this.getBeneficiary1()).ifPresent(builder::setBeneficiary1);
            Optional.ofNullable(this.getBeneficiary1IdentifierTypeIndicator()).ifPresent(builder::setBeneficiary1IdentifierTypeIndicator);
            Optional.ofNullable(this.getBuyerIdentifier()).ifPresent(builder::setBuyerIdentifier);
            Optional.ofNullable(this.getSellerIdentifier()).ifPresent(builder::setSellerIdentifier);
            Optional.ofNullable(this.getCleared()).ifPresent(builder::setCleared);
            Optional.ofNullable(this.getCentralCounterparty()).ifPresent(builder::setCentralCounterparty);
            Optional.ofNullable(this.getClearingMember()).ifPresent(builder::setClearingMember);
            Optional.ofNullable(this.getConfirmed()).ifPresent(builder::setConfirmed);
            Optional.ofNullable(this.getCallAmount()).ifPresent(builder::setCallAmount);
            Optional.ofNullable(this.getPutAmount()).ifPresent(builder::setPutAmount);
            Optional.ofNullable(this.getCallCurrency()).ifPresent(builder::setCallCurrency);
            Optional.ofNullable(this.getPutCurrency()).ifPresent(builder::setPutCurrency);
            Optional.ofNullable(this.getDelta()).ifPresent(builder::setDelta);
            Optional.ofNullable(this.getPriceSchedule()).ifPresent(builder::setPriceSchedule);
            Optional.ofNullable(this.getStrikePriceSchedule()).ifPresent(builder::setStrikePriceSchedule);
            Optional.ofNullable(this.getPrice()).ifPresent(builder::setPrice);
            Optional.ofNullable(this.getPriceNotation()).ifPresent(builder::setPriceNotation);
            Optional.ofNullable(this.getPriceCurrency()).ifPresent(builder::setPriceCurrency);
            Optional.ofNullable(this.getPackageTransactionPrice()).ifPresent(builder::setPackageTransactionPrice);
            Optional.ofNullable(this.getPackageTransactionPriceNotation()).ifPresent(builder::setPackageTransactionPriceNotation);
            Optional.ofNullable(this.getPackageTransactionPriceCurrency()).ifPresent(builder::setPackageTransactionPriceCurrency);
            Optional.ofNullable(this.getPackageTransactionSpread()).ifPresent(builder::setPackageTransactionSpread);
            Optional.ofNullable(this.getPackageTransactionSpreadNotation()).ifPresent(builder::setPackageTransactionSpreadNotation);
            Optional.ofNullable(this.getPackageTransactionSpreadCurrency()).ifPresent(builder::setPackageTransactionSpreadCurrency);
            Optional.ofNullable(this.getPackageIdentifier()).ifPresent(builder::setPackageIdentifier);
            Optional.ofNullable(this.getStrikePrice()).ifPresent(builder::setStrikePrice);
            Optional.ofNullable(this.getStrikePriceNotation()).ifPresent(builder::setStrikePriceNotation);
            Optional.ofNullable(this.getStrikePriceCurrency()).ifPresent(builder::setStrikePriceCurrency);
            Optional.ofNullable(this.getPriceUnitOfMeasure()).ifPresent(builder::setPriceUnitOfMeasure);
            Optional.ofNullable(this.getOptionPremiumAmount()).ifPresent(builder::setOptionPremiumAmount);
            Optional.ofNullable(this.getOptionPremiumCurrency()).ifPresent(builder::setOptionPremiumCurrency);
            Optional.ofNullable(this.getOptionPremiumPaymentDate()).ifPresent(builder::setOptionPremiumPaymentDate);
            Optional.ofNullable(this.getExchangeRate()).ifPresent(builder::setExchangeRate);
            Optional.ofNullable(this.getExchangeRateBasis()).ifPresent(builder::setExchangeRateBasis);
            Optional.ofNullable(this.getCdSIndexAttachmentPoint()).ifPresent(builder::setCdSIndexAttachmentPoint);
            Optional.ofNullable(this.getCdSIndexDetachmentPoint()).ifPresent(builder::setCdSIndexDetachmentPoint);
            Optional.ofNullable(this.getCollateralPortfolioIndicator()).ifPresent(builder::setCollateralPortfolioIndicator);
            Optional.ofNullable(this.getFirstExerciseDate()).ifPresent(builder::setFirstExerciseDate);
            Optional.ofNullable(this.getFinalContractualSettlementDate()).ifPresent(builder::setFinalContractualSettlementDate);
            Optional.ofNullable(this.getSettlementLocation()).ifPresent(builder::setSettlementLocation);
            Optional.ofNullable(this.getPriorUTI()).ifPresent(builder::setPriorUTI);
            Optional.ofNullable(this.getDirection1()).ifPresent(builder::setDirection1);
            Optional.ofNullable(this.getValuationAmount()).ifPresent(builder::setValuationAmount);
            Optional.ofNullable(this.getValuationCurrency()).ifPresent(builder::setValuationCurrency);
            Optional.ofNullable(this.getValuationMethod()).ifPresent(builder::setValuationMethod);
            Optional.ofNullable(this.getValuationTimestamp()).ifPresent(builder::setValuationTimestamp);
            Optional.ofNullable(this.getCustomBasketCode()).ifPresent(builder::setCustomBasketCode);
            Optional.ofNullable(this.getBasketConstituents()).ifPresent(builder::setBasketConstituents);
            Optional.ofNullable(this.getOtherPayment()).ifPresent(builder::setOtherPayment);
            Optional.ofNullable(this.getLeg1()).ifPresent(builder::setLeg1);
            Optional.ofNullable(this.getLeg2()).ifPresent(builder::setLeg2);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CriticalDataElementV1 _that = this.getType().cast(o);
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.earlyTerminationDate, _that.getEarlyTerminationDate())) {
                return false;
            }
            if (!Objects.equals(this.reportingTimestamp, _that.getReportingTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.executionTimestamp, _that.getExecutionTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.expirationDate, _that.getExpirationDate())) {
                return false;
            }
            if (!Objects.equals(this.counterparty1, _that.getCounterparty1())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2, _that.getCounterparty2())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) {
                return false;
            }
            if (!Objects.equals(this.beneficiary1, _that.getBeneficiary1())) {
                return false;
            }
            if (!Objects.equals(this.beneficiary1IdentifierTypeIndicator, _that.getBeneficiary1IdentifierTypeIndicator())) {
                return false;
            }
            if (!Objects.equals(this.buyerIdentifier, _that.getBuyerIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.sellerIdentifier, _that.getSellerIdentifier())) {
                return false;
            }
            if (!Objects.equals((Object)this.cleared, (Object)_that.getCleared())) {
                return false;
            }
            if (!Objects.equals(this.centralCounterparty, _that.getCentralCounterparty())) {
                return false;
            }
            if (!Objects.equals(this.clearingMember, _that.getClearingMember())) {
                return false;
            }
            if (!Objects.equals((Object)this.confirmed, (Object)_that.getConfirmed())) {
                return false;
            }
            if (!Objects.equals(this.callAmount, _that.getCallAmount())) {
                return false;
            }
            if (!Objects.equals(this.putAmount, _that.getPutAmount())) {
                return false;
            }
            if (!Objects.equals(this.callCurrency, _that.getCallCurrency())) {
                return false;
            }
            if (!Objects.equals(this.putCurrency, _that.getPutCurrency())) {
                return false;
            }
            if (!Objects.equals(this.delta, _that.getDelta())) {
                return false;
            }
            if (!ListEquals.listEquals(this.priceSchedule, _that.getPriceSchedule())) {
                return false;
            }
            if (!ListEquals.listEquals(this.strikePriceSchedule, _that.getStrikePriceSchedule())) {
                return false;
            }
            if (!Objects.equals(this.price, _that.getPrice())) {
                return false;
            }
            if (!Objects.equals((Object)this.priceNotation, (Object)_that.getPriceNotation())) {
                return false;
            }
            if (!Objects.equals(this.priceCurrency, _that.getPriceCurrency())) {
                return false;
            }
            if (!Objects.equals(this.packageTransactionPrice, _that.getPackageTransactionPrice())) {
                return false;
            }
            if (!Objects.equals((Object)this.packageTransactionPriceNotation, (Object)_that.getPackageTransactionPriceNotation())) {
                return false;
            }
            if (!Objects.equals(this.packageTransactionPriceCurrency, _that.getPackageTransactionPriceCurrency())) {
                return false;
            }
            if (!Objects.equals(this.packageTransactionSpread, _that.getPackageTransactionSpread())) {
                return false;
            }
            if (!Objects.equals((Object)this.packageTransactionSpreadNotation, (Object)_that.getPackageTransactionSpreadNotation())) {
                return false;
            }
            if (!Objects.equals(this.packageTransactionSpreadCurrency, _that.getPackageTransactionSpreadCurrency())) {
                return false;
            }
            if (!Objects.equals(this.packageIdentifier, _that.getPackageIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.strikePrice, _that.getStrikePrice())) {
                return false;
            }
            if (!Objects.equals((Object)this.strikePriceNotation, (Object)_that.getStrikePriceNotation())) {
                return false;
            }
            if (!Objects.equals(this.strikePriceCurrency, _that.getStrikePriceCurrency())) {
                return false;
            }
            if (!Objects.equals(this.priceUnitOfMeasure, _that.getPriceUnitOfMeasure())) {
                return false;
            }
            if (!Objects.equals(this.optionPremiumAmount, _that.getOptionPremiumAmount())) {
                return false;
            }
            if (!Objects.equals(this.optionPremiumCurrency, _that.getOptionPremiumCurrency())) {
                return false;
            }
            if (!Objects.equals(this.optionPremiumPaymentDate, _that.getOptionPremiumPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.exchangeRate, _that.getExchangeRate())) {
                return false;
            }
            if (!Objects.equals(this.exchangeRateBasis, _that.getExchangeRateBasis())) {
                return false;
            }
            if (!Objects.equals(this.cdSIndexAttachmentPoint, _that.getCdSIndexAttachmentPoint())) {
                return false;
            }
            if (!Objects.equals(this.cdSIndexDetachmentPoint, _that.getCdSIndexDetachmentPoint())) {
                return false;
            }
            if (!Objects.equals(this.collateralPortfolioIndicator, _that.getCollateralPortfolioIndicator())) {
                return false;
            }
            if (!Objects.equals(this.firstExerciseDate, _that.getFirstExerciseDate())) {
                return false;
            }
            if (!Objects.equals(this.finalContractualSettlementDate, _that.getFinalContractualSettlementDate())) {
                return false;
            }
            if (!Objects.equals(this.settlementLocation, _that.getSettlementLocation())) {
                return false;
            }
            if (!Objects.equals(this.priorUTI, _that.getPriorUTI())) {
                return false;
            }
            if (!Objects.equals((Object)this.direction1, (Object)_that.getDirection1())) {
                return false;
            }
            if (!Objects.equals(this.valuationAmount, _that.getValuationAmount())) {
                return false;
            }
            if (!Objects.equals(this.valuationCurrency, _that.getValuationCurrency())) {
                return false;
            }
            if (!Objects.equals((Object)this.valuationMethod, (Object)_that.getValuationMethod())) {
                return false;
            }
            if (!Objects.equals(this.valuationTimestamp, _that.getValuationTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.customBasketCode, _that.getCustomBasketCode())) {
                return false;
            }
            if (!ListEquals.listEquals(this.basketConstituents, _that.getBasketConstituents())) {
                return false;
            }
            if (!ListEquals.listEquals(this.otherPayment, _that.getOtherPayment())) {
                return false;
            }
            if (!Objects.equals(this.leg1, _that.getLeg1())) {
                return false;
            }
            return Objects.equals(this.leg2, _that.getLeg2());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.earlyTerminationDate != null ? this.earlyTerminationDate.hashCode() : 0);
            _result = 31 * _result + (this.reportingTimestamp != null ? this.reportingTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.executionTimestamp != null ? this.executionTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.expirationDate != null ? this.expirationDate.hashCode() : 0);
            _result = 31 * _result + (this.counterparty1 != null ? this.counterparty1.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2 != null ? this.counterparty2.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2IdentifierType != null ? this.counterparty2IdentifierType.hashCode() : 0);
            _result = 31 * _result + (this.beneficiary1 != null ? this.beneficiary1.hashCode() : 0);
            _result = 31 * _result + (this.beneficiary1IdentifierTypeIndicator != null ? this.beneficiary1IdentifierTypeIndicator.hashCode() : 0);
            _result = 31 * _result + (this.buyerIdentifier != null ? this.buyerIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.sellerIdentifier != null ? this.sellerIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.cleared != null ? ((Object)((Object)this.cleared)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.centralCounterparty != null ? this.centralCounterparty.hashCode() : 0);
            _result = 31 * _result + (this.clearingMember != null ? this.clearingMember.hashCode() : 0);
            _result = 31 * _result + (this.confirmed != null ? ((Object)((Object)this.confirmed)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.callAmount != null ? this.callAmount.hashCode() : 0);
            _result = 31 * _result + (this.putAmount != null ? this.putAmount.hashCode() : 0);
            _result = 31 * _result + (this.callCurrency != null ? this.callCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.putCurrency != null ? this.putCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.delta != null ? this.delta.hashCode() : 0);
            _result = 31 * _result + (this.priceSchedule != null ? this.priceSchedule.hashCode() : 0);
            _result = 31 * _result + (this.strikePriceSchedule != null ? this.strikePriceSchedule.hashCode() : 0);
            _result = 31 * _result + (this.price != null ? this.price.hashCode() : 0);
            _result = 31 * _result + (this.priceNotation != null ? ((Object)((Object)this.priceNotation)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.priceCurrency != null ? this.priceCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.packageTransactionPrice != null ? this.packageTransactionPrice.hashCode() : 0);
            _result = 31 * _result + (this.packageTransactionPriceNotation != null ? ((Object)((Object)this.packageTransactionPriceNotation)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.packageTransactionPriceCurrency != null ? this.packageTransactionPriceCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.packageTransactionSpread != null ? this.packageTransactionSpread.hashCode() : 0);
            _result = 31 * _result + (this.packageTransactionSpreadNotation != null ? ((Object)((Object)this.packageTransactionSpreadNotation)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.packageTransactionSpreadCurrency != null ? this.packageTransactionSpreadCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.packageIdentifier != null ? this.packageIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.strikePrice != null ? this.strikePrice.hashCode() : 0);
            _result = 31 * _result + (this.strikePriceNotation != null ? ((Object)((Object)this.strikePriceNotation)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.strikePriceCurrency != null ? this.strikePriceCurrency.hashCode() : 0);
            _result = 31 * _result + (this.priceUnitOfMeasure != null ? this.priceUnitOfMeasure.hashCode() : 0);
            _result = 31 * _result + (this.optionPremiumAmount != null ? this.optionPremiumAmount.hashCode() : 0);
            _result = 31 * _result + (this.optionPremiumCurrency != null ? this.optionPremiumCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.optionPremiumPaymentDate != null ? this.optionPremiumPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.exchangeRate != null ? this.exchangeRate.hashCode() : 0);
            _result = 31 * _result + (this.exchangeRateBasis != null ? this.exchangeRateBasis.hashCode() : 0);
            _result = 31 * _result + (this.cdSIndexAttachmentPoint != null ? this.cdSIndexAttachmentPoint.hashCode() : 0);
            _result = 31 * _result + (this.cdSIndexDetachmentPoint != null ? this.cdSIndexDetachmentPoint.hashCode() : 0);
            _result = 31 * _result + (this.collateralPortfolioIndicator != null ? this.collateralPortfolioIndicator.hashCode() : 0);
            _result = 31 * _result + (this.firstExerciseDate != null ? this.firstExerciseDate.hashCode() : 0);
            _result = 31 * _result + (this.finalContractualSettlementDate != null ? this.finalContractualSettlementDate.hashCode() : 0);
            _result = 31 * _result + (this.settlementLocation != null ? this.settlementLocation.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.priorUTI != null ? this.priorUTI.hashCode() : 0);
            _result = 31 * _result + (this.direction1 != null ? ((Object)((Object)this.direction1)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.valuationAmount != null ? this.valuationAmount.hashCode() : 0);
            _result = 31 * _result + (this.valuationCurrency != null ? this.valuationCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.valuationMethod != null ? ((Object)((Object)this.valuationMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.valuationTimestamp != null ? this.valuationTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.customBasketCode != null ? this.customBasketCode.hashCode() : 0);
            _result = 31 * _result + (this.basketConstituents != null ? this.basketConstituents.hashCode() : 0);
            _result = 31 * _result + (this.otherPayment != null ? this.otherPayment.hashCode() : 0);
            _result = 31 * _result + (this.leg1 != null ? this.leg1.hashCode() : 0);
            _result = 31 * _result + (this.leg2 != null ? this.leg2.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CriticalDataElementV1 {effectiveDate=" + String.valueOf(this.effectiveDate) + ", earlyTerminationDate=" + String.valueOf(this.earlyTerminationDate) + ", reportingTimestamp=" + String.valueOf(this.reportingTimestamp) + ", executionTimestamp=" + String.valueOf(this.executionTimestamp) + ", expirationDate=" + String.valueOf(this.expirationDate) + ", counterparty1=" + this.counterparty1 + ", counterparty2=" + this.counterparty2 + ", counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", beneficiary1=" + this.beneficiary1 + ", beneficiary1IdentifierTypeIndicator=" + this.beneficiary1IdentifierTypeIndicator + ", buyerIdentifier=" + this.buyerIdentifier + ", sellerIdentifier=" + this.sellerIdentifier + ", cleared=" + String.valueOf((Object)this.cleared) + ", centralCounterparty=" + this.centralCounterparty + ", clearingMember=" + this.clearingMember + ", confirmed=" + String.valueOf((Object)this.confirmed) + ", callAmount=" + String.valueOf(this.callAmount) + ", putAmount=" + String.valueOf(this.putAmount) + ", callCurrency=" + String.valueOf(this.callCurrency) + ", putCurrency=" + String.valueOf(this.putCurrency) + ", delta=" + String.valueOf(this.delta) + ", priceSchedule=" + String.valueOf(this.priceSchedule) + ", strikePriceSchedule=" + String.valueOf(this.strikePriceSchedule) + ", price=" + String.valueOf(this.price) + ", priceNotation=" + String.valueOf((Object)this.priceNotation) + ", priceCurrency=" + String.valueOf(this.priceCurrency) + ", packageTransactionPrice=" + String.valueOf(this.packageTransactionPrice) + ", packageTransactionPriceNotation=" + String.valueOf((Object)this.packageTransactionPriceNotation) + ", packageTransactionPriceCurrency=" + String.valueOf(this.packageTransactionPriceCurrency) + ", packageTransactionSpread=" + String.valueOf(this.packageTransactionSpread) + ", packageTransactionSpreadNotation=" + String.valueOf((Object)this.packageTransactionSpreadNotation) + ", packageTransactionSpreadCurrency=" + String.valueOf(this.packageTransactionSpreadCurrency) + ", packageIdentifier=" + this.packageIdentifier + ", strikePrice=" + String.valueOf(this.strikePrice) + ", strikePriceNotation=" + String.valueOf((Object)this.strikePriceNotation) + ", strikePriceCurrency=" + this.strikePriceCurrency + ", priceUnitOfMeasure=" + this.priceUnitOfMeasure + ", optionPremiumAmount=" + String.valueOf(this.optionPremiumAmount) + ", optionPremiumCurrency=" + String.valueOf(this.optionPremiumCurrency) + ", optionPremiumPaymentDate=" + String.valueOf(this.optionPremiumPaymentDate) + ", exchangeRate=" + String.valueOf(this.exchangeRate) + ", exchangeRateBasis=" + this.exchangeRateBasis + ", cdSIndexAttachmentPoint=" + String.valueOf(this.cdSIndexAttachmentPoint) + ", cdSIndexDetachmentPoint=" + String.valueOf(this.cdSIndexDetachmentPoint) + ", collateralPortfolioIndicator=" + this.collateralPortfolioIndicator + ", firstExerciseDate=" + String.valueOf(this.firstExerciseDate) + ", finalContractualSettlementDate=" + String.valueOf(this.finalContractualSettlementDate) + ", settlementLocation=" + String.valueOf(this.settlementLocation) + ", priorUTI=" + this.priorUTI + ", direction1=" + String.valueOf((Object)this.direction1) + ", valuationAmount=" + String.valueOf(this.valuationAmount) + ", valuationCurrency=" + String.valueOf(this.valuationCurrency) + ", valuationMethod=" + String.valueOf((Object)this.valuationMethod) + ", valuationTimestamp=" + String.valueOf(this.valuationTimestamp) + ", customBasketCode=" + this.customBasketCode + ", basketConstituents=" + String.valueOf(this.basketConstituents) + ", otherPayment=" + String.valueOf(this.otherPayment) + ", leg1=" + String.valueOf(this.leg1) + ", leg2=" + String.valueOf(this.leg2) + "}";
        }
    }
}

