/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.valuation.functions;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.event.common.Valuation;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.standards.iso.functions.ConvertNonISOToISOCurrency;
import javax.inject.Inject;

@ImplementedBy(value=ValuationCurrencyFromValuationDefault.class)
public abstract class ValuationCurrencyFromValuation
implements RosettaFunction {
    @Inject
    protected ConvertNonISOToISOCurrency convertNonISOToISOCurrency;

    public ISOCurrencyCodeEnum evaluate(Valuation valuation) {
        ISOCurrencyCodeEnum valuationCurrency = this.doEvaluate(valuation);
        return valuationCurrency;
    }

    protected abstract ISOCurrencyCodeEnum doEvaluate(Valuation var1);

    public static class ValuationCurrencyFromValuationDefault
    extends ValuationCurrencyFromValuation {
        @Override
        protected ISOCurrencyCodeEnum doEvaluate(Valuation valuation) {
            ISOCurrencyCodeEnum valuationCurrency = null;
            return this.assignOutput(valuationCurrency, valuation);
        }

        protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum valuationCurrency, Valuation valuation) {
            MapperS thenArg = MapperS.of((Object)valuation).map("getAmount", _valuation -> _valuation.getAmount()).map("getUnit", money -> money.getUnit()).map("getCurrency", unitType -> unitType.getCurrency());
            valuationCurrency = (ISOCurrencyCodeEnum)thenArg.mapSingleToItem(item -> {
                FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)item.get();
                return MapperS.of((Object)this.convertNonISOToISOCurrency.evaluate(fieldWithMetaString == null ? null : fieldWithMetaString.getValue()));
            }).get();
            return valuationCurrency;
        }
    }
}

