/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version2.payment.functions;

import cdm.event.common.Transfer;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import drr.base.trade.ReportableEventBase;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=OptionPremiumOnEventDateDefault.class)
public abstract class OptionPremiumOnEventDate
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected drr.standards.iosco.cde.version1.payment.functions.OptionPremiumOnEventDate optionPremiumOnEventDate;

    public Transfer evaluate(ReportableEventBase reportableEvent) {
        Transfer optionPremium;
        Transfer.TransferBuilder optionPremiumBuilder = this.doEvaluate(reportableEvent);
        if (optionPremiumBuilder == null) {
            optionPremium = null;
        } else {
            optionPremium = optionPremiumBuilder.build();
            this.objectValidator.validate(Transfer.class, (RosettaModelObject)optionPremium);
        }
        return optionPremium;
    }

    protected abstract Transfer.TransferBuilder doEvaluate(ReportableEventBase var1);

    public static class OptionPremiumOnEventDateDefault
    extends OptionPremiumOnEventDate {
        @Override
        protected Transfer.TransferBuilder doEvaluate(ReportableEventBase reportableEvent) {
            Transfer.TransferBuilder optionPremium = Transfer.builder();
            return this.assignOutput(optionPremium, reportableEvent);
        }

        protected Transfer.TransferBuilder assignOutput(Transfer.TransferBuilder optionPremium, ReportableEventBase reportableEvent) {
            optionPremium = (Transfer.TransferBuilder)this.toBuilder((RosettaModelObject)this.optionPremiumOnEventDate.evaluate(reportableEvent));
            return Optional.ofNullable(optionPremium).map(o -> o.prune()).orElse(null);
        }
    }
}

