/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.model;

import com.regnosys.rosetta.common.model.FunctionMemoisingModule;
import com.rosetta.model.lib.functions.RosettaFunction;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FunctionMemoisingModuleBuilder {
    public static final String DEBUG_FUNCTION_ENV_PREFIX = "DEBUG_ROSETTA_FUNCTION_";
    private final Set<String> packages = new HashSet<String>();
    private final Set<String> debugFunctions = new HashSet<String>();

    public FunctionMemoisingModuleBuilder setPackages(String ... packages) {
        this.packages.addAll(Arrays.asList(packages));
        return this;
    }

    public FunctionMemoisingModuleBuilder setDebugLoggingFunctions(Class<? extends RosettaFunction> ... debugFunctions) {
        Arrays.stream(debugFunctions).map(Class::getSimpleName).map(String::toUpperCase).forEach(this.debugFunctions::add);
        return this;
    }

    public FunctionMemoisingModuleBuilder setFromMap(Map<String, String> map) {
        map.entrySet().stream().filter(x -> ((String)x.getKey()).toUpperCase().startsWith(DEBUG_FUNCTION_ENV_PREFIX)).map(x -> new AbstractMap.SimpleEntry<String, Boolean>(((String)x.getKey()).toUpperCase().replace(DEBUG_FUNCTION_ENV_PREFIX, ""), Boolean.parseBoolean((String)x.getValue()))).forEach(e -> {
            if (Boolean.TRUE.equals(e.getValue())) {
                this.debugFunctions.add((String)e.getKey());
            } else {
                this.debugFunctions.remove(e.getKey());
            }
        });
        return this;
    }

    public FunctionMemoisingModuleBuilder setFromEnvironment() {
        this.setFromMap(System.getenv());
        return this;
    }

    public FunctionMemoisingModule build() {
        return new FunctionMemoisingModule(this.packages, this.debugFunctions);
    }
}

