/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.serialisation.reportdata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.regnosys.rosetta.common.reports.RegReportPaths;
import com.regnosys.rosetta.common.serialisation.InputDataLoader;
import com.regnosys.rosetta.common.serialisation.JsonDataLoaderUtil;
import com.regnosys.rosetta.common.serialisation.reportdata.ExpectedResult;
import com.regnosys.rosetta.common.serialisation.reportdata.ExpectedResultField;
import com.regnosys.rosetta.common.serialisation.reportdata.ReportDataItem;
import com.regnosys.rosetta.common.serialisation.reportdata.ReportDataSet;
import com.regnosys.rosetta.common.serialisation.reportdata.ReportIdentifierDataSet;
import com.regnosys.rosetta.common.util.UrlUtils;
import com.rosetta.model.lib.ModelReportId;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Deprecated
public class JsonExpectedResultLoader
implements InputDataLoader<ReportIdentifierDataSet> {
    private final ClassLoader classLoader;
    private final ObjectMapper rosettaObjectMapper;
    private final URL outputPath;

    public JsonExpectedResultLoader(ClassLoader classLoader, ObjectMapper rosettaObjectMapper, URL outputPath) {
        this.classLoader = classLoader;
        this.rosettaObjectMapper = rosettaObjectMapper;
        this.outputPath = outputPath;
    }

    @Override
    public ReportIdentifierDataSet loadInputFiles(ReportIdentifierDataSet descriptor) {
        ArrayList<ReportDataItem> loadedData = new ArrayList<ReportDataItem>();
        ReportDataSet dataSet = descriptor.getDataSet();
        for (ReportDataItem data : dataSet.getData()) {
            ReportDataItem reportDataItem = new ReportDataItem(data.getName(), data.getInput(), this.getExpected(descriptor.getReportIdentifier(), dataSet.getDataSetName(), dataSet.getExpectedType(), data));
            loadedData.add(reportDataItem);
        }
        return new ReportIdentifierDataSet(descriptor.getReportIdentifier(), new ReportDataSet(dataSet.getDataSetName(), dataSet.getInputType(), dataSet.getApplicableReports(), loadedData));
    }

    private Object getExpected(ModelReportId reportIdentifier, String dataSetName, String expectedType, ReportDataItem data) {
        if (data.getInput() instanceof String) {
            Path inputFileName = Paths.get(String.valueOf(data.getInput()), new String[0]);
            URL keyValueExpectationUrl = null;
            Path keyValueExpectationPath = RegReportPaths.getKeyValueExpectationFilePath(UrlUtils.toPath(this.outputPath), reportIdentifier, dataSetName, inputFileName);
            if (Files.exists(keyValueExpectationPath, new LinkOption[0])) {
                keyValueExpectationUrl = UrlUtils.toUrl(keyValueExpectationPath);
            } else {
                Path legacyKeyValueExpectationPath = RegReportPaths.getLegacyKeyValueExpectationFilePath(UrlUtils.toPath(this.outputPath), reportIdentifier, dataSetName, inputFileName);
                if (Files.exists(legacyKeyValueExpectationPath, new LinkOption[0])) {
                    keyValueExpectationUrl = UrlUtils.toUrl(legacyKeyValueExpectationPath);
                }
            }
            if (keyValueExpectationUrl != null) {
                List<ExpectedResultField> resultFields = JsonDataLoaderUtil.readTypeList(ExpectedResultField.class, this.rosettaObjectMapper, keyValueExpectationUrl);
                ExpectedResult expectedResult = data.getExpected() == null ? new ExpectedResult(new HashMap<ModelReportId, List<ExpectedResultField>>()) : JsonDataLoaderUtil.fromObject(data.getExpected(), ExpectedResult.class, this.rosettaObjectMapper);
                expectedResult.getExpectationsPerReport().put(reportIdentifier, resultFields);
                return expectedResult;
            }
        }
        if (data.getExpected() == null) {
            return null;
        }
        Class<?> expectedTypeClass = JsonDataLoaderUtil.loadClass(expectedType, this.classLoader);
        if (data.getExpected() instanceof String) {
            String expectedFileName = (String)data.getExpected();
            URL expectedUrl = UrlUtils.resolve(this.outputPath, expectedFileName);
            return JsonDataLoaderUtil.readType(expectedTypeClass, this.rosettaObjectMapper, expectedUrl);
        }
        return JsonDataLoaderUtil.fromObject(data.getExpected(), expectedTypeClass, this.rosettaObjectMapper);
    }
}

