/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.validation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.rosetta.lib.postprocess.PostProcessorReport;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.validation.ValidationResult;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationReport
implements PostProcessorReport,
Processor.Report {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidationReport.class);
    @JsonProperty
    private final List<ValidationResult<?>> validationResults;
    @JsonIgnore
    private final RosettaModelObject resultObject;

    public ValidationReport(RosettaModelObject resultObject, List<ValidationResult<?>> validationResults) {
        this.resultObject = resultObject;
        validationResults.sort(Comparator.comparing(ValidationResult::isSuccess, Boolean::compare));
        this.validationResults = validationResults;
    }

    @JsonProperty
    public boolean success() {
        return !this.failure();
    }

    public List<ValidationResult<?>> validationFailures() {
        return this.validationResults.stream().filter(r -> !r.isSuccess()).collect(Collectors.toList());
    }

    public List<ValidationResult<?>> results() {
        return this.validationResults;
    }

    public void logReport() {
        if (LOGGER.isDebugEnabled()) {
            for (ValidationResult<?> validationResult : this.validationResults) {
                if (!validationResult.isSuccess()) {
                    LOGGER.debug(validationResult.toString());
                    continue;
                }
                if (!LOGGER.isTraceEnabled()) continue;
                LOGGER.trace(validationResult.toString());
            }
        }
    }

    private boolean failure() {
        return !this.validationFailures().isEmpty();
    }

    public List<ValidationResult<?>> getValidationResults() {
        return this.validationResults;
    }

    public RosettaModelObject getResultObject() {
        return this.resultObject;
    }
}

