package drr.base.qualification.product.functions;

import cdm.product.template.FixedPricePayout;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.functions.EconomicTermsForProduct;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(IsCommodityFixedPriceForward.IsCommodityFixedPriceForwardDefault.class)
public abstract class IsCommodityFixedPriceForward implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected IsCommodityForward isCommodityForward;

	/**
	* @param product 
	* @return result 
	*/
	public Boolean evaluate(Product product) {
		Boolean result = doEvaluate(product);
		
		return result;
	}

	protected abstract Boolean doEvaluate(Product product);

	public static class IsCommodityFixedPriceForwardDefault extends IsCommodityFixedPriceForward {
		@Override
		protected Boolean doEvaluate(Product product) {
			Boolean result = null;
			return assignOutput(result, product);
		}
		
		protected Boolean assignOutput(Boolean result, Product product) {
			result = areEqual(MapperS.of(isCommodityForward.evaluate(product)), MapperS.of(true), CardinalityOperator.All).and(exists(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<FixedPricePayout>mapC("getFixedPricePayout", payout -> payout.getFixedPricePayout()))).get();
			
			return result;
		}
	}
}
