package drr.base.trade.basket.functions;

import cdm.base.math.CapacityUnitEnum;
import cdm.base.math.FinancialUnitEnum;
import cdm.base.math.UnitType;
import cdm.base.math.WeatherUnitEnum;
import cdm.base.staticdata.asset.common.Commodity;
import cdm.base.staticdata.asset.common.Index;
import cdm.base.staticdata.asset.common.Loan;
import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.base.staticdata.asset.common.Security;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaCommodity;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaProductIdentifier;
import cdm.event.common.Trade;
import cdm.product.asset.BasketReferenceInformation;
import cdm.product.asset.CommodityPayout;
import cdm.product.asset.CreditDefaultPayout;
import cdm.product.asset.GeneralTerms;
import cdm.product.asset.ReferenceObligation;
import cdm.product.asset.ReferencePair;
import cdm.product.asset.ReferencePool;
import cdm.product.asset.ReferencePoolItem;
import cdm.product.template.Basket;
import cdm.product.template.ForwardPayout;
import cdm.product.template.OptionPayout;
import cdm.product.template.Payout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import cdm.product.template.TradableProduct;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.base.trade.basket.BasketConstituentsReport;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.functions.ProductForTrade;
import drr.base.trade.underlier.functions.FilterProductIdentifier;
import drr.standards.iso.functions.CapacityUnitToISO20022UnitOfMeasure;
import drr.standards.iso.functions.FinancialUnitToISO20022UnitOfMeasure;
import drr.standards.iso.functions.WeatherUnitToISO20022UnitOfMeasure;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(GetBasketConstituents.GetBasketConstituentsDefault.class)
public abstract class GetBasketConstituents implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected CapacityUnitToISO20022UnitOfMeasure capacityUnitToISO20022UnitOfMeasure;
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected FilterProductIdentifier filterProductIdentifier;
	@Inject protected FinancialUnitToISO20022UnitOfMeasure financialUnitToISO20022UnitOfMeasure;
	@Inject protected GetBasket getBasket;
	@Inject protected GetQuantityForConstituent getQuantityForConstituent;
	@Inject protected GetQuantityForReferencePoolItem getQuantityForReferencePoolItem;
	@Inject protected ProductForTrade productForTrade;
	@Inject protected WeatherUnitToISO20022UnitOfMeasure weatherUnitToISO20022UnitOfMeasure;

	/**
	* @param trade 
	* @return result Single product identifier per basket constituent.
	*/
	public List<? extends BasketConstituentsReport> evaluate(Trade trade) {
		List<BasketConstituentsReport.BasketConstituentsReportBuilder> resultBuilder = doEvaluate(trade);
		
		final List<? extends BasketConstituentsReport> result;
		if (resultBuilder == null) {
			result = null;
		} else {
			result = resultBuilder.stream().map(BasketConstituentsReport::build).collect(Collectors.toList());
			objectValidator.validate(BasketConstituentsReport.class, result);
		}
		
		return result;
	}

	protected abstract List<BasketConstituentsReport.BasketConstituentsReportBuilder> doEvaluate(Trade trade);

	protected abstract MapperC<? extends Product> underliers(Trade trade);

	protected abstract MapperC<? extends TradeLot> tradeLots(Trade trade);

	protected abstract MapperC<? extends ReferencePoolItem> referencePoolItems(Trade trade);

	public static class GetBasketConstituentsDefault extends GetBasketConstituents {
		@Override
		protected List<BasketConstituentsReport.BasketConstituentsReportBuilder> doEvaluate(Trade trade) {
			List<BasketConstituentsReport.BasketConstituentsReportBuilder> result = new ArrayList<>();
			return assignOutput(result, trade);
		}
		
		protected List<BasketConstituentsReport.BasketConstituentsReportBuilder> assignOutput(List<BasketConstituentsReport.BasketConstituentsReportBuilder> result, Trade trade) {
			final MapperC<Basket> thenArg0 = underliers(trade).<Basket>map("getBasket", product -> product.getBasket());
			final MapperListOfLists<Product> thenArg1 = thenArg0
				.mapItemToList(item -> MapperC.<Product>of(getBasket.evaluate(item.get())));
			final MapperC<Product> thenArg2 = thenArg1
				.flattenList();
			final MapperListOfLists<ReferenceWithMetaProductIdentifier> thenArg3 = thenArg2
				.mapItemToList(item -> {
					if (exists(item.<Security>map("getSecurity", product -> product.getSecurity())).getOrDefault(false)) {
						return item.<Security>map("getSecurity", product -> product.getSecurity()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", security -> security.getProductIdentifier());
					}
					if (exists(item.<Loan>map("getLoan", product -> product.getLoan())).getOrDefault(false)) {
						return item.<Loan>map("getLoan", product -> product.getLoan()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", loan -> loan.getProductIdentifier());
					}
					if (exists(item.<ReferenceWithMetaCommodity>map("getCommodity", product -> product.getCommodity())).getOrDefault(false)) {
						return item.<ReferenceWithMetaCommodity>map("getCommodity", product -> product.getCommodity()).<Commodity>map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity == null ? null : referenceWithMetaCommodity.getValue()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier());
					}
					if (exists(item.<Index>map("getIndex", product -> product.getIndex())).getOrDefault(false)) {
						return item.<Index>map("getIndex", product -> product.getIndex()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", index -> index.getProductIdentifier());
					}
					return MapperC.<ReferenceWithMetaProductIdentifier>ofNull();
				});
			final MapperC<ProductIdentifier> thenArg4 = thenArg3
				.mapListToItem(item -> {
					final ReferenceWithMetaProductIdentifier referenceWithMetaProductIdentifier = item.get();
					return MapperS.of(MapperS.of(filterProductIdentifier.evaluate(item.<ProductIdentifier>map("Type coercion", _referenceWithMetaProductIdentifier -> _referenceWithMetaProductIdentifier.getValue()).getMulti(), ProductIdTypeEnum.ISIN)).getOrDefault((referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue())));
				});
			result.addAll(toBuilder(thenArg4
				.mapItem(item -> {
					final FieldWithMetaString fieldWithMetaString0 = item.<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).get();
					final FieldWithMetaString fieldWithMetaString1 = item.<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).get();
					final FieldWithMetaString fieldWithMetaString2 = item.<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).get();
					final MapperS<UnitType> thenArg = MapperS.of(getQuantityForConstituent.evaluate((fieldWithMetaString2 == null ? null : fieldWithMetaString2.getValue()), tradeLots(trade).getMulti())).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit());
					return MapperS.of(BasketConstituentsReport.builder()
						.setIdentifier((fieldWithMetaString0 == null ? null : fieldWithMetaString0.getValue()))
						.setSource(item.<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()).get())
						.setNumberOfUnits(MapperS.of(getQuantityForConstituent.evaluate((fieldWithMetaString1 == null ? null : fieldWithMetaString1.getValue()), tradeLots(trade).getMulti())).<BigDecimal>map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()).get())
						.setUnitOfMeasure(thenArg
							.mapSingleToItem(_item -> {
								if (exists(_item.<CapacityUnitEnum>map("getCapacityUnit", unitType -> unitType.getCapacityUnit())).getOrDefault(false)) {
									return MapperS.of(capacityUnitToISO20022UnitOfMeasure.evaluate(_item.<CapacityUnitEnum>map("getCapacityUnit", unitType -> unitType.getCapacityUnit()).get()));
								}
								if (exists(_item.<WeatherUnitEnum>map("getWeatherUnit", unitType -> unitType.getWeatherUnit())).getOrDefault(false)) {
									return MapperS.of(weatherUnitToISO20022UnitOfMeasure.evaluate(_item.<WeatherUnitEnum>map("getWeatherUnit", unitType -> unitType.getWeatherUnit()).get()));
								}
								if (exists(_item.<FinancialUnitEnum>map("getFinancialUnit", unitType -> unitType.getFinancialUnit())).getOrDefault(false)) {
									return MapperS.of(financialUnitToISO20022UnitOfMeasure.evaluate(_item.<FinancialUnitEnum>map("getFinancialUnit", unitType -> unitType.getFinancialUnit()).get()));
								}
								return MapperS.<String>ofNull();
							}).get())
						.build());
				}).getMulti()));
			
			final MapperC<? extends ReferencePoolItem> thenArg5 = referencePoolItems(trade);
			final MapperListOfLists<ReferenceWithMetaProductIdentifier> thenArg6 = thenArg5
				.mapItemToList(item -> {
					if (exists(item.<ReferencePair>map("getReferencePair", referencePoolItem -> referencePoolItem.getReferencePair()).<ReferenceObligation>map("getReferenceObligation", referencePair -> referencePair.getReferenceObligation()).<Security>map("getSecurity", referenceObligation -> referenceObligation.getSecurity())).getOrDefault(false)) {
						return item.<ReferencePair>map("getReferencePair", referencePoolItem -> referencePoolItem.getReferencePair()).<ReferenceObligation>map("getReferenceObligation", referencePair -> referencePair.getReferenceObligation()).<Security>map("getSecurity", referenceObligation -> referenceObligation.getSecurity()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", security -> security.getProductIdentifier());
					}
					if (exists(item.<ReferencePair>map("getReferencePair", referencePoolItem -> referencePoolItem.getReferencePair()).<ReferenceObligation>map("getReferenceObligation", referencePair -> referencePair.getReferenceObligation()).<Loan>map("getLoan", referenceObligation -> referenceObligation.getLoan())).getOrDefault(false)) {
						return item.<ReferencePair>map("getReferencePair", referencePoolItem -> referencePoolItem.getReferencePair()).<ReferenceObligation>map("getReferenceObligation", referencePair -> referencePair.getReferenceObligation()).<Loan>map("getLoan", referenceObligation -> referenceObligation.getLoan()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", loan -> loan.getProductIdentifier());
					}
					return MapperC.<ReferenceWithMetaProductIdentifier>ofNull();
				});
			result.addAll(toBuilder(thenArg6
				.mapListToItem(item -> {
					final FieldWithMetaString fieldWithMetaString = MapperS.of(filterProductIdentifier.evaluate(item.<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).getMulti(), ProductIdTypeEnum.ISIN)).<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).getOrDefault(item.<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).get());
					final MapperS<UnitType> thenArg = MapperS.of(getQuantityForReferencePoolItem.evaluate(referencePoolItems(trade).get())).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit());
					return MapperS.of(BasketConstituentsReport.builder()
						.setIdentifier((fieldWithMetaString == null ? null : fieldWithMetaString.getValue()))
						.setSource(MapperS.of(filterProductIdentifier.evaluate(item.<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).getMulti(), ProductIdTypeEnum.ISIN)).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()).getOrDefault(item.<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()).get()))
						.setNumberOfUnits(MapperS.of(getQuantityForReferencePoolItem.evaluate(referencePoolItems(trade).get())).<BigDecimal>map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()).get())
						.setUnitOfMeasure(thenArg
							.mapSingleToItem(_item -> {
								if (exists(_item.<CapacityUnitEnum>map("getCapacityUnit", unitType -> unitType.getCapacityUnit())).getOrDefault(false)) {
									return MapperS.of(capacityUnitToISO20022UnitOfMeasure.evaluate(_item.<CapacityUnitEnum>map("getCapacityUnit", unitType -> unitType.getCapacityUnit()).get()));
								}
								if (exists(_item.<WeatherUnitEnum>map("getWeatherUnit", unitType -> unitType.getWeatherUnit())).getOrDefault(false)) {
									return MapperS.of(weatherUnitToISO20022UnitOfMeasure.evaluate(_item.<WeatherUnitEnum>map("getWeatherUnit", unitType -> unitType.getWeatherUnit()).get()));
								}
								if (exists(_item.<FinancialUnitEnum>map("getFinancialUnit", unitType -> unitType.getFinancialUnit())).getOrDefault(false)) {
									return MapperS.of(financialUnitToISO20022UnitOfMeasure.evaluate(_item.<FinancialUnitEnum>map("getFinancialUnit", unitType -> unitType.getFinancialUnit()).get()));
								}
								return MapperS.<String>ofNull();
							}).get())
						.build());
				}).getMulti()));
			
			return Optional.ofNullable(result)
				.map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList()))
				.orElse(null);
		}
		
		@Override
		protected MapperC<? extends Product> underliers(Trade trade) {
			final MapperS<Payout> thenArg = MapperS.of(economicTermsForProduct.evaluate(productForTrade.evaluate(trade))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout());
			final MapperC<Product> ifThenElseResult;
			if (exists(thenArg.<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout())).getOrDefault(false)) {
				ifThenElseResult = MapperC.of(MapperS.of(thenArg.<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get()).<Product>map("getUnderlier", optionPayout -> optionPayout.getUnderlier()));
			} else if (exists(thenArg.<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout())).getOrDefault(false)) {
				ifThenElseResult = MapperC.of(MapperS.of(thenArg.<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).get()).<Product>map("getUnderlier", forwardPayout -> forwardPayout.getUnderlier()));
			} else if (exists(thenArg.<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout())).getOrDefault(false)) {
				ifThenElseResult = thenArg.<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).<Product>map("getUnderlier", performancePayout -> performancePayout.getUnderlier());
			} else if (exists(thenArg.<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout())).getOrDefault(false)) {
				ifThenElseResult = thenArg.<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier());
			} else {
				ifThenElseResult = MapperC.<Product>ofNull();
			}
			return ifThenElseResult;
		}
		
		@Override
		protected MapperC<? extends TradeLot> tradeLots(Trade trade) {
			return MapperS.of(trade).<TradableProduct>map("getTradableProduct", _trade -> _trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot());
		}
		
		@Override
		protected MapperC<? extends ReferencePoolItem> referencePoolItems(Trade trade) {
			if (exists(MapperS.of(economicTermsForProduct.evaluate(productForTrade.evaluate(trade))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<BasketReferenceInformation>map("getBasketReferenceInformation", generalTerms -> generalTerms.getBasketReferenceInformation()).<ReferencePool>map("getReferencePool", basketReferenceInformation -> basketReferenceInformation.getReferencePool()).<ReferencePoolItem>mapC("getReferencePoolItem", referencePool -> referencePool.getReferencePoolItem()).<ReferencePair>map("getReferencePair", referencePoolItem -> referencePoolItem.getReferencePair()).<ReferenceObligation>map("getReferenceObligation", referencePair -> referencePair.getReferenceObligation())).getOrDefault(false)) {
				return MapperS.of(economicTermsForProduct.evaluate(productForTrade.evaluate(trade))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).<GeneralTerms>map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).<BasketReferenceInformation>map("getBasketReferenceInformation", generalTerms -> generalTerms.getBasketReferenceInformation()).<ReferencePool>map("getReferencePool", basketReferenceInformation -> basketReferenceInformation.getReferencePool()).<ReferencePoolItem>mapC("getReferencePoolItem", referencePool -> referencePool.getReferencePoolItem());
			}
			return MapperC.<ReferencePoolItem>ofNull();
		}
	}
}
