package drr.base.trade.functions;

import cdm.product.asset.CommodityPayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;


@ImplementedBy(GetCommodityKey.GetCommodityKeyDefault.class)
public abstract class GetCommodityKey implements RosettaFunction {

	/**
	* @param commodityPayout 
	* @return key 
	*/
	public String evaluate(CommodityPayout commodityPayout) {
		String key = doEvaluate(commodityPayout);
		
		return key;
	}

	protected abstract String doEvaluate(CommodityPayout commodityPayout);

	public static class GetCommodityKeyDefault extends GetCommodityKey {
		@Override
		protected String doEvaluate(CommodityPayout commodityPayout) {
			String key = null;
			return assignOutput(key, commodityPayout);
		}
		
		protected String assignOutput(String key, CommodityPayout commodityPayout) {
			return key;
		}
	}
}
