package drr.base.util.datetime.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.base.util.datetime.ValuePeriod;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class ValuePeriodTypeFormatValidator implements Validator<ValuePeriod> {

	private List<ComparisonResult> getComparisonResults(ValuePeriod o) {
		return Lists.<ComparisonResult>newArrayList(
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, ValuePeriod o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("ValuePeriod", ValidationResult.ValidationType.TYPE_FORMAT, "ValuePeriod", path, "", res.getError());
				}
				return success("ValuePeriod", ValidationResult.ValidationType.TYPE_FORMAT, "ValuePeriod", path, "");
			})
			.collect(toList());
	}

}
