package drr.projection.dtcc.rds.harmonized.sec.rewrite.trade.functions;

import cdm.base.staticdata.asset.common.AssetClassEnum;
import cdm.base.staticdata.asset.common.ISOCountryCodeEnum;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.base.staticdata.party.PartyIdentifierTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.base.trade.price.PriceFormat;
import drr.base.trade.price.PriceNotationEnum;
import drr.base.trade.price.functions.NotationStringFromEnum;
import drr.base.util.string.functions.SubString;
import drr.regulation.common.AllocationIndicatorEnum;
import drr.regulation.common.ClearingAccountOriginEnum;
import drr.regulation.common.ClearingExceptionsAndExemptionsEnum;
import drr.regulation.common.JurisdictionEnum;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.common.trade.payment.CommonPeriodicPayment;
import drr.regulation.sec.rewrite.dtcc.DTCCAdditionalFields;
import drr.regulation.sec.rewrite.trade.SECTransactionReport;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.ClearedEnum;
import drr.standards.iso.EmbeddedOptionTypeEnum;
import drr.standards.iso.EventTypeEnum;
import drr.standards.iso.FrequencyPeriodEnum;
import drr.standards.iso.InterestComputationMethod4Code;
import iso20022.dtcc.rds.harmonized.HarmonizedData;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(Create_SubmissionHarmonizedData.Create_SubmissionHarmonizedDataDefault.class)
public abstract class Create_SubmissionHarmonizedData implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected NotationStringFromEnum notationStringFromEnum;
	@Inject protected SubString subString;

	/**
	* @param drrReport 
	* @return harmonized 
	*/
	public HarmonizedData evaluate(SECTransactionReport drrReport) {
		HarmonizedData.HarmonizedDataBuilder harmonizedBuilder = doEvaluate(drrReport);
		
		final HarmonizedData harmonized;
		if (harmonizedBuilder == null) {
			harmonized = null;
		} else {
			harmonized = harmonizedBuilder.build();
			objectValidator.validate(HarmonizedData.class, harmonized);
		}
		
		return harmonized;
	}

	protected abstract HarmonizedData.HarmonizedDataBuilder doEvaluate(SECTransactionReport drrReport);

	public static class Create_SubmissionHarmonizedDataDefault extends Create_SubmissionHarmonizedData {
		@Override
		protected HarmonizedData.HarmonizedDataBuilder doEvaluate(SECTransactionReport drrReport) {
			HarmonizedData.HarmonizedDataBuilder harmonized = HarmonizedData.builder();
			return assignOutput(harmonized, drrReport);
		}
		
		protected HarmonizedData.HarmonizedDataBuilder assignOutput(HarmonizedData.HarmonizedDataBuilder harmonized, SECTransactionReport drrReport) {
			final Integer integer0 = MapperS.of(drrReport).<CommonLeg>map("getLeg1", sECTransactionReport -> sECTransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<Integer>map("getFixedRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriodMultiplier()).get();
			final Integer integer1 = MapperS.of(drrReport).<CommonLeg>map("getLeg2", sECTransactionReport -> sECTransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<Integer>map("getFixedRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriodMultiplier()).get();
			final Integer integer2 = MapperS.of(drrReport).<CommonLeg>map("getLeg1", sECTransactionReport -> sECTransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<Integer>map("getFloatingRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRatePaymentFrequencyPeriodMultiplier()).get();
			final Integer integer3 = MapperS.of(drrReport).<CommonLeg>map("getLeg2", sECTransactionReport -> sECTransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<Integer>map("getFloatingRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRatePaymentFrequencyPeriodMultiplier()).get();
			final String ifThenElseResult0;
			if (exists(MapperS.of(drrReport).<String>map("getPlatformIdentifier", sECTransactionReport -> sECTransactionReport.getPlatformIdentifier())).getOrDefault(false)) {
				ifThenElseResult0 = MapperS.of(drrReport).<String>map("getPlatformIdentifier", sECTransactionReport -> sECTransactionReport.getPlatformIdentifier()).get();
			} else if (areEqual(MapperS.of(drrReport).<ClearedEnum>map("getCleared", sECTransactionReport -> sECTransactionReport.getCleared()), MapperS.of(ClearedEnum.N), CardinalityOperator.All).or(areEqual(MapperS.of(drrReport).<ClearedEnum>map("getCleared", sECTransactionReport -> sECTransactionReport.getCleared()), MapperS.of(ClearedEnum.I), CardinalityOperator.All)).getOrDefault(false)) {
				ifThenElseResult0 = "BILT";
			} else {
				ifThenElseResult0 = null;
			}
			final MapperS<PriceNotationEnum> thenArg0 = MapperS.of(drrReport).<PriceNotationEnum>map("getPriceNotation", sECTransactionReport -> sECTransactionReport.getPriceNotation());
			final MapperS<PriceNotationEnum> thenArg1 = MapperS.of(drrReport).<CommonLeg>map("getLeg1", sECTransactionReport -> sECTransactionReport.getLeg1()).<PriceNotationEnum>map("getSpreadNotation", commonLeg -> commonLeg.getSpreadNotation());
			final MapperS<PriceNotationEnum> thenArg2 = MapperS.of(drrReport).<CommonLeg>map("getLeg2", sECTransactionReport -> sECTransactionReport.getLeg2()).<PriceNotationEnum>map("getSpreadNotation", commonLeg -> commonLeg.getSpreadNotation());
			final MapperS<FrequencyPeriodEnum> thenArg3 = MapperS.of(drrReport).<CommonLeg>map("getLeg2", sECTransactionReport -> sECTransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<FrequencyPeriodEnum>map("getFloatingRateResetFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRateResetFrequencyPeriod());
			final MapperS<String> ifThenElseResult1;
			if (areEqual(thenArg3, MapperS.of(FrequencyPeriodEnum.DAIL), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult1 = MapperS.of("D");
			} else if (areEqual(thenArg3, MapperS.of(FrequencyPeriodEnum.WEEK), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult1 = MapperS.of("W");
			} else if (areEqual(thenArg3, MapperS.of(FrequencyPeriodEnum.MNTH), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult1 = MapperS.of("M");
			} else if (areEqual(thenArg3, MapperS.of(FrequencyPeriodEnum.YEAR), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult1 = MapperS.of("Y");
			} else if (areEqual(thenArg3, MapperS.of(FrequencyPeriodEnum.EXPI), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult1 = MapperS.of("T");
			} else {
				ifThenElseResult1 = thenArg3.map("to-string", FrequencyPeriodEnum::toDisplayString);
			}
			final Integer integer4 = MapperS.of(drrReport).<CommonLeg>map("getLeg2", sECTransactionReport -> sECTransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<Integer>map("getFloatingRateResetFrequencyMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRateResetFrequencyMultiplier()).get();
			final MapperS<FrequencyPeriodEnum> thenArg4 = MapperS.of(drrReport).<CommonLeg>map("getLeg1", sECTransactionReport -> sECTransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<FrequencyPeriodEnum>map("getFloatingRateResetFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRateResetFrequencyPeriod());
			final MapperS<String> ifThenElseResult2;
			if (areEqual(thenArg4, MapperS.of(FrequencyPeriodEnum.DAIL), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult2 = MapperS.of("D");
			} else if (areEqual(thenArg4, MapperS.of(FrequencyPeriodEnum.WEEK), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult2 = MapperS.of("W");
			} else if (areEqual(thenArg4, MapperS.of(FrequencyPeriodEnum.MNTH), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult2 = MapperS.of("M");
			} else if (areEqual(thenArg4, MapperS.of(FrequencyPeriodEnum.YEAR), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult2 = MapperS.of("Y");
			} else if (areEqual(thenArg4, MapperS.of(FrequencyPeriodEnum.EXPI), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult2 = MapperS.of("T");
			} else {
				ifThenElseResult2 = thenArg4.map("to-string", FrequencyPeriodEnum::toDisplayString);
			}
			final Integer integer5 = MapperS.of(drrReport).<CommonLeg>map("getLeg1", sECTransactionReport -> sECTransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<Integer>map("getFloatingRateResetFrequencyMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRateResetFrequencyMultiplier()).get();
			final BigDecimal ifThenElseResult3;
			if (areEqual(MapperS.of(drrReport).<PriceNotationEnum>map("getStrikePriceNotation", sECTransactionReport -> sECTransactionReport.getStrikePriceNotation()), MapperS.of(PriceNotationEnum.MONETARY), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult3 = MapperS.of(drrReport).<PriceFormat>map("getStrikePrice", sECTransactionReport -> sECTransactionReport.getStrikePrice()).<BigDecimal>map("getMonetary", priceFormat -> priceFormat.getMonetary()).get();
			} else if (areEqual(MapperS.of(drrReport).<PriceNotationEnum>map("getStrikePriceNotation", sECTransactionReport -> sECTransactionReport.getStrikePriceNotation()), MapperS.of(PriceNotationEnum.DECIMAL), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult3 = MapperS.of(drrReport).<PriceFormat>map("getStrikePrice", sECTransactionReport -> sECTransactionReport.getStrikePrice()).<BigDecimal>map("getDecimal", priceFormat -> priceFormat.getDecimal()).get();
			} else if (areEqual(MapperS.of(drrReport).<PriceNotationEnum>map("getStrikePriceNotation", sECTransactionReport -> sECTransactionReport.getStrikePriceNotation()), MapperS.of(PriceNotationEnum.BASIS), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult3 = MapperS.of(drrReport).<PriceFormat>map("getStrikePrice", sECTransactionReport -> sECTransactionReport.getStrikePrice()).<BigDecimal>map("getBasis", priceFormat -> priceFormat.getBasis()).get();
			} else if (areEqual(MapperS.of(drrReport).<PriceNotationEnum>map("getStrikePriceNotation", sECTransactionReport -> sECTransactionReport.getStrikePriceNotation()), MapperS.of(PriceNotationEnum.PERCENTAGE), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult3 = MapperS.of(drrReport).<PriceFormat>map("getStrikePrice", sECTransactionReport -> sECTransactionReport.getStrikePrice()).<BigDecimal>map("getPercentage", priceFormat -> priceFormat.getPercentage()).get();
			} else {
				ifThenElseResult3 = null;
			}
			String ifThenElseResult4 = null;
			if (areEqual(MapperS.of(drrReport).<PriceNotationEnum>map("getStrikePriceNotation", sECTransactionReport -> sECTransactionReport.getStrikePriceNotation()), MapperS.of(PriceNotationEnum.MONETARY), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult4 = subString.evaluate(MapperS.of(drrReport).<String>map("getStrikePriceCurrency", sECTransactionReport -> sECTransactionReport.getStrikePriceCurrency()).get(), 1, 3);
			}
			final MapperS<PriceNotationEnum> thenArg5 = MapperS.of(drrReport).<PriceNotationEnum>map("getStrikePriceNotation", sECTransactionReport -> sECTransactionReport.getStrikePriceNotation());
			final Integer integer6 = MapperS.of(drrReport).<CommonLeg>map("getLeg1", sECTransactionReport -> sECTransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<Integer>map("getFloatingRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRatePaymentFrequencyPeriodMultiplier()).get();
			final Integer integer7 = MapperS.of(drrReport).<CommonLeg>map("getLeg2", sECTransactionReport -> sECTransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<Integer>map("getFloatingRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRatePaymentFrequencyPeriodMultiplier()).get();
			final Integer integer8 = MapperC.<Integer>of(MapperS.of(drrReport).<CommonLeg>map("getLeg1", sECTransactionReport -> sECTransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<Integer>map("getFixedRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriodMultiplier()), MapperS.of(drrReport).<CommonLeg>map("getLeg1", sECTransactionReport -> sECTransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<Integer>map("getFloatingRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRatePaymentFrequencyPeriodMultiplier())).get();
			final Integer integer9 = MapperC.<Integer>of(MapperS.of(drrReport).<CommonLeg>map("getLeg2", sECTransactionReport -> sECTransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<Integer>map("getFixedRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriodMultiplier()), MapperS.of(drrReport).<CommonLeg>map("getLeg2", sECTransactionReport -> sECTransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<Integer>map("getFloatingRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRatePaymentFrequencyPeriodMultiplier())).get();
			final MapperS<PriceNotationEnum> thenArg6 = MapperS.of(drrReport).<PriceNotationEnum>map("getPackageTransactionPriceNotation", sECTransactionReport -> sECTransactionReport.getPackageTransactionPriceNotation());
			final MapperS<PriceNotationEnum> thenArg7 = MapperS.of(drrReport).<PriceNotationEnum>map("getPackageTransactionSpreadNotation", sECTransactionReport -> sECTransactionReport.getPackageTransactionSpreadNotation());
			final MapperC<ClearingExceptionsAndExemptionsEnum> thenArg8 = MapperS.of(drrReport).<ClearingExceptionsAndExemptionsEnum>mapC("getClearingExceptionsAndExemptionsCounterparty1", sECTransactionReport -> sECTransactionReport.getClearingExceptionsAndExemptionsCounterparty1());
			final MapperC<String> thenArg9 = thenArg8
				.mapItem(item -> item.map("to-string", ClearingExceptionsAndExemptionsEnum::toDisplayString));
			harmonized = toBuilder(HarmonizedData.builder()
				.setAmendmentIndicator(MapperS.of(drrReport).<Boolean>map("getAmendmentIndicator", sECTransactionReport -> sECTransactionReport.getAmendmentIndicator()).get())
				.setCdePackageTransactionSpreadCurrency(MapperS.of(drrReport).<ISOCurrencyCodeEnum>map("getPackageTransactionSpreadCurrency", sECTransactionReport -> sECTransactionReport.getPackageTransactionSpreadCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
				.setClearingVenueIdType(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", sECTransactionReport -> sECTransactionReport.getDtccAdditionalFields()).<PartyIdentifierTypeEnum>map("getClearingVenueIDType", dTCCAdditionalFields -> dTCCAdditionalFields.getClearingVenueIDType()).map("to-string", PartyIdentifierTypeEnum::toDisplayString).get())
				.setClearingVenueId(MapperS.of(drrReport).<String>map("getCentralCounterparty", sECTransactionReport -> sECTransactionReport.getCentralCounterparty()).get())
				.setTradeParty1ClearingBrokerId(MapperS.of(drrReport).<String>map("getClearingMember", sECTransactionReport -> sECTransactionReport.getClearingMember()).get())
				.setTradeParty1ClearingBrokerIdType(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", sECTransactionReport -> sECTransactionReport.getDtccAdditionalFields()).<PartyIdentifierTypeEnum>map("getTradeParty1ClearingBrokerIDType", dTCCAdditionalFields -> dTCCAdditionalFields.getTradeParty1ClearingBrokerIDType()).map("to-string", PartyIdentifierTypeEnum::toDisplayString).get())
				.setBuyerPayer1(MapperS.of(drrReport).<String>map("getBuyerIdentifier", sECTransactionReport -> sECTransactionReport.getBuyerIdentifier()).get())
				.setCdeEffectiveDate(MapperS.of(drrReport).<Date>map("getEffectiveDate", sECTransactionReport -> sECTransactionReport.getEffectiveDate()).get())
				.setCustomBasketIndicator(MapperS.of(drrReport).<Boolean>map("getCustomBasketIndicator", sECTransactionReport -> sECTransactionReport.getCustomBasketIndicator()).get())
				.setCdeExpirationDate(MapperS.of(drrReport).<Date>map("getExpirationDate", sECTransactionReport -> sECTransactionReport.getExpirationDate()).get())
				.setCdeFinalContractualSettlementDate(MapperS.of(drrReport).<Date>map("getFinalContractualSettlementDate", sECTransactionReport -> sECTransactionReport.getFinalContractualSettlementDate()).get())
				.setCdeFirstExerciseDate(MapperS.of(drrReport).<Date>map("getFirstExerciseDate", sECTransactionReport -> sECTransactionReport.getFirstExerciseDate()).get())
				.setCdeFixedRateDayCountConventionLeg1(MapperS.of(drrReport).<CommonLeg>map("getLeg1", sECTransactionReport -> sECTransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<InterestComputationMethod4Code>map("getFixedRateDayCountConvention", commonPeriodicPayment -> commonPeriodicPayment.getFixedRateDayCountConvention()).map("to-string", InterestComputationMethod4Code::toDisplayString).get())
				.setCdeFixedRateDayCountConventionLeg2(MapperS.of(drrReport).<CommonLeg>map("getLeg2", sECTransactionReport -> sECTransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<InterestComputationMethod4Code>map("getFixedRateDayCountConvention", commonPeriodicPayment -> commonPeriodicPayment.getFixedRateDayCountConvention()).map("to-string", InterestComputationMethod4Code::toDisplayString).get())
				.setCdeFixedRatePaymentFrequencyPeriodMultiplierLeg1((integer0 == null ? null : BigDecimal.valueOf(integer0)))
				.setCdeFixedRatePaymentFrequencyPeriodMultiplierLeg2((integer1 == null ? null : BigDecimal.valueOf(integer1)))
				.setCdeFixedRatePaymentFrequencyPeriodLeg1(MapperS.of(drrReport).<CommonLeg>map("getLeg1", sECTransactionReport -> sECTransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<FrequencyPeriodEnum>map("getFixedRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriod()).map("to-string", FrequencyPeriodEnum::toDisplayString).get())
				.setCdeFixedRatePaymentFrequencyPeriodLeg2(MapperS.of(drrReport).<CommonLeg>map("getLeg2", sECTransactionReport -> sECTransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<FrequencyPeriodEnum>map("getFixedRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriod()).map("to-string", FrequencyPeriodEnum::toDisplayString).get())
				.setCdeFloatingRateDayCountConventionLeg1(MapperS.of(drrReport).<CommonLeg>map("getLeg1", sECTransactionReport -> sECTransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<InterestComputationMethod4Code>map("getFloatingRateDayCountConvention", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRateDayCountConvention()).map("to-string", InterestComputationMethod4Code::toDisplayString).get())
				.setCdeFloatingRateDayCountConventionLeg2(MapperS.of(drrReport).<CommonLeg>map("getLeg2", sECTransactionReport -> sECTransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<InterestComputationMethod4Code>map("getFloatingRateDayCountConvention", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRateDayCountConvention()).map("to-string", InterestComputationMethod4Code::toDisplayString).get())
				.setCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1((integer2 == null ? null : BigDecimal.valueOf(integer2)))
				.setCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2((integer3 == null ? null : BigDecimal.valueOf(integer3)))
				.setCdeFloatingRatePaymentFrequencyPeriodLeg1(MapperS.of(drrReport).<CommonLeg>map("getLeg1", sECTransactionReport -> sECTransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<FrequencyPeriodEnum>map("getFloatingRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRatePaymentFrequencyPeriod()).map("to-string", FrequencyPeriodEnum::toDisplayString).get())
				.setCdeFloatingRatePaymentFrequencyPeriodLeg2(MapperS.of(drrReport).<CommonLeg>map("getLeg2", sECTransactionReport -> sECTransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<FrequencyPeriodEnum>map("getFloatingRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRatePaymentFrequencyPeriod()).map("to-string", FrequencyPeriodEnum::toDisplayString).get())
				.setCdePlatformIdentifier(ifThenElseResult0)
				.setCdePriceCurrency(MapperS.of(drrReport).<ISOCurrencyCodeEnum>map("getPriceCurrency", sECTransactionReport -> sECTransactionReport.getPriceCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
				.setCdePriceNotation(MapperS.of(notationStringFromEnum.evaluate(thenArg0.get())).get())
				.setCdeQuantityUnitOfMeasureLeg1(MapperS.of(drrReport).<CommonLeg>map("getLeg1", sECTransactionReport -> sECTransactionReport.getLeg1()).<String>map("getQuantityUnitOfMeasure", commonLeg -> commonLeg.getQuantityUnitOfMeasure()).get())
				.setCdeQuantityUnitOfMeasureLeg2(MapperS.of(drrReport).<CommonLeg>map("getLeg2", sECTransactionReport -> sECTransactionReport.getLeg2()).<String>map("getQuantityUnitOfMeasure", commonLeg -> commonLeg.getQuantityUnitOfMeasure()).get())
				.setCdeReceiverIdentifierLeg2(MapperS.of(drrReport).<CommonLeg>map("getLeg2", sECTransactionReport -> sECTransactionReport.getLeg2()).<String>map("getReceiverIdentifier", commonLeg -> commonLeg.getReceiverIdentifier()).get())
				.setCdeSettlementLocationLeg1(MapperS.of(drrReport).<ISOCountryCodeEnum>map("getSettlementLocation", sECTransactionReport -> sECTransactionReport.getSettlementLocation()).map("to-string", ISOCountryCodeEnum::toDisplayString).get())
				.setCdeSpreadNotationLeg1(MapperS.of(notationStringFromEnum.evaluate(thenArg1.get())).get())
				.setCdeSpreadNotationLeg2(MapperS.of(notationStringFromEnum.evaluate(thenArg2.get())).get())
				.setClearingStatus(MapperS.of(drrReport).<ClearedEnum>map("getCleared", sECTransactionReport -> sECTransactionReport.getCleared()).map("to-string", ClearedEnum::toDisplayString).get())
				.setEventType(MapperS.of(drrReport).<EventTypeEnum>map("getEventType", sECTransactionReport -> sECTransactionReport.getEventType()).map("to-string", EventTypeEnum::toDisplayString).get())
				.setFixingDateLeg1(MapperS.of(drrReport).<CommonLeg>map("getLeg1", sECTransactionReport -> sECTransactionReport.getLeg1()).<ZonedDateTime>map("getFixingDate", commonLeg -> commonLeg.getFixingDate()).<Date>map("Date", zdt -> Date.of(zdt.toLocalDate())).get())
				.setFixingDateLeg2(MapperS.of(drrReport).<CommonLeg>map("getLeg2", sECTransactionReport -> sECTransactionReport.getLeg2()).<ZonedDateTime>map("getFixingDate", commonLeg -> commonLeg.getFixingDate()).<Date>map("Date", zdt -> Date.of(zdt.toLocalDate())).get())
				.setIndexFactor(MapperS.of(drrReport).<BigDecimal>map("getIndexFactor", sECTransactionReport -> sECTransactionReport.getIndexFactor()).get())
				.setLeg1FixedRateInitial(MapperS.of(drrReport).<CommonLeg>map("getLeg1", sECTransactionReport -> sECTransactionReport.getLeg1()).<BigDecimal>map("getFixedRate", commonLeg -> commonLeg.getFixedRate()).get())
				.setLeg1SpreadCurrency(MapperS.of(drrReport).<CommonLeg>map("getLeg1", sECTransactionReport -> sECTransactionReport.getLeg1()).<ISOCurrencyCodeEnum>map("getSpreadCurrency", commonLeg -> commonLeg.getSpreadCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
				.setLeg1TotalNotionalQuantity(MapperS.of(drrReport).<CommonLeg>map("getLeg1", sECTransactionReport -> sECTransactionReport.getLeg1()).<BigDecimal>map("getTotalNotionalQuantity", commonLeg -> commonLeg.getTotalNotionalQuantity()).get())
				.setLeg2FixedRateInitial(MapperS.of(drrReport).<CommonLeg>map("getLeg2", sECTransactionReport -> sECTransactionReport.getLeg2()).<BigDecimal>map("getFixedRate", commonLeg -> commonLeg.getFixedRate()).get())
				.setLeg2ResetFrequencyPeriod(ifThenElseResult1.get())
				.setLeg2ResetFrequencyPeriodMultiplier((integer4 == null ? null : BigDecimal.valueOf(integer4)))
				.setLeg2SettlementCurrency(MapperS.of(drrReport).<CommonLeg>map("getLeg2", sECTransactionReport -> sECTransactionReport.getLeg2()).<ISOCurrencyCodeEnum>map("getSettlementCurrency", commonLeg -> commonLeg.getSettlementCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
				.setLeg2SpreadCurrency(MapperS.of(drrReport).<CommonLeg>map("getLeg2", sECTransactionReport -> sECTransactionReport.getLeg2()).<ISOCurrencyCodeEnum>map("getSpreadCurrency", commonLeg -> commonLeg.getSpreadCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
				.setLeg2TotalNotionalQuantity(MapperS.of(drrReport).<CommonLeg>map("getLeg2", sECTransactionReport -> sECTransactionReport.getLeg2()).<BigDecimal>map("getTotalNotionalQuantity", commonLeg -> commonLeg.getTotalNotionalQuantity()).get())
				.setNewSdrIdentifier(MapperS.of(drrReport).<String>map("getNewSDRIdentifier", sECTransactionReport -> sECTransactionReport.getNewSDRIdentifier()).get())
				.setNoaActionType(MapperS.of(drrReport).<ActionTypeEnum>map("getActionType", sECTransactionReport -> sECTransactionReport.getActionType()).map("to-string", ActionTypeEnum::toDisplayString).get())
				.setNonStandardTradeIndicator(MapperS.of(drrReport).<Boolean>map("getNonStandardizedTermIndicator", sECTransactionReport -> sECTransactionReport.getNonStandardizedTermIndicator()).get())
				.setNotionalAmount1(MapperS.of(drrReport).<CommonLeg>map("getLeg1", sECTransactionReport -> sECTransactionReport.getLeg1()).<BigDecimal>map("getNotionalAmount", commonLeg -> commonLeg.getNotionalAmount()).get())
				.setNotionalAmount2(MapperS.of(drrReport).<CommonLeg>map("getLeg2", sECTransactionReport -> sECTransactionReport.getLeg2()).<BigDecimal>map("getNotionalAmount", commonLeg -> commonLeg.getNotionalAmount()).get())
				.setNotionalCurrency1(MapperS.of(drrReport).<CommonLeg>map("getLeg1", sECTransactionReport -> sECTransactionReport.getLeg1()).<ISOCurrencyCodeEnum>map("getNotionalCurrency", commonLeg -> commonLeg.getNotionalCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
				.setNotionalCurrency2(MapperS.of(drrReport).<CommonLeg>map("getLeg2", sECTransactionReport -> sECTransactionReport.getLeg2()).<ISOCurrencyCodeEnum>map("getNotionalCurrency", commonLeg -> commonLeg.getNotionalCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
				.setOriginalExecutionTimestamp(MapperS.of(drrReport).<ZonedDateTime>map("getExecutionTimestamp", sECTransactionReport -> sECTransactionReport.getExecutionTimestamp()).get())
				.setPayment1Payer(MapperS.of(drrReport).<CommonLeg>map("getLeg1", sECTransactionReport -> sECTransactionReport.getLeg1()).<String>map("getPayerIdentifier", commonLeg -> commonLeg.getPayerIdentifier()).get())
				.setPayment1Receiver(MapperS.of(drrReport).<CommonLeg>map("getLeg1", sECTransactionReport -> sECTransactionReport.getLeg1()).<String>map("getReceiverIdentifier", commonLeg -> commonLeg.getReceiverIdentifier()).get())
				.setPayment2Payer(MapperS.of(drrReport).<CommonLeg>map("getLeg2", sECTransactionReport -> sECTransactionReport.getLeg2()).<String>map("getPayerIdentifier", commonLeg -> commonLeg.getPayerIdentifier()).get())
				.setPremiumAmount(MapperS.of(drrReport).<BigDecimal>map("getOptionPremiumAmount", sECTransactionReport -> sECTransactionReport.getOptionPremiumAmount()).get())
				.setPremiumCurrency(MapperS.of(drrReport).<ISOCurrencyCodeEnum>map("getOptionPremiumCurrency", sECTransactionReport -> sECTransactionReport.getOptionPremiumCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
				.setPremiumPaymentDateUnadjusted(MapperS.of(drrReport).<Date>map("getOptionPremiumPaymentDate", sECTransactionReport -> sECTransactionReport.getOptionPremiumPaymentDate()).get())
				.setPrice1Price(MapperC.<BigDecimal>of(MapperS.of(drrReport).<PriceFormat>map("getPrice", sECTransactionReport -> sECTransactionReport.getPrice()).<BigDecimal>map("getMonetary", priceFormat -> priceFormat.getMonetary()), MapperS.of(drrReport).<PriceFormat>map("getPrice", sECTransactionReport -> sECTransactionReport.getPrice()).<BigDecimal>map("getDecimal", priceFormat -> priceFormat.getDecimal())).get())
				.setPrice1Units(MapperS.of(drrReport).<String>map("getPriceUnitOfMeasure", sECTransactionReport -> sECTransactionReport.getPriceUnitOfMeasure()).get())
				.setPriorUtiId(MapperS.of(drrReport).<String>map("getPriorUTI", sECTransactionReport -> sECTransactionReport.getPriorUTI()).get())
				.setResetFrequencyPeriod1(ifThenElseResult2.get())
				.setResetFrequencyPeriodMultiplier1((integer5 == null ? null : BigDecimal.valueOf(integer5)))
				.setSellerPayer2(MapperS.of(drrReport).<String>map("getSellerIdentifier", sECTransactionReport -> sECTransactionReport.getSellerIdentifier()).get())
				.setSettlementCurrency1(MapperS.of(drrReport).<CommonLeg>map("getLeg1", sECTransactionReport -> sECTransactionReport.getLeg1()).<ISOCurrencyCodeEnum>map("getSettlementCurrency", commonLeg -> commonLeg.getSettlementCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
				.setStrikePrice(ifThenElseResult3)
				.setStrikePriceCurrency(ifThenElseResult4)
				.setCdeStrikePriceNotation(MapperS.of(notationStringFromEnum.evaluate(thenArg5.get())).get())
				.setLeg1FloatingRateIndex(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", sECTransactionReport -> sECTransactionReport.getDtccAdditionalFields()).<String>map("getLeg1FloatingRateIndex", dTCCAdditionalFields -> dTCCAdditionalFields.getLeg1FloatingRateIndex()).get())
				.setLeg2FloatingRateIndex(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", sECTransactionReport -> sECTransactionReport.getDtccAdditionalFields()).<String>map("getLeg2FloatingRateIndex", dTCCAdditionalFields -> dTCCAdditionalFields.getLeg2FloatingRateIndex()).get())
				.setResponsibleDataSubmitterId(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", sECTransactionReport -> sECTransactionReport.getDtccAdditionalFields()).<String>map("getResponsibleDataSubmitterID", dTCCAdditionalFields -> dTCCAdditionalFields.getResponsibleDataSubmitterID()).get())
				.setResponsibleDataSubmitterIdType(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", sECTransactionReport -> sECTransactionReport.getDtccAdditionalFields()).<PartyIdentifierTypeEnum>map("getResponsibleDataSubmitterIDType", dTCCAdditionalFields -> dTCCAdditionalFields.getResponsibleDataSubmitterIDType()).map("to-string", PartyIdentifierTypeEnum::toDisplayString).get())
				.setSecondaryAssetClass(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", sECTransactionReport -> sECTransactionReport.getDtccAdditionalFields()).<AssetClassEnum>map("getSecondaryAssetClass", dTCCAdditionalFields -> dTCCAdditionalFields.getSecondaryAssetClass()).map("to-string", AssetClassEnum::toDisplayString).get())
				.setLeg2SpreadAmount(MapperC.<BigDecimal>of(MapperS.of(drrReport).<CommonLeg>map("getLeg2", sECTransactionReport -> sECTransactionReport.getLeg2()).<PriceFormat>map("getSpread", commonLeg -> commonLeg.getSpread()).<BigDecimal>map("getMonetary", priceFormat -> priceFormat.getMonetary()), MapperS.of(drrReport).<CommonLeg>map("getLeg2", sECTransactionReport -> sECTransactionReport.getLeg2()).<PriceFormat>map("getSpread", commonLeg -> commonLeg.getSpread()).<BigDecimal>map("getDecimal", priceFormat -> priceFormat.getDecimal()), MapperS.of(drrReport).<CommonLeg>map("getLeg2", sECTransactionReport -> sECTransactionReport.getLeg2()).<PriceFormat>map("getSpread", commonLeg -> commonLeg.getSpread()).<BigDecimal>map("getPercentage", priceFormat -> priceFormat.getPercentage()), MapperS.of(drrReport).<CommonLeg>map("getLeg2", sECTransactionReport -> sECTransactionReport.getLeg2()).<PriceFormat>map("getSpread", commonLeg -> commonLeg.getSpread()).<BigDecimal>map("getBasis", priceFormat -> priceFormat.getBasis())).get())
				.setLeg1SpreadAmount(MapperC.<BigDecimal>of(MapperS.of(drrReport).<CommonLeg>map("getLeg1", sECTransactionReport -> sECTransactionReport.getLeg1()).<PriceFormat>map("getSpread", commonLeg -> commonLeg.getSpread()).<BigDecimal>map("getMonetary", priceFormat -> priceFormat.getMonetary()), MapperS.of(drrReport).<CommonLeg>map("getLeg1", sECTransactionReport -> sECTransactionReport.getLeg1()).<PriceFormat>map("getSpread", commonLeg -> commonLeg.getSpread()).<BigDecimal>map("getDecimal", priceFormat -> priceFormat.getDecimal()), MapperS.of(drrReport).<CommonLeg>map("getLeg1", sECTransactionReport -> sECTransactionReport.getLeg1()).<PriceFormat>map("getSpread", commonLeg -> commonLeg.getSpread()).<BigDecimal>map("getPercentage", priceFormat -> priceFormat.getPercentage()), MapperS.of(drrReport).<CommonLeg>map("getLeg1", sECTransactionReport -> sECTransactionReport.getLeg1()).<PriceFormat>map("getSpread", commonLeg -> commonLeg.getSpread()).<BigDecimal>map("getBasis", priceFormat -> priceFormat.getBasis())).get())
				.setExpirationDate(MapperS.of(drrReport).<Date>map("getExpirationDate", sECTransactionReport -> sECTransactionReport.getExpirationDate()).get())
				.setVersion(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", sECTransactionReport -> sECTransactionReport.getDtccAdditionalFields()).<String>map("getVersion", dTCCAdditionalFields -> dTCCAdditionalFields.getVersion()).get())
				.setComment1(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", sECTransactionReport -> sECTransactionReport.getDtccAdditionalFields()).<String>map("getComment1", dTCCAdditionalFields -> dTCCAdditionalFields.getComment1()).get())
				.setExecutionVenueId(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", sECTransactionReport -> sECTransactionReport.getDtccAdditionalFields()).<String>map("getExecutionVenueID", dTCCAdditionalFields -> dTCCAdditionalFields.getExecutionVenueID()).get())
				.setExecutionVenueIdType(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", sECTransactionReport -> sECTransactionReport.getDtccAdditionalFields()).<PartyIdentifierTypeEnum>map("getExecutionVenueIDType", dTCCAdditionalFields -> dTCCAdditionalFields.getExecutionVenueIDType()).map("to-string", PartyIdentifierTypeEnum::toDisplayString).get())
				.setMaturityDateOfTheUnderlying(MapperS.of(drrReport).<Date>map("getMaturityDateOfTheUnderlying", sECTransactionReport -> sECTransactionReport.getMaturityDateOfTheUnderlying()).get())
				.setAllocationType(MapperS.of(drrReport).<AllocationIndicatorEnum>map("getAllocationIndicator", sECTransactionReport -> sECTransactionReport.getAllocationIndicator()).map("to-string", AllocationIndicatorEnum::toDisplayString).get())
				.setFloatingRatePaymentFrequencyLeg1Multiplier((integer6 == null ? null : BigDecimal.valueOf(integer6)))
				.setFloatingRatePaymentFrequencyLeg2Multiplier((integer7 == null ? null : BigDecimal.valueOf(integer7)))
				.setPaymentFrequencyPeriodLeg1(MapperC.<String>of(MapperS.of(drrReport).<CommonLeg>map("getLeg1", sECTransactionReport -> sECTransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<FrequencyPeriodEnum>map("getFixedRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriod()).map("to-string", FrequencyPeriodEnum::toDisplayString), MapperS.of(drrReport).<CommonLeg>map("getLeg1", sECTransactionReport -> sECTransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<FrequencyPeriodEnum>map("getFloatingRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRatePaymentFrequencyPeriod()).map("to-string", FrequencyPeriodEnum::toDisplayString)).get())
				.setPaymentFrequencyPeriodLeg2(MapperC.<String>of(MapperS.of(drrReport).<CommonLeg>map("getLeg2", sECTransactionReport -> sECTransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<FrequencyPeriodEnum>map("getFixedRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriod()).map("to-string", FrequencyPeriodEnum::toDisplayString), MapperS.of(drrReport).<CommonLeg>map("getLeg2", sECTransactionReport -> sECTransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<FrequencyPeriodEnum>map("getFloatingRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRatePaymentFrequencyPeriod()).map("to-string", FrequencyPeriodEnum::toDisplayString)).get())
				.setPaymentFrequencyPeriodMultiplierLeg1((integer8 == null ? null : BigDecimal.valueOf(integer8)))
				.setPaymentFrequencyPeriodMultiplierLeg2((integer9 == null ? null : BigDecimal.valueOf(integer9)))
				.setEventIdentifier(MapperS.of(drrReport).<String>map("getEventIdentifier", sECTransactionReport -> sECTransactionReport.getEventIdentifier()).get())
				.setPackageIndicator(MapperS.of(drrReport).<Boolean>map("getPackageIndicator", sECTransactionReport -> sECTransactionReport.getPackageIndicator()).get())
				.setCdePackageIdentifier(MapperS.of(drrReport).<String>map("getPackageIdentifier", sECTransactionReport -> sECTransactionReport.getPackageIdentifier()).get())
				.setCdePackageTransactionPrice(MapperC.<BigDecimal>of(MapperS.of(drrReport).<PriceFormat>map("getPackageTransactionPrice", sECTransactionReport -> sECTransactionReport.getPackageTransactionPrice()).<BigDecimal>map("getMonetary", priceFormat -> priceFormat.getMonetary()), MapperS.of(drrReport).<PriceFormat>map("getPackageTransactionPrice", sECTransactionReport -> sECTransactionReport.getPackageTransactionPrice()).<BigDecimal>map("getDecimal", priceFormat -> priceFormat.getDecimal()), MapperS.of(drrReport).<PriceFormat>map("getPackageTransactionPrice", sECTransactionReport -> sECTransactionReport.getPackageTransactionPrice()).<BigDecimal>map("getPercentage", priceFormat -> priceFormat.getPercentage()), MapperS.of(drrReport).<PriceFormat>map("getPackageTransactionPrice", sECTransactionReport -> sECTransactionReport.getPackageTransactionPrice()).<BigDecimal>map("getBasis", priceFormat -> priceFormat.getBasis())).get())
				.setCdePackageTransactionPriceCurrency(MapperS.of(drrReport).<ISOCurrencyCodeEnum>map("getPackageTransactionPriceCurrency", sECTransactionReport -> sECTransactionReport.getPackageTransactionPriceCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
				.setCdePackageTransactionPriceNotation(MapperS.of(notationStringFromEnum.evaluate(thenArg6.get())).get())
				.setCdePackageTransactionSpread(MapperC.<BigDecimal>of(MapperS.of(drrReport).<PriceFormat>map("getPackageTransactionSpread", sECTransactionReport -> sECTransactionReport.getPackageTransactionSpread()).<BigDecimal>map("getMonetary", priceFormat -> priceFormat.getMonetary()), MapperS.of(drrReport).<PriceFormat>map("getPackageTransactionSpread", sECTransactionReport -> sECTransactionReport.getPackageTransactionSpread()).<BigDecimal>map("getDecimal", priceFormat -> priceFormat.getDecimal()), MapperS.of(drrReport).<PriceFormat>map("getPackageTransactionSpread", sECTransactionReport -> sECTransactionReport.getPackageTransactionSpread()).<BigDecimal>map("getPercentage", priceFormat -> priceFormat.getPercentage()), MapperS.of(drrReport).<PriceFormat>map("getPackageTransactionSpread", sECTransactionReport -> sECTransactionReport.getPackageTransactionSpread()).<BigDecimal>map("getBasis", priceFormat -> priceFormat.getBasis())).get())
				.setCdePackageTransactionSpreadNotation(MapperS.of(notationStringFromEnum.evaluate(thenArg7.get())).get())
				.setSefOrDcmAnonymousExecutionIndicator(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", sECTransactionReport -> sECTransactionReport.getDtccAdditionalFields()).<Boolean>map("getSefOrDcmAnonymousExecutionIndicator", dTCCAdditionalFields -> dTCCAdditionalFields.getSefOrDcmAnonymousExecutionIndicator()).get())
				.setPriorUsiId(MapperS.of(drrReport).<String>map("getPriorUSI", sECTransactionReport -> sECTransactionReport.getPriorUSI()).get())
				.setPrice1Currency(MapperS.of(drrReport).<ISOCurrencyCodeEnum>map("getPriceCurrency", sECTransactionReport -> sECTransactionReport.getPriceCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
				.setAttachmentPoint(MapperS.of(drrReport).<BigDecimal>map("getCdSIndexAttachmentPoint", sECTransactionReport -> sECTransactionReport.getCdSIndexAttachmentPoint()).get())
				.setExhaustionPoint(MapperS.of(drrReport).<BigDecimal>map("getCdSIndexDetachmentPoint", sECTransactionReport -> sECTransactionReport.getCdSIndexDetachmentPoint()).get())
				.setClearingExceptionType(thenArg9.join(MapperS.of(";")).get())
				.setEmbeddedOptionOnSwap(MapperS.of(drrReport).<EmbeddedOptionTypeEnum>map("getEmbeddedOptionType", sECTransactionReport -> sECTransactionReport.getEmbeddedOptionType()).map("to-string", EmbeddedOptionTypeEnum::toDisplayString).get())
				.setPriorUsiIdPrefix(null)
				.setPriorUtiIdPrefix(null)
				.setClearingReceiptDatetime(MapperS.of(drrReport).<ZonedDateTime>map("getClearingReceiptTimestamp", sECTransactionReport -> sECTransactionReport.getClearingReceiptTimestamp()).get())
				.setClearingSwapUtiId(MapperS.of(drrReport).<String>mapC("getClearingSwapUTIs", sECTransactionReport -> sECTransactionReport.getClearingSwapUTIs()).get())
				.setOrigin(MapperS.of(drrReport).<ClearingAccountOriginEnum>map("getClearingAccountOrigin", sECTransactionReport -> sECTransactionReport.getClearingAccountOrigin()).map("to-string", ClearingAccountOriginEnum::toDisplayString).get())
				.setOriginalSwapSdrId(MapperS.of(drrReport).<String>map("getOriginalSwapSDRIdentifier", sECTransactionReport -> sECTransactionReport.getOriginalSwapSDRIdentifier()).get())
				.setOriginalSwapSdrIdType(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", sECTransactionReport -> sECTransactionReport.getDtccAdditionalFields()).<PartyIdentifierTypeEnum>map("getOriginalSwapSDRIDType", dTCCAdditionalFields -> dTCCAdditionalFields.getOriginalSwapSDRIDType()).map("to-string", PartyIdentifierTypeEnum::toDisplayString).get())
				.setOriginalSwapUsi(MapperS.of(drrReport).<String>map("getOriginalSwapUSI", sECTransactionReport -> sECTransactionReport.getOriginalSwapUSI()).get())
				.setOriginalSwapUti(MapperS.of(drrReport).<String>map("getOriginalSwapUTI", sECTransactionReport -> sECTransactionReport.getOriginalSwapUTI()).get())
				.setPostPricedSwapIndicator(MapperS.of(drrReport).<Boolean>map("getPostPricedSwapIndicator", sECTransactionReport -> sECTransactionReport.getPostPricedSwapIndicator()).get())
				.setSwapReportingJurisdiction(MapperS.of(drrReport).<JurisdictionEnum>map("getJurisdiction", sECTransactionReport -> sECTransactionReport.getJurisdiction()).map("to-string", JurisdictionEnum::toDisplayString).get())
				.build());
			
			return Optional.ofNullable(harmonized)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
