package drr.regulation.asic.rewrite.margin;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.asic.rewrite.margin.meta.ASICMarginReportMeta;
import drr.standards.iso.CollateralisationType3Code__1;
import drr.standards.iso.MarginActionEnum;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 7.0.0-dev.66
 */
@RosettaDataType(value="ASICMarginReport", builder=ASICMarginReport.ASICMarginReportBuilderImpl.class, version="7.0.0-dev.66")
@RuneDataType(value="ASICMarginReport", model="drr", builder=ASICMarginReport.ASICMarginReportBuilderImpl.class, version="7.0.0-dev.66")
public interface ASICMarginReport extends RosettaModelObject {

	ASICMarginReportMeta metaData = new ASICMarginReportMeta();

	/*********************** Getter Methods  ***********************/
	String getUniqueTransactionIdentifier();
	String getUniqueTransactionIdentifierProprietary();
	String getReportingEntity();
	String getCounterparty1();
	String getSmallScaleBuySideEntityIndicator();
	String getCounterparty2();
	ZonedDateTime getCollateralTimestamp();
	CollateralisationType3Code__1 getCollateralisationCategory();
	Boolean getCollateralPortfolioIndicator();
	Boolean getPortfolioContainingNonReportedComponentIndicator();
	String getInitialMarginCollateralPortfolioCode();
	String getCollateralPortfolioCodeVM();
	BigDecimal getInitialMarginPostedByTheReportingEntityPreHaircut();
	BigDecimal getInitialMarginPostedByTheReportingEntityPostHaircut();
	ISOCurrencyCodeEnum getCurrencyofInitialMarginPosted();
	BigDecimal getInitialMarginCollectedByTheReportingEntityPreHaircut();
	BigDecimal getInitialMarginCollectedByTheReportingEntityPostHaircut();
	ISOCurrencyCodeEnum getCurrencyofInitialMarginCollected();
	BigDecimal getVariationMarginPostedByTheReportingEntityPreHaircut();
	ISOCurrencyCodeEnum getCurrencyOfVariationMarginPosted();
	BigDecimal getVariationMarginCollectedByTheReportingEntityPreHaircut();
	ISOCurrencyCodeEnum getCurrencyOfVariationMarginCollected();
	MarginActionEnum getActionType();
	ZonedDateTime getReportingTimestamp();
	String getReportSubmittingEntityID();
	Boolean getCounterpartyIdentifierType();
	String getTechnicalRecordId();
	String getExecutionAgentOfCounterparty1();

	/*********************** Build Methods  ***********************/
	ASICMarginReport build();
	
	ASICMarginReport.ASICMarginReportBuilder toBuilder();
	
	static ASICMarginReport.ASICMarginReportBuilder builder() {
		return new ASICMarginReport.ASICMarginReportBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends ASICMarginReport> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends ASICMarginReport> getType() {
		return ASICMarginReport.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, getUniqueTransactionIdentifier(), this);
		processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, getUniqueTransactionIdentifierProprietary(), this);
		processor.processBasic(path.newSubPath("reportingEntity"), String.class, getReportingEntity(), this);
		processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
		processor.processBasic(path.newSubPath("smallScaleBuySideEntityIndicator"), String.class, getSmallScaleBuySideEntityIndicator(), this);
		processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
		processor.processBasic(path.newSubPath("collateralTimestamp"), ZonedDateTime.class, getCollateralTimestamp(), this);
		processor.processBasic(path.newSubPath("collateralisationCategory"), CollateralisationType3Code__1.class, getCollateralisationCategory(), this);
		processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, getCollateralPortfolioIndicator(), this);
		processor.processBasic(path.newSubPath("portfolioContainingNonReportedComponentIndicator"), Boolean.class, getPortfolioContainingNonReportedComponentIndicator(), this);
		processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, getInitialMarginCollateralPortfolioCode(), this);
		processor.processBasic(path.newSubPath("collateralPortfolioCodeVM"), String.class, getCollateralPortfolioCodeVM(), this);
		processor.processBasic(path.newSubPath("initialMarginPostedByTheReportingEntityPreHaircut"), BigDecimal.class, getInitialMarginPostedByTheReportingEntityPreHaircut(), this);
		processor.processBasic(path.newSubPath("initialMarginPostedByTheReportingEntityPostHaircut"), BigDecimal.class, getInitialMarginPostedByTheReportingEntityPostHaircut(), this);
		processor.processBasic(path.newSubPath("currencyofInitialMarginPosted"), ISOCurrencyCodeEnum.class, getCurrencyofInitialMarginPosted(), this);
		processor.processBasic(path.newSubPath("initialMarginCollectedByTheReportingEntityPreHaircut"), BigDecimal.class, getInitialMarginCollectedByTheReportingEntityPreHaircut(), this);
		processor.processBasic(path.newSubPath("initialMarginCollectedByTheReportingEntityPostHaircut"), BigDecimal.class, getInitialMarginCollectedByTheReportingEntityPostHaircut(), this);
		processor.processBasic(path.newSubPath("currencyofInitialMarginCollected"), ISOCurrencyCodeEnum.class, getCurrencyofInitialMarginCollected(), this);
		processor.processBasic(path.newSubPath("variationMarginPostedByTheReportingEntityPreHaircut"), BigDecimal.class, getVariationMarginPostedByTheReportingEntityPreHaircut(), this);
		processor.processBasic(path.newSubPath("currencyOfVariationMarginPosted"), ISOCurrencyCodeEnum.class, getCurrencyOfVariationMarginPosted(), this);
		processor.processBasic(path.newSubPath("variationMarginCollectedByTheReportingEntityPreHaircut"), BigDecimal.class, getVariationMarginCollectedByTheReportingEntityPreHaircut(), this);
		processor.processBasic(path.newSubPath("currencyOfVariationMarginCollected"), ISOCurrencyCodeEnum.class, getCurrencyOfVariationMarginCollected(), this);
		processor.processBasic(path.newSubPath("actionType"), MarginActionEnum.class, getActionType(), this);
		processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
		processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, getReportSubmittingEntityID(), this);
		processor.processBasic(path.newSubPath("counterpartyIdentifierType"), Boolean.class, getCounterpartyIdentifierType(), this);
		processor.processBasic(path.newSubPath("technicalRecordId"), String.class, getTechnicalRecordId(), this);
		processor.processBasic(path.newSubPath("executionAgentOfCounterparty1"), String.class, getExecutionAgentOfCounterparty1(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface ASICMarginReportBuilder extends ASICMarginReport, RosettaModelObjectBuilder {
		ASICMarginReport.ASICMarginReportBuilder setUniqueTransactionIdentifier(String uniqueTransactionIdentifier);
		ASICMarginReport.ASICMarginReportBuilder setUniqueTransactionIdentifierProprietary(String uniqueTransactionIdentifierProprietary);
		ASICMarginReport.ASICMarginReportBuilder setReportingEntity(String reportingEntity);
		ASICMarginReport.ASICMarginReportBuilder setCounterparty1(String counterparty1);
		ASICMarginReport.ASICMarginReportBuilder setSmallScaleBuySideEntityIndicator(String smallScaleBuySideEntityIndicator);
		ASICMarginReport.ASICMarginReportBuilder setCounterparty2(String counterparty2);
		ASICMarginReport.ASICMarginReportBuilder setCollateralTimestamp(ZonedDateTime collateralTimestamp);
		ASICMarginReport.ASICMarginReportBuilder setCollateralisationCategory(CollateralisationType3Code__1 collateralisationCategory);
		ASICMarginReport.ASICMarginReportBuilder setCollateralPortfolioIndicator(Boolean collateralPortfolioIndicator);
		ASICMarginReport.ASICMarginReportBuilder setPortfolioContainingNonReportedComponentIndicator(Boolean portfolioContainingNonReportedComponentIndicator);
		ASICMarginReport.ASICMarginReportBuilder setInitialMarginCollateralPortfolioCode(String initialMarginCollateralPortfolioCode);
		ASICMarginReport.ASICMarginReportBuilder setCollateralPortfolioCodeVM(String collateralPortfolioCodeVM);
		ASICMarginReport.ASICMarginReportBuilder setInitialMarginPostedByTheReportingEntityPreHaircut(BigDecimal initialMarginPostedByTheReportingEntityPreHaircut);
		ASICMarginReport.ASICMarginReportBuilder setInitialMarginPostedByTheReportingEntityPostHaircut(BigDecimal initialMarginPostedByTheReportingEntityPostHaircut);
		ASICMarginReport.ASICMarginReportBuilder setCurrencyofInitialMarginPosted(ISOCurrencyCodeEnum currencyofInitialMarginPosted);
		ASICMarginReport.ASICMarginReportBuilder setInitialMarginCollectedByTheReportingEntityPreHaircut(BigDecimal initialMarginCollectedByTheReportingEntityPreHaircut);
		ASICMarginReport.ASICMarginReportBuilder setInitialMarginCollectedByTheReportingEntityPostHaircut(BigDecimal initialMarginCollectedByTheReportingEntityPostHaircut);
		ASICMarginReport.ASICMarginReportBuilder setCurrencyofInitialMarginCollected(ISOCurrencyCodeEnum currencyofInitialMarginCollected);
		ASICMarginReport.ASICMarginReportBuilder setVariationMarginPostedByTheReportingEntityPreHaircut(BigDecimal variationMarginPostedByTheReportingEntityPreHaircut);
		ASICMarginReport.ASICMarginReportBuilder setCurrencyOfVariationMarginPosted(ISOCurrencyCodeEnum currencyOfVariationMarginPosted);
		ASICMarginReport.ASICMarginReportBuilder setVariationMarginCollectedByTheReportingEntityPreHaircut(BigDecimal variationMarginCollectedByTheReportingEntityPreHaircut);
		ASICMarginReport.ASICMarginReportBuilder setCurrencyOfVariationMarginCollected(ISOCurrencyCodeEnum currencyOfVariationMarginCollected);
		ASICMarginReport.ASICMarginReportBuilder setActionType(MarginActionEnum actionType);
		ASICMarginReport.ASICMarginReportBuilder setReportingTimestamp(ZonedDateTime reportingTimestamp);
		ASICMarginReport.ASICMarginReportBuilder setReportSubmittingEntityID(String reportSubmittingEntityID);
		ASICMarginReport.ASICMarginReportBuilder setCounterpartyIdentifierType(Boolean counterpartyIdentifierType);
		ASICMarginReport.ASICMarginReportBuilder setTechnicalRecordId(String technicalRecordId);
		ASICMarginReport.ASICMarginReportBuilder setExecutionAgentOfCounterparty1(String executionAgentOfCounterparty1);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, getUniqueTransactionIdentifier(), this);
			processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, getUniqueTransactionIdentifierProprietary(), this);
			processor.processBasic(path.newSubPath("reportingEntity"), String.class, getReportingEntity(), this);
			processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
			processor.processBasic(path.newSubPath("smallScaleBuySideEntityIndicator"), String.class, getSmallScaleBuySideEntityIndicator(), this);
			processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
			processor.processBasic(path.newSubPath("collateralTimestamp"), ZonedDateTime.class, getCollateralTimestamp(), this);
			processor.processBasic(path.newSubPath("collateralisationCategory"), CollateralisationType3Code__1.class, getCollateralisationCategory(), this);
			processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, getCollateralPortfolioIndicator(), this);
			processor.processBasic(path.newSubPath("portfolioContainingNonReportedComponentIndicator"), Boolean.class, getPortfolioContainingNonReportedComponentIndicator(), this);
			processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, getInitialMarginCollateralPortfolioCode(), this);
			processor.processBasic(path.newSubPath("collateralPortfolioCodeVM"), String.class, getCollateralPortfolioCodeVM(), this);
			processor.processBasic(path.newSubPath("initialMarginPostedByTheReportingEntityPreHaircut"), BigDecimal.class, getInitialMarginPostedByTheReportingEntityPreHaircut(), this);
			processor.processBasic(path.newSubPath("initialMarginPostedByTheReportingEntityPostHaircut"), BigDecimal.class, getInitialMarginPostedByTheReportingEntityPostHaircut(), this);
			processor.processBasic(path.newSubPath("currencyofInitialMarginPosted"), ISOCurrencyCodeEnum.class, getCurrencyofInitialMarginPosted(), this);
			processor.processBasic(path.newSubPath("initialMarginCollectedByTheReportingEntityPreHaircut"), BigDecimal.class, getInitialMarginCollectedByTheReportingEntityPreHaircut(), this);
			processor.processBasic(path.newSubPath("initialMarginCollectedByTheReportingEntityPostHaircut"), BigDecimal.class, getInitialMarginCollectedByTheReportingEntityPostHaircut(), this);
			processor.processBasic(path.newSubPath("currencyofInitialMarginCollected"), ISOCurrencyCodeEnum.class, getCurrencyofInitialMarginCollected(), this);
			processor.processBasic(path.newSubPath("variationMarginPostedByTheReportingEntityPreHaircut"), BigDecimal.class, getVariationMarginPostedByTheReportingEntityPreHaircut(), this);
			processor.processBasic(path.newSubPath("currencyOfVariationMarginPosted"), ISOCurrencyCodeEnum.class, getCurrencyOfVariationMarginPosted(), this);
			processor.processBasic(path.newSubPath("variationMarginCollectedByTheReportingEntityPreHaircut"), BigDecimal.class, getVariationMarginCollectedByTheReportingEntityPreHaircut(), this);
			processor.processBasic(path.newSubPath("currencyOfVariationMarginCollected"), ISOCurrencyCodeEnum.class, getCurrencyOfVariationMarginCollected(), this);
			processor.processBasic(path.newSubPath("actionType"), MarginActionEnum.class, getActionType(), this);
			processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
			processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, getReportSubmittingEntityID(), this);
			processor.processBasic(path.newSubPath("counterpartyIdentifierType"), Boolean.class, getCounterpartyIdentifierType(), this);
			processor.processBasic(path.newSubPath("technicalRecordId"), String.class, getTechnicalRecordId(), this);
			processor.processBasic(path.newSubPath("executionAgentOfCounterparty1"), String.class, getExecutionAgentOfCounterparty1(), this);
		}
		

		ASICMarginReport.ASICMarginReportBuilder prune();
	}

	/*********************** Immutable Implementation of ASICMarginReport  ***********************/
	class ASICMarginReportImpl implements ASICMarginReport {
		private final String uniqueTransactionIdentifier;
		private final String uniqueTransactionIdentifierProprietary;
		private final String reportingEntity;
		private final String counterparty1;
		private final String smallScaleBuySideEntityIndicator;
		private final String counterparty2;
		private final ZonedDateTime collateralTimestamp;
		private final CollateralisationType3Code__1 collateralisationCategory;
		private final Boolean collateralPortfolioIndicator;
		private final Boolean portfolioContainingNonReportedComponentIndicator;
		private final String initialMarginCollateralPortfolioCode;
		private final String collateralPortfolioCodeVM;
		private final BigDecimal initialMarginPostedByTheReportingEntityPreHaircut;
		private final BigDecimal initialMarginPostedByTheReportingEntityPostHaircut;
		private final ISOCurrencyCodeEnum currencyofInitialMarginPosted;
		private final BigDecimal initialMarginCollectedByTheReportingEntityPreHaircut;
		private final BigDecimal initialMarginCollectedByTheReportingEntityPostHaircut;
		private final ISOCurrencyCodeEnum currencyofInitialMarginCollected;
		private final BigDecimal variationMarginPostedByTheReportingEntityPreHaircut;
		private final ISOCurrencyCodeEnum currencyOfVariationMarginPosted;
		private final BigDecimal variationMarginCollectedByTheReportingEntityPreHaircut;
		private final ISOCurrencyCodeEnum currencyOfVariationMarginCollected;
		private final MarginActionEnum actionType;
		private final ZonedDateTime reportingTimestamp;
		private final String reportSubmittingEntityID;
		private final Boolean counterpartyIdentifierType;
		private final String technicalRecordId;
		private final String executionAgentOfCounterparty1;
		
		protected ASICMarginReportImpl(ASICMarginReport.ASICMarginReportBuilder builder) {
			this.uniqueTransactionIdentifier = builder.getUniqueTransactionIdentifier();
			this.uniqueTransactionIdentifierProprietary = builder.getUniqueTransactionIdentifierProprietary();
			this.reportingEntity = builder.getReportingEntity();
			this.counterparty1 = builder.getCounterparty1();
			this.smallScaleBuySideEntityIndicator = builder.getSmallScaleBuySideEntityIndicator();
			this.counterparty2 = builder.getCounterparty2();
			this.collateralTimestamp = builder.getCollateralTimestamp();
			this.collateralisationCategory = builder.getCollateralisationCategory();
			this.collateralPortfolioIndicator = builder.getCollateralPortfolioIndicator();
			this.portfolioContainingNonReportedComponentIndicator = builder.getPortfolioContainingNonReportedComponentIndicator();
			this.initialMarginCollateralPortfolioCode = builder.getInitialMarginCollateralPortfolioCode();
			this.collateralPortfolioCodeVM = builder.getCollateralPortfolioCodeVM();
			this.initialMarginPostedByTheReportingEntityPreHaircut = builder.getInitialMarginPostedByTheReportingEntityPreHaircut();
			this.initialMarginPostedByTheReportingEntityPostHaircut = builder.getInitialMarginPostedByTheReportingEntityPostHaircut();
			this.currencyofInitialMarginPosted = builder.getCurrencyofInitialMarginPosted();
			this.initialMarginCollectedByTheReportingEntityPreHaircut = builder.getInitialMarginCollectedByTheReportingEntityPreHaircut();
			this.initialMarginCollectedByTheReportingEntityPostHaircut = builder.getInitialMarginCollectedByTheReportingEntityPostHaircut();
			this.currencyofInitialMarginCollected = builder.getCurrencyofInitialMarginCollected();
			this.variationMarginPostedByTheReportingEntityPreHaircut = builder.getVariationMarginPostedByTheReportingEntityPreHaircut();
			this.currencyOfVariationMarginPosted = builder.getCurrencyOfVariationMarginPosted();
			this.variationMarginCollectedByTheReportingEntityPreHaircut = builder.getVariationMarginCollectedByTheReportingEntityPreHaircut();
			this.currencyOfVariationMarginCollected = builder.getCurrencyOfVariationMarginCollected();
			this.actionType = builder.getActionType();
			this.reportingTimestamp = builder.getReportingTimestamp();
			this.reportSubmittingEntityID = builder.getReportSubmittingEntityID();
			this.counterpartyIdentifierType = builder.getCounterpartyIdentifierType();
			this.technicalRecordId = builder.getTechnicalRecordId();
			this.executionAgentOfCounterparty1 = builder.getExecutionAgentOfCounterparty1();
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifier")
		@RuneAttribute("uniqueTransactionIdentifier")
		public String getUniqueTransactionIdentifier() {
			return uniqueTransactionIdentifier;
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifierProprietary")
		@RuneAttribute("uniqueTransactionIdentifierProprietary")
		public String getUniqueTransactionIdentifierProprietary() {
			return uniqueTransactionIdentifierProprietary;
		}
		
		@Override
		@RosettaAttribute(value="reportingEntity", isRequired=true)
		@RuneAttribute(value="reportingEntity", isRequired=true)
		public String getReportingEntity() {
			return reportingEntity;
		}
		
		@Override
		@RosettaAttribute(value="counterparty1", isRequired=true)
		@RuneAttribute(value="counterparty1", isRequired=true)
		public String getCounterparty1() {
			return counterparty1;
		}
		
		@Override
		@RosettaAttribute(value="smallScaleBuySideEntityIndicator", isRequired=true)
		@RuneAttribute(value="smallScaleBuySideEntityIndicator", isRequired=true)
		public String getSmallScaleBuySideEntityIndicator() {
			return smallScaleBuySideEntityIndicator;
		}
		
		@Override
		@RosettaAttribute(value="counterparty2", isRequired=true)
		@RuneAttribute(value="counterparty2", isRequired=true)
		public String getCounterparty2() {
			return counterparty2;
		}
		
		@Override
		@RosettaAttribute("collateralTimestamp")
		@RuneAttribute("collateralTimestamp")
		public ZonedDateTime getCollateralTimestamp() {
			return collateralTimestamp;
		}
		
		@Override
		@RosettaAttribute("collateralisationCategory")
		@RuneAttribute("collateralisationCategory")
		public CollateralisationType3Code__1 getCollateralisationCategory() {
			return collateralisationCategory;
		}
		
		@Override
		@RosettaAttribute("collateralPortfolioIndicator")
		@RuneAttribute("collateralPortfolioIndicator")
		public Boolean getCollateralPortfolioIndicator() {
			return collateralPortfolioIndicator;
		}
		
		@Override
		@RosettaAttribute("portfolioContainingNonReportedComponentIndicator")
		@RuneAttribute("portfolioContainingNonReportedComponentIndicator")
		public Boolean getPortfolioContainingNonReportedComponentIndicator() {
			return portfolioContainingNonReportedComponentIndicator;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollateralPortfolioCode")
		@RuneAttribute("initialMarginCollateralPortfolioCode")
		public String getInitialMarginCollateralPortfolioCode() {
			return initialMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("collateralPortfolioCodeVM")
		@RuneAttribute("collateralPortfolioCodeVM")
		public String getCollateralPortfolioCodeVM() {
			return collateralPortfolioCodeVM;
		}
		
		@Override
		@RosettaAttribute("initialMarginPostedByTheReportingEntityPreHaircut")
		@RuneAttribute("initialMarginPostedByTheReportingEntityPreHaircut")
		public BigDecimal getInitialMarginPostedByTheReportingEntityPreHaircut() {
			return initialMarginPostedByTheReportingEntityPreHaircut;
		}
		
		@Override
		@RosettaAttribute("initialMarginPostedByTheReportingEntityPostHaircut")
		@RuneAttribute("initialMarginPostedByTheReportingEntityPostHaircut")
		public BigDecimal getInitialMarginPostedByTheReportingEntityPostHaircut() {
			return initialMarginPostedByTheReportingEntityPostHaircut;
		}
		
		@Override
		@RosettaAttribute("currencyofInitialMarginPosted")
		@RuneAttribute("currencyofInitialMarginPosted")
		public ISOCurrencyCodeEnum getCurrencyofInitialMarginPosted() {
			return currencyofInitialMarginPosted;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollectedByTheReportingEntityPreHaircut")
		@RuneAttribute("initialMarginCollectedByTheReportingEntityPreHaircut")
		public BigDecimal getInitialMarginCollectedByTheReportingEntityPreHaircut() {
			return initialMarginCollectedByTheReportingEntityPreHaircut;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollectedByTheReportingEntityPostHaircut")
		@RuneAttribute("initialMarginCollectedByTheReportingEntityPostHaircut")
		public BigDecimal getInitialMarginCollectedByTheReportingEntityPostHaircut() {
			return initialMarginCollectedByTheReportingEntityPostHaircut;
		}
		
		@Override
		@RosettaAttribute("currencyofInitialMarginCollected")
		@RuneAttribute("currencyofInitialMarginCollected")
		public ISOCurrencyCodeEnum getCurrencyofInitialMarginCollected() {
			return currencyofInitialMarginCollected;
		}
		
		@Override
		@RosettaAttribute("variationMarginPostedByTheReportingEntityPreHaircut")
		@RuneAttribute("variationMarginPostedByTheReportingEntityPreHaircut")
		public BigDecimal getVariationMarginPostedByTheReportingEntityPreHaircut() {
			return variationMarginPostedByTheReportingEntityPreHaircut;
		}
		
		@Override
		@RosettaAttribute("currencyOfVariationMarginPosted")
		@RuneAttribute("currencyOfVariationMarginPosted")
		public ISOCurrencyCodeEnum getCurrencyOfVariationMarginPosted() {
			return currencyOfVariationMarginPosted;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollectedByTheReportingEntityPreHaircut")
		@RuneAttribute("variationMarginCollectedByTheReportingEntityPreHaircut")
		public BigDecimal getVariationMarginCollectedByTheReportingEntityPreHaircut() {
			return variationMarginCollectedByTheReportingEntityPreHaircut;
		}
		
		@Override
		@RosettaAttribute("currencyOfVariationMarginCollected")
		@RuneAttribute("currencyOfVariationMarginCollected")
		public ISOCurrencyCodeEnum getCurrencyOfVariationMarginCollected() {
			return currencyOfVariationMarginCollected;
		}
		
		@Override
		@RosettaAttribute("actionType")
		@RuneAttribute("actionType")
		public MarginActionEnum getActionType() {
			return actionType;
		}
		
		@Override
		@RosettaAttribute(value="reportingTimestamp", isRequired=true)
		@RuneAttribute(value="reportingTimestamp", isRequired=true)
		public ZonedDateTime getReportingTimestamp() {
			return reportingTimestamp;
		}
		
		@Override
		@RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
		@RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
		public String getReportSubmittingEntityID() {
			return reportSubmittingEntityID;
		}
		
		@Override
		@RosettaAttribute(value="counterpartyIdentifierType", isRequired=true)
		@RuneAttribute(value="counterpartyIdentifierType", isRequired=true)
		public Boolean getCounterpartyIdentifierType() {
			return counterpartyIdentifierType;
		}
		
		@Override
		@RosettaAttribute(value="technicalRecordId", isRequired=true)
		@RuneAttribute(value="technicalRecordId", isRequired=true)
		public String getTechnicalRecordId() {
			return technicalRecordId;
		}
		
		@Override
		@RosettaAttribute(value="executionAgentOfCounterparty1", isRequired=true)
		@RuneAttribute(value="executionAgentOfCounterparty1", isRequired=true)
		public String getExecutionAgentOfCounterparty1() {
			return executionAgentOfCounterparty1;
		}
		
		@Override
		public ASICMarginReport build() {
			return this;
		}
		
		@Override
		public ASICMarginReport.ASICMarginReportBuilder toBuilder() {
			ASICMarginReport.ASICMarginReportBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(ASICMarginReport.ASICMarginReportBuilder builder) {
			ofNullable(getUniqueTransactionIdentifier()).ifPresent(builder::setUniqueTransactionIdentifier);
			ofNullable(getUniqueTransactionIdentifierProprietary()).ifPresent(builder::setUniqueTransactionIdentifierProprietary);
			ofNullable(getReportingEntity()).ifPresent(builder::setReportingEntity);
			ofNullable(getCounterparty1()).ifPresent(builder::setCounterparty1);
			ofNullable(getSmallScaleBuySideEntityIndicator()).ifPresent(builder::setSmallScaleBuySideEntityIndicator);
			ofNullable(getCounterparty2()).ifPresent(builder::setCounterparty2);
			ofNullable(getCollateralTimestamp()).ifPresent(builder::setCollateralTimestamp);
			ofNullable(getCollateralisationCategory()).ifPresent(builder::setCollateralisationCategory);
			ofNullable(getCollateralPortfolioIndicator()).ifPresent(builder::setCollateralPortfolioIndicator);
			ofNullable(getPortfolioContainingNonReportedComponentIndicator()).ifPresent(builder::setPortfolioContainingNonReportedComponentIndicator);
			ofNullable(getInitialMarginCollateralPortfolioCode()).ifPresent(builder::setInitialMarginCollateralPortfolioCode);
			ofNullable(getCollateralPortfolioCodeVM()).ifPresent(builder::setCollateralPortfolioCodeVM);
			ofNullable(getInitialMarginPostedByTheReportingEntityPreHaircut()).ifPresent(builder::setInitialMarginPostedByTheReportingEntityPreHaircut);
			ofNullable(getInitialMarginPostedByTheReportingEntityPostHaircut()).ifPresent(builder::setInitialMarginPostedByTheReportingEntityPostHaircut);
			ofNullable(getCurrencyofInitialMarginPosted()).ifPresent(builder::setCurrencyofInitialMarginPosted);
			ofNullable(getInitialMarginCollectedByTheReportingEntityPreHaircut()).ifPresent(builder::setInitialMarginCollectedByTheReportingEntityPreHaircut);
			ofNullable(getInitialMarginCollectedByTheReportingEntityPostHaircut()).ifPresent(builder::setInitialMarginCollectedByTheReportingEntityPostHaircut);
			ofNullable(getCurrencyofInitialMarginCollected()).ifPresent(builder::setCurrencyofInitialMarginCollected);
			ofNullable(getVariationMarginPostedByTheReportingEntityPreHaircut()).ifPresent(builder::setVariationMarginPostedByTheReportingEntityPreHaircut);
			ofNullable(getCurrencyOfVariationMarginPosted()).ifPresent(builder::setCurrencyOfVariationMarginPosted);
			ofNullable(getVariationMarginCollectedByTheReportingEntityPreHaircut()).ifPresent(builder::setVariationMarginCollectedByTheReportingEntityPreHaircut);
			ofNullable(getCurrencyOfVariationMarginCollected()).ifPresent(builder::setCurrencyOfVariationMarginCollected);
			ofNullable(getActionType()).ifPresent(builder::setActionType);
			ofNullable(getReportingTimestamp()).ifPresent(builder::setReportingTimestamp);
			ofNullable(getReportSubmittingEntityID()).ifPresent(builder::setReportSubmittingEntityID);
			ofNullable(getCounterpartyIdentifierType()).ifPresent(builder::setCounterpartyIdentifierType);
			ofNullable(getTechnicalRecordId()).ifPresent(builder::setTechnicalRecordId);
			ofNullable(getExecutionAgentOfCounterparty1()).ifPresent(builder::setExecutionAgentOfCounterparty1);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ASICMarginReport _that = getType().cast(o);
		
			if (!Objects.equals(uniqueTransactionIdentifier, _that.getUniqueTransactionIdentifier())) return false;
			if (!Objects.equals(uniqueTransactionIdentifierProprietary, _that.getUniqueTransactionIdentifierProprietary())) return false;
			if (!Objects.equals(reportingEntity, _that.getReportingEntity())) return false;
			if (!Objects.equals(counterparty1, _that.getCounterparty1())) return false;
			if (!Objects.equals(smallScaleBuySideEntityIndicator, _that.getSmallScaleBuySideEntityIndicator())) return false;
			if (!Objects.equals(counterparty2, _that.getCounterparty2())) return false;
			if (!Objects.equals(collateralTimestamp, _that.getCollateralTimestamp())) return false;
			if (!Objects.equals(collateralisationCategory, _that.getCollateralisationCategory())) return false;
			if (!Objects.equals(collateralPortfolioIndicator, _that.getCollateralPortfolioIndicator())) return false;
			if (!Objects.equals(portfolioContainingNonReportedComponentIndicator, _that.getPortfolioContainingNonReportedComponentIndicator())) return false;
			if (!Objects.equals(initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(collateralPortfolioCodeVM, _that.getCollateralPortfolioCodeVM())) return false;
			if (!Objects.equals(initialMarginPostedByTheReportingEntityPreHaircut, _that.getInitialMarginPostedByTheReportingEntityPreHaircut())) return false;
			if (!Objects.equals(initialMarginPostedByTheReportingEntityPostHaircut, _that.getInitialMarginPostedByTheReportingEntityPostHaircut())) return false;
			if (!Objects.equals(currencyofInitialMarginPosted, _that.getCurrencyofInitialMarginPosted())) return false;
			if (!Objects.equals(initialMarginCollectedByTheReportingEntityPreHaircut, _that.getInitialMarginCollectedByTheReportingEntityPreHaircut())) return false;
			if (!Objects.equals(initialMarginCollectedByTheReportingEntityPostHaircut, _that.getInitialMarginCollectedByTheReportingEntityPostHaircut())) return false;
			if (!Objects.equals(currencyofInitialMarginCollected, _that.getCurrencyofInitialMarginCollected())) return false;
			if (!Objects.equals(variationMarginPostedByTheReportingEntityPreHaircut, _that.getVariationMarginPostedByTheReportingEntityPreHaircut())) return false;
			if (!Objects.equals(currencyOfVariationMarginPosted, _that.getCurrencyOfVariationMarginPosted())) return false;
			if (!Objects.equals(variationMarginCollectedByTheReportingEntityPreHaircut, _that.getVariationMarginCollectedByTheReportingEntityPreHaircut())) return false;
			if (!Objects.equals(currencyOfVariationMarginCollected, _that.getCurrencyOfVariationMarginCollected())) return false;
			if (!Objects.equals(actionType, _that.getActionType())) return false;
			if (!Objects.equals(reportingTimestamp, _that.getReportingTimestamp())) return false;
			if (!Objects.equals(reportSubmittingEntityID, _that.getReportSubmittingEntityID())) return false;
			if (!Objects.equals(counterpartyIdentifierType, _that.getCounterpartyIdentifierType())) return false;
			if (!Objects.equals(technicalRecordId, _that.getTechnicalRecordId())) return false;
			if (!Objects.equals(executionAgentOfCounterparty1, _that.getExecutionAgentOfCounterparty1())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (uniqueTransactionIdentifier != null ? uniqueTransactionIdentifier.hashCode() : 0);
			_result = 31 * _result + (uniqueTransactionIdentifierProprietary != null ? uniqueTransactionIdentifierProprietary.hashCode() : 0);
			_result = 31 * _result + (reportingEntity != null ? reportingEntity.hashCode() : 0);
			_result = 31 * _result + (counterparty1 != null ? counterparty1.hashCode() : 0);
			_result = 31 * _result + (smallScaleBuySideEntityIndicator != null ? smallScaleBuySideEntityIndicator.hashCode() : 0);
			_result = 31 * _result + (counterparty2 != null ? counterparty2.hashCode() : 0);
			_result = 31 * _result + (collateralTimestamp != null ? collateralTimestamp.hashCode() : 0);
			_result = 31 * _result + (collateralisationCategory != null ? collateralisationCategory.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (collateralPortfolioIndicator != null ? collateralPortfolioIndicator.hashCode() : 0);
			_result = 31 * _result + (portfolioContainingNonReportedComponentIndicator != null ? portfolioContainingNonReportedComponentIndicator.hashCode() : 0);
			_result = 31 * _result + (initialMarginCollateralPortfolioCode != null ? initialMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (collateralPortfolioCodeVM != null ? collateralPortfolioCodeVM.hashCode() : 0);
			_result = 31 * _result + (initialMarginPostedByTheReportingEntityPreHaircut != null ? initialMarginPostedByTheReportingEntityPreHaircut.hashCode() : 0);
			_result = 31 * _result + (initialMarginPostedByTheReportingEntityPostHaircut != null ? initialMarginPostedByTheReportingEntityPostHaircut.hashCode() : 0);
			_result = 31 * _result + (currencyofInitialMarginPosted != null ? currencyofInitialMarginPosted.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (initialMarginCollectedByTheReportingEntityPreHaircut != null ? initialMarginCollectedByTheReportingEntityPreHaircut.hashCode() : 0);
			_result = 31 * _result + (initialMarginCollectedByTheReportingEntityPostHaircut != null ? initialMarginCollectedByTheReportingEntityPostHaircut.hashCode() : 0);
			_result = 31 * _result + (currencyofInitialMarginCollected != null ? currencyofInitialMarginCollected.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (variationMarginPostedByTheReportingEntityPreHaircut != null ? variationMarginPostedByTheReportingEntityPreHaircut.hashCode() : 0);
			_result = 31 * _result + (currencyOfVariationMarginPosted != null ? currencyOfVariationMarginPosted.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (variationMarginCollectedByTheReportingEntityPreHaircut != null ? variationMarginCollectedByTheReportingEntityPreHaircut.hashCode() : 0);
			_result = 31 * _result + (currencyOfVariationMarginCollected != null ? currencyOfVariationMarginCollected.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (actionType != null ? actionType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (reportingTimestamp != null ? reportingTimestamp.hashCode() : 0);
			_result = 31 * _result + (reportSubmittingEntityID != null ? reportSubmittingEntityID.hashCode() : 0);
			_result = 31 * _result + (counterpartyIdentifierType != null ? counterpartyIdentifierType.hashCode() : 0);
			_result = 31 * _result + (technicalRecordId != null ? technicalRecordId.hashCode() : 0);
			_result = 31 * _result + (executionAgentOfCounterparty1 != null ? executionAgentOfCounterparty1.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ASICMarginReport {" +
				"uniqueTransactionIdentifier=" + this.uniqueTransactionIdentifier + ", " +
				"uniqueTransactionIdentifierProprietary=" + this.uniqueTransactionIdentifierProprietary + ", " +
				"reportingEntity=" + this.reportingEntity + ", " +
				"counterparty1=" + this.counterparty1 + ", " +
				"smallScaleBuySideEntityIndicator=" + this.smallScaleBuySideEntityIndicator + ", " +
				"counterparty2=" + this.counterparty2 + ", " +
				"collateralTimestamp=" + this.collateralTimestamp + ", " +
				"collateralisationCategory=" + this.collateralisationCategory + ", " +
				"collateralPortfolioIndicator=" + this.collateralPortfolioIndicator + ", " +
				"portfolioContainingNonReportedComponentIndicator=" + this.portfolioContainingNonReportedComponentIndicator + ", " +
				"initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", " +
				"collateralPortfolioCodeVM=" + this.collateralPortfolioCodeVM + ", " +
				"initialMarginPostedByTheReportingEntityPreHaircut=" + this.initialMarginPostedByTheReportingEntityPreHaircut + ", " +
				"initialMarginPostedByTheReportingEntityPostHaircut=" + this.initialMarginPostedByTheReportingEntityPostHaircut + ", " +
				"currencyofInitialMarginPosted=" + this.currencyofInitialMarginPosted + ", " +
				"initialMarginCollectedByTheReportingEntityPreHaircut=" + this.initialMarginCollectedByTheReportingEntityPreHaircut + ", " +
				"initialMarginCollectedByTheReportingEntityPostHaircut=" + this.initialMarginCollectedByTheReportingEntityPostHaircut + ", " +
				"currencyofInitialMarginCollected=" + this.currencyofInitialMarginCollected + ", " +
				"variationMarginPostedByTheReportingEntityPreHaircut=" + this.variationMarginPostedByTheReportingEntityPreHaircut + ", " +
				"currencyOfVariationMarginPosted=" + this.currencyOfVariationMarginPosted + ", " +
				"variationMarginCollectedByTheReportingEntityPreHaircut=" + this.variationMarginCollectedByTheReportingEntityPreHaircut + ", " +
				"currencyOfVariationMarginCollected=" + this.currencyOfVariationMarginCollected + ", " +
				"actionType=" + this.actionType + ", " +
				"reportingTimestamp=" + this.reportingTimestamp + ", " +
				"reportSubmittingEntityID=" + this.reportSubmittingEntityID + ", " +
				"counterpartyIdentifierType=" + this.counterpartyIdentifierType + ", " +
				"technicalRecordId=" + this.technicalRecordId + ", " +
				"executionAgentOfCounterparty1=" + this.executionAgentOfCounterparty1 +
			'}';
		}
	}

	/*********************** Builder Implementation of ASICMarginReport  ***********************/
	class ASICMarginReportBuilderImpl implements ASICMarginReport.ASICMarginReportBuilder {
	
		protected String uniqueTransactionIdentifier;
		protected String uniqueTransactionIdentifierProprietary;
		protected String reportingEntity;
		protected String counterparty1;
		protected String smallScaleBuySideEntityIndicator;
		protected String counterparty2;
		protected ZonedDateTime collateralTimestamp;
		protected CollateralisationType3Code__1 collateralisationCategory;
		protected Boolean collateralPortfolioIndicator;
		protected Boolean portfolioContainingNonReportedComponentIndicator;
		protected String initialMarginCollateralPortfolioCode;
		protected String collateralPortfolioCodeVM;
		protected BigDecimal initialMarginPostedByTheReportingEntityPreHaircut;
		protected BigDecimal initialMarginPostedByTheReportingEntityPostHaircut;
		protected ISOCurrencyCodeEnum currencyofInitialMarginPosted;
		protected BigDecimal initialMarginCollectedByTheReportingEntityPreHaircut;
		protected BigDecimal initialMarginCollectedByTheReportingEntityPostHaircut;
		protected ISOCurrencyCodeEnum currencyofInitialMarginCollected;
		protected BigDecimal variationMarginPostedByTheReportingEntityPreHaircut;
		protected ISOCurrencyCodeEnum currencyOfVariationMarginPosted;
		protected BigDecimal variationMarginCollectedByTheReportingEntityPreHaircut;
		protected ISOCurrencyCodeEnum currencyOfVariationMarginCollected;
		protected MarginActionEnum actionType;
		protected ZonedDateTime reportingTimestamp;
		protected String reportSubmittingEntityID;
		protected Boolean counterpartyIdentifierType;
		protected String technicalRecordId;
		protected String executionAgentOfCounterparty1;
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifier")
		@RuneAttribute("uniqueTransactionIdentifier")
		public String getUniqueTransactionIdentifier() {
			return uniqueTransactionIdentifier;
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifierProprietary")
		@RuneAttribute("uniqueTransactionIdentifierProprietary")
		public String getUniqueTransactionIdentifierProprietary() {
			return uniqueTransactionIdentifierProprietary;
		}
		
		@Override
		@RosettaAttribute(value="reportingEntity", isRequired=true)
		@RuneAttribute(value="reportingEntity", isRequired=true)
		public String getReportingEntity() {
			return reportingEntity;
		}
		
		@Override
		@RosettaAttribute(value="counterparty1", isRequired=true)
		@RuneAttribute(value="counterparty1", isRequired=true)
		public String getCounterparty1() {
			return counterparty1;
		}
		
		@Override
		@RosettaAttribute(value="smallScaleBuySideEntityIndicator", isRequired=true)
		@RuneAttribute(value="smallScaleBuySideEntityIndicator", isRequired=true)
		public String getSmallScaleBuySideEntityIndicator() {
			return smallScaleBuySideEntityIndicator;
		}
		
		@Override
		@RosettaAttribute(value="counterparty2", isRequired=true)
		@RuneAttribute(value="counterparty2", isRequired=true)
		public String getCounterparty2() {
			return counterparty2;
		}
		
		@Override
		@RosettaAttribute("collateralTimestamp")
		@RuneAttribute("collateralTimestamp")
		public ZonedDateTime getCollateralTimestamp() {
			return collateralTimestamp;
		}
		
		@Override
		@RosettaAttribute("collateralisationCategory")
		@RuneAttribute("collateralisationCategory")
		public CollateralisationType3Code__1 getCollateralisationCategory() {
			return collateralisationCategory;
		}
		
		@Override
		@RosettaAttribute("collateralPortfolioIndicator")
		@RuneAttribute("collateralPortfolioIndicator")
		public Boolean getCollateralPortfolioIndicator() {
			return collateralPortfolioIndicator;
		}
		
		@Override
		@RosettaAttribute("portfolioContainingNonReportedComponentIndicator")
		@RuneAttribute("portfolioContainingNonReportedComponentIndicator")
		public Boolean getPortfolioContainingNonReportedComponentIndicator() {
			return portfolioContainingNonReportedComponentIndicator;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollateralPortfolioCode")
		@RuneAttribute("initialMarginCollateralPortfolioCode")
		public String getInitialMarginCollateralPortfolioCode() {
			return initialMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("collateralPortfolioCodeVM")
		@RuneAttribute("collateralPortfolioCodeVM")
		public String getCollateralPortfolioCodeVM() {
			return collateralPortfolioCodeVM;
		}
		
		@Override
		@RosettaAttribute("initialMarginPostedByTheReportingEntityPreHaircut")
		@RuneAttribute("initialMarginPostedByTheReportingEntityPreHaircut")
		public BigDecimal getInitialMarginPostedByTheReportingEntityPreHaircut() {
			return initialMarginPostedByTheReportingEntityPreHaircut;
		}
		
		@Override
		@RosettaAttribute("initialMarginPostedByTheReportingEntityPostHaircut")
		@RuneAttribute("initialMarginPostedByTheReportingEntityPostHaircut")
		public BigDecimal getInitialMarginPostedByTheReportingEntityPostHaircut() {
			return initialMarginPostedByTheReportingEntityPostHaircut;
		}
		
		@Override
		@RosettaAttribute("currencyofInitialMarginPosted")
		@RuneAttribute("currencyofInitialMarginPosted")
		public ISOCurrencyCodeEnum getCurrencyofInitialMarginPosted() {
			return currencyofInitialMarginPosted;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollectedByTheReportingEntityPreHaircut")
		@RuneAttribute("initialMarginCollectedByTheReportingEntityPreHaircut")
		public BigDecimal getInitialMarginCollectedByTheReportingEntityPreHaircut() {
			return initialMarginCollectedByTheReportingEntityPreHaircut;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollectedByTheReportingEntityPostHaircut")
		@RuneAttribute("initialMarginCollectedByTheReportingEntityPostHaircut")
		public BigDecimal getInitialMarginCollectedByTheReportingEntityPostHaircut() {
			return initialMarginCollectedByTheReportingEntityPostHaircut;
		}
		
		@Override
		@RosettaAttribute("currencyofInitialMarginCollected")
		@RuneAttribute("currencyofInitialMarginCollected")
		public ISOCurrencyCodeEnum getCurrencyofInitialMarginCollected() {
			return currencyofInitialMarginCollected;
		}
		
		@Override
		@RosettaAttribute("variationMarginPostedByTheReportingEntityPreHaircut")
		@RuneAttribute("variationMarginPostedByTheReportingEntityPreHaircut")
		public BigDecimal getVariationMarginPostedByTheReportingEntityPreHaircut() {
			return variationMarginPostedByTheReportingEntityPreHaircut;
		}
		
		@Override
		@RosettaAttribute("currencyOfVariationMarginPosted")
		@RuneAttribute("currencyOfVariationMarginPosted")
		public ISOCurrencyCodeEnum getCurrencyOfVariationMarginPosted() {
			return currencyOfVariationMarginPosted;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollectedByTheReportingEntityPreHaircut")
		@RuneAttribute("variationMarginCollectedByTheReportingEntityPreHaircut")
		public BigDecimal getVariationMarginCollectedByTheReportingEntityPreHaircut() {
			return variationMarginCollectedByTheReportingEntityPreHaircut;
		}
		
		@Override
		@RosettaAttribute("currencyOfVariationMarginCollected")
		@RuneAttribute("currencyOfVariationMarginCollected")
		public ISOCurrencyCodeEnum getCurrencyOfVariationMarginCollected() {
			return currencyOfVariationMarginCollected;
		}
		
		@Override
		@RosettaAttribute("actionType")
		@RuneAttribute("actionType")
		public MarginActionEnum getActionType() {
			return actionType;
		}
		
		@Override
		@RosettaAttribute(value="reportingTimestamp", isRequired=true)
		@RuneAttribute(value="reportingTimestamp", isRequired=true)
		public ZonedDateTime getReportingTimestamp() {
			return reportingTimestamp;
		}
		
		@Override
		@RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
		@RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
		public String getReportSubmittingEntityID() {
			return reportSubmittingEntityID;
		}
		
		@Override
		@RosettaAttribute(value="counterpartyIdentifierType", isRequired=true)
		@RuneAttribute(value="counterpartyIdentifierType", isRequired=true)
		public Boolean getCounterpartyIdentifierType() {
			return counterpartyIdentifierType;
		}
		
		@Override
		@RosettaAttribute(value="technicalRecordId", isRequired=true)
		@RuneAttribute(value="technicalRecordId", isRequired=true)
		public String getTechnicalRecordId() {
			return technicalRecordId;
		}
		
		@Override
		@RosettaAttribute(value="executionAgentOfCounterparty1", isRequired=true)
		@RuneAttribute(value="executionAgentOfCounterparty1", isRequired=true)
		public String getExecutionAgentOfCounterparty1() {
			return executionAgentOfCounterparty1;
		}
		
		@RosettaAttribute("uniqueTransactionIdentifier")
		@RuneAttribute("uniqueTransactionIdentifier")
		@Override
		public ASICMarginReport.ASICMarginReportBuilder setUniqueTransactionIdentifier(String _uniqueTransactionIdentifier) {
			this.uniqueTransactionIdentifier = _uniqueTransactionIdentifier == null ? null : _uniqueTransactionIdentifier;
			return this;
		}
		
		@RosettaAttribute("uniqueTransactionIdentifierProprietary")
		@RuneAttribute("uniqueTransactionIdentifierProprietary")
		@Override
		public ASICMarginReport.ASICMarginReportBuilder setUniqueTransactionIdentifierProprietary(String _uniqueTransactionIdentifierProprietary) {
			this.uniqueTransactionIdentifierProprietary = _uniqueTransactionIdentifierProprietary == null ? null : _uniqueTransactionIdentifierProprietary;
			return this;
		}
		
		@RosettaAttribute(value="reportingEntity", isRequired=true)
		@RuneAttribute(value="reportingEntity", isRequired=true)
		@Override
		public ASICMarginReport.ASICMarginReportBuilder setReportingEntity(String _reportingEntity) {
			this.reportingEntity = _reportingEntity == null ? null : _reportingEntity;
			return this;
		}
		
		@RosettaAttribute(value="counterparty1", isRequired=true)
		@RuneAttribute(value="counterparty1", isRequired=true)
		@Override
		public ASICMarginReport.ASICMarginReportBuilder setCounterparty1(String _counterparty1) {
			this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
			return this;
		}
		
		@RosettaAttribute(value="smallScaleBuySideEntityIndicator", isRequired=true)
		@RuneAttribute(value="smallScaleBuySideEntityIndicator", isRequired=true)
		@Override
		public ASICMarginReport.ASICMarginReportBuilder setSmallScaleBuySideEntityIndicator(String _smallScaleBuySideEntityIndicator) {
			this.smallScaleBuySideEntityIndicator = _smallScaleBuySideEntityIndicator == null ? null : _smallScaleBuySideEntityIndicator;
			return this;
		}
		
		@RosettaAttribute(value="counterparty2", isRequired=true)
		@RuneAttribute(value="counterparty2", isRequired=true)
		@Override
		public ASICMarginReport.ASICMarginReportBuilder setCounterparty2(String _counterparty2) {
			this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
			return this;
		}
		
		@RosettaAttribute("collateralTimestamp")
		@RuneAttribute("collateralTimestamp")
		@Override
		public ASICMarginReport.ASICMarginReportBuilder setCollateralTimestamp(ZonedDateTime _collateralTimestamp) {
			this.collateralTimestamp = _collateralTimestamp == null ? null : _collateralTimestamp;
			return this;
		}
		
		@RosettaAttribute("collateralisationCategory")
		@RuneAttribute("collateralisationCategory")
		@Override
		public ASICMarginReport.ASICMarginReportBuilder setCollateralisationCategory(CollateralisationType3Code__1 _collateralisationCategory) {
			this.collateralisationCategory = _collateralisationCategory == null ? null : _collateralisationCategory;
			return this;
		}
		
		@RosettaAttribute("collateralPortfolioIndicator")
		@RuneAttribute("collateralPortfolioIndicator")
		@Override
		public ASICMarginReport.ASICMarginReportBuilder setCollateralPortfolioIndicator(Boolean _collateralPortfolioIndicator) {
			this.collateralPortfolioIndicator = _collateralPortfolioIndicator == null ? null : _collateralPortfolioIndicator;
			return this;
		}
		
		@RosettaAttribute("portfolioContainingNonReportedComponentIndicator")
		@RuneAttribute("portfolioContainingNonReportedComponentIndicator")
		@Override
		public ASICMarginReport.ASICMarginReportBuilder setPortfolioContainingNonReportedComponentIndicator(Boolean _portfolioContainingNonReportedComponentIndicator) {
			this.portfolioContainingNonReportedComponentIndicator = _portfolioContainingNonReportedComponentIndicator == null ? null : _portfolioContainingNonReportedComponentIndicator;
			return this;
		}
		
		@RosettaAttribute("initialMarginCollateralPortfolioCode")
		@RuneAttribute("initialMarginCollateralPortfolioCode")
		@Override
		public ASICMarginReport.ASICMarginReportBuilder setInitialMarginCollateralPortfolioCode(String _initialMarginCollateralPortfolioCode) {
			this.initialMarginCollateralPortfolioCode = _initialMarginCollateralPortfolioCode == null ? null : _initialMarginCollateralPortfolioCode;
			return this;
		}
		
		@RosettaAttribute("collateralPortfolioCodeVM")
		@RuneAttribute("collateralPortfolioCodeVM")
		@Override
		public ASICMarginReport.ASICMarginReportBuilder setCollateralPortfolioCodeVM(String _collateralPortfolioCodeVM) {
			this.collateralPortfolioCodeVM = _collateralPortfolioCodeVM == null ? null : _collateralPortfolioCodeVM;
			return this;
		}
		
		@RosettaAttribute("initialMarginPostedByTheReportingEntityPreHaircut")
		@RuneAttribute("initialMarginPostedByTheReportingEntityPreHaircut")
		@Override
		public ASICMarginReport.ASICMarginReportBuilder setInitialMarginPostedByTheReportingEntityPreHaircut(BigDecimal _initialMarginPostedByTheReportingEntityPreHaircut) {
			this.initialMarginPostedByTheReportingEntityPreHaircut = _initialMarginPostedByTheReportingEntityPreHaircut == null ? null : _initialMarginPostedByTheReportingEntityPreHaircut;
			return this;
		}
		
		@RosettaAttribute("initialMarginPostedByTheReportingEntityPostHaircut")
		@RuneAttribute("initialMarginPostedByTheReportingEntityPostHaircut")
		@Override
		public ASICMarginReport.ASICMarginReportBuilder setInitialMarginPostedByTheReportingEntityPostHaircut(BigDecimal _initialMarginPostedByTheReportingEntityPostHaircut) {
			this.initialMarginPostedByTheReportingEntityPostHaircut = _initialMarginPostedByTheReportingEntityPostHaircut == null ? null : _initialMarginPostedByTheReportingEntityPostHaircut;
			return this;
		}
		
		@RosettaAttribute("currencyofInitialMarginPosted")
		@RuneAttribute("currencyofInitialMarginPosted")
		@Override
		public ASICMarginReport.ASICMarginReportBuilder setCurrencyofInitialMarginPosted(ISOCurrencyCodeEnum _currencyofInitialMarginPosted) {
			this.currencyofInitialMarginPosted = _currencyofInitialMarginPosted == null ? null : _currencyofInitialMarginPosted;
			return this;
		}
		
		@RosettaAttribute("initialMarginCollectedByTheReportingEntityPreHaircut")
		@RuneAttribute("initialMarginCollectedByTheReportingEntityPreHaircut")
		@Override
		public ASICMarginReport.ASICMarginReportBuilder setInitialMarginCollectedByTheReportingEntityPreHaircut(BigDecimal _initialMarginCollectedByTheReportingEntityPreHaircut) {
			this.initialMarginCollectedByTheReportingEntityPreHaircut = _initialMarginCollectedByTheReportingEntityPreHaircut == null ? null : _initialMarginCollectedByTheReportingEntityPreHaircut;
			return this;
		}
		
		@RosettaAttribute("initialMarginCollectedByTheReportingEntityPostHaircut")
		@RuneAttribute("initialMarginCollectedByTheReportingEntityPostHaircut")
		@Override
		public ASICMarginReport.ASICMarginReportBuilder setInitialMarginCollectedByTheReportingEntityPostHaircut(BigDecimal _initialMarginCollectedByTheReportingEntityPostHaircut) {
			this.initialMarginCollectedByTheReportingEntityPostHaircut = _initialMarginCollectedByTheReportingEntityPostHaircut == null ? null : _initialMarginCollectedByTheReportingEntityPostHaircut;
			return this;
		}
		
		@RosettaAttribute("currencyofInitialMarginCollected")
		@RuneAttribute("currencyofInitialMarginCollected")
		@Override
		public ASICMarginReport.ASICMarginReportBuilder setCurrencyofInitialMarginCollected(ISOCurrencyCodeEnum _currencyofInitialMarginCollected) {
			this.currencyofInitialMarginCollected = _currencyofInitialMarginCollected == null ? null : _currencyofInitialMarginCollected;
			return this;
		}
		
		@RosettaAttribute("variationMarginPostedByTheReportingEntityPreHaircut")
		@RuneAttribute("variationMarginPostedByTheReportingEntityPreHaircut")
		@Override
		public ASICMarginReport.ASICMarginReportBuilder setVariationMarginPostedByTheReportingEntityPreHaircut(BigDecimal _variationMarginPostedByTheReportingEntityPreHaircut) {
			this.variationMarginPostedByTheReportingEntityPreHaircut = _variationMarginPostedByTheReportingEntityPreHaircut == null ? null : _variationMarginPostedByTheReportingEntityPreHaircut;
			return this;
		}
		
		@RosettaAttribute("currencyOfVariationMarginPosted")
		@RuneAttribute("currencyOfVariationMarginPosted")
		@Override
		public ASICMarginReport.ASICMarginReportBuilder setCurrencyOfVariationMarginPosted(ISOCurrencyCodeEnum _currencyOfVariationMarginPosted) {
			this.currencyOfVariationMarginPosted = _currencyOfVariationMarginPosted == null ? null : _currencyOfVariationMarginPosted;
			return this;
		}
		
		@RosettaAttribute("variationMarginCollectedByTheReportingEntityPreHaircut")
		@RuneAttribute("variationMarginCollectedByTheReportingEntityPreHaircut")
		@Override
		public ASICMarginReport.ASICMarginReportBuilder setVariationMarginCollectedByTheReportingEntityPreHaircut(BigDecimal _variationMarginCollectedByTheReportingEntityPreHaircut) {
			this.variationMarginCollectedByTheReportingEntityPreHaircut = _variationMarginCollectedByTheReportingEntityPreHaircut == null ? null : _variationMarginCollectedByTheReportingEntityPreHaircut;
			return this;
		}
		
		@RosettaAttribute("currencyOfVariationMarginCollected")
		@RuneAttribute("currencyOfVariationMarginCollected")
		@Override
		public ASICMarginReport.ASICMarginReportBuilder setCurrencyOfVariationMarginCollected(ISOCurrencyCodeEnum _currencyOfVariationMarginCollected) {
			this.currencyOfVariationMarginCollected = _currencyOfVariationMarginCollected == null ? null : _currencyOfVariationMarginCollected;
			return this;
		}
		
		@RosettaAttribute("actionType")
		@RuneAttribute("actionType")
		@Override
		public ASICMarginReport.ASICMarginReportBuilder setActionType(MarginActionEnum _actionType) {
			this.actionType = _actionType == null ? null : _actionType;
			return this;
		}
		
		@RosettaAttribute(value="reportingTimestamp", isRequired=true)
		@RuneAttribute(value="reportingTimestamp", isRequired=true)
		@Override
		public ASICMarginReport.ASICMarginReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
			this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
			return this;
		}
		
		@RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
		@RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
		@Override
		public ASICMarginReport.ASICMarginReportBuilder setReportSubmittingEntityID(String _reportSubmittingEntityID) {
			this.reportSubmittingEntityID = _reportSubmittingEntityID == null ? null : _reportSubmittingEntityID;
			return this;
		}
		
		@RosettaAttribute(value="counterpartyIdentifierType", isRequired=true)
		@RuneAttribute(value="counterpartyIdentifierType", isRequired=true)
		@Override
		public ASICMarginReport.ASICMarginReportBuilder setCounterpartyIdentifierType(Boolean _counterpartyIdentifierType) {
			this.counterpartyIdentifierType = _counterpartyIdentifierType == null ? null : _counterpartyIdentifierType;
			return this;
		}
		
		@RosettaAttribute(value="technicalRecordId", isRequired=true)
		@RuneAttribute(value="technicalRecordId", isRequired=true)
		@Override
		public ASICMarginReport.ASICMarginReportBuilder setTechnicalRecordId(String _technicalRecordId) {
			this.technicalRecordId = _technicalRecordId == null ? null : _technicalRecordId;
			return this;
		}
		
		@RosettaAttribute(value="executionAgentOfCounterparty1", isRequired=true)
		@RuneAttribute(value="executionAgentOfCounterparty1", isRequired=true)
		@Override
		public ASICMarginReport.ASICMarginReportBuilder setExecutionAgentOfCounterparty1(String _executionAgentOfCounterparty1) {
			this.executionAgentOfCounterparty1 = _executionAgentOfCounterparty1 == null ? null : _executionAgentOfCounterparty1;
			return this;
		}
		
		@Override
		public ASICMarginReport build() {
			return new ASICMarginReport.ASICMarginReportImpl(this);
		}
		
		@Override
		public ASICMarginReport.ASICMarginReportBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ASICMarginReport.ASICMarginReportBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getUniqueTransactionIdentifier()!=null) return true;
			if (getUniqueTransactionIdentifierProprietary()!=null) return true;
			if (getReportingEntity()!=null) return true;
			if (getCounterparty1()!=null) return true;
			if (getSmallScaleBuySideEntityIndicator()!=null) return true;
			if (getCounterparty2()!=null) return true;
			if (getCollateralTimestamp()!=null) return true;
			if (getCollateralisationCategory()!=null) return true;
			if (getCollateralPortfolioIndicator()!=null) return true;
			if (getPortfolioContainingNonReportedComponentIndicator()!=null) return true;
			if (getInitialMarginCollateralPortfolioCode()!=null) return true;
			if (getCollateralPortfolioCodeVM()!=null) return true;
			if (getInitialMarginPostedByTheReportingEntityPreHaircut()!=null) return true;
			if (getInitialMarginPostedByTheReportingEntityPostHaircut()!=null) return true;
			if (getCurrencyofInitialMarginPosted()!=null) return true;
			if (getInitialMarginCollectedByTheReportingEntityPreHaircut()!=null) return true;
			if (getInitialMarginCollectedByTheReportingEntityPostHaircut()!=null) return true;
			if (getCurrencyofInitialMarginCollected()!=null) return true;
			if (getVariationMarginPostedByTheReportingEntityPreHaircut()!=null) return true;
			if (getCurrencyOfVariationMarginPosted()!=null) return true;
			if (getVariationMarginCollectedByTheReportingEntityPreHaircut()!=null) return true;
			if (getCurrencyOfVariationMarginCollected()!=null) return true;
			if (getActionType()!=null) return true;
			if (getReportingTimestamp()!=null) return true;
			if (getReportSubmittingEntityID()!=null) return true;
			if (getCounterpartyIdentifierType()!=null) return true;
			if (getTechnicalRecordId()!=null) return true;
			if (getExecutionAgentOfCounterparty1()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ASICMarginReport.ASICMarginReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			ASICMarginReport.ASICMarginReportBuilder o = (ASICMarginReport.ASICMarginReportBuilder) other;
			
			
			merger.mergeBasic(getUniqueTransactionIdentifier(), o.getUniqueTransactionIdentifier(), this::setUniqueTransactionIdentifier);
			merger.mergeBasic(getUniqueTransactionIdentifierProprietary(), o.getUniqueTransactionIdentifierProprietary(), this::setUniqueTransactionIdentifierProprietary);
			merger.mergeBasic(getReportingEntity(), o.getReportingEntity(), this::setReportingEntity);
			merger.mergeBasic(getCounterparty1(), o.getCounterparty1(), this::setCounterparty1);
			merger.mergeBasic(getSmallScaleBuySideEntityIndicator(), o.getSmallScaleBuySideEntityIndicator(), this::setSmallScaleBuySideEntityIndicator);
			merger.mergeBasic(getCounterparty2(), o.getCounterparty2(), this::setCounterparty2);
			merger.mergeBasic(getCollateralTimestamp(), o.getCollateralTimestamp(), this::setCollateralTimestamp);
			merger.mergeBasic(getCollateralisationCategory(), o.getCollateralisationCategory(), this::setCollateralisationCategory);
			merger.mergeBasic(getCollateralPortfolioIndicator(), o.getCollateralPortfolioIndicator(), this::setCollateralPortfolioIndicator);
			merger.mergeBasic(getPortfolioContainingNonReportedComponentIndicator(), o.getPortfolioContainingNonReportedComponentIndicator(), this::setPortfolioContainingNonReportedComponentIndicator);
			merger.mergeBasic(getInitialMarginCollateralPortfolioCode(), o.getInitialMarginCollateralPortfolioCode(), this::setInitialMarginCollateralPortfolioCode);
			merger.mergeBasic(getCollateralPortfolioCodeVM(), o.getCollateralPortfolioCodeVM(), this::setCollateralPortfolioCodeVM);
			merger.mergeBasic(getInitialMarginPostedByTheReportingEntityPreHaircut(), o.getInitialMarginPostedByTheReportingEntityPreHaircut(), this::setInitialMarginPostedByTheReportingEntityPreHaircut);
			merger.mergeBasic(getInitialMarginPostedByTheReportingEntityPostHaircut(), o.getInitialMarginPostedByTheReportingEntityPostHaircut(), this::setInitialMarginPostedByTheReportingEntityPostHaircut);
			merger.mergeBasic(getCurrencyofInitialMarginPosted(), o.getCurrencyofInitialMarginPosted(), this::setCurrencyofInitialMarginPosted);
			merger.mergeBasic(getInitialMarginCollectedByTheReportingEntityPreHaircut(), o.getInitialMarginCollectedByTheReportingEntityPreHaircut(), this::setInitialMarginCollectedByTheReportingEntityPreHaircut);
			merger.mergeBasic(getInitialMarginCollectedByTheReportingEntityPostHaircut(), o.getInitialMarginCollectedByTheReportingEntityPostHaircut(), this::setInitialMarginCollectedByTheReportingEntityPostHaircut);
			merger.mergeBasic(getCurrencyofInitialMarginCollected(), o.getCurrencyofInitialMarginCollected(), this::setCurrencyofInitialMarginCollected);
			merger.mergeBasic(getVariationMarginPostedByTheReportingEntityPreHaircut(), o.getVariationMarginPostedByTheReportingEntityPreHaircut(), this::setVariationMarginPostedByTheReportingEntityPreHaircut);
			merger.mergeBasic(getCurrencyOfVariationMarginPosted(), o.getCurrencyOfVariationMarginPosted(), this::setCurrencyOfVariationMarginPosted);
			merger.mergeBasic(getVariationMarginCollectedByTheReportingEntityPreHaircut(), o.getVariationMarginCollectedByTheReportingEntityPreHaircut(), this::setVariationMarginCollectedByTheReportingEntityPreHaircut);
			merger.mergeBasic(getCurrencyOfVariationMarginCollected(), o.getCurrencyOfVariationMarginCollected(), this::setCurrencyOfVariationMarginCollected);
			merger.mergeBasic(getActionType(), o.getActionType(), this::setActionType);
			merger.mergeBasic(getReportingTimestamp(), o.getReportingTimestamp(), this::setReportingTimestamp);
			merger.mergeBasic(getReportSubmittingEntityID(), o.getReportSubmittingEntityID(), this::setReportSubmittingEntityID);
			merger.mergeBasic(getCounterpartyIdentifierType(), o.getCounterpartyIdentifierType(), this::setCounterpartyIdentifierType);
			merger.mergeBasic(getTechnicalRecordId(), o.getTechnicalRecordId(), this::setTechnicalRecordId);
			merger.mergeBasic(getExecutionAgentOfCounterparty1(), o.getExecutionAgentOfCounterparty1(), this::setExecutionAgentOfCounterparty1);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ASICMarginReport _that = getType().cast(o);
		
			if (!Objects.equals(uniqueTransactionIdentifier, _that.getUniqueTransactionIdentifier())) return false;
			if (!Objects.equals(uniqueTransactionIdentifierProprietary, _that.getUniqueTransactionIdentifierProprietary())) return false;
			if (!Objects.equals(reportingEntity, _that.getReportingEntity())) return false;
			if (!Objects.equals(counterparty1, _that.getCounterparty1())) return false;
			if (!Objects.equals(smallScaleBuySideEntityIndicator, _that.getSmallScaleBuySideEntityIndicator())) return false;
			if (!Objects.equals(counterparty2, _that.getCounterparty2())) return false;
			if (!Objects.equals(collateralTimestamp, _that.getCollateralTimestamp())) return false;
			if (!Objects.equals(collateralisationCategory, _that.getCollateralisationCategory())) return false;
			if (!Objects.equals(collateralPortfolioIndicator, _that.getCollateralPortfolioIndicator())) return false;
			if (!Objects.equals(portfolioContainingNonReportedComponentIndicator, _that.getPortfolioContainingNonReportedComponentIndicator())) return false;
			if (!Objects.equals(initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(collateralPortfolioCodeVM, _that.getCollateralPortfolioCodeVM())) return false;
			if (!Objects.equals(initialMarginPostedByTheReportingEntityPreHaircut, _that.getInitialMarginPostedByTheReportingEntityPreHaircut())) return false;
			if (!Objects.equals(initialMarginPostedByTheReportingEntityPostHaircut, _that.getInitialMarginPostedByTheReportingEntityPostHaircut())) return false;
			if (!Objects.equals(currencyofInitialMarginPosted, _that.getCurrencyofInitialMarginPosted())) return false;
			if (!Objects.equals(initialMarginCollectedByTheReportingEntityPreHaircut, _that.getInitialMarginCollectedByTheReportingEntityPreHaircut())) return false;
			if (!Objects.equals(initialMarginCollectedByTheReportingEntityPostHaircut, _that.getInitialMarginCollectedByTheReportingEntityPostHaircut())) return false;
			if (!Objects.equals(currencyofInitialMarginCollected, _that.getCurrencyofInitialMarginCollected())) return false;
			if (!Objects.equals(variationMarginPostedByTheReportingEntityPreHaircut, _that.getVariationMarginPostedByTheReportingEntityPreHaircut())) return false;
			if (!Objects.equals(currencyOfVariationMarginPosted, _that.getCurrencyOfVariationMarginPosted())) return false;
			if (!Objects.equals(variationMarginCollectedByTheReportingEntityPreHaircut, _that.getVariationMarginCollectedByTheReportingEntityPreHaircut())) return false;
			if (!Objects.equals(currencyOfVariationMarginCollected, _that.getCurrencyOfVariationMarginCollected())) return false;
			if (!Objects.equals(actionType, _that.getActionType())) return false;
			if (!Objects.equals(reportingTimestamp, _that.getReportingTimestamp())) return false;
			if (!Objects.equals(reportSubmittingEntityID, _that.getReportSubmittingEntityID())) return false;
			if (!Objects.equals(counterpartyIdentifierType, _that.getCounterpartyIdentifierType())) return false;
			if (!Objects.equals(technicalRecordId, _that.getTechnicalRecordId())) return false;
			if (!Objects.equals(executionAgentOfCounterparty1, _that.getExecutionAgentOfCounterparty1())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (uniqueTransactionIdentifier != null ? uniqueTransactionIdentifier.hashCode() : 0);
			_result = 31 * _result + (uniqueTransactionIdentifierProprietary != null ? uniqueTransactionIdentifierProprietary.hashCode() : 0);
			_result = 31 * _result + (reportingEntity != null ? reportingEntity.hashCode() : 0);
			_result = 31 * _result + (counterparty1 != null ? counterparty1.hashCode() : 0);
			_result = 31 * _result + (smallScaleBuySideEntityIndicator != null ? smallScaleBuySideEntityIndicator.hashCode() : 0);
			_result = 31 * _result + (counterparty2 != null ? counterparty2.hashCode() : 0);
			_result = 31 * _result + (collateralTimestamp != null ? collateralTimestamp.hashCode() : 0);
			_result = 31 * _result + (collateralisationCategory != null ? collateralisationCategory.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (collateralPortfolioIndicator != null ? collateralPortfolioIndicator.hashCode() : 0);
			_result = 31 * _result + (portfolioContainingNonReportedComponentIndicator != null ? portfolioContainingNonReportedComponentIndicator.hashCode() : 0);
			_result = 31 * _result + (initialMarginCollateralPortfolioCode != null ? initialMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (collateralPortfolioCodeVM != null ? collateralPortfolioCodeVM.hashCode() : 0);
			_result = 31 * _result + (initialMarginPostedByTheReportingEntityPreHaircut != null ? initialMarginPostedByTheReportingEntityPreHaircut.hashCode() : 0);
			_result = 31 * _result + (initialMarginPostedByTheReportingEntityPostHaircut != null ? initialMarginPostedByTheReportingEntityPostHaircut.hashCode() : 0);
			_result = 31 * _result + (currencyofInitialMarginPosted != null ? currencyofInitialMarginPosted.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (initialMarginCollectedByTheReportingEntityPreHaircut != null ? initialMarginCollectedByTheReportingEntityPreHaircut.hashCode() : 0);
			_result = 31 * _result + (initialMarginCollectedByTheReportingEntityPostHaircut != null ? initialMarginCollectedByTheReportingEntityPostHaircut.hashCode() : 0);
			_result = 31 * _result + (currencyofInitialMarginCollected != null ? currencyofInitialMarginCollected.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (variationMarginPostedByTheReportingEntityPreHaircut != null ? variationMarginPostedByTheReportingEntityPreHaircut.hashCode() : 0);
			_result = 31 * _result + (currencyOfVariationMarginPosted != null ? currencyOfVariationMarginPosted.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (variationMarginCollectedByTheReportingEntityPreHaircut != null ? variationMarginCollectedByTheReportingEntityPreHaircut.hashCode() : 0);
			_result = 31 * _result + (currencyOfVariationMarginCollected != null ? currencyOfVariationMarginCollected.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (actionType != null ? actionType.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (reportingTimestamp != null ? reportingTimestamp.hashCode() : 0);
			_result = 31 * _result + (reportSubmittingEntityID != null ? reportSubmittingEntityID.hashCode() : 0);
			_result = 31 * _result + (counterpartyIdentifierType != null ? counterpartyIdentifierType.hashCode() : 0);
			_result = 31 * _result + (technicalRecordId != null ? technicalRecordId.hashCode() : 0);
			_result = 31 * _result + (executionAgentOfCounterparty1 != null ? executionAgentOfCounterparty1.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ASICMarginReportBuilder {" +
				"uniqueTransactionIdentifier=" + this.uniqueTransactionIdentifier + ", " +
				"uniqueTransactionIdentifierProprietary=" + this.uniqueTransactionIdentifierProprietary + ", " +
				"reportingEntity=" + this.reportingEntity + ", " +
				"counterparty1=" + this.counterparty1 + ", " +
				"smallScaleBuySideEntityIndicator=" + this.smallScaleBuySideEntityIndicator + ", " +
				"counterparty2=" + this.counterparty2 + ", " +
				"collateralTimestamp=" + this.collateralTimestamp + ", " +
				"collateralisationCategory=" + this.collateralisationCategory + ", " +
				"collateralPortfolioIndicator=" + this.collateralPortfolioIndicator + ", " +
				"portfolioContainingNonReportedComponentIndicator=" + this.portfolioContainingNonReportedComponentIndicator + ", " +
				"initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", " +
				"collateralPortfolioCodeVM=" + this.collateralPortfolioCodeVM + ", " +
				"initialMarginPostedByTheReportingEntityPreHaircut=" + this.initialMarginPostedByTheReportingEntityPreHaircut + ", " +
				"initialMarginPostedByTheReportingEntityPostHaircut=" + this.initialMarginPostedByTheReportingEntityPostHaircut + ", " +
				"currencyofInitialMarginPosted=" + this.currencyofInitialMarginPosted + ", " +
				"initialMarginCollectedByTheReportingEntityPreHaircut=" + this.initialMarginCollectedByTheReportingEntityPreHaircut + ", " +
				"initialMarginCollectedByTheReportingEntityPostHaircut=" + this.initialMarginCollectedByTheReportingEntityPostHaircut + ", " +
				"currencyofInitialMarginCollected=" + this.currencyofInitialMarginCollected + ", " +
				"variationMarginPostedByTheReportingEntityPreHaircut=" + this.variationMarginPostedByTheReportingEntityPreHaircut + ", " +
				"currencyOfVariationMarginPosted=" + this.currencyOfVariationMarginPosted + ", " +
				"variationMarginCollectedByTheReportingEntityPreHaircut=" + this.variationMarginCollectedByTheReportingEntityPreHaircut + ", " +
				"currencyOfVariationMarginCollected=" + this.currencyOfVariationMarginCollected + ", " +
				"actionType=" + this.actionType + ", " +
				"reportingTimestamp=" + this.reportingTimestamp + ", " +
				"reportSubmittingEntityID=" + this.reportSubmittingEntityID + ", " +
				"counterpartyIdentifierType=" + this.counterpartyIdentifierType + ", " +
				"technicalRecordId=" + this.technicalRecordId + ", " +
				"executionAgentOfCounterparty1=" + this.executionAgentOfCounterparty1 +
			'}';
		}
	}
}
