package drr.regulation.asic.rewrite.margin.validation;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.margin.ASICMarginReport;
import drr.standards.iso.CollateralisationType3Code__1;
import drr.standards.iso.MarginActionEnum;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class ASICMarginReportValidator implements Validator<ASICMarginReport> {

	private List<ComparisonResult> getComparisonResults(ASICMarginReport o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("uniqueTransactionIdentifier", (String) o.getUniqueTransactionIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("uniqueTransactionIdentifierProprietary", (String) o.getUniqueTransactionIdentifierProprietary() != null ? 1 : 0, 0, 1), 
				checkCardinality("reportingEntity", (String) o.getReportingEntity() != null ? 1 : 0, 1, 1), 
				checkCardinality("counterparty1", (String) o.getCounterparty1() != null ? 1 : 0, 1, 1), 
				checkCardinality("smallScaleBuySideEntityIndicator", (String) o.getSmallScaleBuySideEntityIndicator() != null ? 1 : 0, 1, 1), 
				checkCardinality("counterparty2", (String) o.getCounterparty2() != null ? 1 : 0, 1, 1), 
				checkCardinality("collateralTimestamp", (ZonedDateTime) o.getCollateralTimestamp() != null ? 1 : 0, 0, 1), 
				checkCardinality("collateralisationCategory", (CollateralisationType3Code__1) o.getCollateralisationCategory() != null ? 1 : 0, 0, 1), 
				checkCardinality("collateralPortfolioIndicator", (Boolean) o.getCollateralPortfolioIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("portfolioContainingNonReportedComponentIndicator", (Boolean) o.getPortfolioContainingNonReportedComponentIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("initialMarginCollateralPortfolioCode", (String) o.getInitialMarginCollateralPortfolioCode() != null ? 1 : 0, 0, 1), 
				checkCardinality("collateralPortfolioCodeVM", (String) o.getCollateralPortfolioCodeVM() != null ? 1 : 0, 0, 1), 
				checkCardinality("initialMarginPostedByTheReportingEntityPreHaircut", (BigDecimal) o.getInitialMarginPostedByTheReportingEntityPreHaircut() != null ? 1 : 0, 0, 1), 
				checkCardinality("initialMarginPostedByTheReportingEntityPostHaircut", (BigDecimal) o.getInitialMarginPostedByTheReportingEntityPostHaircut() != null ? 1 : 0, 0, 1), 
				checkCardinality("currencyofInitialMarginPosted", (ISOCurrencyCodeEnum) o.getCurrencyofInitialMarginPosted() != null ? 1 : 0, 0, 1), 
				checkCardinality("initialMarginCollectedByTheReportingEntityPreHaircut", (BigDecimal) o.getInitialMarginCollectedByTheReportingEntityPreHaircut() != null ? 1 : 0, 0, 1), 
				checkCardinality("initialMarginCollectedByTheReportingEntityPostHaircut", (BigDecimal) o.getInitialMarginCollectedByTheReportingEntityPostHaircut() != null ? 1 : 0, 0, 1), 
				checkCardinality("currencyofInitialMarginCollected", (ISOCurrencyCodeEnum) o.getCurrencyofInitialMarginCollected() != null ? 1 : 0, 0, 1), 
				checkCardinality("variationMarginPostedByTheReportingEntityPreHaircut", (BigDecimal) o.getVariationMarginPostedByTheReportingEntityPreHaircut() != null ? 1 : 0, 0, 1), 
				checkCardinality("currencyOfVariationMarginPosted", (ISOCurrencyCodeEnum) o.getCurrencyOfVariationMarginPosted() != null ? 1 : 0, 0, 1), 
				checkCardinality("variationMarginCollectedByTheReportingEntityPreHaircut", (BigDecimal) o.getVariationMarginCollectedByTheReportingEntityPreHaircut() != null ? 1 : 0, 0, 1), 
				checkCardinality("currencyOfVariationMarginCollected", (ISOCurrencyCodeEnum) o.getCurrencyOfVariationMarginCollected() != null ? 1 : 0, 0, 1), 
				checkCardinality("actionType", (MarginActionEnum) o.getActionType() != null ? 1 : 0, 0, 1), 
				checkCardinality("reportingTimestamp", (ZonedDateTime) o.getReportingTimestamp() != null ? 1 : 0, 1, 1), 
				checkCardinality("reportSubmittingEntityID", (String) o.getReportSubmittingEntityID() != null ? 1 : 0, 1, 1), 
				checkCardinality("counterpartyIdentifierType", (Boolean) o.getCounterpartyIdentifierType() != null ? 1 : 0, 1, 1), 
				checkCardinality("technicalRecordId", (String) o.getTechnicalRecordId() != null ? 1 : 0, 1, 1), 
				checkCardinality("executionAgentOfCounterparty1", (String) o.getExecutionAgentOfCounterparty1() != null ? 1 : 0, 1, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICMarginReport o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("ASICMarginReport", ValidationResult.ValidationType.CARDINALITY, "ASICMarginReport", path, "", res.getError());
				}
				return success("ASICMarginReport", ValidationResult.ValidationType.CARDINALITY, "ASICMarginReport", path, "");
			})
			.collect(toList());
	}

}
