package drr.regulation.asic.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.trade.ASICTransactionReport;
import drr.regulation.common.trade.party.functions.ExecutionAgentOfCounterparty2_Validation;
import drr.standards.iso.ActionTypeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;


/**
 * @version 7.0.0-dev.66
 */
@RosettaDataRule("ASICTransactionReportDTCC_ASIC_BR_1013a_01")
@ImplementedBy(ASICTransactionReportDTCC_ASIC_BR_1013a_01.Default.class)
public interface ASICTransactionReportDTCC_ASIC_BR_1013a_01 extends Validator<ASICTransactionReport> {
	
	String NAME = "ASICTransactionReportDTCC_ASIC_BR_1013a_01";
	String DEFINITION = "common.party.ExecutionAgentOfCounterparty2_Validation( actionType, executionAgentCounterparty1, executionAgentCounterparty2 )";
	
	class Default implements ASICTransactionReportDTCC_ASIC_BR_1013a_01 {
	
		@Inject protected ExecutionAgentOfCounterparty2_Validation executionAgentOfCounterparty2_Validation;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
			ComparisonResult result = executeDataRule(aSICTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ASICTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "ASICTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(ASICTransactionReport aSICTransactionReport) {
			try {
				return ComparisonResult.of(MapperS.of(executionAgentOfCounterparty2_Validation.evaluate(MapperS.of(aSICTransactionReport).<ActionTypeEnum>map("getActionType", _aSICTransactionReport -> _aSICTransactionReport.getActionType()).get(), MapperS.of(aSICTransactionReport).<String>map("getExecutionAgentCounterparty1", _aSICTransactionReport -> _aSICTransactionReport.getExecutionAgentCounterparty1()).get(), MapperS.of(aSICTransactionReport).<String>map("getExecutionAgentCounterparty2", _aSICTransactionReport -> _aSICTransactionReport.getExecutionAgentCounterparty2()).get())));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ASICTransactionReportDTCC_ASIC_BR_1013a_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
			return Collections.emptyList();
		}
	}
}
