package drr.regulation.cftc.rewrite.margin.validation.exists;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.base.staticdata.party.PartyIdentifierTypeEnum;
import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.cftc.rewrite.margin.CFTCMarginReport;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.standards.iso.CollateralisationType3Code__1;
import drr.standards.iso.MarginActionEnum;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class CFTCMarginReportOnlyExistsValidator implements ValidatorWithArg<CFTCMarginReport, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends CFTCMarginReport> ValidationResult<CFTCMarginReport> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("counterparty1", ExistenceChecker.isSet((String) o.getCounterparty1()))
				.put("counterparty2", ExistenceChecker.isSet((String) o.getCounterparty2()))
				.put("counterparty2IdentifierSource", ExistenceChecker.isSet((String) o.getCounterparty2IdentifierSource()))
				.put("submitterIdentifier", ExistenceChecker.isSet((String) o.getSubmitterIdentifier()))
				.put("actionType", ExistenceChecker.isSet((MarginActionEnum) o.getActionType()))
				.put("eventTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getEventTimestamp()))
				.put("reportingTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getReportingTimestamp()))
				.put("uniqueSwapIdentifier", ExistenceChecker.isSet((String) o.getUniqueSwapIdentifier()))
				.put("uniqueTransactionIdentifier", ExistenceChecker.isSet((String) o.getUniqueTransactionIdentifier()))
				.put("affiliatedCounterpartyForMarginAndCapitalIndicator", ExistenceChecker.isSet((Boolean) o.getAffiliatedCounterpartyForMarginAndCapitalIndicator()))
				.put("collateralisationCategory", ExistenceChecker.isSet((CollateralisationType3Code__1) o.getCollateralisationCategory()))
				.put("initialMarginCollateralPortfolioCode", ExistenceChecker.isSet((String) o.getInitialMarginCollateralPortfolioCode()))
				.put("portfolioContainingNonReportableComponentIndicator", ExistenceChecker.isSet((Boolean) o.getPortfolioContainingNonReportableComponentIndicator()))
				.put("initialMarginPostedByTheReportingCounterpartyPostHaircut", ExistenceChecker.isSet((BigDecimal) o.getInitialMarginPostedByTheReportingCounterpartyPostHaircut()))
				.put("initialMarginPostedByTheReportingCounterpartyPreHaircut", ExistenceChecker.isSet((BigDecimal) o.getInitialMarginPostedByTheReportingCounterpartyPreHaircut()))
				.put("currencyOfInitialMarginPosted", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getCurrencyOfInitialMarginPosted()))
				.put("initialMarginCollectedByTheReportingCounterpartyPostHaircut", ExistenceChecker.isSet((BigDecimal) o.getInitialMarginCollectedByTheReportingCounterpartyPostHaircut()))
				.put("initialMarginCollectedByTheReportingCounterpartyPreHaircut", ExistenceChecker.isSet((BigDecimal) o.getInitialMarginCollectedByTheReportingCounterpartyPreHaircut()))
				.put("currencyOfInitialMarginCollected", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getCurrencyOfInitialMarginCollected()))
				.put("variationMarginCollateralPortfolioCode", ExistenceChecker.isSet((String) o.getVariationMarginCollateralPortfolioCode()))
				.put("variationMarginPostedByTheReportingCounterpartyPreHaircut", ExistenceChecker.isSet((BigDecimal) o.getVariationMarginPostedByTheReportingCounterpartyPreHaircut()))
				.put("currencyOfVariationMarginPosted", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getCurrencyOfVariationMarginPosted()))
				.put("variationMarginCollectedByTheReportingCounterpartyPreHaircut", ExistenceChecker.isSet((BigDecimal) o.getVariationMarginCollectedByTheReportingCounterpartyPreHaircut()))
				.put("currencyOfVariationMarginCollected", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getCurrencyOfVariationMarginCollected()))
				.put("tradeParty1IDType", ExistenceChecker.isSet((PartyIdentifierTypeEnum) o.getTradeParty1IDType()))
				.put("submittingPartyIDType", ExistenceChecker.isSet((PartyIdentifierTypeEnum) o.getSubmittingPartyIDType()))
				.put("usiIDPrefix", ExistenceChecker.isSet((String) o.getUsiIDPrefix()))
				.put("utiIDPrefix", ExistenceChecker.isSet((String) o.getUtiIDPrefix()))
				.put("tradeParty1ReportingDestination", ExistenceChecker.isSet((List<SupervisoryBodyEnum>) o.getTradeParty1ReportingDestination()))
				.put("comment1", ExistenceChecker.isSet((String) o.getComment1()))
				.put("messageID", ExistenceChecker.isSet((String) o.getMessageID()))
				.put("messageType", ExistenceChecker.isSet((String) o.getMessageType()))
				.put("version", ExistenceChecker.isSet((String) o.getVersion()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("CFTCMarginReport", ValidationResult.ValidationType.ONLY_EXISTS, "CFTCMarginReport", path, "");
		}
		return failure("CFTCMarginReport", ValidationResult.ValidationType.ONLY_EXISTS, "CFTCMarginReport", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
