package drr.regulation.common.functions;

import cdm.base.staticdata.asset.common.Commodity;
import cdm.base.staticdata.asset.common.metafields.FieldWithMetaCommodity;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaCommodity;
import cdm.observable.asset.Observable;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.template.ForwardPayout;
import cdm.product.template.Product;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.functions.GetQuantityKeys;
import drr.base.trade.functions.GetQuantityReference;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(CommodityForwardObservablePriceQuantity.CommodityForwardObservablePriceQuantityDefault.class)
public abstract class CommodityForwardObservablePriceQuantity implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected GetQuantityKeys getQuantityKeys;
	@Inject protected GetQuantityReference getQuantityReference;

	/**
	* @param tradeLot 
	* @param forwardPayout 
	* @return priceQuantity 
	*/
	public PriceQuantity evaluate(TradeLot tradeLot, ForwardPayout forwardPayout) {
		PriceQuantity.PriceQuantityBuilder priceQuantityBuilder = doEvaluate(tradeLot, forwardPayout);
		
		final PriceQuantity priceQuantity;
		if (priceQuantityBuilder == null) {
			priceQuantity = null;
		} else {
			priceQuantity = priceQuantityBuilder.build();
			objectValidator.validate(PriceQuantity.class, priceQuantity);
		}
		
		return priceQuantity;
	}

	protected abstract PriceQuantity.PriceQuantityBuilder doEvaluate(TradeLot tradeLot, ForwardPayout forwardPayout);

	protected abstract MapperS<? extends PriceQuantity> priceQuantityWithMatchingObservable(TradeLot tradeLot, ForwardPayout forwardPayout);

	protected abstract MapperS<? extends PriceQuantity> priceQuantityWithMatchingKey(TradeLot tradeLot, ForwardPayout forwardPayout);

	public static class CommodityForwardObservablePriceQuantityDefault extends CommodityForwardObservablePriceQuantity {
		@Override
		protected PriceQuantity.PriceQuantityBuilder doEvaluate(TradeLot tradeLot, ForwardPayout forwardPayout) {
			PriceQuantity.PriceQuantityBuilder priceQuantity = PriceQuantity.builder();
			return assignOutput(priceQuantity, tradeLot, forwardPayout);
		}
		
		protected PriceQuantity.PriceQuantityBuilder assignOutput(PriceQuantity.PriceQuantityBuilder priceQuantity, TradeLot tradeLot, ForwardPayout forwardPayout) {
			if (exists(priceQuantityWithMatchingObservable(tradeLot, forwardPayout)).getOrDefault(false)) {
				priceQuantity = toBuilder(priceQuantityWithMatchingObservable(tradeLot, forwardPayout).get());
			} else {
				priceQuantity = toBuilder(priceQuantityWithMatchingKey(tradeLot, forwardPayout).get());
			}
			
			return Optional.ofNullable(priceQuantity)
				.map(o -> o.prune())
				.orElse(null);
		}
		
		@Override
		protected MapperS<? extends PriceQuantity> priceQuantityWithMatchingObservable(TradeLot tradeLot, ForwardPayout forwardPayout) {
			final MapperC<PriceQuantity> thenArg0 = MapperS.of(tradeLot).<PriceQuantity>mapC("getPriceQuantity", _tradeLot -> _tradeLot.getPriceQuantity());
			final MapperC<PriceQuantity> thenArg1 = thenArg0
				.filterItemNullSafe(item -> areEqual(item.<Observable>map("getObservable", priceQuantity -> priceQuantity.getObservable()).<FieldWithMetaCommodity>map("getCommodity", observable -> observable.getCommodity()).<Commodity>map("Type coercion", fieldWithMetaCommodity -> fieldWithMetaCommodity == null ? null : fieldWithMetaCommodity.getValue()), MapperS.of(forwardPayout).<Product>map("getUnderlier", _forwardPayout -> _forwardPayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", product -> product.getCommodity()).<Commodity>map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity == null ? null : referenceWithMetaCommodity.getValue()), CardinalityOperator.All).get());
			return MapperS.of(thenArg1.get());
		}
		
		@Override
		protected MapperS<? extends PriceQuantity> priceQuantityWithMatchingKey(TradeLot tradeLot, ForwardPayout forwardPayout) {
			final MapperC<PriceQuantity> thenArg = MapperS.of(tradeLot).<PriceQuantity>mapC("getPriceQuantity", _tradeLot -> _tradeLot.getPriceQuantity())
				.filterItemNullSafe(item -> contains(MapperC.<String>of(getQuantityKeys.evaluate(item.get())), MapperS.of(getQuantityReference.evaluate(MapperS.of(forwardPayout).<ResolvablePriceQuantity>map("getPriceQuantity", _forwardPayout -> _forwardPayout.getPriceQuantity()).get()))).get());
			return MapperS.of(thenArg.get());
		}
	}
}
