package drr.regulation.common.functions;

import cdm.base.staticdata.asset.common.Commodity;
import cdm.base.staticdata.asset.common.Index;
import cdm.base.staticdata.asset.common.Loan;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.base.staticdata.asset.common.Security;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaCommodity;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaProductIdentifier;
import cdm.product.asset.BondReference;
import cdm.product.template.Basket;
import cdm.product.template.ContractualProduct;
import cdm.product.template.Payout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.qualification.product.functions.IsCommoditySwap;
import drr.base.qualification.product.functions.IsCommoditySwaption;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.underlier.functions.UnderlierForProduct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(GetUnderlierProductIdentifierLeg1.GetUnderlierProductIdentifierLeg1Default.class)
public abstract class GetUnderlierProductIdentifierLeg1 implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected CommodityLeg1 commodityLeg1;
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected InterestRateLeg1 interestRateLeg1;
	@Inject protected IsCommoditySwap isCommoditySwap;
	@Inject protected IsCommoditySwaption isCommoditySwaption;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param product 
	* @return productId 
	*/
	public List<? extends ProductIdentifier> evaluate(Product product) {
		List<ProductIdentifier.ProductIdentifierBuilder> productIdBuilder = doEvaluate(product);
		
		final List<? extends ProductIdentifier> productId;
		if (productIdBuilder == null) {
			productId = null;
		} else {
			productId = productIdBuilder.stream().map(ProductIdentifier::build).collect(Collectors.toList());
			objectValidator.validate(ProductIdentifier.class, productId);
		}
		
		return productId;
	}

	protected abstract List<ProductIdentifier.ProductIdentifierBuilder> doEvaluate(Product product);

	public static class GetUnderlierProductIdentifierLeg1Default extends GetUnderlierProductIdentifierLeg1 {
		@Override
		protected List<ProductIdentifier.ProductIdentifierBuilder> doEvaluate(Product product) {
			List<ProductIdentifier.ProductIdentifierBuilder> productId = new ArrayList<>();
			return assignOutput(productId, product);
		}
		
		protected List<ProductIdentifier.ProductIdentifierBuilder> assignOutput(List<ProductIdentifier.ProductIdentifierBuilder> productId, Product product) {
			final MapperC<Product> thenArg0;
			if (exists(MapperS.of(underlierForProduct.evaluate(product))).getOrDefault(false)) {
				thenArg0 = MapperC.of(Collections.singletonList(underlierForProduct.evaluate(product)));
			} else if (exists(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).<Product>map("getUnderlier", performancePayout -> performancePayout.getUnderlier())).getOrDefault(false)) {
				thenArg0 = MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).<Product>map("getUnderlier", performancePayout -> performancePayout.getUnderlier());
			} else {
				thenArg0 = MapperC.<Product>ofNull();
			}
			final MapperListOfLists<ReferenceWithMetaProductIdentifier> thenArg1 = thenArg0
				.mapItemToList(item -> {
					if (exists(item.<Security>map("getSecurity", _product -> _product.getSecurity())).getOrDefault(false)) {
						return item.<Security>map("getSecurity", _product -> _product.getSecurity()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", security -> security.getProductIdentifier());
					}
					if (exists(item.<Loan>map("getLoan", _product -> _product.getLoan())).getOrDefault(false)) {
						return item.<Loan>map("getLoan", _product -> _product.getLoan()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", loan -> loan.getProductIdentifier());
					}
					if (exists(item.<Index>map("getIndex", _product -> _product.getIndex())).getOrDefault(false)) {
						return item.<Index>map("getIndex", _product -> _product.getIndex()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", index -> index.getProductIdentifier());
					}
					if (exists(item.<Basket>map("getBasket", _product -> _product.getBasket())).getOrDefault(false)) {
						return item.<Basket>map("getBasket", _product -> _product.getBasket()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", basket -> basket.getProductIdentifier());
					}
					return MapperC.<ReferenceWithMetaProductIdentifier>ofNull();
				});
			productId.addAll(toBuilder(thenArg1
				.flattenList().<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).getMulti()));
			
			if (exists(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).<Product>map("getUnderlier", performancePayout -> performancePayout.getUnderlier())).getOrDefault(false)) {
				productId.addAll(toBuilder(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).<Product>map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", _product -> _product.getCommodity()).<Commodity>map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity.getValue()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier()).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).getMulti()));
			} else if (ComparisonResult.of(MapperS.of(isCommoditySwaption.evaluate(product))).and(exists(MapperS.of(commodityLeg1.evaluate(underlierForProduct.evaluate(product))).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", _product -> _product.getCommodity()).<Commodity>map("Type coercion", referenceWithMetaCommodity0 -> referenceWithMetaCommodity0 == null ? null : referenceWithMetaCommodity0.getValue()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier()))).getOrDefault(false)) {
				productId.addAll(toBuilder(MapperS.of(commodityLeg1.evaluate(underlierForProduct.evaluate(product))).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", _product -> _product.getCommodity()).<Commodity>map("Type coercion", referenceWithMetaCommodity1 -> referenceWithMetaCommodity1 == null ? null : referenceWithMetaCommodity1.getValue()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier()).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).getMulti()));
			} else if (ComparisonResult.of(MapperS.of(isCommoditySwap.evaluate(product))).and(exists(MapperS.of(commodityLeg1.evaluate(product)).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", _product -> _product.getCommodity()).<Commodity>map("Type coercion", referenceWithMetaCommodity2 -> referenceWithMetaCommodity2 == null ? null : referenceWithMetaCommodity2.getValue()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier()))).getOrDefault(false)) {
				productId.addAll(toBuilder(MapperS.of(commodityLeg1.evaluate(product)).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", _product -> _product.getCommodity()).<Commodity>map("Type coercion", referenceWithMetaCommodity3 -> referenceWithMetaCommodity3 == null ? null : referenceWithMetaCommodity3.getValue()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier()).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).getMulti()));
			} else if (exists(MapperS.of(commodityLeg1.evaluate(product)).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<Basket>map("getBasket", _product -> _product.getBasket()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", basket -> basket.getProductIdentifier())).getOrDefault(false)) {
				productId.addAll(toBuilder(MapperS.of(commodityLeg1.evaluate(product)).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<Basket>map("getBasket", _product -> _product.getBasket()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", basket -> basket.getProductIdentifier()).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).getMulti()));
			} else if (exists(MapperS.of(commodityLeg1.evaluate(product)).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<Index>map("getIndex", _product -> _product.getIndex())).getOrDefault(false)) {
				productId.addAll(toBuilder(MapperS.of(commodityLeg1.evaluate(product)).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<Index>map("getIndex", _product -> _product.getIndex()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", index -> index.getProductIdentifier()).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).getMulti()));
			} else if (exists(MapperS.of(underlierForProduct.evaluate(product)).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", contractualProduct -> contractualProduct.getProductIdentifier())).getOrDefault(false)) {
				productId.addAll(toBuilder(MapperS.of(underlierForProduct.evaluate(product)).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", contractualProduct -> contractualProduct.getProductIdentifier()).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).getMulti()));
			} else if (exists(MapperS.of(interestRateLeg1.evaluate(product)).<BondReference>map("getBondReference", interestRatePayout -> interestRatePayout.getBondReference()).<ProductIdentifier>map("getBond", bondReference -> bondReference.getBond())).getOrDefault(false)) {
				productId.addAll(toBuilder(MapperS.of(interestRateLeg1.evaluate(product)).<BondReference>map("getBondReference", interestRatePayout -> interestRatePayout.getBondReference()).<ProductIdentifier>map("getBond", bondReference -> bondReference.getBond()).getMulti()));
			} else if (exists(MapperS.of(underlierForProduct.evaluate(underlierForProduct.evaluate(product))).<Index>map("getIndex", _product -> _product.getIndex())).getOrDefault(false)) {
				productId.addAll(toBuilder(MapperS.of(underlierForProduct.evaluate(underlierForProduct.evaluate(product))).<Index>map("getIndex", _product -> _product.getIndex()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", index -> index.getProductIdentifier()).<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).getMulti()));
			} else {
				productId.addAll(toBuilder(Collections.<ProductIdentifier>emptyList()));
			}
			
			return Optional.ofNullable(productId)
				.map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList()))
				.orElse(null);
		}
	}
}
