package drr.regulation.common.functions;

import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import drr.base.qualification.product.functions.IsProductWithUnderlier;
import drr.base.trade.underlier.functions.UnderlierForProduct;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(ProductOrUnderlierProduct.ProductOrUnderlierProductDefault.class)
public abstract class ProductOrUnderlierProduct implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected IsProductWithUnderlier isProductWithUnderlier;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param product 
	* @return productOrUnderlierProduct 
	*/
	public Product evaluate(Product product) {
		Product.ProductBuilder productOrUnderlierProductBuilder = doEvaluate(product);
		
		final Product productOrUnderlierProduct;
		if (productOrUnderlierProductBuilder == null) {
			productOrUnderlierProduct = null;
		} else {
			productOrUnderlierProduct = productOrUnderlierProductBuilder.build();
			objectValidator.validate(Product.class, productOrUnderlierProduct);
		}
		
		return productOrUnderlierProduct;
	}

	protected abstract Product.ProductBuilder doEvaluate(Product product);

	public static class ProductOrUnderlierProductDefault extends ProductOrUnderlierProduct {
		@Override
		protected Product.ProductBuilder doEvaluate(Product product) {
			Product.ProductBuilder productOrUnderlierProduct = Product.builder();
			return assignOutput(productOrUnderlierProduct, product);
		}
		
		protected Product.ProductBuilder assignOutput(Product.ProductBuilder productOrUnderlierProduct, Product product) {
			final Boolean _boolean = isProductWithUnderlier.evaluate(product);
			if ((_boolean == null ? false : _boolean)) {
				productOrUnderlierProduct = toBuilder(underlierForProduct.evaluate(product));
			} else {
				productOrUnderlierProduct = toBuilder(product);
			}
			
			return Optional.ofNullable(productOrUnderlierProduct)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
