package drr.regulation.csa.rewrite.dtcc.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.csa.rewrite.dtcc.UnderlyingAssetReport;
import drr.regulation.csa.rewrite.dtcc.validation.UnderlyingAssetReportTypeFormatValidator;
import drr.regulation.csa.rewrite.dtcc.validation.UnderlyingAssetReportValidator;
import drr.regulation.csa.rewrite.dtcc.validation.exists.UnderlyingAssetReportOnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 7.0.0-dev.66
 */
@RosettaMeta(model=UnderlyingAssetReport.class)
public class UnderlyingAssetReportMeta implements RosettaMetaData<UnderlyingAssetReport> {

	@Override
	public List<Validator<? super UnderlyingAssetReport>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
		);
	}
	
	@Override
	public List<Function<? super UnderlyingAssetReport, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super UnderlyingAssetReport> validator(ValidatorFactory factory) {
		return factory.<UnderlyingAssetReport>create(UnderlyingAssetReportValidator.class);
	}

	@Override
	public Validator<? super UnderlyingAssetReport> typeFormatValidator(ValidatorFactory factory) {
		return factory.<UnderlyingAssetReport>create(UnderlyingAssetReportTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super UnderlyingAssetReport> validator() {
		return new UnderlyingAssetReportValidator();
	}

	@Deprecated
	@Override
	public Validator<? super UnderlyingAssetReport> typeFormatValidator() {
		return new UnderlyingAssetReportTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super UnderlyingAssetReport, Set<String>> onlyExistsValidator() {
		return new UnderlyingAssetReportOnlyExistsValidator();
	}
}
