package drr.regulation.csa.rewrite.dtcc.reports;

import cdm.base.staticdata.asset.common.IndexReferenceInformation;
import cdm.observable.asset.FloatingRateOption;
import cdm.observable.asset.metafields.ReferenceWithMetaFloatingRateOption;
import cdm.product.asset.FloatingRateSpecification;
import cdm.product.asset.InflationRateSpecification;
import cdm.product.asset.RateSpecification;
import cdm.product.qualification.functions.Qualify_AssetClass_InterestRate;
import cdm.product.qualification.functions.Qualify_BaseProduct_IRSwap;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.base.qualification.product.functions.IsFRA;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.functions.ProductForEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.ProductOrUnderlierProduct;
import drr.regulation.csa.rewrite.trade.functions.InterestRateLeg1;
import drr.regulation.csa.rewrite.trade.functions.IsAllowableActionForCSA;
import javax.inject.Inject;


@ImplementedBy(DTCC_Leg1FloatingRateIndexRule.DTCC_Leg1FloatingRateIndexRuleDefault.class)
public abstract class DTCC_Leg1FloatingRateIndexRule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected InterestRateLeg1 interestRateLeg1;
	@Inject protected IsAllowableActionForCSA isAllowableActionForCSA;
	@Inject protected IsFRA isFRA;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected ProductOrUnderlierProduct productOrUnderlierProduct;
	@Inject protected Qualify_AssetClass_InterestRate qualify_AssetClass_InterestRate;
	@Inject protected Qualify_BaseProduct_IRSwap qualify_BaseProduct_IRSwap;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class DTCC_Leg1FloatingRateIndexRuleDefault extends DTCC_Leg1FloatingRateIndexRule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForCSA.evaluate(item.get()));
			final MapperS<Product> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(productForEvent.evaluate(item.get())));
			final MapperS<Product> thenArg2 = thenArg1
				.filterSingleNullSafe(item -> qualify_AssetClass_InterestRate.evaluate(economicTermsForProduct.evaluate(item.get())));
			final MapperS<Product> thenArg3 = thenArg2
				.mapSingleToItem(item -> MapperS.of(productOrUnderlierProduct.evaluate(item.get())));
			final FieldWithMetaString fieldWithMetaString = thenArg3
				.mapSingleToItem(item -> {
					final Boolean boolean0 = isFRA.evaluate(item.get());
					if ((boolean0 == null ? false : boolean0)) {
						return MapperS.of(interestRateLeg1.evaluate(item.get())).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", referenceWithMetaFloatingRateOption0 -> referenceWithMetaFloatingRateOption0 == null ? null : referenceWithMetaFloatingRateOption0.getValue()).<IndexReferenceInformation>map("getIndexReferenceInformation", floatingRateOption -> floatingRateOption.getIndexReferenceInformation()).<FieldWithMetaString>mapC("getIndexId", indexReferenceInformation -> indexReferenceInformation.getIndexId())
							.first();
					}
					final Boolean boolean1 = qualify_BaseProduct_IRSwap.evaluate(economicTermsForProduct.evaluate(item.get()));
					if ((boolean1 == null ? false : boolean1)) {
						return MapperS.of(MapperC.<FieldWithMetaString>of(MapperS.of(interestRateLeg1.evaluate(item.get())).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", referenceWithMetaFloatingRateOption1 -> referenceWithMetaFloatingRateOption1 == null ? null : referenceWithMetaFloatingRateOption1.getValue()).<IndexReferenceInformation>map("getIndexReferenceInformation", floatingRateOption -> floatingRateOption.getIndexReferenceInformation()).<FieldWithMetaString>mapC("getIndexId", indexReferenceInformation -> indexReferenceInformation.getIndexId())
							.first(), MapperS.of(interestRateLeg1.evaluate(item.get())).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<InflationRateSpecification>map("getInflationRate", rateSpecification -> rateSpecification.getInflationRate()).<ReferenceWithMetaFloatingRateOption>map("getRateOption", inflationRateSpecification -> inflationRateSpecification.getRateOption()).<FloatingRateOption>map("Type coercion", referenceWithMetaFloatingRateOption2 -> referenceWithMetaFloatingRateOption2 == null ? null : referenceWithMetaFloatingRateOption2.getValue()).<IndexReferenceInformation>map("getIndexReferenceInformation", floatingRateOption -> floatingRateOption.getIndexReferenceInformation()).<FieldWithMetaString>mapC("getIndexId", indexReferenceInformation -> indexReferenceInformation.getIndexId())
							.first()).get());
					}
					return MapperS.<FieldWithMetaString>ofNull();
				}).get();
			if (fieldWithMetaString == null) {
				output = null;
			} else {
				output = fieldWithMetaString.getValue();
			}
			
			return output;
		}
	}
}
